/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.json.internal;

import com.hazelcast.json.internal.JsonDataSerializerHook;
import com.hazelcast.json.internal.JsonSchemaNode;
import com.hazelcast.json.internal.JsonSchemaStructNode;
import com.hazelcast.json.internal.JsonSchemaTerminalNode;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class JsonSchemaNameValue
implements IdentifiedDataSerializable {
    private int nameStart;
    private JsonSchemaNode value;

    public JsonSchemaNameValue() {
    }

    public JsonSchemaNameValue(int nameStart, JsonSchemaNode value) {
        this.nameStart = nameStart;
        this.value = value;
    }

    public int getNameStart() {
        return this.nameStart;
    }

    public boolean isArrayItem() {
        return this.nameStart == -1;
    }

    public boolean isObjectItem() {
        return this.nameStart > 0;
    }

    public JsonSchemaNode getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaNameValue that = (JsonSchemaNameValue)o;
        if (this.nameStart != that.nameStart) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.nameStart;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JsonSchemaNameValue{nameStart=" + this.nameStart + ", value=" + this.value + "}";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nameStart);
        out.writeBoolean(this.value instanceof JsonSchemaTerminalNode);
        this.value.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nameStart = in.readInt();
        boolean isTerminal = in.readBoolean();
        this.value = isTerminal ? new JsonSchemaTerminalNode() : new JsonSchemaStructNode();
        this.value.readData(in);
    }

    @Override
    public int getFactoryId() {
        return JsonDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }
}

