/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

class ClusterMetricsProvider
implements MetricsProvider {
    ClusterMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        ClusterServiceImpl clusterService = node.getClusterService();
        int clusterSize = clusterService.getMembers().size();
        long clusterUpTime = clusterService.getClusterClock().getClusterUpTime();
        int partitionCount = node.getPartitionService().getPartitionCount();
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        context.collect(PhoneHomeMetrics.UUID_OF_CLUSTER, node.getThisUuid());
        context.collect(PhoneHomeMetrics.CLUSTER_ID, clusterService.getClusterId());
        context.collect(PhoneHomeMetrics.CLUSTER_SIZE, MetricsProvider.convertToLetter(clusterSize));
        context.collect(PhoneHomeMetrics.EXACT_CLUSTER_SIZE, clusterSize);
        context.collect(PhoneHomeMetrics.TIME_TAKEN_TO_CLUSTER_UP, clusterUpTime);
        context.collect(PhoneHomeMetrics.UPTIME_OF_RUNTIME_MXBEAN, rt.getUptime());
        context.collect(PhoneHomeMetrics.RUNTIME_MXBEAN_VM_NAME, rt.getVmName());
        context.collect(PhoneHomeMetrics.PARTITION_COUNT, partitionCount);
    }
}

