/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.internal.partition.PartitionEventListener;
import com.hazelcast.internal.partition.PartitionLostEventImpl;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.ReplicaMigrationEventImpl;
import com.hazelcast.internal.partition.impl.MigrationListenerAdapter;
import com.hazelcast.internal.partition.impl.PartitionLostListenerAdapter;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.ReplicaMigrationEvent;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.EventService;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class PartitionEventManager {
    private final Node node;
    private final NodeEngineImpl nodeEngine;

    public PartitionEventManager(Node node) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
    }

    public void sendMigrationEvent(MigrationState state, MigrationInfo migrationInfo, long elapsed) {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        PartitionReplica sourceReplica = migrationInfo.getSource();
        PartitionReplica destReplica = migrationInfo.getDestination();
        MemberImpl source = sourceReplica != null ? clusterService.getMember(sourceReplica.address(), sourceReplica.uuid()) : null;
        MemberImpl destination = clusterService.getMember(destReplica.address(), destReplica.uuid());
        int partitionId = migrationInfo.getPartitionId();
        int replicaIndex = migrationInfo.getDestinationNewReplicaIndex();
        boolean success = migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS;
        ReplicaMigrationEventImpl event = new ReplicaMigrationEventImpl(state, partitionId, replicaIndex, source, destination, success, elapsed);
        this.sendMigrationEvent(event);
    }

    public void sendMigrationProcessStartedEvent(MigrationState state) {
        ReplicaMigrationEventImpl event = new ReplicaMigrationEventImpl(state, -1, 0, null, null, false, 0L);
        this.sendMigrationEvent(event);
    }

    public void sendMigrationProcessCompletedEvent(MigrationState state) {
        ReplicaMigrationEventImpl event = new ReplicaMigrationEventImpl(state, -2, 0, null, null, false, 0L);
        this.sendMigrationEvent(event);
    }

    private void sendMigrationEvent(ReplicaMigrationEvent event) {
        EventService eventService = this.nodeEngine.getEventService();
        eventService.publishEvent("hz:core:partitionService", ".migration", (Object)event, ".migration".hashCode());
    }

    public UUID addMigrationListener(@Nonnull MigrationListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        MigrationListenerAdapter adapter = new MigrationListenerAdapter(listener);
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerListener("hz:core:partitionService", ".migration", adapter);
        return registration.getId();
    }

    public UUID addLocalMigrationListener(@Nonnull MigrationListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        MigrationListenerAdapter adapter = new MigrationListenerAdapter(listener);
        return this.registerLocalListener(adapter, ".migration");
    }

    public CompletableFuture<UUID> addMigrationListenerAsync(@Nonnull MigrationListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        MigrationListenerAdapter adapter = new MigrationListenerAdapter(listener);
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.registerListenerAsync("hz:core:partitionService", ".migration", adapter).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    public boolean removeMigrationListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener("hz:core:partitionService", ".migration", registrationId);
    }

    public CompletableFuture<Boolean> removeMigrationListenerAsync(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListenerAsync("hz:core:partitionService", ".migration", registrationId);
    }

    public UUID addPartitionLostListener(@Nonnull PartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        PartitionLostListenerAdapter adapter = new PartitionLostListenerAdapter(listener);
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerListener("hz:core:partitionService", ".partitionLost", adapter);
        return registration.getId();
    }

    public CompletableFuture<UUID> addPartitionLostListenerAsync(@Nonnull PartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        PartitionLostListenerAdapter adapter = new PartitionLostListenerAdapter(listener);
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.registerListenerAsync("hz:core:partitionService", ".partitionLost", adapter).thenApplyAsync(EventRegistration::getId, ConcurrencyUtil.CALLER_RUNS);
    }

    public UUID addLocalPartitionLostListener(@Nonnull PartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "listener can't be null");
        PartitionLostListenerAdapter adapter = new PartitionLostListenerAdapter(listener);
        return this.registerLocalListener(adapter, ".partitionLost");
    }

    public boolean removePartitionLostListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener("hz:core:partitionService", ".partitionLost", registrationId);
    }

    public CompletableFuture<Boolean> removePartitionLostListenerAsync(UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListenerAsync("hz:core:partitionService", ".partitionLost", registrationId);
    }

    public void onPartitionLost(IPartitionLostEvent event) {
        assert (event instanceof PartitionLostEvent);
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:core:partitionService", ".partitionLost");
        eventService.publishEvent("hz:core:partitionService", registrations, (Object)event, event.getPartitionId());
    }

    public void sendPartitionLostEvent(int partitionId, int lostReplicaIndex) {
        PartitionLostEventImpl event = new PartitionLostEventImpl(partitionId, lostReplicaIndex, this.nodeEngine.getThisAddress());
        InternalPartitionLostEventPublisher publisher = new InternalPartitionLostEventPublisher(this.nodeEngine, event);
        this.nodeEngine.getExecutionService().execute("hz:system", publisher);
    }

    private UUID registerLocalListener(PartitionEventListener<?> adapter, String topic) {
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:core:partitionService", topic, adapter);
        return registration.getId();
    }

    private static class InternalPartitionLostEventPublisher
    implements Runnable {
        private final NodeEngineImpl nodeEngine;
        private final IPartitionLostEvent event;

        InternalPartitionLostEventPublisher(NodeEngineImpl nodeEngine, IPartitionLostEvent event) {
            this.nodeEngine = nodeEngine;
            this.event = event;
        }

        @Override
        public void run() {
            for (PartitionAwareService service : this.nodeEngine.getServices(PartitionAwareService.class)) {
                try {
                    service.onPartitionLost(this.event);
                }
                catch (Exception e) {
                    ILogger logger = this.nodeEngine.getLogger(InternalPartitionLostEventPublisher.class);
                    logger.warning("Handling partitionLostEvent failed. Service: " + service.getClass() + " Event: " + this.event, e);
                }
            }
        }

        public IPartitionLostEvent getEvent() {
            return this.event;
        }
    }
}

