/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.durableexecutor.impl;

import com.hazelcast.durableexecutor.impl.DistributedDurableExecutorService;
import com.hazelcast.durableexecutor.impl.TaskRingBuffer;
import com.hazelcast.durableexecutor.impl.operations.PutResultOperation;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.ExecutorStats;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nullable;

public class DurableExecutorContainer {
    private final int durability;
    private final int partitionId;
    private final boolean statisticsEnabled;
    private final String name;
    private final ILogger logger;
    private final TaskRingBuffer ringBuffer;
    private final NodeEngineImpl nodeEngine;
    private final ExecutorStats executorStats;
    private final ExecutionService executionService;
    @Nullable
    private final String userCodeNamespace;

    public DurableExecutorContainer(NodeEngineImpl nodeEngine, String name, int partitionId, int durability, boolean statisticsEnabled, TaskRingBuffer ringBuffer, @Nullable String userCodeNamespace) {
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.executionService = nodeEngine.getExecutionService();
        this.partitionId = partitionId;
        this.logger = nodeEngine.getLogger(DurableExecutorContainer.class);
        this.durability = durability;
        this.ringBuffer = ringBuffer;
        this.statisticsEnabled = statisticsEnabled;
        this.executorStats = ((DistributedDurableExecutorService)nodeEngine.getService("hz:impl:durableExecutorService")).getExecutorStats();
        this.userCodeNamespace = userCodeNamespace;
    }

    public int execute(Callable callable) {
        try {
            int sequence = this.ringBuffer.add(callable);
            TaskProcessor processor = new TaskProcessor(sequence, callable);
            this.executionService.executeDurable(this.name, processor);
            return sequence;
        }
        catch (RejectedExecutionException e) {
            if (this.statisticsEnabled) {
                this.executorStats.rejectExecution(this.name);
            }
            throw e;
        }
    }

    void executeAll() {
        try {
            TaskRingBuffer.DurableIterator iterator = this.ringBuffer.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                boolean isCallable = iterator.isTask();
                if (!isCallable) continue;
                Callable callable = (Callable)item;
                int sequence = iterator.getSequence();
                TaskProcessor processor = new TaskProcessor(sequence, callable);
                this.executionService.executeDurable(this.name, processor);
            }
        }
        catch (RejectedExecutionException e) {
            if (this.statisticsEnabled) {
                this.executorStats.rejectExecution(this.name);
            }
            throw e;
        }
    }

    public void putBackup(int sequence, Callable callable) {
        this.ringBuffer.putBackup(sequence, callable);
    }

    public Object retrieveResult(int sequence) {
        return this.ringBuffer.retrieve(sequence);
    }

    public void disposeResult(int sequence) {
        this.ringBuffer.dispose(sequence);
    }

    public Object retrieveAndDisposeResult(int sequence) {
        return this.ringBuffer.retrieveAndDispose(sequence);
    }

    public void putResult(int sequence, Object result) {
        this.ringBuffer.replaceTaskWithResult(sequence, result);
    }

    public boolean shouldWait(int sequence) {
        return this.ringBuffer.isTask(sequence);
    }

    public TaskRingBuffer getRingBuffer() {
        return this.ringBuffer;
    }

    public int getDurability() {
        return this.durability;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    public final class TaskProcessor
    extends FutureTask
    implements Runnable {
        private final int sequence;
        private final long creationTime;
        private final String callableString;

        private TaskProcessor(int sequence, Callable callable) {
            super(callable);
            this.creationTime = Clock.currentTimeMillis();
            this.callableString = String.valueOf(callable);
            this.sequence = sequence;
            if (DurableExecutorContainer.this.statisticsEnabled) {
                DurableExecutorContainer.this.executorStats.startPending(DurableExecutorContainer.this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception response;
            long start;
            block11: {
                start = Clock.currentTimeMillis();
                if (DurableExecutorContainer.this.statisticsEnabled) {
                    DurableExecutorContainer.this.executorStats.startExecution(DurableExecutorContainer.this.name, start - this.creationTime);
                }
                response = null;
                try {
                    NamespaceUtil.setupNamespace(DurableExecutorContainer.this.nodeEngine, DurableExecutorContainer.this.userCodeNamespace);
                    super.run();
                    if (this.isCancelled()) break block11;
                    response = this.get();
                }
                catch (Exception e) {
                    try {
                        DurableExecutorContainer.this.logger.warning("While executing callable: " + this.callableString, e);
                        response = e;
                    }
                    catch (Throwable throwable) {
                        if (!this.isCancelled()) {
                            this.setResponse(response);
                            if (DurableExecutorContainer.this.statisticsEnabled) {
                                DurableExecutorContainer.this.executorStats.finishExecution(DurableExecutorContainer.this.name, Clock.currentTimeMillis() - start);
                            }
                        }
                        NamespaceUtil.cleanupNamespace(DurableExecutorContainer.this.nodeEngine, DurableExecutorContainer.this.userCodeNamespace);
                        throw throwable;
                    }
                    if (!this.isCancelled()) {
                        this.setResponse(response);
                        if (DurableExecutorContainer.this.statisticsEnabled) {
                            DurableExecutorContainer.this.executorStats.finishExecution(DurableExecutorContainer.this.name, Clock.currentTimeMillis() - start);
                        }
                    }
                    NamespaceUtil.cleanupNamespace(DurableExecutorContainer.this.nodeEngine, DurableExecutorContainer.this.userCodeNamespace);
                }
            }
            if (!this.isCancelled()) {
                this.setResponse(response);
                if (DurableExecutorContainer.this.statisticsEnabled) {
                    DurableExecutorContainer.this.executorStats.finishExecution(DurableExecutorContainer.this.name, Clock.currentTimeMillis() - start);
                }
            }
            NamespaceUtil.cleanupNamespace(DurableExecutorContainer.this.nodeEngine, DurableExecutorContainer.this.userCodeNamespace);
        }

        private void setResponse(Object response) {
            OperationServiceImpl operationService = DurableExecutorContainer.this.nodeEngine.getOperationService();
            PutResultOperation op = new PutResultOperation(DurableExecutorContainer.this.name, this.sequence, response);
            operationService.createInvocationBuilder("hz:impl:durableExecutorService", (Operation)op, DurableExecutorContainer.this.partitionId).setCallTimeout(Long.MAX_VALUE).invoke();
        }
    }
}

