/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.netpreserve.jwarc.DecodedBody;
import org.netpreserve.jwarc.Message;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public abstract class HttpMessage
extends Message {
    HttpMessage(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    @Override
    Charset headerCharset() {
        return StandardCharsets.ISO_8859_1;
    }

    public MessageBody bodyDecoded() throws IOException {
        MessageBody payload = this.body();
        List<String> contentEncodings = this.headers().all("Content-Encoding");
        if (contentEncodings.isEmpty()) {
            return payload;
        }
        if (contentEncodings.size() > 1) {
            throw new IOException("Multiple Content-Encodings not supported: " + contentEncodings);
        }
        if (contentEncodings.get(0).equalsIgnoreCase("identity") || contentEncodings.get(0).equalsIgnoreCase("none")) {
            return payload;
        }
        if (contentEncodings.get(0).equalsIgnoreCase("gzip") || contentEncodings.get(0).equalsIgnoreCase("x-gzip")) {
            return DecodedBody.create(payload, DecodedBody.Encoding.GZIP);
        }
        if (contentEncodings.get(0).equalsIgnoreCase("br")) {
            return DecodedBody.create(payload, DecodedBody.Encoding.BROTLI);
        }
        if (contentEncodings.get(0).equalsIgnoreCase("deflate")) {
            return DecodedBody.create(payload, DecodedBody.Encoding.DEFLATE);
        }
        throw new IOException("Content-Encoding not supported: " + contentEncodings.get(0));
    }

    public static abstract class AbstractBuilder<R extends HttpMessage, B extends AbstractBuilder<R, B>>
    extends Message.AbstractBuilder<R, B> {
        public AbstractBuilder() {
            super(MessageVersion.HTTP_1_1);
        }

        @Override
        public B version(MessageVersion version) {
            version.requireProtocol("HTTP");
            return (B)((AbstractBuilder)super.version(version));
        }
    }
}

