/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.editor;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.editor.SummernoteStorage;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IOUtils;

public class SummernoteFileStorage
implements SummernoteStorage {
    private final File folder;
    private final String id;

    public SummernoteFileStorage(String id, File folder) {
        this.folder = folder;
        this.id = id;
    }

    @Override
    public byte[] getContent(String imageName) {
        byte[] byArray;
        File file = new File(this.folder, this.id);
        if (!file.exists()) {
            file.mkdirs();
        }
        File image = new File(file, imageName);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(image);
            byArray = IOUtils.toByteArray((InputStream)fileInputStream);
        }
        catch (IOException e) {
            try {
                throw new WicketRuntimeException("Error while reading file: " + image.getPath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileInputStream);
        return byArray;
    }

    @Override
    public void writeContent(String imageName, InputStream inputStream) {
        File file = new File(this.folder, this.id);
        if (!file.exists()) {
            file.mkdirs();
        }
        File image = new File(file, imageName);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(image);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            try {
                throw new WicketRuntimeException("Error while writing file: " + image.getPath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fileOutputStream);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

