/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.resource.IUploadsFileManager;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;

public class FolderUploadsFileManager
implements IUploadsFileManager {
    private final org.apache.wicket.util.file.File folder;

    public FolderUploadsFileManager(org.apache.wicket.util.file.File folder) {
        Args.notNull((Object)folder, (String)"folder");
        if (!folder.exists()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        } else if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("Not a folder : " + folder.getAbsolutePath());
        }
        this.folder = folder;
    }

    public org.apache.wicket.util.file.File getFolder() {
        return this.folder;
    }

    @Override
    public void save(FileUpload fileItem, String uploadFieldId) {
        org.apache.wicket.util.file.File uploadFieldFolder = new org.apache.wicket.util.file.File(this.getFolder(), uploadFieldId);
        uploadFieldFolder.mkdirs();
        try {
            IOUtils.copy((InputStream)fileItem.getInputStream(), (OutputStream)new FileOutputStream((File)new org.apache.wicket.util.file.File(uploadFieldFolder, fileItem.getClientFileName())));
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    @Override
    public org.apache.wicket.util.file.File getFile(String uploadFieldId, String clientFileName) {
        return new org.apache.wicket.util.file.File(new org.apache.wicket.util.file.File(this.getFolder(), uploadFieldId), clientFileName);
    }
}

