/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.mock.MockApplication;
import org.apache.wicket.mock.MockWebRequest;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentRenderer.class);
    private Application application;

    public ComponentRenderer() {
        this(new MockApplication(){

            @Override
            public RuntimeConfigurationType getConfigurationType() {
                return RuntimeConfigurationType.DEPLOYMENT;
            }

            @Override
            protected void init() {
                super.init();
                this.setSessionStoreProvider(() -> new NeverSessionStore());
                this.getFrameworkSettings().setSerializer(new NeverSerializer());
            }
        });
    }

    public ComponentRenderer(Application application) {
        this.application = application;
        if (application.getName() == null) {
            this.inThreadContext(this::initApplication);
        }
    }

    private void initApplication() {
        if (this.application instanceof WebApplication) {
            WebApplication webApplication = (WebApplication)this.application;
            webApplication.setServletContext(new MockServletContext(this.application, null));
        }
        this.application.setName("ComponentRenderer[" + System.identityHashCode(this) + "]");
        this.application.initApplication();
    }

    public void destroy() {
        this.inThreadContext(() -> {
            this.application.internalDestroy();
            this.application = null;
        });
    }

    public CharSequence renderComponent(Supplier<Component> component) {
        return this.renderPage(() -> new RenderPage((Component)component.get()));
    }

    public CharSequence renderPage(Supplier<? extends Page> page) {
        return this.inThreadContext(() -> {
            Request request = this.newRequest();
            BufferedWebResponse response = new BufferedWebResponse(null);
            RequestCycle cycle = this.application.createRequestCycle(request, (Response)response);
            ThreadContext.setRequestCycle(cycle);
            ((Page)page.get()).renderPage();
            return response.getText();
        });
    }

    private void inThreadContext(Runnable runnable) {
        this.inThreadContext(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T inThreadContext(Supplier<T> supplier) {
        ThreadContext oldContext = ThreadContext.detach();
        try {
            ThreadContext.setApplication(this.application);
            T t = supplier.get();
            return t;
        }
        finally {
            ThreadContext.restore(oldContext);
        }
    }

    protected Request newRequest() {
        return new MockWebRequest(Url.parse((CharSequence)"/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence renderPage(PageProvider pageProvider) {
        Application application = Application.get();
        RequestCycle originalRequestCycle = RequestCycle.get();
        BufferedWebResponse tempResponse = new BufferedWebResponse(null);
        RequestCycle tempRequestCycle = application.createRequestCycle(originalRequestCycle.getRequest(), (Response)tempResponse);
        try {
            ThreadContext.setRequestCycle(tempRequestCycle);
            pageProvider.getPageInstance().renderPage();
        }
        finally {
            ThreadContext.setRequestCycle(originalRequestCycle);
        }
        return tempResponse.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharSequence renderComponent(Component component) {
        BufferedWebResponse tempResponse;
        Response originalResponse;
        RequestCycle requestCycle;
        block4: {
            requestCycle = RequestCycle.get();
            originalResponse = requestCycle.getResponse();
            tempResponse = new BufferedWebResponse(null);
            MarkupContainer oldParent = component.getParent();
            if (oldParent != null && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Component '{}' with a parent '{}' is passed for standalone rendering. It is recommended to render only orphan components because they are not cleaned up/detached after the rendering.", (Object)component, (Object)oldParent);
            }
            try {
                requestCycle.setResponse((Response)tempResponse);
                RenderPage page = new RenderPage(component);
                page.internalInitialize();
                component.beforeRender();
                component.renderPart();
                if (oldParent == null) break block4;
            }
            catch (Throwable throwable) {
                if (oldParent != null) {
                    oldParent.add(component);
                }
                requestCycle.setResponse(originalResponse);
                throw throwable;
            }
            oldParent.add(component);
        }
        requestCycle.setResponse(originalResponse);
        return tempResponse.getText();
    }

    private static class RenderPage
    extends WebPage
    implements IMarkupResourceStreamProvider,
    IMarkupCacheKeyProvider {
        private static final String DEFAULT_MARKUP = "<wicket:container wicket:id='%s'></wicket:container>";
        private final String markup;

        private RenderPage(Component component) {
            String componentMarkup;
            this.setStatelessHint(true);
            try {
                componentMarkup = component.getMarkup().toString(true);
            }
            catch (MarkupNotFoundException mnfx) {
                componentMarkup = String.format(DEFAULT_MARKUP, component.getId());
            }
            this.markup = componentMarkup;
            this.add(component);
        }

        @Override
        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)this.markup);
        }

        @Override
        public String getCacheKey(MarkupContainer container, Class<?> containerClass) {
            return null;
        }

        @Override
        public boolean isBookmarkable() {
            return true;
        }
    }

    private static class NeverSessionStore
    implements ISessionStore {
        private NeverSessionStore() {
        }

        @Override
        public Serializable getAttribute(Request request, String name) {
            return null;
        }

        @Override
        public List<String> getAttributeNames(Request request) {
            return null;
        }

        @Override
        public void setAttribute(Request request, String name, Serializable value) {
        }

        @Override
        public void removeAttribute(Request request, String name) {
        }

        @Override
        public void invalidate(Request request) {
        }

        @Override
        public String getSessionId(Request request, boolean create) {
            return null;
        }

        @Override
        public Session lookup(Request request) {
            return null;
        }

        @Override
        public void bind(Request request, Session newSession) {
        }

        @Override
        public void flushSession(Request request, Session session) {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void registerUnboundListener(ISessionStore.UnboundListener listener) {
        }

        @Override
        public void unregisterUnboundListener(ISessionStore.UnboundListener listener) {
        }

        @Override
        public Set<ISessionStore.UnboundListener> getUnboundListener() {
            return null;
        }

        @Override
        public void registerBindListener(ISessionStore.BindListener listener) {
        }

        @Override
        public void unregisterBindListener(ISessionStore.BindListener listener) {
        }

        @Override
        public Set<ISessionStore.BindListener> getBindListeners() {
            return null;
        }
    }

    private static final class NeverSerializer
    implements ISerializer {
        private NeverSerializer() {
        }

        @Override
        public byte[] serialize(Object object) {
            return null;
        }

        @Override
        public Object deserialize(byte[] data) {
            return null;
        }
    }
}

