/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.JQuery;
import org.wicketstuff.select2.Select2LanguageResourceReference;
import org.wicketstuff.select2.Select2ResourcesBehavior;
import org.wicketstuff.select2.Settings;

public class Select2Behavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private Settings settings = new Settings();

    public static Select2Behavior forSingleChoice() {
        return new Select2Behavior();
    }

    public static Select2Behavior forMultiChoice() {
        Select2Behavior select2Behavior = new Select2Behavior();
        select2Behavior.getSettings().setMultiple(true);
        return select2Behavior;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        new Select2ResourcesBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                if (Select2Behavior.this.settings.getTheme() != null) {
                    Select2Behavior.this.settings.getTheme().renderHead(component, response);
                }
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new Select2LanguageResourceReference(Select2Behavior.this.settings.getLanguage())));
            }
        }.renderHead(component, response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2(%s);", component.getMarkupId(), this.getSettings().toJson())));
    }

    public void bind(Component component) {
        component.setOutputMarkupId(true);
        if (!(component instanceof AbstractSelect2Choice) && !(component instanceof AbstractChoice)) {
            throw new IllegalArgumentException("This behavior should only be used on AbstractSelect2Choice or AbstractChoice components");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

