/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.util.Set;
import org.apache.tika.extractor.EmbeddedBytesSelector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.utils.StringUtils;

public class BasicEmbeddedBytesSelector
implements EmbeddedBytesSelector {
    private final Set<String> includeMimes;
    private final Set<String> excludeMimes;
    private final Set<String> includeEmbeddedResourceTypes;
    private final Set<String> excludeEmbeddedResourceTypes;

    public BasicEmbeddedBytesSelector(Set<String> includeMimes, Set<String> excludeMimes, Set<String> includeEmbeddedResourceTypes, Set<String> excludeEmbeddedResourceTypes) {
        this.includeMimes = includeMimes;
        this.excludeMimes = excludeMimes;
        this.includeEmbeddedResourceTypes = includeEmbeddedResourceTypes;
        this.excludeEmbeddedResourceTypes = excludeEmbeddedResourceTypes;
    }

    @Override
    public boolean select(Metadata metadata) {
        MediaType mt;
        Object mime = metadata.get("Content-Type");
        if (mime == null) {
            mime = "";
        } else if ((this.includeMimes.size() > 0 || this.excludeMimes.size() > 0) && (mt = MediaType.parse((String)mime)) != null) {
            mime = mt.getType() + "/" + mt.getSubtype();
        }
        if (this.excludeMimes.contains(mime)) {
            return false;
        }
        if (this.includeMimes.size() > 0 && !this.includeMimes.contains(mime)) {
            return false;
        }
        String embeddedResourceType = metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
        String string = embeddedResourceType = StringUtils.isBlank(embeddedResourceType) ? "ATTACHMENT" : embeddedResourceType;
        if (this.excludeEmbeddedResourceTypes.contains(embeddedResourceType)) {
            return false;
        }
        return this.includeEmbeddedResourceTypes.size() > 0 && this.includeEmbeddedResourceTypes.contains(embeddedResourceType);
    }
}

