/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.crypt;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

class SHA256Implementation {
    private static final int KEY_LENGTH = 1024;

    private SHA256Implementation() {
    }

    private static String hash(String str, byte[] salt, int iter) {
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(str.getBytes(StandardCharsets.UTF_8), salt, iter);
        byte[] dk = ((KeyParameter)gen.generateDerivedParameters(1024)).getKey();
        return Base64.encodeBase64String((byte[])dk);
    }

    static boolean verify(String str, String hash) {
        if (str == null) {
            return hash == null;
        }
        if (hash == null) {
            return false;
        }
        String[] ss = hash.split(":");
        if (ss.length != 3) {
            return false;
        }
        try {
            int iter = Integer.parseInt(ss[0]);
            String h1 = ss[1];
            byte[] salt = Base64.decodeBase64((String)ss[2]);
            String h2 = SHA256Implementation.hash(str, salt, iter);
            return h2.equals(h1);
        }
        catch (Exception e) {
            return false;
        }
    }
}

