/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.NikonPictureControl2Directory;

public final class NikonPictureControl2Descriptor
extends TagDescriptor<NikonPictureControl2Directory> {
    public NikonPictureControl2Descriptor(NikonPictureControl2Directory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 48: {
                return this.getPictureControlAdjustDescription();
            }
            case 63: {
                return this.getFilterEffectDescription();
            }
            case 64: {
                return this.getToningEffectDescription();
            }
        }
        return super.getDescription(tagType);
    }

    public String getPictureControlAdjustDescription() {
        return this.getIndexedDescription(48, "Default Settings", "Quick Adjust", "Full Control");
    }

    public String getFilterEffectDescription() {
        byte[] value = ((NikonPictureControl2Directory)this._directory).getByteArray(63);
        if (value == null) {
            return null;
        }
        switch (value[0]) {
            case -128: {
                return "Off";
            }
            case -127: {
                return "Yellow";
            }
            case -126: {
                return "Orange";
            }
            case -125: {
                return "Red";
            }
            case -124: {
                return "Green";
            }
            case -1: {
                return "N/A";
            }
        }
        return super.getDescription(63);
    }

    public String getToningEffectDescription() {
        byte[] value = ((NikonPictureControl2Directory)this._directory).getByteArray(64);
        if (value == null) {
            return null;
        }
        switch (value[0]) {
            case -128: {
                return "B&W";
            }
            case -127: {
                return "Sepia";
            }
            case -126: {
                return "Cyanotype";
            }
            case -125: {
                return "Red";
            }
            case -124: {
                return "Yellow";
            }
            case -123: {
                return "Green";
            }
            case -122: {
                return "Blue-green";
            }
            case -121: {
                return "Blue";
            }
            case -120: {
                return "Purple-blue";
            }
            case -119: {
                return "Red-purple";
            }
            case -1: {
                return "N/A";
            }
        }
        return super.getDescription(64);
    }
}

