/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.tracer.otel;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.prometheus.metrics.tracer.common.SpanContext;
import javax.annotation.Nullable;

public class OpenTelemetrySpanContext
implements SpanContext {
    public static boolean isAvailable() {
        try {
            OpenTelemetrySpanContext test = new OpenTelemetrySpanContext();
            test.getCurrentSpanId();
            test.getCurrentTraceId();
            test.isCurrentSpanSampled();
            return true;
        }
        catch (LinkageError ignored) {
            return false;
        }
    }

    @Nullable
    public String getCurrentTraceId() {
        String traceId = Span.current().getSpanContext().getTraceId();
        return TraceId.isValid((CharSequence)traceId) ? traceId : null;
    }

    @Nullable
    public String getCurrentSpanId() {
        String spanId = Span.current().getSpanContext().getSpanId();
        return SpanId.isValid((CharSequence)spanId) ? spanId : null;
    }

    public boolean isCurrentSpanSampled() {
        return Span.current().getSpanContext().isSampled();
    }

    public void markCurrentSpanAsExemplar() {
        Span.current().setAttribute("exemplar", "true");
    }
}

