/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard.dynamic;

import java.util.Iterator;
import org.apache.wicket.extensions.wizard.AbstractWizardModel;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.dynamic.IDynamicWizardStep;

public class DynamicWizardModel
extends AbstractWizardModel {
    private static final long serialVersionUID = 1L;
    private IDynamicWizardStep activeStep;
    private final IDynamicWizardStep startStep;

    public DynamicWizardModel(IDynamicWizardStep startStep) {
        this.startStep = startStep;
    }

    @Override
    public IDynamicWizardStep getActiveStep() {
        return this.activeStep;
    }

    public final IDynamicWizardStep getStartStep() {
        return this.startStep;
    }

    @Override
    public boolean isLastAvailable() {
        return this.activeStep.isLastAvailable();
    }

    @Override
    public boolean isLastStep(IWizardStep step) {
        return ((IDynamicWizardStep)step).isLastStep();
    }

    @Override
    public boolean isNextAvailable() {
        return this.activeStep.isNextAvailable();
    }

    @Override
    public boolean isPreviousAvailable() {
        return this.activeStep.isPreviousAvailable();
    }

    @Override
    public boolean isFinishAvailable() {
        return this.activeStep.isFinishAvailable();
    }

    @Override
    public void last() {
        this.setActiveStep(this.activeStep.last());
    }

    @Override
    public void next() {
        this.setActiveStep(this.activeStep.next());
    }

    @Override
    public void previous() {
        this.setActiveStep(this.activeStep.previous());
    }

    @Override
    public void reset() {
        this.setActiveStep(this.startStep);
    }

    @Override
    public Iterator<IWizardStep> stepIterator() {
        return null;
    }

    protected final void setActiveStep(IDynamicWizardStep step) {
        if (step == null) {
            throw new IllegalArgumentException("argument step must to be not null");
        }
        step.init(this);
        this.activeStep = step;
        this.fireActiveStepChanged(step);
    }
}

