/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class CalDAVProp
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "prop";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NOVALUE = "novalue";
    public static final String ATTR_VAL_YES = "yes";
    public static final String ATTR_VAL_NO = "no";
    private boolean attrNoValueEnabled = true;
    private String name = null;
    private boolean novalue = false;

    public CalDAVProp(String name, boolean novalue, boolean attrNoValueEnabled) {
        this.name = name;
        this.novalue = novalue;
        this.attrNoValueEnabled = attrNoValueEnabled;
    }

    public CalDAVProp(String name, boolean novalue) {
        this(name, novalue, true);
    }

    public CalDAVProp(String name) {
        this(name, false, false);
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ATTR_NAME, this.name);
        if (this.attrNoValueEnabled) {
            m.put(ATTR_NOVALUE, this.novalue ? ATTR_VAL_YES : ATTR_VAL_NO);
        }
        return m;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    public Collection<XmlSerializable> getChildren() {
        return null;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.name == null) {
            this.throwValidationException("name is a required property");
        }
    }
}

