/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j;

import com.github.caldav4j.CalDAVCalendarCollectionBase;
import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.CalDAVResource;
import com.github.caldav4j.exceptions.BadStatusException;
import com.github.caldav4j.exceptions.CalDAV4JException;
import com.github.caldav4j.exceptions.ResourceNotFoundException;
import com.github.caldav4j.exceptions.ResourceOutOfDateException;
import com.github.caldav4j.methods.CalDAV4JMethodFactory;
import com.github.caldav4j.methods.HttpAclMethod;
import com.github.caldav4j.methods.HttpCalDAVReportMethod;
import com.github.caldav4j.methods.HttpDeleteMethod;
import com.github.caldav4j.methods.HttpGetMethod;
import com.github.caldav4j.methods.HttpMkCalendarMethod;
import com.github.caldav4j.methods.HttpPropFindMethod;
import com.github.caldav4j.methods.HttpPutMethod;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.CalendarMultiget;
import com.github.caldav4j.model.request.CalendarQuery;
import com.github.caldav4j.model.request.CalendarRequest;
import com.github.caldav4j.model.request.FreeBusyQuery;
import com.github.caldav4j.model.request.TimeRange;
import com.github.caldav4j.model.response.CalendarDataProperty;
import com.github.caldav4j.util.GenerateQuery;
import com.github.caldav4j.util.ICalendarUtils;
import com.github.caldav4j.util.MethodUtil;
import com.github.caldav4j.util.UrlUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalDAVCollection
extends CalDAVCalendarCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(CalDAVCollection.class);

    public CalDAVCollection() {
    }

    public CalDAVCollection(String uri) {
        this.setCalendarCollectionRoot(uri);
        this.setMethodFactory(new CalDAV4JMethodFactory());
        this.prodId = "-//NONSGML CalDAV4j Client//EN";
    }

    public CalDAVCollection(String path, HttpHost httpHost, CalDAV4JMethodFactory methodFactory, String prodId) {
        this.setCalendarCollectionRoot(path);
        this.httpHost = httpHost;
        this.methodFactory = methodFactory;
        this.prodId = prodId;
    }

    public Calendar getCalendarForEventUID(HttpClient httpClient, String uid) throws CalDAV4JException {
        return this.getCalDAVResourceForEventUID(httpClient, uid).getCalendar();
    }

    public Calendar getCalendar(HttpClient httpClient, String icsRelativePath) throws CalDAV4JException {
        return this.getCalDAVResource(httpClient, this.getAbsolutePath(icsRelativePath)).getCalendar();
    }

    public Calendar queryCalendar(HttpClient httpClient, String component, String uid, String recurrenceId) throws CalDAV4JException {
        String filter = String.format("%s : UID==%s", component, uid);
        if (recurrenceId != null) {
            filter = String.format("%s, RECURRENCE-ID==%s", filter, recurrenceId);
        }
        GenerateQuery gq = new GenerateQuery(component, filter);
        List<Calendar> cals = this.queryCalendars(httpClient, gq.generate());
        switch (cals.size()) {
            case 1: {
                return cals.get(0);
            }
            case 0: {
                return null;
            }
        }
        throw new CalDAV4JException("More than one calendar returned for uid " + uid);
    }

    public List<Calendar> getEventResources(HttpClient httpClient, Date beginDate, Date endDate) throws CalDAV4JException {
        GenerateQuery gq = new GenerateQuery();
        gq.setFilter("VEVENT");
        gq.setTimeRange(beginDate, endDate);
        return this.queryCalendars(httpClient, gq.generate());
    }

    public void delete(HttpClient httpClient, String component, String uid) throws CalDAV4JException {
        CalDAVResource resource = this.getCalDAVResourceByUID(httpClient, component, uid);
        Calendar calendar = resource.getCalendar();
        ComponentList eventList = calendar.getComponents().getComponents(component);
        ArrayList<CalendarComponent> componentsToRemove = new ArrayList<CalendarComponent>();
        boolean hasOtherEvents = false;
        for (CalendarComponent calendarComponent : eventList) {
            String curUID = ICalendarUtils.getUIDValue((Component)calendarComponent);
            if (!uid.equals(curUID)) {
                hasOtherEvents = true;
                continue;
            }
            componentsToRemove.add(calendarComponent);
        }
        if (hasOtherEvents) {
            if (componentsToRemove.size() == 0) {
                throw new ResourceNotFoundException(ResourceNotFoundException.IdentifierType.UID, uid);
            }
            for (Component component2 : componentsToRemove) {
                calendar.getComponents().remove((Object)component2);
            }
            this.put(httpClient, calendar, UrlUtils.stripHost(resource.getResourceMetadata().getHref()), resource.getResourceMetadata().getETag());
            return;
        }
        this.delete(httpClient, UrlUtils.stripHost(resource.getResourceMetadata().getHref()));
    }

    public void createCalendar(HttpClient httpClient) throws CalDAV4JException {
        HttpMkCalendarMethod mkCalendarMethod = null;
        try {
            mkCalendarMethod = this.methodFactory.createMkCalendarMethod(this.getCalendarCollectionRoot());
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(mkCalendarMethod.getURI()), (HttpRequest)mkCalendarMethod);
            if (!mkCalendarMethod.succeeded(response)) {
                MethodUtil.StatusToExceptions((HttpRequestBase)mkCalendarMethod, response);
            }
        }
        catch (Exception e) {
            throw new CalDAV4JException("Trouble executing MKCalendar", e);
        }
        finally {
            if (mkCalendarMethod != null) {
                mkCalendarMethod.reset();
            }
        }
    }

    private void put(HttpClient httpClient, Calendar calendar, String path, String etag) throws CalDAV4JException {
        CalendarRequest cr = new CalendarRequest();
        cr.addEtag(etag);
        cr.setIfMatch(true);
        cr.setCalendar(calendar);
        HttpPutMethod putMethod = this.methodFactory.createPutMethod(path, cr);
        try {
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(putMethod.getURI()), (HttpRequest)putMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 201: 
                case 204: {
                    break;
                }
                case 412: {
                    throw new ResourceOutOfDateException("Etag was not matched: " + etag);
                }
                default: {
                    throw new BadStatusException(statusCode, putMethod.getMethod(), path);
                }
            }
            if (this.isCacheEnabled()) {
                Header h = putMethod.getFirstHeader("ETag");
                String newEtag = null;
                newEtag = h != null ? h.getValue() : this.getETagbyMultiget(httpClient, path);
                this.cache.putResource(new CalDAVResource(calendar, newEtag, putMethod.getURI().toString()));
            }
        }
        catch (BadStatusException | ResourceOutOfDateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CalDAV4JException("Problem executing put method", e);
        }
        finally {
            putMethod.reset();
        }
    }

    public String add(HttpClient httpClient, CalendarComponent vevent, VTimeZone timezone) throws CalDAV4JException {
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId(this.prodId));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        if (timezone != null) {
            calendar.getComponents().add((Object)timezone);
        }
        calendar.getComponents().add((Object)vevent);
        return this.add(httpClient, calendar);
    }

    public String add(HttpClient httpClient, Calendar c) throws CalDAV4JException {
        return this.add(httpClient, c, true);
    }

    public String add(HttpClient httpClient, Calendar c, boolean attemptRetry) throws CalDAV4JException {
        Random random = new Random();
        boolean didIt = false;
        String path = "";
        Uid uid = null;
        block6: for (int x = 0; x < 3 && !didIt; ++x) {
            Object resourceName = null;
            uid = ICalendarUtils.setUID(c);
            if (x > 0) {
                uid.setValue(uid.getValue() + "-" + random.nextInt());
            }
            HttpPutMethod putMethod = this.createPutMethodForNewResource(uid.getValue() + ".ics", c);
            HttpResponse response = null;
            try {
                response = httpClient.execute(this.getDefaultHttpHost(putMethod.getURI()), (HttpRequest)putMethod);
                if (this.isCacheEnabled() && putMethod.succeeded(response)) {
                    String etag = UrlUtils.getHeaderPrettyValue(response, "ETag");
                    if (etag == null) {
                        etag = this.getETagbyMultiget(httpClient, putMethod.getURI().toString());
                    }
                    CalDAVResource calDAVResource = new CalDAVResource(c, etag, putMethod.getURI().toString());
                    this.cache.putResource(calDAVResource);
                }
            }
            catch (Exception e) {
                throw new CalDAV4JException("Trouble executing PUT", e);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 201: 
                case 204: {
                    didIt = true;
                    continue block6;
                }
                case 412: {
                    if (attemptRetry) continue block6;
                }
                default: {
                    MethodUtil.StatusToExceptions((HttpRequestBase)putMethod, response);
                }
            }
        }
        return uid.getValue();
    }

    public void updateMasterEvent(HttpClient httpClient, VEvent vevent, VTimeZone timezone) throws CalDAV4JException {
        String uid = ICalendarUtils.getUIDValue((Component)vevent);
        CalDAVResource resource = this.getCalDAVResourceByUID(httpClient, "VEVENT", uid);
        Calendar calendar = resource.getCalendar();
        VEvent originalVEvent = ICalendarUtils.getMasterEvent(calendar, uid);
        calendar.getComponents().remove((Object)originalVEvent);
        calendar.getComponents().add((Object)vevent);
        if (timezone != null) {
            VTimeZone originalVTimeZone = ICalendarUtils.getTimezone(calendar);
            if (originalVTimeZone != null) {
                calendar.getComponents().remove((Object)originalVTimeZone);
            }
            calendar.getComponents().add((Object)timezone);
        }
        this.put(httpClient, calendar, UrlUtils.stripHost(resource.getResourceMetadata().getHref()), resource.getResourceMetadata().getETag());
    }

    private CalDAVResource getCalDAVResourceForEventUID(HttpClient httpClient, String uid) throws CalDAV4JException {
        return this.getCalDAVResourceByUID(httpClient, "VEVENT", uid);
    }

    protected CalDAVResource getCalDAVResourceByUID(HttpClient httpClient, String component, String uid) throws CalDAV4JException, ResourceNotFoundException {
        String href = this.cache.getHrefForEventUID(uid);
        CalDAVResource resource = null;
        if (href != null) {
            resource = this.getCalDAVResource(httpClient, UrlUtils.stripHost(href));
            if (resource != null) {
                return resource;
            }
        } else {
            try {
                resource = this.getCalDAVResource(httpClient, this.getAbsolutePath(uid + ".ics"));
                if (uid.equals(ICalendarUtils.getUIDValue((Component)ICalendarUtils.getFirstComponent(resource, component)))) {
                    return resource;
                }
            }
            catch (Exception e) {
                resource = null;
            }
        }
        GenerateQuery gq = new GenerateQuery(null, component + " : UID==" + uid);
        List<CalDAVResource> cr = this.getCalDAVResources(httpClient, gq.generate());
        try {
            resource = cr.get(0);
            if (uid.equals(ICalendarUtils.getUIDValue((Component)ICalendarUtils.getFirstComponent(resource, component)))) {
                this.cache.putResource(resource);
                return resource;
            }
            throw new Exception();
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(ResourceNotFoundException.IdentifierType.UID, uid);
        }
    }

    protected CalDAVResource getCalDAVResource(HttpClient httpClient, String path) throws CalDAV4JException {
        CalDAVResource calDAVResource = this.cache.getResource(this.getHref(path));
        if (calDAVResource == null || calDAVResource.getCalendar() == null) {
            return this.getCalDAVResourceFromServer(httpClient, path);
        }
        String currentEtag = this.getETag(httpClient, path);
        return this.getCalDAVResource(httpClient, path, currentEtag);
    }

    protected CalDAVResource getCalDAVResource(HttpClient httpClient, String path, String currentEtag) throws CalDAV4JException {
        String cachedEtag;
        CalDAVResource calDAVResource = this.cache.getResource(this.getHref(path));
        if (calDAVResource != null && calDAVResource.getCalendar() != null && (cachedEtag = calDAVResource.getResourceMetadata().getETag()).equals(currentEtag)) {
            return calDAVResource;
        }
        return this.getCalDAVResourceFromServer(httpClient, path);
    }

    protected CalDAVResource getCalDAVResourceFromServer(HttpClient httpClient, String path) throws CalDAV4JException {
        CalDAVResource calDAVResource = null;
        HttpGetMethod getMethod = this.getMethodFactory().createGetMethod(path);
        try {
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(getMethod.getURI()), (HttpRequest)getMethod);
            if (response.getStatusLine().getStatusCode() != 200) {
                MethodUtil.StatusToExceptions((HttpRequestBase)getMethod, response);
                throw new BadStatusException(getMethod, response);
            }
            String href = this.getHref(path);
            String etag = response.getFirstHeader("ETag").getValue();
            Calendar calendar = null;
            if (this.isTolerantParsing()) {
                CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)false);
                CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)false);
                CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
                CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)false);
            }
            calendar = getMethod.getResponseBodyAsCalendar(response);
            calDAVResource = new CalDAVResource();
            calDAVResource.setCalendar(calendar);
            calDAVResource.getResourceMetadata().setETag(etag);
            calDAVResource.getResourceMetadata().setHref(href);
            this.cache.putResource(calDAVResource);
        }
        catch (BadStatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CalDAV4JException("Problem executing get method", e);
        }
        finally {
            getMethod.reset();
        }
        return calDAVResource;
    }

    public void delete(HttpClient httpClient, String path) throws CalDAV4JException {
        HttpDeleteMethod deleteMethod = new HttpDeleteMethod(path);
        HttpResponse response = null;
        try {
            response = httpClient.execute(this.httpHost, (HttpRequest)deleteMethod);
        }
        catch (Exception e) {
            throw new CalDAV4JException("Problem executing delete method", e);
        }
        if (response == null || response.getStatusLine().getStatusCode() != 204) {
            MethodUtil.StatusToExceptions((HttpRequestBase)deleteMethod, response);
            throw new CalDAV4JException("Problem executing delete method");
        }
        if (this.isCacheEnabled()) {
            this.cache.removeResource(this.getHref(path));
        }
    }

    protected String getAbsolutePath(String relativePath) {
        return (this.getCalendarCollectionRoot() + relativePath).replaceAll("/+", "/");
    }

    protected String getETag(HttpClient httpClient, String path) throws CalDAV4JException {
        HttpHead headMethod = new HttpHead(path);
        try {
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(headMethod.getURI()), (HttpRequest)headMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new ResourceNotFoundException(ResourceNotFoundException.IdentifierType.PATH, path);
            }
            if (statusCode != 200) {
                throw new BadStatusException(headMethod, response);
            }
        }
        catch (IOException e) {
            throw new CalDAV4JException("Problem executing HEAD method on: " + this.getDefaultHttpHost(headMethod.getURI()), e);
        }
        Header h = headMethod.getFirstHeader("ETag");
        String etag = null;
        etag = h != null ? h.getValue() : this.getETagbyMultiget(httpClient, path);
        return etag;
    }

    protected String getETagbyMultiget(HttpClient httpClient, String path) throws CalDAV4JException {
        String etag = null;
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(DavPropertyName.GETETAG);
        CalendarMultiget query = new CalendarMultiget(props, null, false, false);
        query.addHref(path);
        MultiStatus multiStatus = this.getMultiStatusforQuery(httpClient, query);
        for (MultiStatusResponse response : multiStatus.getResponses()) {
            if (response.getStatus()[0].getStatusCode() != 200) continue;
            etag = CalendarDataProperty.getEtagfromResponse(response);
        }
        return etag;
    }

    protected List<String> getComponentProperty(HttpClient httpClient, String componentName, String propertyName, CalendarQuery query) throws CalDAV4JException {
        ArrayList<String> propertyList = new ArrayList<String>();
        List<Calendar> calendarList = this.getCalendarLight(httpClient, query);
        for (Calendar cal : calendarList) {
            propertyList.add(ICalendarUtils.getPropertyValue((Component)cal.getComponent(componentName), propertyName));
        }
        return propertyList;
    }

    public List<Calendar> queryCalendars(HttpClient httpClient, CalendarQuery query) throws CalDAV4JException {
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        for (CalDAVResource cr : this.getCalDAVResources(httpClient, query)) {
            list.add(cr.getCalendar());
        }
        return list;
    }

    public List<Calendar> getCalendarLight(HttpClient httpClient, CalendarQuery query) throws CalDAV4JException {
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        if (this.isCacheEnabled()) {
            query.setCalendarDataProp(null);
        }
        HttpCalDAVReportMethod reportMethod = null;
        try {
            MultiStatusResponse[] set;
            reportMethod = this.methodFactory.createCalDAVReportMethod(this.getCalendarCollectionRoot(), (CalDAVReportRequest)query, 1);
            HttpResponse httpResponse = httpClient.execute(this.getDefaultHttpHost(reportMethod.getURI()), (HttpRequest)reportMethod);
            for (MultiStatusResponse response : set = reportMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                String etag = CalendarDataProperty.getEtagfromResponse(response);
                if (this.isCacheEnabled()) {
                    CalDAVResource resource = this.getCalDAVResource(httpClient, UrlUtils.stripHost(response.getHref()), etag);
                    list.add(resource.getCalendar());
                    this.cache.putResource(resource);
                    continue;
                }
                Calendar cal = CalendarDataProperty.getCalendarfromResponse(response);
                if (cal == null) continue;
                list.add(cal);
            }
        }
        catch (Exception he) {
            throw new CalDAV4JException("Problem executing method", he);
        }
        finally {
            if (reportMethod != null) {
                reportMethod.reset();
            }
        }
        return list;
    }

    public MultiStatus getMultiStatusforQuery(HttpClient httpClient, CalDAVReportRequest query) throws CalDAV4JException {
        HttpCalDAVReportMethod reportMethod = null;
        try {
            reportMethod = this.methodFactory.createCalDAVReportMethod(this.getCalendarCollectionRoot(), query, 1);
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(reportMethod.getURI()), (HttpRequest)reportMethod);
            if (reportMethod.succeeded(response)) {
                MultiStatus multiStatus = reportMethod.getResponseBodyAsMultiStatus(response);
                return multiStatus;
            }
        }
        catch (Exception he) {
            throw new CalDAV4JException("Problem executing method", he);
        }
        finally {
            if (reportMethod != null) {
                reportMethod.reset();
            }
        }
        return null;
    }

    protected List<CalDAVResource> getCalDAVResources(HttpClient httpClient, CalendarQuery query) throws CalDAV4JException {
        boolean usingCache = this.isCacheEnabled();
        if (usingCache) {
            query.setCalendarDataProp(null);
            log.debug("Using cache, so I am removing calendar data");
        }
        log.trace("Executing query: " + GenerateQuery.printQuery(query));
        HttpCalDAVReportMethod reportMethod = null;
        ArrayList<CalDAVResource> list = new ArrayList<CalDAVResource>();
        try {
            MultiStatusResponse[] responses;
            reportMethod = this.methodFactory.createCalDAVReportMethod(this.getCalendarCollectionRoot(), (CalDAVReportRequest)query, 1);
            HttpResponse httpResponse = httpClient.execute(this.getDefaultHttpHost(reportMethod.getURI()), (HttpRequest)reportMethod);
            log.trace("Parsing response.. ");
            for (MultiStatusResponse response : responses = reportMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                String etag = CalendarDataProperty.getEtagfromResponse(response);
                if (usingCache) {
                    CalDAVResource resource = this.getCalDAVResource(httpClient, UrlUtils.stripHost(response.getHref()), etag);
                    list.add(resource);
                    this.cache.putResource(resource);
                    continue;
                }
                if (response == null) continue;
                list.add(new CalDAVResource(response));
            }
        }
        catch (ConnectException connEx) {
            throw new CalDAV4JException("Can't connecto to " + this.getDefaultHttpHost(reportMethod.getURI()), connEx.getCause());
        }
        catch (Exception he) {
            throw new CalDAV4JException("Problem executing method", he);
        }
        finally {
            if (reportMethod != null) {
                reportMethod.reset();
            }
        }
        return list;
    }

    protected List<Calendar> getComponentByMultiget(HttpClient httpClient, CalendarMultiget query) throws CalDAV4JException {
        if (this.isCacheEnabled()) {
            query.setCalendarDataProp(null);
        }
        HttpCalDAVReportMethod reportMethod = null;
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        try {
            MultiStatusResponse[] e;
            reportMethod = this.methodFactory.createCalDAVReportMethod(this.getCalendarCollectionRoot(), (CalDAVReportRequest)query, 1);
            HttpResponse httpResponse = httpClient.execute(this.getDefaultHttpHost(reportMethod.getURI()), (HttpRequest)reportMethod);
            for (MultiStatusResponse response : e = reportMethod.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
                CalDAVResource resource = null;
                if (this.isCacheEnabled()) {
                    String etag = CalendarDataProperty.getEtagfromResponse(response);
                    try {
                        resource = this.getCalDAVResource(httpClient, UrlUtils.stripHost(response.getHref()), etag);
                        list.add(resource.getCalendar());
                    }
                    catch (Exception e1) {
                        log.warn("Unable to get CalDAVResource for etag: " + etag);
                        e1.printStackTrace();
                    }
                    continue;
                }
                list.add(CalendarDataProperty.getCalendarfromResponse(response));
            }
        }
        catch (Exception he) {
            throw new CalDAV4JException("Problem executing method", he);
        }
        finally {
            if (reportMethod != null) {
                reportMethod.reset();
            }
        }
        return list;
    }

    public List<Calendar> multigetCalendarUris(HttpClient httpClient, List<String> calendarUris) throws CalDAV4JException {
        CalendarMultiget query = new CalendarMultiget();
        CalendarData calendarData = new CalendarData();
        query.addProperty((XmlSerializable)CalDAVConstants.DNAME_GETETAG);
        query.setCalendarDataProp(calendarData);
        query.setHrefs(calendarUris);
        return this.getComponentByMultiget(httpClient, query);
    }

    public Calendar getFreeBusyQueryCalendar(HttpClient httpClient, TimeRange timeRange) throws CalDAV4JException {
        return this.getFreeBusyQueryCalendar(httpClient, new FreeBusyQuery(timeRange));
    }

    public Calendar getFreeBusyQueryCalendar(HttpClient httpClient, FreeBusyQuery freeBusyQuery) throws CalDAV4JException {
        HttpCalDAVReportMethod reportMethod = null;
        try {
            reportMethod = this.methodFactory.createCalDAVReportMethod(this.getCalendarCollectionRoot(), (CalDAVReportRequest)freeBusyQuery, 1);
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(reportMethod.getURI()), (HttpRequest)reportMethod);
            if (reportMethod.succeeded(response)) {
                Calendar calendar = reportMethod.getResponseBodyAsCalendar(response);
                return calendar;
            }
        }
        catch (Exception he) {
            throw new CalDAV4JException("Problem executing method", he);
        }
        finally {
            if (reportMethod != null) {
                reportMethod.reset();
            }
        }
        return null;
    }

    public int testConnection(HttpClient httpClient) throws CalDAV4JException {
        HttpHead method = new HttpHead(this.getCalendarCollectionRoot());
        HttpResponse response = null;
        try {
            response = httpClient.execute(this.getDefaultHttpHost(method.getURI()), (HttpRequest)method);
        }
        catch (Exception e) {
            throw new CalDAV4JException(e.getMessage(), new Throwable(e.getCause()));
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                break;
            }
            default: {
                throw new BadStatusException(response.getStatusLine().getStatusCode(), method.getMethod(), this.getCalendarCollectionRoot());
            }
        }
        return response.getStatusLine().getStatusCode();
    }

    public List<AclProperty.Ace> getAces(HttpClient httpClient) throws CalDAV4JException {
        return this.getAces(httpClient, null);
    }

    public List<AclProperty.Ace> getAces(HttpClient httpClient, String path) throws CalDAV4JException {
        DavPropertyNameSet propfind = new DavPropertyNameSet();
        propfind.add(CalDAVConstants.DNAME_ACL);
        HttpPropFindMethod method = null;
        try {
            method = this.methodFactory.createPropFindMethod(this.getCalendarCollectionRoot() + UrlUtils.defaultString(path, ""), propfind, 1);
            HttpResponse response = httpClient.execute(this.getDefaultHttpHost(method.getURI()), (HttpRequest)method);
            if (method.succeeded(response)) {
                List<AclProperty.Ace> list = method.getAces(response, method.getURI().toString());
                return list;
            }
            MethodUtil.StatusToExceptions((HttpRequestBase)method, response);
            List<AclProperty.Ace> list = null;
            return list;
        }
        catch (Exception e) {
            throw new CalDAV4JException("Error in PROPFIND " + this.getCalendarCollectionRoot(), e);
        }
        finally {
            if (method != null) {
                method.reset();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAces(HttpClient client, AclProperty.Ace[] aces, String path) throws CalDAV4JException {
        HttpAclMethod method = null;
        try {
            method = this.methodFactory.createAclMethod(this.getCalendarCollectionRoot() + UrlUtils.defaultString(path, ""), new AclProperty(aces));
            HttpResponse response = client.execute(this.getDefaultHttpHost(method.getURI()), (HttpRequest)method);
            int status = response.getStatusLine().getStatusCode();
            switch (status) {
                case 200: {
                    return;
                }
                case 404: {
                    throw new ResourceNotFoundException(ResourceNotFoundException.IdentifierType.PATH, method.getURI().toString());
                }
                default: {
                    throw new BadStatusException(status, method.getMethod(), this.getCalendarCollectionRoot());
                }
            }
        }
        catch (IOException e) {
            throw new CalDAV4JException("Error in ACL " + this.getCalendarCollectionRoot(), e);
        }
        finally {
            if (method != null) {
                method.reset();
            }
        }
    }
}

