/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AgentState;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.lock.Locker;

public class AsteriskAgentImpl
extends AbstractLiveObject
implements AsteriskAgent {
    private String name;
    private String agentId;
    private AgentState state;

    AsteriskAgentImpl(AsteriskServerImpl server, String name, String agentId, AgentState state) {
        super(server);
        if (server == null || name == null || agentId == null) {
            throw new IllegalArgumentException("Parameters passed to AsteriskAgentImpl() must not be null.");
        }
        this.name = name;
        this.agentId = agentId;
        this.state = state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public AgentState getState() {
        return this.state;
    }

    void updateState(AgentState state) {
        try (Locker.LockCloser closer = this.withLock();){
            AgentState oldState = this.state;
            this.state = state;
            this.firePropertyChange("state", (Object)oldState, (Object)this.state);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AsteriskAgent[");
        sb.append("agentId='").append(this.getAgentId()).append("',");
        sb.append("name='").append(this.getName()).append("',");
        sb.append("state=").append((Object)this.getState()).append(",");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

