/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.chat;

import com.github.openjson.JSONObject;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.confirmation.ConfirmationHelper;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.user.chat.ChatForm;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.AjaxDownloadBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;

public class ChatToolbar
extends Panel
implements IWysiwygToolbar {
    private static final long serialVersionUID = 1L;
    private static final String CHAT_FNAME_TMPL = "chatlog_%s.txt";
    private final WebMarkupContainer toolbar = new WebMarkupContainer("toolbar");
    private final WebMarkupContainer save = new WebMarkupContainer("save");
    private final ChatForm chatForm;
    private AjaxButton delBtn;
    private final AjaxDownloadBehavior download = new AjaxDownloadBehavior((IResource)new ResourceStreamResource(){
        private static final long serialVersionUID = 1L;
        private static final char DELIMITER = ',';
        private static final char QUOTE_CHAR = '\"';
        private final String quoteReplacement = "" + '\"' + '\"';
        {
            this.setCacheDuration(Duration.ZERO);
        }

        protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
            AbstractResource.ResourceResponse rr = super.newResourceResponse(attributes);
            boolean admin = AuthLevelUtil.hasAdminLevel(WebSession.getRights());
            if (!ChatToolbar.this.chatForm.process(() -> admin, r -> admin || RoomPanel.isModerator(ChatToolbar.this.cm, WebSession.getUserId(), r.getId()), u -> true)) {
                rr.setError(Integer.valueOf(403));
            }
            return rr;
        }

        private String getName(User u) {
            return String.format("%s %s", u.getFirstname(), u.getLastname());
        }

        private StringBuilder appendQuoted(StringBuilder sb, String value) {
            return sb.append('\"').append(value == null ? "" : value.replace(String.valueOf('\"'), this.quoteReplacement)).append('\"');
        }

        private void export(List<ChatMessage> list, StringBuilder sb) {
            String lineDelim = "";
            for (ChatMessage msg : list) {
                sb.append(lineDelim);
                this.appendQuoted(sb, this.getName(msg.getFromUser())).append(',');
                this.appendQuoted(sb, WebSession.getDateFormat().format(msg.getSent())).append(',');
                this.appendQuoted(sb, msg.getMessage());
                lineDelim = "\r\n";
            }
        }

        protected IResourceStream getResourceStream(IResource.Attributes attributes) {
            boolean admin = AuthLevelUtil.hasAdminLevel(WebSession.getRights());
            StringBuilder sb = new StringBuilder();
            ChatToolbar.this.chatForm.process(() -> {
                if (admin) {
                    this.setFileName(String.format(ChatToolbar.CHAT_FNAME_TMPL, "global"));
                    this.export(ChatToolbar.this.chatDao.getGlobal(0L, Integer.MAX_VALUE), sb);
                }
                return true;
            }, r -> {
                if (admin || RoomPanel.isModerator(ChatToolbar.this.cm, WebSession.getUserId(), r.getId())) {
                    this.setFileName(String.format(ChatToolbar.CHAT_FNAME_TMPL, "room_" + r.getId()));
                    this.export(ChatToolbar.this.chatDao.getRoom(r.getId().longValue(), 0L, Integer.MAX_VALUE, true), sb);
                }
                return true;
            }, u -> {
                this.setFileName(String.format(ChatToolbar.CHAT_FNAME_TMPL, "user_" + u.getId()));
                this.export(ChatToolbar.this.chatDao.getUser(u.getId().longValue(), 0L, Integer.MAX_VALUE), sb);
                return true;
            });
            StringResourceStream srs = new StringResourceStream((CharSequence)sb, "text/csv");
            srs.setCharset(StandardCharsets.UTF_8);
            return srs;
        }
    });
    @Inject
    private ClientManager cm;
    @Inject
    private ChatDao chatDao;

    public ChatToolbar(String id, ChatForm form) {
        this(id, form, null);
    }

    public ChatToolbar(String id, ChatForm form, IModel<String> model) {
        super(id, model);
        this.chatForm = form;
    }

    public void attachToEditor(Component editor) {
        this.toolbar.add(new Behavior[]{AttributeModifier.replace((String)"data-bs-target", (Serializable)((Object)IJQueryWidget.JQueryWidget.getSelector((Component)editor)))});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.toolbar});
        this.add(new Behavior[]{this.download});
        this.delBtn = new AjaxButton("delete", this.chatForm){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                String scope = ChatToolbar.this.chatForm.getScope();
                boolean admin = AuthLevelUtil.hasAdminLevel(WebSession.getRights());
                ChatToolbar.this.chatForm.process(() -> {
                    if (admin) {
                        ChatToolbar.this.chatDao.deleteGlobal();
                        WebSocketHelper.sendAll((String)ChatToolbar.cleanMsg("chatTab-all").toString());
                    }
                    return true;
                }, r -> {
                    if (admin || RoomPanel.isModerator(ChatToolbar.this.cm, WebSession.getUserId(), r.getId())) {
                        ChatToolbar.this.chatDao.deleteRoom(r.getId());
                        WebSocketHelper.sendRoom((Long)r.getId(), (JSONObject)ChatToolbar.cleanMsg(scope));
                    }
                    return true;
                }, u -> {
                    ChatToolbar.this.chatDao.deleteUser(u.getId());
                    WebSocketHelper.sendUser((Long)u.getId(), (JSONObject)ChatToolbar.cleanMsg(scope));
                    return true;
                });
            }
        };
        this.delBtn.add(new Behavior[]{new ConfirmationBehavior(ConfirmationHelper.newOkCancelDangerConfirmCfg((Component)this, this.getString("832")).withCustomClass("chat-delete"))});
        this.toolbar.add(new Component[]{this.delBtn.setVisible(AuthLevelUtil.hasAdminLevel(WebSession.getRights())).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        Component[] componentArray = new Component[1];
        Behavior[] behaviorArray = new Behavior[1];
        behaviorArray[0] = AjaxEventBehavior.onEvent((String)"click", arg_0 -> ((AjaxDownloadBehavior)this.download).initiate(arg_0));
        componentArray[0] = this.save.setVisible(AuthLevelUtil.hasAdminLevel(WebSession.getRights())).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).add(behaviorArray);
        this.toolbar.add(componentArray);
    }

    private static JSONObject cleanMsg(String scope) {
        return new JSONObject().put("type", (Object)"chat").put("action", (Object)"clean").put("scope", (Object)scope);
    }

    void update(AjaxRequestTarget target) {
        boolean admin = AuthLevelUtil.hasAdminLevel(WebSession.getRights());
        this.chatForm.process(() -> {
            target.add(new Component[]{this.save.setVisible(admin), this.delBtn.setVisible(admin)});
            return true;
        }, r -> {
            boolean moder = admin || RoomPanel.isModerator(this.cm, WebSession.getUserId(), r.getId());
            target.add(new Component[]{this.save.setVisible(moder), this.delBtn.setVisible(moder)});
            return true;
        }, u -> {
            target.add(new Component[]{this.save.setVisible(true), this.delBtn.setVisible(true)});
            return true;
        });
    }
}

