/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import org.apache.wicket.Application;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.ResourceUtils;

public class ContextRelativeResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private final boolean minifyIt;
    private final String minPostfix;

    public ContextRelativeResourceReference(String name) {
        this(name, "min", true);
    }

    public ContextRelativeResourceReference(String name, boolean minifyIt) {
        this(name, "min", minifyIt);
    }

    public ContextRelativeResourceReference(String name, String minPostfix) {
        this(name, minPostfix, true);
    }

    public ContextRelativeResourceReference(String name, String minPostfix, boolean minifyIt) {
        super(name);
        Args.notNull((Object)minPostfix, (String)"minPostfix");
        this.minPostfix = minPostfix;
        this.minifyIt = minifyIt;
    }

    protected ContextRelativeResource buildContextRelativeResource(String name, String minPostfix) {
        String minifiedName = name;
        if (this.canBeMinified()) {
            minifiedName = ResourceUtils.getMinifiedName((String)name, (String)minPostfix);
        }
        return new ContextRelativeResource(minifiedName);
    }

    protected boolean canBeMinified() {
        return this.minifyIt && Application.exists() && Application.get().getResourceSettings().getUseMinifiedResources();
    }

    @Override
    public final ContextRelativeResource getResource() {
        return this.buildContextRelativeResource(this.getName(), this.minPostfix);
    }

    public boolean isMinifyIt() {
        return this.minifyIt;
    }

    public String getMinPostfix() {
        return this.minPostfix;
    }
}

