/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.AndResultSet;
import com.hazelcast.query.impl.OrResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import java.util.Collection;
import java.util.Optional;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static int estimatedSizeOf(Collection<QueryableEntry> result) {
        if (result instanceof AndResultSet) {
            AndResultSet set = (AndResultSet)result;
            return set.estimatedSize();
        }
        if (result instanceof OrResultSet) {
            OrResultSet set = (OrResultSet)result;
            return set.estimatedSize();
        }
        return result.size();
    }

    public static boolean isNull(Comparable value) {
        return value == null || value == AbstractIndex.NULL;
    }

    public static <T> T unwrapIfOptional(Object value) {
        return (T)(value instanceof Optional ? ((Optional)value).orElse(null) : value);
    }

    public static PagingPredicateImpl unwrapPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicateImpl) {
            PagingPredicateImpl impl = (PagingPredicateImpl)predicate;
            return impl;
        }
        Predicate unwrappedPredicate = ((PartitionPredicate)predicate).getTarget();
        return (PagingPredicateImpl)unwrappedPredicate;
    }

    public static void checkDoesNotContainPagingPredicate(Predicate predicate, String methodName) throws IllegalArgumentException {
        if (PredicateUtils.containsPagingPredicate(predicate)) {
            throw new IllegalArgumentException("Paging predicate is not supported in " + methodName + " method");
        }
    }

    public static boolean containsPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicateImpl) {
            return true;
        }
        if (!(predicate instanceof PartitionPredicate)) {
            return false;
        }
        PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
        return partitionPredicate.getTarget() instanceof PagingPredicateImpl;
    }
}

