/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.operation.steps.engine.StepSupplier;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ClearOpSteps implements IMapOpStep
{
    CLEAR_MEMORY{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            if (recordStore == null) {
                return;
            }
            recordStore.checkIfLoaded();
            state.setSizeBefore(recordStore.size());
            boolean tieredStorageEnabled = recordStore.isTieredStorageEnabled();
            ArrayList<Data> keys = new ArrayList<Data>(BATCH_SIZE);
            ArrayList<Record> records = tieredStorageEnabled ? null : new ArrayList<Record>(BATCH_SIZE);
            Iterator<Map.Entry<Data, Record>> iterator = recordStore.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Data, Record> entry = iterator.next();
                Data dataKey = entry.getKey();
                Record record = entry.getValue();
                if (!recordStore.isLocked(dataKey)) {
                    keys.add(tieredStorageEnabled ? ToHeapDataConverter.toHeapData(dataKey) : dataKey);
                    if (!tieredStorageEnabled) {
                        records.add(record);
                    }
                }
                if (keys.size() != BATCH_SIZE) continue;
                break;
            }
            state.setKeys(keys);
            if (!tieredStorageEnabled) {
                state.setRecords(records);
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.getRecordStore() == null ? UtilSteps.FINAL_STEP : CLEAR_MAP_STORE;
        }
    }
    ,
    CLEAR_MAP_STORE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Collection<Data> keys = state.getKeys();
            recordStore.getMapDataStore().removeAll(keys);
            recordStore.getMapDataStore().reset();
        }

        public ClearOpSteps nextStep(State state) {
            return ON_CLEAR;
        }
    }
    ,
    ON_CLEAR{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            int removedKeyCount = recordStore.removeBulk((ArrayList)state.getKeys(), state.getRecords(), false);
            if (removedKeyCount > 0) {
                recordStore.updateStatsOnRemove(Clock.currentTimeMillis());
            }
            state.setResult((Integer)state.getResult() + removedKeyCount);
        }

        @Override
        public Step nextStep(State state) {
            int lockedSize;
            RecordStore recordStore = state.getRecordStore();
            int currentSize = recordStore.size();
            boolean loopingToClear = currentSize - (lockedSize = recordStore.getLockedEntryCount()) > 0;
            state.setSizeAfter(loopingToClear ? state.getSizeBefore() : currentSize);
            Enum injectBeforeStep = loopingToClear ? CLEAR_MEMORY : UtilSteps.FINAL_STEP;
            return StepSupplier.injectCustomStepsToOperation(state.getOperation(), injectBeforeStep);
        }
    };

}

