/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.KubernetesClientException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

interface KubernetesApiProvider {
    public String getEndpointsByServiceLabelUrlString();

    public String getEndpointsByNameUrlString();

    public String getEndpointsUrlString();

    public List<KubernetesClient.Endpoint> parseEndpointsList(JsonObject var1);

    public List<KubernetesClient.Endpoint> parseEndpoints(JsonValue var1);

    public Map<KubernetesClient.EndpointAddress, String> extractServices(JsonObject var1, List<String> var2);

    public Map<KubernetesClient.EndpointAddress, String> extractNodes(JsonObject var1, List<String> var2);

    default public Integer extractPort(JsonValue subsetJson) {
        JsonValue port;
        JsonValue servicePort;
        JsonArray ports = KubernetesApiProvider.toJsonArray(subsetJson.asObject().get("ports"));
        for (JsonValue port2 : ports) {
            JsonValue servicePort2;
            JsonValue hazelcastServicePort = port2.asObject().get("name");
            if (hazelcastServicePort == null || !hazelcastServicePort.asString().equals("hazelcast") || (servicePort2 = port2.asObject().get("port")) == null || !servicePort2.isNumber()) continue;
            return servicePort2.asInt();
        }
        if (ports.size() == 1 && (servicePort = (port = ports.get(0)).asObject().get("port")) != null && servicePort.isNumber()) {
            return servicePort.asInt();
        }
        return null;
    }

    default public Map<String, String> extractAdditionalPropertiesFrom(JsonValue endpointAddressJson) {
        HashSet<String> knownFieldNames = new HashSet<String>(Arrays.asList("ip", "nodeName", "targetRef", "hostname"));
        HashMap<String, String> result = new HashMap<String, String>();
        for (JsonObject.Member member : endpointAddressJson.asObject()) {
            if (knownFieldNames.contains(member.getName())) continue;
            result.put(member.getName(), KubernetesApiProvider.convertToString(member.getValue()));
        }
        return result;
    }

    default public KubernetesClientException noCorrespondingServicesException(Set<String> endpoints) {
        return new KubernetesClientException(String.format("Cannot expose externally, the following Hazelcast member pods do not have corresponding Kubernetes services: %s", endpoints));
    }

    default public KubernetesClientException noNodeNameAssignedException(Set<String> endpoints) {
        return new KubernetesClientException(String.format("Cannot expose externally, the following Hazelcast member pods do not have corresponding Endpoint.nodeName value assigned: %s", endpoints));
    }

    public static JsonArray toJsonArray(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonArray();
        }
        return jsonValue.asArray();
    }

    public static String convertToString(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return null;
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        return jsonValue.toString();
    }

    public static String extractTargetRefName(JsonValue endpointAddressJson) {
        JsonValue targetRef = endpointAddressJson.asObject().get("targetRef");
        if (targetRef == null || targetRef.isNull()) {
            return null;
        }
        return targetRef.asObject().get("name").asString();
    }
}

