/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.instance.impl.ClusterTopologyIntentTracker;
import com.hazelcast.kubernetes.DnsEndpointResolver;
import com.hazelcast.kubernetes.KubernetesApiEndpointResolver;
import com.hazelcast.kubernetes.KubernetesConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.utils.RetryUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HazelcastKubernetesDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final int DNS_RETRY = 5;
    private final EndpointResolver endpointResolver;
    private final Map<String, String> memberMetadata = new HashMap<String, String>();

    HazelcastKubernetesDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties, ClusterTopologyIntentTracker clusterTopologyIntentTracker) {
        super(logger, properties);
        KubernetesConfig config = new KubernetesConfig(properties);
        logger.info(config.toString());
        this.endpointResolver = KubernetesConfig.DiscoveryMode.DNS_LOOKUP.equals((Object)config.getMode()) ? new DnsEndpointResolver(logger, config) : new KubernetesApiEndpointResolver(logger, config, clusterTopologyIntentTracker);
        logger.info("Kubernetes Discovery activated with mode: " + config.getMode().name());
    }

    @Override
    public void start() {
        this.endpointResolver.start();
    }

    @Override
    public Map<String, String> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.endpointResolver.resolveCurrentZone());
            this.memberMetadata.put("hazelcast.partition.group.node", this.endpointResolver.resolveCurrentNodeName());
        }
        return this.memberMetadata;
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        return this.endpointResolver.resolveNodes();
    }

    @Override
    public void destroy() {
        this.endpointResolver.destroy();
    }

    static abstract class EndpointResolver {
        protected final ILogger logger;

        EndpointResolver(ILogger logger) {
            this.logger = logger;
        }

        abstract List<DiscoveryNode> resolveNodes();

        String resolveCurrentZone() {
            return "unknown";
        }

        String resolveCurrentNodeName() {
            return "unknown";
        }

        void start() {
        }

        void destroy() {
        }

        protected InetAddress mapAddress(String address) {
            if (address == null) {
                return null;
            }
            try {
                return RetryUtils.retry(() -> InetAddress.getByName(address), 5);
            }
            catch (Exception e) {
                this.logger.warning("Address '" + address + "' could not be resolved");
                return null;
            }
        }
    }
}

