/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.processor.TwoPhaseSnapshotCommitUtility;
import com.hazelcast.jet.impl.processor.UnboundedTransactionsProcessorUtility;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.ConnectorPermission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.function.LongSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WriteFileP<T>
implements Processor {
    private static final LongSupplier SYSTEM_CLOCK = System::currentTimeMillis;
    private static final Pattern FILE_INDEX_WITH_SEQ = Pattern.compile("(\\d+)-\\d+(\\.tmp)?$");
    private final Path directory;
    private final FunctionEx<? super T, ? extends String> toStringFn;
    private final Charset charset;
    private final DateTimeFormatter dateFormatter;
    private final long maxFileSize;
    private final boolean exactlyOnce;
    private final LongSupplier clock;
    private UnboundedTransactionsProcessorUtility<FileId, FileResource> utility;
    private Processor.Context context;
    private int fileSequence;
    private SizeTrackingStream sizeTrackingStream;
    private String lastFileDate;

    public WriteFileP(@Nonnull String directoryName, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull String charset, @Nullable String dateFormatter, long maxFileSize, boolean exactlyOnce, @Nonnull LongSupplier clock) {
        this.directory = Paths.get(directoryName, new String[0]);
        this.toStringFn = toStringFn;
        this.charset = Charset.forName(charset);
        this.dateFormatter = dateFormatter != null ? DateTimeFormatter.ofPattern(dateFormatter).withZone(ZoneId.from(ZoneOffset.UTC)) : null;
        this.maxFileSize = maxFileSize;
        this.exactlyOnce = exactlyOnce;
        this.clock = clock;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws IOException {
        this.context = context;
        Files.createDirectories(this.directory, new FileAttribute[0]);
        ProcessingGuarantee guarantee = context.processingGuarantee() == ProcessingGuarantee.EXACTLY_ONCE && !this.exactlyOnce ? ProcessingGuarantee.AT_LEAST_ONCE : context.processingGuarantee();
        this.utility = new UnboundedTransactionsProcessorUtility<FileId, FileResource>(outbox, context, guarantee, this::newFileName, this::newFileResource, this::recoverAndCommit, this::abortUnfinishedTransactions);
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    public boolean tryProcess() {
        return this.utility.tryProcess();
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.dateFormatter != null && !this.currentTimeFormatted().equals(this.lastFileDate)) {
            this.fileSequence = 0;
            this.utility.finishActiveTransaction();
        }
        FileResource transaction = this.utility.activeTransaction();
        Writer writer = transaction.writer();
        try {
            Object item;
            while ((item = inbox.poll()) != null) {
                Object castedItem = item;
                writer.write(this.toStringFn.apply(castedItem));
                writer.write(System.lineSeparator());
                if (this.maxFileSize == Long.MAX_VALUE || this.sizeTrackingStream.size < this.maxFileSize) continue;
                this.utility.finishActiveTransaction();
                writer = this.utility.activeTransaction().writer();
            }
            writer.flush();
            if (this.maxFileSize != Long.MAX_VALUE && this.sizeTrackingStream.size >= this.maxFileSize) {
                this.utility.finishActiveTransaction();
            }
        }
        catch (IOException e) {
            throw new RestartableException(e);
        }
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    @Override
    public boolean complete() {
        this.utility.afterCompleted();
        return true;
    }

    @Override
    public void close() {
        if (this.utility != null) {
            this.utility.close();
        }
    }

    @Override
    public boolean snapshotCommitPrepare() {
        return this.utility.snapshotCommitPrepare();
    }

    @Override
    public boolean snapshotCommitFinish(boolean success) {
        return this.utility.snapshotCommitFinish(success);
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.utility.restoreFromSnapshot(inbox);
    }

    private FileId newFileName() {
        boolean usesSequence;
        StringBuilder sb = new StringBuilder();
        if (this.dateFormatter != null) {
            this.lastFileDate = this.currentTimeFormatted();
            sb.append(this.lastFileDate);
            sb.append('-');
        }
        sb.append(this.context.globalProcessorIndex());
        String file = sb.toString();
        boolean bl = usesSequence = this.utility.externalGuarantee() == ProcessingGuarantee.EXACTLY_ONCE || this.maxFileSize != Long.MAX_VALUE;
        if (usesSequence) {
            int prefixLength = sb.length();
            do {
                sb.append('-').append(this.fileSequence++);
                file = sb.toString();
                sb.setLength(prefixLength);
            } while (Files.exists(this.directory.resolve(file), new LinkOption[0]) || Files.exists(this.directory.resolve(file + ".tmp"), new LinkOption[0]));
        }
        return new FileId(file, this.context.globalProcessorIndex());
    }

    private FileResource newFileResource(FileId fileId) {
        return this.utility.externalGuarantee() == ProcessingGuarantee.EXACTLY_ONCE ? new FileWithTransaction(fileId) : new FileWithoutTransaction(fileId);
    }

    private void recoverAndCommit(FileId fileId) throws IOException {
        Path tempFile = this.directory.resolve(fileId.fileName + ".tmp");
        Path finalFile = this.directory.resolve(fileId.fileName);
        if (Files.exists(tempFile, new LinkOption[0])) {
            Files.move(tempFile, finalFile, StandardCopyOption.ATOMIC_MOVE);
        } else if (!Files.exists(finalFile, new LinkOption[0])) {
            this.context.logger().warning("Neither temporary nor final file from the previous execution exists, data loss might occur: " + tempFile);
        }
    }

    private void abortUnfinishedTransactions() {
        try (Stream<Path> fileStream = Files.list(this.directory);){
            fileStream.filter(file -> file.getFileName().toString().endsWith(".tmp")).filter(file -> {
                int index;
                assert (this.utility.usesTransactionLifecycle());
                Matcher m = FILE_INDEX_WITH_SEQ.matcher(file.getFileName().toString());
                if (!m.find() || m.groupCount() < 1) {
                    this.context.logger().warning("file with unknown name structure found in the directory: " + file);
                    return false;
                }
                try {
                    index = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException e) {
                    this.context.logger().warning("file with unknown name structure found in the directory: " + file, e);
                    return false;
                }
                return index % this.context.totalParallelism() == this.context.globalProcessorIndex();
            }).forEach(file -> Util.uncheckRun(() -> {
                this.context.logger().fine("deleting %s", file);
                Files.delete(file);
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Writer createWriter(Path file) {
        try {
            this.context.logger().fine("creating %s", file);
            FileOutputStream fos = new FileOutputStream(file.toFile(), true);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.sizeTrackingStream = new SizeTrackingStream(bos);
            return new OutputStreamWriter((OutputStream)this.sizeTrackingStream, this.charset);
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    private String currentTimeFormatted() {
        return this.dateFormatter.format(Instant.ofEpochMilli(this.clock.getAsLong()));
    }

    public static <T> ProcessorMetaSupplier metaSupplier(@Nonnull String directoryName, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull String charset, @Nullable String datePattern, long maxFileSize, boolean exactlyOnce) {
        return WriteFileP.metaSupplier(directoryName, toStringFn, charset, datePattern, maxFileSize, exactlyOnce, SYSTEM_CLOCK);
    }

    static <T> ProcessorMetaSupplier metaSupplier(@Nonnull String directoryName, @Nonnull FunctionEx<? super T, ? extends String> toStringFn, @Nonnull String charset, @Nullable String datePattern, long maxFileSize, boolean exactlyOnce, @Nonnull LongSupplier clock) {
        return ProcessorMetaSupplier.preferLocalParallelismOne((Permission)ConnectorPermission.file(directoryName, "write"), SecuredFunctions.writeFileProcessorFn(directoryName, toStringFn, charset, datePattern, maxFileSize, exactlyOnce, clock));
    }

    private abstract class FileResource
    implements TwoPhaseSnapshotCommitUtility.TransactionalResource<FileId> {
        final FileId fileId;
        final Path targetFile;
        Writer writer;

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="targetFile always has fileName")
        FileResource(FileId fileId) {
            this.fileId = fileId;
            this.targetFile = WriteFileP.this.directory.resolve(fileId.fileName);
        }

        @Override
        public FileId id() {
            return this.fileId;
        }

        @Override
        public void endAndPrepare() throws IOException {
            this.closeFile();
        }

        @Override
        public void release() throws IOException {
            this.closeFile();
        }

        private void closeFile() throws IOException {
            if (this.writer != null) {
                WriteFileP.this.context.logger().fine("closing %s", this.id().fileName);
                this.writer.close();
                this.writer = null;
            }
        }

        public Writer writer() {
            return this.writer;
        }
    }

    private static final class SizeTrackingStream
    extends OutputStream {
        private final OutputStream target;
        private long size;

        private SizeTrackingStream(OutputStream target) {
            this.target = target;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            this.target.write(b);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            this.size += (long)len;
            this.target.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.target.close();
        }

        @Override
        public void flush() throws IOException {
            this.target.flush();
        }
    }

    public static final class FileId
    implements TwoPhaseSnapshotCommitUtility.TransactionId,
    IdentifiedDataSerializable {
        private String fileName;
        private int index;

        public FileId() {
        }

        private FileId(String fileName, int index) {
            this.fileName = fileName;
            this.index = index;
        }

        @Override
        public int index() {
            return this.index;
        }

        public String toString() {
            return "File{" + this.fileName + "}";
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 42;
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.fileName = in.readString();
            this.index = in.readInt();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.fileName);
            out.writeInt(this.index);
        }
    }

    private final class FileWithTransaction
    extends FileResource {
        private final Path tempFile;

        FileWithTransaction(FileId fileId) {
            super(fileId);
            this.tempFile = WriteFileP.this.directory.resolve(fileId.fileName + ".tmp");
        }

        @Override
        public void begin() {
            this.writer = WriteFileP.this.createWriter(this.tempFile);
        }

        @Override
        public void commit() throws IOException {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            Files.move(this.tempFile, this.targetFile, StandardCopyOption.ATOMIC_MOVE);
        }

        @Override
        public void rollback() throws Exception {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            Files.delete(this.tempFile);
        }
    }

    private final class FileWithoutTransaction
    extends FileResource {
        FileWithoutTransaction(FileId fileId) {
            super(fileId);
        }

        @Override
        public Writer writer() {
            if (this.writer == null) {
                this.writer = WriteFileP.this.createWriter(this.targetFile);
            }
            return super.writer();
        }
    }
}

