/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.nio.SelectorMode;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.ServerSocketRegistry;
import com.hazelcast.internal.server.tcp.TcpServer;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class TcpServerAcceptor
implements DynamicMetricsProvider {
    private static final long SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final long SELECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final int SELECT_IDLE_COUNT_THRESHOLD = 10;
    private final ServerSocketRegistry registry;
    private final TcpServer server;
    private final ILogger logger;
    private final ServerContext serverContext;
    @Probe(name="eventCount", level=ProbeLevel.DEBUG)
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe(name="exceptionCount", level=ProbeLevel.DEBUG)
    private final SwCounter exceptionCount = SwCounter.newSwCounter();
    @Probe(name="selectorRecreateCount", level=ProbeLevel.DEBUG)
    private final SwCounter selectorRecreateCount = SwCounter.newSwCounter();
    private final AcceptorIOThread acceptorThread;
    private volatile long lastSelectTimeMs;
    private final boolean selectorWorkaround = SelectorMode.getConfiguredValue() == SelectorMode.SELECT_WITH_FIX;
    private volatile boolean stop;
    private volatile Selector selector;
    private final Set<SelectionKey> selectionKeys = Collections.newSetFromMap(new ConcurrentHashMap());

    TcpServerAcceptor(ServerSocketRegistry registry, TcpServer server, ServerContext serverContext) {
        this.registry = registry;
        this.server = server;
        this.serverContext = server.getContext();
        this.logger = serverContext.getLoggingService().getLogger(this.getClass());
        this.acceptorThread = new AcceptorIOThread();
    }

    @Probe(name="idleTimeMillis", unit=ProbeUnit.MS, level=ProbeLevel.DEBUG)
    private long idleTimeMillis() {
        return Math.max(System.currentTimeMillis() - this.lastSelectTimeMs, 0L);
    }

    public TcpServerAcceptor start() {
        this.acceptorThread.start();
        return this;
    }

    public synchronized void shutdown() {
        if (this.stop) {
            return;
        }
        this.logger.finest("Shutting down SocketAcceptor thread.");
        this.stop = true;
        Selector sel = this.selector;
        if (sel != null) {
            sel.wakeup();
        }
        try {
            this.acceptorThread.join(SHUTDOWN_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.finest(e);
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        context.collect(descriptor.withPrefix("tcp.acceptor").withDiscriminator("thread", this.acceptorThread.getName()), this);
    }

    private final class AcceptorIOThread
    extends Thread {
        private AcceptorIOThread() {
            super(ThreadUtil.createThreadPoolName(TcpServerAcceptor.this.serverContext.getHazelcastName(), "IO") + "Acceptor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TcpServerAcceptor.this.logger.isFinestEnabled()) {
                TcpServerAcceptor.this.logger.finest("Starting TcpIpAcceptor on " + TcpServerAcceptor.this.registry);
            }
            try {
                TcpServerAcceptor.this.selector = Selector.open();
                for (ServerSocketRegistry.Pair entry : TcpServerAcceptor.this.registry) {
                    ServerSocketChannel serverSocketChannel = entry.getChannel();
                    serverSocketChannel.configureBlocking(false);
                    SelectionKey selectionKey = serverSocketChannel.register(TcpServerAcceptor.this.selector, 16);
                    selectionKey.attach(entry);
                    TcpServerAcceptor.this.selectionKeys.add(selectionKey);
                }
                if (TcpServerAcceptor.this.selectorWorkaround) {
                    this.acceptLoopWithSelectorFix();
                } else {
                    this.acceptLoop();
                }
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (Throwable e) {
                TcpServerAcceptor.this.logger.severe(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            finally {
                IOUtil.closeResource(TcpServerAcceptor.this.selector);
            }
        }

        private void acceptLoop() throws IOException {
            while (!TcpServerAcceptor.this.stop) {
                int keyCount = TcpServerAcceptor.this.selector.select();
                if (this.isInterrupted()) break;
                if (keyCount == 0) continue;
                Iterator<SelectionKey> it = TcpServerAcceptor.this.selector.selectedKeys().iterator();
                this.handleSelectionKeys(it);
            }
        }

        private void acceptLoopWithSelectorFix() throws IOException {
            int idleCount = 0;
            while (!TcpServerAcceptor.this.stop) {
                long before = System.currentTimeMillis();
                int keyCount = TcpServerAcceptor.this.selector.select(SELECT_TIMEOUT_MILLIS);
                if (this.isInterrupted()) break;
                if (keyCount == 0) {
                    long selectTimeTaken = System.currentTimeMillis() - before;
                    idleCount = selectTimeTaken < SELECT_TIMEOUT_MILLIS ? idleCount + 1 : 0;
                    if (idleCount <= 10) continue;
                    this.rebuildSelector();
                    idleCount = 0;
                    continue;
                }
                idleCount = 0;
                Iterator<SelectionKey> it = TcpServerAcceptor.this.selector.selectedKeys().iterator();
                this.handleSelectionKeys(it);
            }
        }

        private void rebuildSelector() throws IOException {
            Selector newSelector;
            TcpServerAcceptor.this.selectorRecreateCount.inc();
            for (SelectionKey key : TcpServerAcceptor.this.selectionKeys) {
                key.cancel();
            }
            TcpServerAcceptor.this.selectionKeys.clear();
            IOUtil.closeResource(TcpServerAcceptor.this.selector);
            TcpServerAcceptor.this.selector = newSelector = Selector.open();
            for (ServerSocketRegistry.Pair entry : TcpServerAcceptor.this.registry) {
                ServerSocketChannel serverSocketChannel = entry.getChannel();
                SelectionKey selectionKey = serverSocketChannel.register(newSelector, 16);
                selectionKey.attach(entry);
                TcpServerAcceptor.this.selectionKeys.add(selectionKey);
            }
        }

        private void handleSelectionKeys(Iterator<SelectionKey> it) {
            TcpServerAcceptor.this.lastSelectTimeMs = System.currentTimeMillis();
            while (it.hasNext()) {
                SelectionKey sk = it.next();
                it.remove();
                if (!sk.isValid() || !sk.isAcceptable()) continue;
                TcpServerAcceptor.this.eventCount.inc();
                ServerSocketRegistry.Pair attachment = (ServerSocketRegistry.Pair)sk.attachment();
                ServerSocketChannel serverSocketChannel = attachment.getChannel();
                try {
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    if (socketChannel == null) continue;
                    this.newConnection(attachment.getQualifier(), socketChannel);
                }
                catch (Exception e) {
                    this.handleAcceptException(serverSocketChannel, e);
                }
            }
        }

        private void handleAcceptException(ServerSocketChannel serverSocketChannel, Exception e) {
            TcpServerAcceptor.this.exceptionCount.inc();
            if (e instanceof ClosedChannelException && !TcpServerAcceptor.this.server.isLive()) {
                TcpServerAcceptor.this.logger.finest("Terminating socket acceptor thread...", e);
            } else {
                TcpServerAcceptor.this.logger.severe("Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage());
                try {
                    serverSocketChannel.close();
                }
                catch (Exception ex) {
                    TcpServerAcceptor.this.logger.finest("Closing server socket failed", ex);
                }
                TcpServerAcceptor.this.serverContext.onFatalError(e);
            }
        }

        private void newConnection(EndpointQualifier qualifier, SocketChannel socketChannel) throws IOException {
            TcpServerConnectionManager connectionManager = TcpServerAcceptor.this.server.getConnectionManager(qualifier);
            Channel channel = connectionManager.newChannel(socketChannel, false);
            if (TcpServerAcceptor.this.logger.isFineEnabled()) {
                TcpServerAcceptor.this.logger.fine("Accepting socket connection from " + channel.socket().getRemoteSocketAddress());
            }
            TcpServerAcceptor.this.serverContext.getAuditLogService().eventBuilder("HZ-0101").message("New connection accepted.").addParameter("qualifier", qualifier).addParameter("remoteAddress", socketChannel.getRemoteAddress()).log();
            if (TcpServerAcceptor.this.serverContext.isSocketInterceptorEnabled(qualifier)) {
                TcpServerAcceptor.this.serverContext.submitAsync(() -> this.newConnection0(connectionManager, channel));
            } else {
                this.newConnection0(connectionManager, channel);
            }
        }

        private void newConnection0(TcpServerConnectionManager connectionManager, Channel channel) {
            try {
                TcpServerAcceptor.this.serverContext.interceptSocket(connectionManager.getEndpointQualifier(), channel.socket(), true);
                connectionManager.newConnection(channel, null, true);
            }
            catch (Exception e) {
                TcpServerAcceptor.this.exceptionCount.inc();
                TcpServerAcceptor.this.logger.warning(e.getClass().getName() + ": " + e.getMessage(), e);
                IOUtil.closeResource(channel);
            }
        }
    }
}

