/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.iterator;

import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEndEntryViewIterationCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapFetchEntryViewsCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ClientReplicatedMapEntryViewIterator
implements Iterator<ReplicatedMapEntryViewHolder> {
    private UUID currentCursorId;
    private List<ReplicatedMapEntryViewHolder> currentPage;
    private int index;
    private boolean noMorePages;
    private final UUID iteratorId;
    private final int fetchSize;
    private final String mapName;
    private final int partitionId;
    private final ClientContext context;

    public ClientReplicatedMapEntryViewIterator(@Nonnull String mapName, int partitionId, @Nonnull UUID iteratorId, @Nonnull UUID currentCursorId, List<ReplicatedMapEntryViewHolder> initialPage, int fetchSize, ClientContext context) {
        this.mapName = mapName;
        this.partitionId = partitionId;
        this.iteratorId = iteratorId;
        this.currentCursorId = currentCursorId;
        this.currentPage = initialPage;
        this.fetchSize = fetchSize;
        this.index = 0;
        this.context = context;
    }

    @Override
    public boolean hasNext() {
        return this.currentPage != null && this.index < this.currentPage.size();
    }

    @Override
    public ReplicatedMapEntryViewHolder next() {
        if (this.index >= this.currentPage.size()) {
            throw new NoSuchElementException();
        }
        ReplicatedMapEntryViewHolder nextItem = this.currentPage.get(this.index);
        ++this.index;
        if (this.index >= this.currentPage.size() && this.fetchNewPage()) {
            this.index = 0;
        }
        return nextItem;
    }

    private boolean fetchNewPage() {
        if (this.noMorePages) {
            return false;
        }
        ClientMessage message = ReplicatedMapFetchEntryViewsCodec.encodeRequest(this.mapName, this.currentCursorId, false, this.partitionId, this.fetchSize);
        ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstance)((HazelcastClientInstanceImpl)this.context.getHazelcastInstance()), message, (Object)this.mapName, this.partitionId);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            ReplicatedMapFetchEntryViewsCodec.ResponseParameters responseParameters = ReplicatedMapFetchEntryViewsCodec.decodeResponse((ClientMessage)f.get());
            this.currentPage = responseParameters.entryViews;
            if (this.currentPage.size() < this.fetchSize) {
                ClientMessage request = ReplicatedMapEndEntryViewIterationCodec.encodeRequest(this.mapName, this.iteratorId);
                ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)((HazelcastClientInstanceImpl)this.context.getHazelcastInstance()), request, (Object)this.mapName, this.partitionId);
                invocation.invoke();
                this.noMorePages = true;
            }
            this.currentCursorId = responseParameters.cursorId;
            return true;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

