/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard;

import java.util.List;
import java.util.Map;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetLocation;
import org.wicketstuff.dashboard.web.DashboardEvent;

public class DashboardUtils {
    public static void updateWidgetLocations(Dashboard dashboard, DashboardEvent dashboardEvent) {
        block4: {
            DashboardEvent.EventType eventType;
            block5: {
                block3: {
                    eventType = dashboardEvent.getType();
                    if (DashboardEvent.EventType.WIDGET_ADDED != eventType) break block3;
                    List<Widget> widgets = dashboard.getWidgets(0);
                    for (Widget widget : widgets) {
                        widget.getLocation().incrementRow();
                    }
                    break block4;
                }
                if (DashboardEvent.EventType.WIDGET_REMOVED != eventType) break block5;
                Widget widgetRemoved = (Widget)dashboardEvent.getDetail();
                WidgetLocation widgetRemovedLocation = widgetRemoved.getLocation();
                List<Widget> widgets = dashboard.getWidgets(widgetRemovedLocation.getColumn());
                for (Widget widget : widgets) {
                    WidgetLocation widgetLocation = widget.getLocation();
                    if (widgetLocation.getRow() <= widgetRemovedLocation.getRow()) continue;
                    widget.getLocation().decrementRow();
                }
                break block4;
            }
            if (DashboardEvent.EventType.WIDGETS_SORTED != eventType) break block4;
            Map widgetLocations = (Map)dashboardEvent.getDetail();
            List<Widget> widgets = dashboard.getWidgets();
            for (Widget widget : widgets) {
                String id = widget.getId();
                WidgetLocation location = (WidgetLocation)widgetLocations.get(id);
                if (location.equals(widget.getLocation())) continue;
                widget.setLocation(location);
            }
        }
    }
}

