/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.registry.bootstrap.RunNiFiRegistry;

public class ShutdownHook
extends Thread {
    private final Process nifiRegistryProcess;
    private final RunNiFiRegistry runner;
    private final int gracefulShutdownSeconds;
    private final ExecutorService executor;
    private volatile String secretKey;

    public ShutdownHook(Process nifiRegistryProcess, RunNiFiRegistry runner, String secretKey, int gracefulShutdownSeconds, ExecutorService executor) {
        this.nifiRegistryProcess = nifiRegistryProcess;
        this.runner = runner;
        this.secretKey = secretKey;
        this.gracefulShutdownSeconds = gracefulShutdownSeconds;
        this.executor = executor;
    }

    void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public void run() {
        this.executor.shutdown();
        this.runner.setAutoRestartNiFiRegistry(false);
        int ccPort = this.runner.getNiFiRegistryCommandControlPort();
        if (ccPort > 0) {
            System.out.println("Initiating Shutdown of NiFi Registry...");
            try {
                Socket socket = new Socket("localhost", ccPort);
                OutputStream out = socket.getOutputStream();
                out.write(("SHUTDOWN " + this.secretKey + "\n").getBytes(StandardCharsets.UTF_8));
                out.flush();
                socket.close();
            }
            catch (IOException ioe) {
                System.out.println("Failed to Shutdown NiFi Registry due to " + String.valueOf(ioe));
            }
        }
        this.runner.notifyStop();
        System.out.println("Waiting for Apache NiFi Registry to finish shutting down...");
        long startWait = System.nanoTime();
        while (RunNiFiRegistry.isAlive(this.nifiRegistryProcess)) {
            long waitNanos = System.nanoTime() - startWait;
            long waitSeconds = TimeUnit.NANOSECONDS.toSeconds(waitNanos);
            if (waitSeconds >= (long)this.gracefulShutdownSeconds && this.gracefulShutdownSeconds > 0) {
                if (!RunNiFiRegistry.isAlive(this.nifiRegistryProcess)) break;
                System.out.println("NiFi Registry has not finished shutting down after " + this.gracefulShutdownSeconds + " seconds. Killing process.");
                this.nifiRegistryProcess.destroy();
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            File statusFile = this.runner.getStatusFile();
            if (!statusFile.delete()) {
                System.err.println("Failed to delete status file " + statusFile.getAbsolutePath() + "; this file should be cleaned up manually");
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to retrieve status file " + String.valueOf(ex));
        }
    }
}

