/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bundle;

public class BundleCoordinate {
    public static final String DEFAULT_GROUP = "default";
    public static final String DEFAULT_VERSION = "unversioned";
    public static final BundleCoordinate UNKNOWN_COORDINATE = new BundleCoordinate("default", "unknown", "unversioned");
    private final String group;
    private final String id;
    private final String version;
    private final String coordinate;

    public BundleCoordinate(String group, String id, String version) {
        this.group = this.isBlank(group) ? DEFAULT_GROUP : group;
        this.id = id;
        String string = this.version = this.isBlank(version) ? DEFAULT_VERSION : version;
        if (this.isBlank(id)) {
            throw new IllegalStateException("Id is required for BundleCoordinate");
        }
        this.coordinate = this.group + ":" + this.id + ":" + this.version;
    }

    private boolean isBlank(String str) {
        return str == null || str.isBlank();
    }

    public String getGroup() {
        return this.group;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public final String getCoordinate() {
        return this.coordinate;
    }

    public String toString() {
        return this.coordinate;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleCoordinate)) {
            return false;
        }
        BundleCoordinate other = (BundleCoordinate)obj;
        return this.getCoordinate().equals(other.getCoordinate());
    }

    public int hashCode() {
        return 37 * this.coordinate.hashCode();
    }
}

