/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.pulsar;

import java.util.ArrayList;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderBuilder;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderBuilder;
import org.springframework.boot.autoconfigure.pulsar.DeadLetterPolicyMapper;
import org.springframework.boot.autoconfigure.pulsar.PulsarProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;

final class PulsarReactivePropertiesMapper {
    private final PulsarProperties properties;

    PulsarReactivePropertiesMapper(PulsarProperties properties) {
        this.properties = properties;
    }

    <T> void customizeMessageSenderBuilder(ReactiveMessageSenderBuilder<T> builder) {
        PulsarProperties.Producer properties = this.properties.getProducer();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> builder.producerName(arg_0));
        map.from(properties::getTopicName).to(arg_0 -> builder.topic(arg_0));
        map.from(properties::getSendTimeout).to(arg_0 -> builder.sendTimeout(arg_0));
        map.from(properties::getMessageRoutingMode).to(arg_0 -> builder.messageRoutingMode(arg_0));
        map.from(properties::getHashingScheme).to(arg_0 -> builder.hashingScheme(arg_0));
        map.from(properties::isBatchingEnabled).to(arg_0 -> builder.batchingEnabled(arg_0));
        map.from(properties::isChunkingEnabled).to(arg_0 -> builder.chunkingEnabled(arg_0));
        map.from(properties::getCompressionType).to(arg_0 -> builder.compressionType(arg_0));
        map.from(properties::getAccessMode).to(arg_0 -> builder.accessMode(arg_0));
    }

    <T> void customizeMessageConsumerBuilder(ReactiveMessageConsumerBuilder<T> builder) {
        PulsarProperties.Consumer properties = this.properties.getConsumer();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> builder.consumerName(arg_0));
        map.from(properties::getTopics).as(ArrayList::new).to(arg_0 -> builder.topics(arg_0));
        map.from(properties::getTopicsPattern).to(arg_0 -> builder.topicsPattern(arg_0));
        map.from(properties::getPriorityLevel).to(arg_0 -> builder.priorityLevel(arg_0));
        map.from(properties::isReadCompacted).to(arg_0 -> builder.readCompacted(arg_0));
        map.from(properties::getDeadLetterPolicy).as(DeadLetterPolicyMapper::map).to(arg_0 -> builder.deadLetterPolicy(arg_0));
        map.from(properties::isRetryEnable).to(arg_0 -> builder.retryLetterTopicEnable(arg_0));
        this.customizerMessageConsumerBuilderSubscription(builder);
    }

    private <T> void customizerMessageConsumerBuilderSubscription(ReactiveMessageConsumerBuilder<T> builder) {
        PulsarProperties.Consumer.Subscription properties = this.properties.getConsumer().getSubscription();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> builder.subscriptionName(arg_0));
        map.from(properties::getInitialPosition).to(arg_0 -> builder.subscriptionInitialPosition(arg_0));
        map.from(properties::getMode).to(arg_0 -> builder.subscriptionMode(arg_0));
        map.from(properties::getTopicsMode).to(arg_0 -> builder.topicsPatternSubscriptionMode(arg_0));
        map.from(properties::getType).to(arg_0 -> builder.subscriptionType(arg_0));
    }

    <T> void customizeContainerProperties(ReactivePulsarContainerProperties<T> containerProperties) {
        this.customizePulsarContainerConsumerSubscriptionProperties(containerProperties);
        this.customizePulsarContainerListenerProperties(containerProperties);
    }

    private void customizePulsarContainerConsumerSubscriptionProperties(ReactivePulsarContainerProperties<?> containerProperties) {
        PulsarProperties.Consumer.Subscription properties = this.properties.getConsumer().getSubscription();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getType).to(arg_0 -> containerProperties.setSubscriptionType(arg_0));
        map.from(properties::getName).to(arg_0 -> containerProperties.setSubscriptionName(arg_0));
    }

    private void customizePulsarContainerListenerProperties(ReactivePulsarContainerProperties<?> containerProperties) {
        PulsarProperties.Listener properties = this.properties.getListener();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getSchemaType).to(arg_0 -> containerProperties.setSchemaType(arg_0));
        map.from(properties::getConcurrency).to(arg_0 -> containerProperties.setConcurrency(arg_0));
    }

    void customizeMessageReaderBuilder(ReactiveMessageReaderBuilder<?> builder) {
        PulsarProperties.Reader properties = this.properties.getReader();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::getName).to(arg_0 -> builder.readerName(arg_0));
        map.from(properties::getTopics).to(arg_0 -> builder.topics(arg_0));
        map.from(properties::getSubscriptionName).to(arg_0 -> builder.subscriptionName(arg_0));
        map.from(properties::getSubscriptionRolePrefix).to(arg_0 -> builder.generatedSubscriptionNamePrefix(arg_0));
        map.from(properties::isReadCompacted).to(arg_0 -> builder.readCompacted(arg_0));
    }
}

