/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.IOException;
import org.apache.sshd.agent.unix.ChannelAgentForwarding;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;

public class ChannelAgentForwardingFactory
implements ChannelFactory {
    public static final ChannelAgentForwardingFactory OPENSSH = new ChannelAgentForwardingFactory("auth-agent@openssh.com");
    public static final ChannelAgentForwardingFactory IETF = new ChannelAgentForwardingFactory("auth-agent");
    private final String name;
    private final Factory<CloseableExecutorService> executorServiceFactory;

    public ChannelAgentForwardingFactory(String name) {
        this(name, null);
    }

    public ChannelAgentForwardingFactory(String name, Factory<CloseableExecutorService> executorServiceFactory) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No channel factory name specified");
        this.executorServiceFactory = executorServiceFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Channel createChannel(Session session) throws IOException {
        CloseableExecutorService executorService = this.executorServiceFactory != null ? this.executorServiceFactory.create() : null;
        ChannelAgentForwarding channel = new ChannelAgentForwarding(executorService);
        return channel;
    }
}

