/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LazyConnectionDataSourceProxy
extends DelegatingDataSource {
    static final Map<String, Integer> constants = Map.of("TRANSACTION_READ_UNCOMMITTED", 1, "TRANSACTION_READ_COMMITTED", 2, "TRANSACTION_REPEATABLE_READ", 4, "TRANSACTION_SERIALIZABLE", 8);
    private static final Log logger = LogFactory.getLog(LazyConnectionDataSourceProxy.class);
    @Nullable
    private DataSource readOnlyDataSource;
    @Nullable
    private volatile Boolean defaultAutoCommit;
    @Nullable
    private volatile Integer defaultTransactionIsolation;

    public LazyConnectionDataSourceProxy() {
    }

    public LazyConnectionDataSourceProxy(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
        this.afterPropertiesSet();
    }

    public void setReadOnlyDataSource(@Nullable DataSource readOnlyDataSource) {
        this.readOnlyDataSource = readOnlyDataSource;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolationName(String constantName) {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer defaultTransactionIsolation = constants.get(constantName);
        Assert.notNull((Object)defaultTransactionIsolation, (String)"Only transaction isolation constants allowed");
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        Assert.isTrue((boolean)constants.containsValue(defaultTransactionIsolation), (String)"Only values of transaction isolation constants allowed");
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void checkDefaultConnectionProperties() {
        if (this.defaultAutoCommit == null || this.defaultTransactionIsolation == null) {
            try (Connection con = this.obtainTargetDataSource().getConnection();){
                this.checkDefaultConnectionProperties(con);
            }
            catch (SQLException ex) {
                logger.debug((Object)"Could not retrieve default auto-commit and transaction isolation settings", (Throwable)ex);
            }
        }
    }

    protected void checkDefaultConnectionProperties(Connection con) throws SQLException {
        if (this.defaultAutoCommit == null) {
            this.defaultAutoCommit = con.getAutoCommit();
        }
        if (this.defaultTransactionIsolation == null) {
            this.defaultTransactionIsolation = con.getTransactionIsolation();
        }
    }

    @Nullable
    protected Boolean defaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    @Nullable
    protected Integer defaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkDefaultConnectionProperties();
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new LazyConnectionInvocationHandler());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.checkDefaultConnectionProperties();
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new LazyConnectionInvocationHandler(username, password));
    }

    private class LazyConnectionInvocationHandler
    implements InvocationHandler {
        @Nullable
        private String username;
        @Nullable
        private String password;
        @Nullable
        private Boolean autoCommit;
        @Nullable
        private Integer transactionIsolation;
        private boolean readOnly = false;
        private int holdability = 2;
        private boolean closed = false;
        @Nullable
        private Connection target;

        public LazyConnectionInvocationHandler() {
            this.autoCommit = LazyConnectionDataSourceProxy.this.defaultAutoCommit();
            this.transactionIsolation = LazyConnectionDataSourceProxy.this.defaultTransactionIsolation();
        }

        public LazyConnectionInvocationHandler(String username, String password) {
            this();
            this.username = username;
            this.password = password;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "getTargetConnection": {
                    return this.getTargetConnection(method);
                }
                case "unwrap": {
                    if (!((Class)args[0]).isInstance(proxy)) break;
                    return proxy;
                }
                case "isWrapperFor": {
                    if (!((Class)args[0]).isInstance(proxy)) break;
                    return true;
                }
            }
            if (!this.hasTargetConnection()) {
                switch (method.getName()) {
                    case "toString": {
                        return "Lazy Connection proxy for target DataSource [" + String.valueOf(LazyConnectionDataSourceProxy.this.getTargetDataSource()) + "]";
                    }
                    case "getAutoCommit": {
                        if (this.autoCommit == null) break;
                        return this.autoCommit;
                    }
                    case "setAutoCommit": {
                        this.autoCommit = (Boolean)args[0];
                        return null;
                    }
                    case "getTransactionIsolation": {
                        if (this.transactionIsolation == null) break;
                        return this.transactionIsolation;
                    }
                    case "setTransactionIsolation": {
                        this.transactionIsolation = (Integer)args[0];
                        return null;
                    }
                    case "isReadOnly": {
                        return this.readOnly;
                    }
                    case "setReadOnly": {
                        this.readOnly = (Boolean)args[0];
                        return null;
                    }
                    case "getHoldability": {
                        return this.holdability;
                    }
                    case "setHoldability": {
                        this.holdability = (Integer)args[0];
                        return null;
                    }
                    case "commit": 
                    case "rollback": {
                        return null;
                    }
                    case "getWarnings": 
                    case "clearWarnings": {
                        return null;
                    }
                    case "close": {
                        this.closed = true;
                        return null;
                    }
                    case "isClosed": {
                        return this.closed;
                    }
                    default: {
                        if (!this.closed) break;
                        throw new SQLException("Illegal operation: connection is closed");
                    }
                }
            }
            if (LazyConnectionDataSourceProxy.this.readOnlyDataSource != null && "setReadOnly".equals(method.getName())) {
                return null;
            }
            try {
                Connection conToUse = this.getTargetConnection(method);
                if ("rollback".equals(method.getName()) && conToUse.isClosed()) {
                    return null;
                }
                return method.invoke((Object)conToUse, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private boolean hasTargetConnection() {
            return this.target != null;
        }

        private Connection getTargetConnection(Method operation) throws SQLException {
            if (this.target == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Connecting to database for operation '" + operation.getName() + "'"));
                }
                DataSource dataSource = this.getDataSourceToUse();
                Connection connection = this.target = this.username != null ? dataSource.getConnection(this.username, this.password) : dataSource.getConnection();
                if (this.target == null) {
                    throw new IllegalStateException("DataSource returned null from getConnection(): " + String.valueOf(dataSource));
                }
                if (this.readOnly && LazyConnectionDataSourceProxy.this.readOnlyDataSource == null) {
                    try {
                        this.target.setReadOnly(true);
                    }
                    catch (Exception ex) {
                        logger.debug((Object)"Could not set JDBC Connection read-only", (Throwable)ex);
                    }
                }
                if (this.transactionIsolation != null && !this.transactionIsolation.equals(LazyConnectionDataSourceProxy.this.defaultTransactionIsolation())) {
                    this.target.setTransactionIsolation(this.transactionIsolation);
                }
                if (this.autoCommit != null && this.autoCommit != LazyConnectionDataSourceProxy.this.defaultAutoCommit()) {
                    this.target.setAutoCommit(this.autoCommit);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("Using existing database connection for operation '" + operation.getName() + "'"));
            }
            return this.target;
        }

        private DataSource getDataSourceToUse() {
            return this.readOnly && LazyConnectionDataSourceProxy.this.readOnlyDataSource != null ? LazyConnectionDataSourceProxy.this.readOnlyDataSource : LazyConnectionDataSourceProxy.this.obtainTargetDataSource();
        }
    }
}

