/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.java;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class JavaMigrationExecutor
implements MigrationExecutor {
    private final JavaMigration javaMigration;
    private final StatementInterceptor statementInterceptor;

    @Override
    public List<Results> execute(Context context) throws SQLException {
        if (this.statementInterceptor != null) {
            this.statementInterceptor.javaMigration(this.javaMigration);
        } else {
            DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(context.getConnection(), context.getConfiguration());
            DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
            strategy.execute(() -> {
                this.executeOnce(context);
                return true;
            });
        }
        return List.of();
    }

    private void executeOnce(final Context context) throws SQLException {
        try {
            this.javaMigration.migrate(new org.flywaydb.core.api.migration.Context(){

                @Override
                public Configuration getConfiguration() {
                    return context.getConfiguration();
                }

                @Override
                public Connection getConnection() {
                    return context.getConnection();
                }
            });
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.javaMigration.canExecuteInTransaction();
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Generated
    public JavaMigrationExecutor(JavaMigration javaMigration, StatementInterceptor statementInterceptor) {
        this.javaMigration = javaMigration;
        this.statementInterceptor = statementInterceptor;
    }
}

