/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.core.checksums.ChecksumSpecs;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public class LegacyMd5ExecutionInterceptor
implements ExecutionInterceptor {
    public static final String HTTP_CHECKSUM_HEADER_PREFIX = "x-amz-checksum";

    private LegacyMd5ExecutionInterceptor() {
    }

    public static LegacyMd5ExecutionInterceptor create() {
        return new LegacyMd5ExecutionInterceptor();
    }

    public static boolean isMd5ChecksumRequired(ExecutionAttributes executionAttributes) {
        ChecksumSpecs resolvedChecksumSpecs = LegacyMd5ExecutionInterceptor.getResolvedChecksumSpecs(executionAttributes);
        if (resolvedChecksumSpecs == null) {
            return false;
        }
        return resolvedChecksumSpecs.algorithm() == null && resolvedChecksumSpecs.isRequestChecksumRequired();
    }

    public static ChecksumSpecs getResolvedChecksumSpecs(ExecutionAttributes executionAttributes) {
        ChecksumSpecs checksumSpecs = (ChecksumSpecs)executionAttributes.getAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS);
        return checksumSpecs != null ? checksumSpecs : LegacyMd5ExecutionInterceptor.resolveChecksumSpecs(executionAttributes);
    }

    public static ChecksumSpecs resolveChecksumSpecs(ExecutionAttributes executionAttributes) {
        HttpChecksum httpChecksumTraitInOperation = (HttpChecksum)executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM);
        if (httpChecksumTraitInOperation == null) {
            return null;
        }
        boolean hasRequestValidation = httpChecksumTraitInOperation.requestValidationMode() != null;
        String requestAlgorithm = httpChecksumTraitInOperation.requestAlgorithm();
        String checksumHeaderName = requestAlgorithm != null ? LegacyMd5ExecutionInterceptor.httpChecksumHeader(requestAlgorithm) : null;
        return ChecksumSpecs.builder().algorithmV2(DefaultChecksumAlgorithm.fromValue((String)requestAlgorithm)).headerName(checksumHeaderName).responseValidationAlgorithmsV2(httpChecksumTraitInOperation.responseAlgorithmsV2()).isValidationEnabled(hasRequestValidation).isRequestChecksumRequired(httpChecksumTraitInOperation.isRequestChecksumRequired()).isRequestStreaming(httpChecksumTraitInOperation.isRequestStreaming()).requestAlgorithmHeader(httpChecksumTraitInOperation.requestAlgorithmHeader()).build();
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        boolean isHttpChecksumRequired = this.isHttpChecksumRequired(executionAttributes);
        boolean requestAlreadyHasMd5 = context.httpRequest().firstMatchingHeader("Content-MD5").isPresent();
        Optional syncContent = context.requestBody();
        Optional asyncContent = context.asyncRequestBody();
        if (!isHttpChecksumRequired || requestAlreadyHasMd5) {
            return context.httpRequest();
        }
        if (asyncContent.isPresent()) {
            throw new IllegalStateException("This operation requires a content-MD5 checksum, but one cannot be calculated for non-blocking content.");
        }
        if (syncContent.isPresent()) {
            try {
                String payloadMd5 = Md5Utils.md5AsBase64((InputStream)((RequestBody)syncContent.get()).contentStreamProvider().newStream());
                return (SdkHttpRequest)context.httpRequest().copy(r -> r.putHeader("Content-MD5", payloadMd5));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return context.httpRequest();
    }

    private boolean isHttpChecksumRequired(ExecutionAttributes executionAttributes) {
        return executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED) != null || LegacyMd5ExecutionInterceptor.isMd5ChecksumRequired(executionAttributes);
    }

    private static String httpChecksumHeader(String algorithmName) {
        return "x-amz-checksum-" + StringUtils.lowerCase((String)algorithmName);
    }
}

