/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.exception.IllegalAttributeException;

public class StringToInstantEvaluator
extends InstantEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> format;
    private final Evaluator<String> timeZone;

    public StringToInstantEvaluator(Evaluator<String> subject, Evaluator<String> format, Evaluator<String> timeZone) {
        this.subject = subject;
        this.format = format;
        this.timeZone = timeZone;
    }

    @Override
    public QueryResult<Instant> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        String formatValue = this.format.evaluate(evaluationContext).getValue();
        if (subjectValue == null || formatValue == null) {
            return new InstantQueryResult(null);
        }
        QueryResult<String> tzResult = this.timeZone.evaluate(evaluationContext);
        String tz = tzResult.getValue();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(formatValue, Locale.US).withZone(ZoneId.of(tz));
        try {
            return new InstantQueryResult(dtf.parse((CharSequence)subjectValue, Instant::from));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalAttributeException("Invalid instant format: " + formatValue);
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

