/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectRegexRule
extends RegexRule {
    protected String _location;
    private int _statusCode = 302;
    private boolean _addQueries = false;

    public RedirectRegexRule() {
    }

    public RedirectRegexRule(@Name(value="regex") String regex, @Name(value="location") String location) {
        super(regex);
        this._location = location;
    }

    @Override
    public boolean isTerminating() {
        return true;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public boolean isAddQueries() {
        return this._addQueries;
    }

    public void setAddQueries(boolean flag) {
        this._addQueries = flag;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(int statusCode) {
        if (!HttpStatus.isRedirection((int)statusCode)) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    protected Rule.Handler apply(final Rule.Handler input, final Matcher matcher) throws IOException {
        return new Rule.Handler(this, input){
            final /* synthetic */ RedirectRegexRule this$0;
            {
                this.this$0 = this$0;
                super(handler);
            }

            @Override
            protected boolean handle(Response response, Callback callback) {
                Object target = matcher.replaceAll(this.this$0.getLocation());
                if (this.this$0.isAddQueries() && StringUtil.isNotBlank((String)input.getHttpURI().getQuery())) {
                    String inputQuery = input.getHttpURI().getQuery();
                    String targetPath = null;
                    String targetQuery = null;
                    int targetQueryIdx = ((String)target).indexOf("?");
                    if (targetQueryIdx != -1) {
                        targetPath = ((String)target).substring(0, targetQueryIdx);
                        targetQuery = ((String)target).substring(targetQueryIdx + 1);
                    } else {
                        targetPath = target;
                    }
                    String resultingQuery = URIUtil.addQueries((String)inputQuery, targetQuery);
                    target = targetPath + "?" + resultingQuery;
                }
                response.setStatus(this.this$0._statusCode);
                response.getHeaders().put(HttpHeader.LOCATION, Response.toRedirectURI((Request)this, (String)target));
                callback.succeeded();
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[redirect:%d>%s]".formatted(super.toString(), this.getStatusCode(), this.getLocation());
    }
}

