/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.file.launcher;

import java.util.prefs.Preferences;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.util.NbPreferences;

final class GlobalSettingsPanel extends javax.swing.JPanel {

    private final GlobalSettingsOptionsPanelController controller;

    GlobalSettingsPanel(GlobalSettingsOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        // TODO listen to changes in form fields and call controller.changed()
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        vmTextField = new javax.swing.JTextField();
        vmLabel = new javax.swing.JLabel();
        singleRunCheckBox = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();

        vmLabel.setLabelFor(vmTextField);
        org.openide.awt.Mnemonics.setLocalizedText(vmLabel, org.openide.util.NbBundle.getMessage(GlobalSettingsPanel.class, "GlobalSettingsPanel.vmLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(singleRunCheckBox, org.openide.util.NbBundle.getMessage(GlobalSettingsPanel.class, "GlobalSettingsPanel.singleRunCheckBox.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(GlobalSettingsPanel.class, "GlobalSettingsPanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(vmLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(singleRunCheckBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(vmTextField)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(vmLabel)
                    .addComponent(vmTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(singleRunCheckBox)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    void load() {
        Preferences prefs = NbPreferences.forModule(JavaPlatformManager.class);
        vmTextField.setText(prefs.get(SingleSourceFileUtil.GLOBAL_VM_OPTIONS, "")); // NOI18N
        singleRunCheckBox.setSelected(prefs.getBoolean(SingleSourceFileUtil.GLOBAL_STOP_AND_RUN_OPTION, false)); // NOI18N
    }

    void store() {
        Preferences prefs = NbPreferences.forModule(JavaPlatformManager.class);
        prefs.put(SingleSourceFileUtil.GLOBAL_VM_OPTIONS, vmTextField.getText()); // NOI18N
        prefs.putBoolean(SingleSourceFileUtil.GLOBAL_STOP_AND_RUN_OPTION, singleRunCheckBox.isSelected()); // NOI18N
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox singleRunCheckBox;
    private javax.swing.JLabel vmLabel;
    private javax.swing.JTextField vmTextField;
    // End of variables declaration//GEN-END:variables
}
