/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.IndexerBridge;
import org.netbeans.modules.parsing.impl.ParserAccessor;
import org.netbeans.modules.parsing.impl.SelfProfile;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.lucene.spi.ScanSuspendImplementation;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class TaskProcessor {
    private static final String COMPAT_MODE = "org.netbeans.modules.parsing.impl.TaskProcessor.compatMode";
    private static final Logger LOGGER = Logger.getLogger(TaskProcessor.class.getName());
    private static final int SLOW_CANCEL_LIMIT = 50;
    private static final PriorityBlockingQueue<Request> requests = new PriorityBlockingQueue<Request>(10, new RequestPriorityComparator());
    private static final Map<Source, Collection<Request>> finishedRequests = new WeakHashMap<Source, Collection<Request>>();
    private static final Map<Source, Collection<Request>> waitingRequests = new WeakHashMap<Source, Collection<Request>>();
    private static final Collection<RemovedTask> toRemove = new LinkedList<RemovedTask>();
    static final RequestProcessor WORKER = new RequestProcessor(String.format("Editor Parsing Loop (%s)", System.getProperty("netbeans.buildnumber")), 1, false, false);
    private static final CurrentRequestReference currentRequest = new CurrentRequestReference();
    public static final Object INTERNAL_LOCK = new InternalLock();
    private static final ReentrantLock parserLock = new ReentrantLock(true);
    private static int lockCount = 0;
    private static final Pattern excludedTasks;
    private static final Pattern includedTasks;
    private static final Set<StackTraceElement> warnedAboutRunInEQ;
    static volatile boolean SAMPLING_ENABLED;
    private static final int DEFAULT_START_SAMPLING_AFTER = 500;
    private static final Sampler sampler;
    private static final RequestProcessor SAMPLING_RP;
    private static final RequestProcessor.Task SAMPLING_TASK;
    private static final AtomicReference<Request> rst;
    private static volatile ScanSuspendImplementation scanSuspend;
    private static volatile IndexerBridge indexingBridge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUserTask(final Mutex.ExceptionAction<Void> task, Collection<Source> sources) throws ParseException {
        StackTraceElement stackTraceElement;
        Parameters.notNull("task", task);
        if (sources.size() == 1) {
            SourceAccessor.getINSTANCE().assignListeners(sources.iterator().next());
        }
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (a && SwingUtilities.isEventDispatchThread() && (stackTraceElement = Utilities.findCaller(Thread.currentThread().getStackTrace(), TaskProcessor.class, ParserManager.class, "org.netbeans.api.java.source.JavaSource", "org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper")) != null && warnedAboutRunInEQ.add(stackTraceElement)) {
            LOGGER.log(Level.WARNING, "ParserManager.parse called in AWT event thread by: {0}", stackTraceElement);
        }
        Request request = currentRequest.cancel(new CancelStrategy(Parser.CancelReason.USER_TASK){

            @Override
            public boolean apply(@NonNull Request request) {
                return true;
            }
        });
        try {
            TaskProcessor.suspendOrResumeBackgroundTasks(true);
            try {
                parserLock.lock();
                try {
                    if (lockCount < 1) {
                        for (Source source : sources) {
                            SourceAccessor.getINSTANCE().invalidate(source, false);
                        }
                    }
                    ++lockCount;
                    Utilities.runPriorityIO(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            task.run();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    ParseException ioe = new ParseException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    --lockCount;
                    parserLock.unlock();
                }
            }
            finally {
                TaskProcessor.suspendOrResumeBackgroundTasks(false);
            }
        }
        finally {
            currentRequest.cancelCompleted(request);
        }
    }

    public static void addPhaseCompletionTasks(@NonNull Collection<Pair<SchedulerTask, Class<? extends Scheduler>>> tasks, @NonNull SourceCache cache, boolean bridge) {
        Collection<? extends Request> rqs = TaskProcessor.toRequests(tasks, cache, bridge);
        if (TaskProcessor.handleAddRequests(cache.getSource(), rqs)) {
            TaskProcessor.cancelLowPriorityTask(rqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePhaseCompletionTasks(Collection<? extends SchedulerTask> tasks, Source source) {
        Parameters.notNull("task", tasks);
        Parameters.notNull("source", source);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            boolean wakeUp = false;
            Collection<Request> frqs = finishedRequests.get(source);
            Collection<Request> wrqs = waitingRequests.get(source);
            for (SchedulerTask schedulerTask : tasks) {
                Request rq;
                Iterator<Request> it;
                boolean found = false;
                String taskClassName = schedulerTask.getClass().getName();
                if (excludedTasks != null && excludedTasks.matcher(taskClassName).matches() && (includedTasks == null || !includedTasks.matcher(taskClassName).matches())) continue;
                if (frqs != null) {
                    it = frqs.iterator();
                    while (it.hasNext()) {
                        rq = it.next();
                        if (rq.task != schedulerTask || rq.cache == null || rq.cache.getSource() != source) continue;
                        it.remove();
                        found = true;
                    }
                    if (frqs.isEmpty()) {
                        finishedRequests.remove(source);
                        frqs = null;
                    }
                }
                it = requests.iterator();
                while (it.hasNext()) {
                    rq = it.next();
                    if (rq.task != schedulerTask || rq.cache == null || rq.cache.getSource() != source) continue;
                    it.remove();
                    found = true;
                }
                if (wrqs != null) {
                    it = wrqs.iterator();
                    while (it.hasNext()) {
                        rq = it.next();
                        if (rq.task != schedulerTask || rq.cache == null || rq.cache.getSource() != source) continue;
                        it.remove();
                        found = true;
                    }
                    if (wrqs.isEmpty()) {
                        waitingRequests.remove(source);
                        wrqs = null;
                    }
                }
                if (!found) {
                    toRemove.add(new RemovedTask(source, schedulerTask));
                    wakeUp = true;
                }
                SourceAccessor.getINSTANCE().taskRemoved(source);
            }
            if (wakeUp) {
                requests.add(Request.NONE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rescheduleTasks(final Collection<SchedulerTask> tasks, Source source, Class<? extends Scheduler> schedulerType) {
        Parameters.notNull("task", tasks);
        Parameters.notNull("source", source);
        Request request = currentRequest.cancel(new CancelStrategy(Parser.CancelReason.PARSER_RESULT_TASK){

            @Override
            public boolean apply(@NonNull Request request) {
                return tasks.contains(request.task);
            }
        });
        try {
            Object object = INTERNAL_LOCK;
            synchronized (object) {
                Collection<Request> cr = finishedRequests.get(source);
                if (cr != null) {
                    for (SchedulerTask task : tasks) {
                        if (request != null && request.task == task) continue;
                        ArrayList<Request> aRequests = new ArrayList<Request>();
                        Iterator<Request> it = cr.iterator();
                        while (it.hasNext()) {
                            Request fr = it.next();
                            if (task != fr.task) continue;
                            it.remove();
                            assert (fr.reschedule == ReschedulePolicy.ON_CHANGE);
                            fr.schedulerType = schedulerType;
                            aRequests.add(fr);
                            if (!cr.isEmpty()) break;
                            finishedRequests.remove(source);
                            break;
                        }
                        requests.addAll(aRequests);
                    }
                }
            }
        }
        finally {
            if (request != null) {
                currentRequest.cancelCompleted(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePhaseCompletionTask(@NonNull Collection<Pair<SchedulerTask, Class<? extends Scheduler>>> add, @NonNull Collection<SchedulerTask> remove, @NonNull Source source, @NonNull SourceCache cache) {
        Parameters.notNull("add", add);
        Parameters.notNull("remove", remove);
        Parameters.notNull("source", source);
        Parameters.notNull("cache", cache);
        if (add.isEmpty() && remove.isEmpty()) {
            return;
        }
        Collection<? extends Request> rqs = TaskProcessor.toRequests(add, cache, false);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            TaskProcessor.removePhaseCompletionTasks(remove, source);
            TaskProcessor.handleAddRequests(source, rqs);
        }
        TaskProcessor.cancelLowPriorityTask(rqs);
    }

    public static Request resetState(Source source, boolean mayInterruptParser, boolean sync) {
        assert (source != null);
        Request r = currentRequest.cancel(new CancelStrategy(Parser.CancelReason.SOURCE_MODIFICATION_EVENT, Request.DUMMY, mayInterruptParser){

            @Override
            public boolean apply(@NonNull Request request) {
                return true;
            }
        });
        if (sync && r != null) {
            Request oldR = rst.getAndSet(r);
            assert (oldR == null);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStateImpl(Source source) {
        Request r = rst.getAndSet(null);
        currentRequest.cancelCompleted(r);
        if (source != null) {
            boolean reschedule2 = SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.RESCHEDULE_FINISHED_TASKS);
            if (reschedule2) {
                SourceAccessor.getINSTANCE().getCache(source).sourceModified();
            }
            Object object = INTERNAL_LOCK;
            synchronized (object) {
                Collection<Request> cr;
                boolean reschedule = SourceAccessor.getINSTANCE().testAndCleanFlags(source, SourceFlags.RESCHEDULE_FINISHED_TASKS, EnumSet.of(SourceFlags.RESCHEDULE_FINISHED_TASKS, SourceFlags.CHANGE_EXPECTED));
                if (reschedule && (cr = finishedRequests.remove(source)) != null && cr.size() > 0) {
                    for (Request toAdd : cr) {
                        assert (toAdd.reschedule == ReschedulePolicy.ON_CHANGE);
                        requests.add(toAdd);
                    }
                }
                if ((cr = waitingRequests.remove(source)) != null && cr.size() > 0) {
                    for (Request toAdd : cr) {
                        requests.add(toAdd);
                    }
                }
            }
        }
    }

    public static boolean isCancelled(@NonNull SchedulerTask task) {
        assert (task != null);
        return currentRequest.isCancelled(task);
    }

    static void acquireParserLock() {
        TaskProcessor.suspendOrResumeBackgroundTasks(true);
        parserLock.lock();
    }

    static void releaseParserLock() {
        parserLock.unlock();
        TaskProcessor.suspendOrResumeBackgroundTasks(false);
    }

    static boolean holdsParserLock() {
        return parserLock.isHeldByCurrentThread();
    }

    static void scheduleSpecialTask(final @NonNull Runnable runnable, @NonNull Lookup context, final int priority) {
        Parameters.notNull("runnable", runnable);
        Parameters.notNull("context", context);
        ParserResultTask<Parser.Result> task = new ParserResultTask<Parser.Result>(){

            @Override
            public int getPriority() {
                return priority;
            }

            @Override
            public Class<? extends Scheduler> getSchedulerClass() {
                return null;
            }

            @Override
            public void cancel() {
            }

            @Override
            public void run(Parser.Result result, SchedulerEvent event) {
                runnable.run();
            }
        };
        Set<Request> rqs = Collections.singleton(new Request(task, context));
        if (TaskProcessor.handleAddRequests(null, rqs)) {
            TaskProcessor.cancelLowPriorityTask(rqs);
        }
    }

    @NonNull
    private static Collection<? extends Request> toRequests(@NonNull Collection<Pair<SchedulerTask, Class<? extends Scheduler>>> tasks, @NonNull SourceCache cache, boolean bridge) {
        Parameters.notNull("task", tasks);
        Parameters.notNull("cache", cache);
        ArrayList<Request> _requests = new ArrayList<Request>();
        for (Pair<SchedulerTask, Class<? extends Scheduler>> task : tasks) {
            String taskClassName = task.first().getClass().getName();
            if (excludedTasks != null && excludedTasks.matcher(taskClassName).matches() && (includedTasks == null || !includedTasks.matcher(taskClassName).matches())) continue;
            _requests.add(new Request(task.first(), cache, bridge ? ReschedulePolicy.ON_CHANGE : ReschedulePolicy.CANCELED, task.second()));
        }
        return _requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleAddRequests(@NullAllowed Source source, @NonNull Collection<? extends Request> requests) {
        Parameters.notNull("requests", requests);
        if (requests.isEmpty()) {
            return false;
        }
        if (source != null) {
            SourceAccessor.getINSTANCE().assignListeners(source);
        }
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            TaskProcessor.requests.addAll(requests);
        }
        return true;
    }

    private static void cancelLowPriorityTask(@NonNull Iterable<? extends Request> requests) {
        int priority = Integer.MAX_VALUE;
        for (Request request : requests) {
            priority = Math.min(priority, request.task.getPriority());
        }
        final int pf = priority;
        Request request = currentRequest.cancel(new CancelStrategy(Parser.CancelReason.PARSER_RESULT_TASK){

            @Override
            public boolean apply(Request request) {
                return pf < request.task.getPriority();
            }
        });
        currentRequest.cancelCompleted(request);
    }

    static void cancelTask(@NonNull SchedulerTask task, @NonNull Parser.CancelReason reason) {
        assert (task != null);
        assert (reason != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        Utilities.setTaskCancelReason(reason);
        try {
            LOGGER.fine("Cancelling task: " + task);
            task.cancel();
        }
        finally {
            Utilities.setTaskCancelReason(null);
        }
    }

    static void cancelParser(@NonNull Parser parser, boolean callDeprecatedCancel, @NonNull Parser.CancelReason cancelReason, @NullAllowed SourceModificationEvent event) {
        assert (parser != null);
        assert (cancelReason != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        if (callDeprecatedCancel) {
            parser.cancel();
        }
        parser.cancel(cancelReason, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Parser.Result> long callParserResultTask(@NonNull ParserResultTask<T> task, @NullAllowed T result, @NullAllowed SchedulerEvent event) {
        long cancelTime;
        long now;
        assert (task != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        assert (parserLock.isHeldByCurrentThread());
        sampler.enableSampling();
        try {
            task.run(result, event);
        }
        finally {
            now = System.currentTimeMillis();
            cancelTime = sampler.disableSampling();
        }
        return cancelTime == 0L ? 0L : now - cancelTime;
    }

    static List<Embedding> callEmbeddingProvider(@NonNull EmbeddingProvider embeddingProvider, @NonNull Snapshot snapshot) {
        assert (embeddingProvider != null);
        assert (snapshot != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        return embeddingProvider.getEmbeddings(snapshot);
    }

    public static void callUserTask(@NonNull UserTask task, @NonNull ResultIterator resultIterator) throws Exception {
        assert (task != null);
        assert (resultIterator != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        assert (parserLock.isHeldByCurrentThread());
        task.run(resultIterator);
    }

    public static void callParse(@NonNull Parser parser, @NullAllowed Snapshot snapshot, @NonNull Task task, @NullAllowed SourceModificationEvent event) throws ParseException {
        assert (parser != null);
        assert (task != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        assert (parserLock.isHeldByCurrentThread());
        parser.parse(snapshot, task, event);
    }

    public static Parser.Result callGetResult(@NonNull Parser parser, @NonNull Task task) throws ParseException {
        assert (parser != null);
        assert (task != null);
        assert (!Thread.holdsLock(INTERNAL_LOCK));
        assert (parserLock.isHeldByCurrentThread());
        return parser.getResult(task);
    }

    private static boolean holdsDocumentWriteLock(Iterable<Source> sources) {
        assert (sources != null);
        Class<AbstractDocument> docClass = AbstractDocument.class;
        try {
            Method method = docClass.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread currentThread = Thread.currentThread();
            for (Source source : sources) {
                try {
                    Object result;
                    Document doc = source.getDocument(true);
                    if (!(doc instanceof AbstractDocument) || (result = method.invoke((Object)doc, new Object[0])) != currentThread) continue;
                    return true;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace(e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            Exceptions.printStackTrace(e);
        }
        return false;
    }

    private static boolean shouldCall(@NonNull Source source, @NullAllowed SchedulerTask task, boolean checkScan) {
        boolean sourceInvalid = SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID);
        boolean scanAffinity = true;
        if (checkScan) {
            boolean scanInProgress = TaskProcessor.getIndexerBridge().isIndexing();
            boolean canRunDuringScan = task instanceof IndexingAwareParserResultTask && ((IndexingAwareParserResultTask)task).getIndexingMode() == TaskIndexingMode.ALLOWED_DURING_SCAN;
            boolean compatMode = "true".equals(System.getProperty(COMPAT_MODE));
            scanAffinity = !scanInProgress || canRunDuringScan || compatMode;
        }
        boolean taskCancelled = currentRequest.isCancelled(task);
        return !sourceInvalid && scanAffinity && !taskCancelled;
    }

    private static void suspendOrResumeBackgroundTasks(boolean stop) {
        ScanSuspendImplementation suspend = TaskProcessor.getScanSuspend();
        if (stop) {
            suspend.suspend();
        } else {
            suspend.resume();
        }
    }

    @NonNull
    private static ScanSuspendImplementation getScanSuspend() {
        ScanSuspendImplementation suspend = scanSuspend;
        if (suspend == null) {
            suspend = Lookup.getDefault().lookup(ScanSuspendImplementation.class);
            if (suspend == null) {
                suspend = new ScanSuspendImplementation(){

                    @Override
                    public void suspend() {
                    }

                    @Override
                    public void resume() {
                    }
                };
            }
            scanSuspend = suspend;
        }
        return suspend;
    }

    public static IndexerBridge getIndexerBridge() {
        IndexerBridge bridge = indexingBridge;
        if (bridge != null) {
            return bridge;
        }
        bridge = Lookup.getDefault().lookup(IndexerBridge.class);
        if (bridge == null) {
            bridge = new IndexerBridge(){

                @Override
                public boolean isIndexing() {
                    return false;
                }

                @Override
                public boolean ownsProtectedMode() {
                    return false;
                }
            };
        }
        indexingBridge = bridge;
        return indexingBridge;
    }

    static {
        warnedAboutRunInEQ = new HashSet<StackTraceElement>();
        SAMPLING_ENABLED = false;
        sampler = new Sampler();
        SAMPLING_RP = new RequestProcessor(TaskProcessor.class.getName() + "-sampling");
        SAMPLING_TASK = SAMPLING_RP.create(sampler);
        WORKER.submit(new CompilationJob());
        Pattern _excludedTasks = null;
        try {
            String excludedValue = System.getProperty("org.netbeans.modules.parsing.impl.Source.excludedTasks");
            if (excludedValue != null) {
                _excludedTasks = Pattern.compile(excludedValue);
            }
        }
        catch (PatternSyntaxException e) {
            Exceptions.printStackTrace(e);
        }
        excludedTasks = _excludedTasks;
        Pattern _includedTasks = null;
        try {
            String includedValue = System.getProperty("org.netbeans.modules.parsing.impl.Source.includedTasks");
            if (includedValue != null) {
                _includedTasks = Pattern.compile(includedValue);
            }
        }
        catch (PatternSyntaxException e) {
            Exceptions.printStackTrace(e);
        }
        includedTasks = _includedTasks;
        rst = new AtomicReference();
    }

    private static class Sampler
    implements Runnable {
        private boolean samplingEnabled;
        private SelfProfile profiler;
        private long cancelTime;

        private Sampler() {
        }

        synchronized void schedule() {
            this.cancelTime = System.currentTimeMillis();
            if (this.samplingEnabled) {
                SAMPLING_TASK.schedule(Integer.getInteger("org.netbeans.modules.parsing.api.taskcancel.slowness.start", 500));
            }
        }

        synchronized void enableSampling() {
            this.cancelTime = 0L;
            boolean ae = false;
            if (!$assertionsDisabled) {
                ae = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (ae && SAMPLING_ENABLED) {
                this.samplingEnabled = true;
            }
        }

        synchronized long disableSampling() {
            try {
                this.samplingEnabled = false;
                SAMPLING_TASK.cancel();
            }
            finally {
                if (this.profiler != null) {
                    this.profiler.stop();
                    this.profiler = null;
                }
            }
            return this.cancelTime;
        }

        @Override
        public synchronized void run() {
            if (!this.samplingEnabled) {
                return;
            }
            assert (this.profiler == null);
            this.profiler = new SelfProfile(System.currentTimeMillis());
        }
    }

    private static final class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private Parser activeParser;
        private SchedulerTask canceled;
        private static final Object CRR_LOCK = new CRRLock();

        private CurrentRequestReference() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setCurrentTask(Request reference) throws InterruptedException {
            boolean result = false;
            assert (!parserLock.isHeldByCurrentThread());
            assert (reference == null || reference.cache == null || !Thread.holdsLock(INTERNAL_LOCK));
            Object object = CRR_LOCK;
            synchronized (object) {
                while (this.canceledReference != null) {
                    CRR_LOCK.wait();
                }
                result = this.canceled != null;
                this.canceled = null;
                this.activeParser = null;
                this.reference = reference;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearCurrentTask() {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.reference = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCurrentParser(Parser parser) {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.activeParser = parser;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request cancel(@NonNull CancelStrategy cancelStrategy) {
            Request request = null;
            Parser parser = null;
            if (!WORKER.isRequestProcessorThread()) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null && cancelStrategy.apply(this.reference)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = request.task;
                        parser = this.activeParser;
                        sampler.schedule();
                    } else if (this.canceledReference == null && cancelStrategy.getRequestToCancel() != null) {
                        this.canceledReference = request = cancelStrategy.getRequestToCancel();
                        parser = this.activeParser;
                    }
                }
                Parser.CancelReason cancelReason = cancelStrategy.getCancelReason();
                try {
                    try {
                        if (parser != null) {
                            if (cancelReason == Parser.CancelReason.SOURCE_MODIFICATION_EVENT) {
                                Source src;
                                SourceCache sc;
                                if (request != null && (sc = request.cache) != null && (src = sc.getSource()) != null) {
                                    TaskProcessor.cancelParser(parser, cancelStrategy.callDeprecatedParserCancel(), cancelReason, SourceAccessor.getINSTANCE().getSourceModificationEvent(src));
                                }
                            } else {
                                TaskProcessor.cancelParser(parser, false, cancelReason, null);
                            }
                        }
                    }
                    finally {
                        if (request != null) {
                            TaskProcessor.cancelTask(request.task, cancelReason);
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    Exceptions.printStackTrace(t);
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelCompleted(Request request) {
            if (request != null) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    CRR_LOCK.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCancelled(@NullAllowed SchedulerTask task) {
            Object object = CRR_LOCK;
            synchronized (object) {
                return this.canceled == task;
            }
        }

        private static class CRRLock {
            private CRRLock() {
            }
        }
    }

    private static abstract class CancelStrategy {
        private final Parser.CancelReason cancelReason;
        private final Request cancelReplace;
        private final boolean callDeprecatedParserCancel;

        CancelStrategy(@NonNull Parser.CancelReason cancelReason) {
            this(cancelReason, null, false);
        }

        CancelStrategy(@NonNull Parser.CancelReason cancelReason, @NullAllowed Request cancelReplace, boolean callDeprecatedParserCancel) {
            Parameters.notNull("cancelReason", (Object)cancelReason);
            this.cancelReason = cancelReason;
            this.cancelReplace = cancelReplace;
            this.callDeprecatedParserCancel = callDeprecatedParserCancel;
        }

        @NonNull
        public final Parser.CancelReason getCancelReason() {
            return this.cancelReason;
        }

        @CheckForNull
        public final Request getRequestToCancel() {
            return this.cancelReplace;
        }

        public final boolean callDeprecatedParserCancel() {
            return this.callDeprecatedParserCancel;
        }

        public abstract boolean apply(@NonNull Request var1);
    }

    static class Request {
        static final Request DUMMY = new Request(){

            @Override
            public String toString() {
                return "DUMMY";
            }
        };
        static final Request NONE = new Request(){

            @Override
            public String toString() {
                return "NONE";
            }
        };
        private final SchedulerTask task;
        private final SourceCache cache;
        private final ReschedulePolicy reschedule;
        private final Lookup context;
        private Class<? extends Scheduler> schedulerType;

        private Request(@NonNull SchedulerTask task, @NonNull SourceCache cache, @NonNull ReschedulePolicy reschedule, @NullAllowed Class<? extends Scheduler> schedulerType) {
            Parameters.notNull("task", task);
            Parameters.notNull("cache", cache);
            Parameters.notNull("reschedule", (Object)reschedule);
            this.task = task;
            this.cache = cache;
            this.reschedule = reschedule;
            this.context = this.cache.getSource().getLookup();
            this.schedulerType = schedulerType;
        }

        private Request(@NonNull SchedulerTask task, @NonNull Lookup context) {
            Parameters.notNull("tesk", task);
            Parameters.notNull("context", context);
            this.task = task;
            this.cache = null;
            this.reschedule = ReschedulePolicy.NEVER;
            this.context = context;
            this.schedulerType = null;
        }

        private Request() {
            this(new ParserResultTask(){

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public Class<? extends Scheduler> getSchedulerClass() {
                    return null;
                }

                @Override
                public void cancel() {
                }

                public void run(Parser.Result result, SchedulerEvent event) {
                }
            }, Lookup.EMPTY);
        }

        public String toString() {
            if (this.reschedule != ReschedulePolicy.NEVER) {
                return String.format("Periodic request %d to perform: %s on: %s", System.identityHashCode(this), this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
            }
            return String.format("One time request %d to perform: %s on: %s", System.identityHashCode(this), this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
        }

        public int hashCode() {
            return this.task == null ? 0 : this.task.getPriority();
        }

        public boolean equals(Object other) {
            if (other instanceof Request) {
                Request otherRequest = (Request)other;
                return this.reschedule == otherRequest.reschedule && (this.cache == null ? otherRequest.cache == null : this.cache.equals(otherRequest.cache)) && (this.task == null ? otherRequest.task == null : this.task.equals(otherRequest.task));
            }
            return false;
        }
    }

    static final class RemovedTask
    extends WeakReference<Source>
    implements Runnable {
        private final SchedulerTask task;

        public RemovedTask(@NonNull Source src, @NonNull SchedulerTask task) {
            super(src, BaseUtilities.activeReferenceQueue());
            Parameters.notNull("src", src);
            Parameters.notNull("task", task);
            this.task = task;
        }

        public boolean equals(Object other) {
            if (!(other instanceof RemovedTask)) {
                return false;
            }
            RemovedTask otherRt = (RemovedTask)other;
            Source thisSrc = (Source)this.get();
            Source otherSrc = (Source)otherRt.get();
            return (thisSrc == null ? otherSrc == null : thisSrc.equals(otherSrc)) && this.task.equals(otherRt.task);
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public String toString() {
            return String.format("RemovedTask[%s, %s]", this.get(), this.task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = INTERNAL_LOCK;
            synchronized (object) {
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    RemovedTask rt = (RemovedTask)it.next();
                    if (rt != this) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    private static enum ReschedulePolicy {
        NEVER,
        CANCELED,
        ON_CHANGE;

    }

    private static class RequestPriorityComparator
    implements Comparator<Request> {
        private RequestPriorityComparator() {
        }

        @Override
        public int compare(Request r1, Request r2) {
            assert (r1 != null && r2 != null);
            return r1.task.getPriority() - r2.task.getPriority();
        }
    }

    private static class InternalLock {
        private InternalLock() {
        }
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                Request r;
                                if ((r = (Request)requests.take()) != null && r != Request.NONE) {
                                    currentRequest.setCurrentTask(r);
                                    LOGGER.log(Level.FINE, "Set current request to: {0}", r);
                                    try {
                                        new RequestPerformer(r).execute();
                                    }
                                    finally {
                                        currentRequest.setCurrentTask(null);
                                    }
                                    continue;
                                }
                                if (r != null) break;
                            }
                            Object object = INTERNAL_LOCK;
                            synchronized (object) {
                                toRemove.clear();
                                continue block10;
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof InterruptedException) {
                                throw (InterruptedException)e;
                            }
                            if (e instanceof ThreadDeath) {
                                throw (ThreadDeath)e;
                            }
                            Exceptions.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException ie) {
                    Exceptions.printStackTrace(ie);
                    return;
                }
            }
        }
    }

    private static final class RequestPerformer
    implements Runnable {
        private final Request r;
        private final AtomicReference<Thread> owner;

        RequestPerformer(@NonNull Request request) {
            this.r = request;
            this.owner = new AtomicReference();
        }

        public void execute() throws Exception {
            if (!this.owner.compareAndSet(null, Thread.currentThread())) {
                throw new IllegalStateException("Already running");
            }
            try {
                Lookups.executeWith(this.r.context, this);
            }
            catch (Transfer t) {
                throw (Exception)t.getCause();
            }
            finally {
                this.owner.set(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block71: {
                if (this.owner.get() != Thread.currentThread()) {
                    throw new IllegalStateException("Not an owner");
                }
                try {
                    Collection<Request> rc;
                    Object object;
                    int validFlags;
                    boolean reschedule;
                    Source source;
                    block72: {
                        SourceCache sourceCache = this.r.cache;
                        if (sourceCache == null) {
                            assert (this.r.task instanceof ParserResultTask) : "Illegal request: EmbeddingProvider has to be bound to Source";
                            TaskProcessor.suspendOrResumeBackgroundTasks(true);
                            try {
                                parserLock.lock();
                                try {
                                    try {
                                        LOGGER.log(Level.FINE, "Running Special Task: {0}", this.r);
                                        TaskProcessor.callParserResultTask((ParserResultTask)this.r.task, null, null);
                                        break block71;
                                    }
                                    finally {
                                        currentRequest.clearCurrentTask();
                                        boolean cancelled = requests.contains(this.r);
                                        if (!cancelled) {
                                            // empty if block
                                        }
                                    }
                                }
                                catch (RuntimeException re) {
                                    Exceptions.printStackTrace(re);
                                    break block71;
                                }
                                finally {
                                    parserLock.unlock();
                                }
                            }
                            finally {
                                TaskProcessor.suspendOrResumeBackgroundTasks(false);
                            }
                        }
                        source = sourceCache.getSnapshot().getSource();
                        assert (source != null);
                        reschedule = false;
                        validFlags = 0;
                        object = INTERNAL_LOCK;
                        synchronized (object) {
                            if (toRemove.contains(new RemovedTask(source, this.r.task))) {
                                validFlags = 1;
                            } else if (SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.CHANGE_EXPECTED)) {
                                validFlags = 2;
                            }
                        }
                        TaskProcessor.suspendOrResumeBackgroundTasks(true);
                        try {
                            if (validFlags != 0) break block72;
                            Snapshot snapshot = null;
                            long[] id = new long[]{-1L};
                            if (SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID)) {
                                snapshot = sourceCache.createSnapshot(id);
                            }
                            parserLock.lock();
                            try {
                                if (SourceAccessor.getINSTANCE().invalidate(source, id[0], snapshot)) {
                                    lockCount++;
                                    try {
                                        if (this.r.task instanceof EmbeddingProvider) {
                                            if (TaskProcessor.shouldCall(source, this.r.task, false)) {
                                                sourceCache.refresh((EmbeddingProvider)this.r.task, this.r.schedulerType);
                                            }
                                            break block72;
                                        }
                                        if (!TaskProcessor.shouldCall(source, this.r.task, true)) break block72;
                                        currentRequest.setCurrentParser(sourceCache.getParser());
                                        Parser.Result currentResult = sourceCache.getResult(this.r.task);
                                        if (currentResult == null) break block72;
                                        try {
                                            if (!TaskProcessor.shouldCall(source, this.r.task, false)) break block72;
                                            try {
                                                long startTime = System.currentTimeMillis();
                                                long cancelTime = 0L;
                                                if (this.r.task instanceof ParserResultTask) {
                                                    LOGGER.log(Level.FINE, "Running Task: {0}", this.r);
                                                    ParserResultTask parserResultTask = (ParserResultTask)this.r.task;
                                                    SchedulerEvent schedulerEvent = SourceAccessor.getINSTANCE().getSchedulerEvent(source, parserResultTask.getSchedulerClass());
                                                    cancelTime = TaskProcessor.callParserResultTask(parserResultTask, currentResult, schedulerEvent);
                                                } else assert (false) : String.format("Unknown task type: %s : %s", Request.access$500(this.r), Request.access$500(this.r).getClass());
                                                if (LOGGER.isLoggable(Level.FINEST)) {
                                                    LOGGER.log(Level.FINEST, "Executed task: {0} : {1} in {2} ms.", new Object[]{this.r.task, this.r.task.getClass(), System.currentTimeMillis() - startTime});
                                                }
                                                if (cancelTime > 50L) {
                                                    LOGGER.log(Level.INFO, "Task: {0} : {1} ignored cancel for {2} ms.", new Object[]{this.r.task, this.r.task.getClass(), cancelTime});
                                                }
                                                break block72;
                                            }
                                            catch (Exception re) {
                                                Exceptions.printStackTrace(re);
                                            }
                                            break block72;
                                        }
                                        finally {
                                            ParserAccessor.getINSTANCE().invalidate(currentResult);
                                        }
                                    }
                                    finally {
                                        lockCount--;
                                    }
                                }
                                reschedule = true;
                            }
                            finally {
                                parserLock.unlock();
                            }
                        }
                        finally {
                            TaskProcessor.suspendOrResumeBackgroundTasks(false);
                        }
                    }
                    if (this.r.reschedule != ReschedulePolicy.NEVER) {
                        reschedule |= currentRequest.setCurrentTask(null);
                        object = INTERNAL_LOCK;
                        synchronized (object) {
                            if (!toRemove.contains(new RemovedTask(source, this.r.task))) {
                                if (validFlags == 2) {
                                    if (SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.CHANGE_EXPECTED)) {
                                        rc = (Collection)waitingRequests.get(source);
                                        if (rc == null) {
                                            rc = new LinkedList();
                                            waitingRequests.put(source, rc);
                                        }
                                        rc.add(this.r);
                                        LOGGER.log(Level.FINE, "Waiting Task: {0}", this.r);
                                    } else {
                                        requests.add(this.r);
                                        LOGGER.log(Level.FINE, "Rescheduling Waiting Task: {0}", this.r);
                                    }
                                } else if (reschedule || SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID)) {
                                    requests.add(this.r);
                                    LOGGER.log(Level.FINE, "Rescheduling Canceled Task: {0}", this.r);
                                } else if (this.r.reschedule == ReschedulePolicy.ON_CHANGE) {
                                    rc = (Collection)finishedRequests.get(this.r.cache.getSnapshot().getSource());
                                    if (rc == null) {
                                        rc = new LinkedList();
                                        finishedRequests.put(this.r.cache.getSnapshot().getSource(), rc);
                                    }
                                    rc.add(this.r);
                                    LOGGER.log(Level.FINE, "Finished ON_CHANGE Task: {0}", this.r);
                                } else {
                                    LOGGER.log(Level.FINE, "Finished  CANCELED Task: {0}", this.r);
                                }
                            } else {
                                LOGGER.log(Level.FINE, "Removing Task: {0}", this.r);
                            }
                            toRemove.clear();
                            break block71;
                        }
                    }
                    object = INTERNAL_LOCK;
                    synchronized (object) {
                        if (validFlags == 2 && !toRemove.contains(new RemovedTask(source, this.r.task))) {
                            if (SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.CHANGE_EXPECTED)) {
                                rc = (LinkedList<Request>)waitingRequests.get(source);
                                if (rc == null) {
                                    rc = new LinkedList<Request>();
                                    waitingRequests.put(source, rc);
                                }
                                rc.add(this.r);
                                LOGGER.log(Level.FINE, "Waiting NEVER Task: {0}", this.r.toString());
                            } else {
                                requests.add(this.r);
                                LOGGER.log(Level.FINE, "Rescheduling Waiting NEVER Task: {0}", this.r.toString());
                            }
                        } else {
                            LOGGER.log(Level.FINE, "Finished NEVER task: {0}", this.r.toString());
                        }
                        toRemove.clear();
                    }
                    SourceAccessor.getINSTANCE().taskRemoved(source);
                }
                catch (InterruptedException | ParseException e) {
                    throw new Transfer(e);
                }
            }
        }

        private static final class Transfer
        extends RuntimeException {
            Transfer(Exception e) {
                super(e);
            }
        }
    }
}

