/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Convert;
import jpt.sun.tools.javac.util.InvalidUtfException;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;

public abstract class Utf8NameTable
extends Name.Table {
    protected Utf8NameTable(Names names) {
        super(names);
    }

    protected static int hashValue(byte[] buf, int off, int len) {
        int hash = 0;
        while (len-- > 0) {
            hash = (hash << 5) - hash + buf[off++];
        }
        return hash;
    }

    protected static boolean equals(byte[] buf1, int off1, byte[] buf2, int off2, int len) {
        while (len-- > 0) {
            if (buf1[off1++] == buf2[off2++]) continue;
            return false;
        }
        return true;
    }

    protected static abstract class NameImpl
    extends Name {
        NameImpl(Utf8NameTable table) {
            super(table);
        }

        protected abstract byte[] getByteData();

        protected abstract int getByteOffset();

        protected abstract int getByteLength();

        protected abstract int getNameIndex();

        @Override
        protected boolean nameEquals(Name that) {
            return ((NameImpl)that).getNameIndex() == this.getNameIndex();
        }

        @Override
        public int length() {
            return Convert.utfNumChars(this.getByteData(), this.getByteOffset(), this.getByteLength());
        }

        @Override
        public String toString() {
            try {
                return Convert.utf2string(this.getByteData(), this.getByteOffset(), this.getByteLength(), Convert.Validation.NONE);
            }
            catch (InvalidUtfException e) {
                throw new AssertionError("invalid UTF8 data", e);
            }
        }

        @Override
        public int hashCode() {
            return this.getNameIndex();
        }

        @Override
        public int compareTo(Name name0) {
            int len2;
            if (!(name0 instanceof NameImpl)) {
                return super.compareTo(name0);
            }
            NameImpl name = (NameImpl)name0;
            byte[] buf1 = this.getByteData();
            byte[] buf2 = name.getByteData();
            int off1 = this.getByteOffset();
            int off2 = name.getByteOffset();
            int len1 = this.getByteLength();
            for (len2 = name.getByteLength(); len1 > 0 && len2 > 0; --len1, --len2) {
                int diff;
                int val1 = buf1[off1++] & 0xFF;
                int val2 = buf2[off2++] & 0xFF;
                if (val1 == 192 && (buf1[off1] & 0x3F) == 0) {
                    val1 = 0;
                    ++off1;
                    --len1;
                }
                if (val2 == 192 && (buf2[off2] & 0x3F) == 0) {
                    val2 = 0;
                    ++off2;
                    --len2;
                }
                if ((diff = val1 - val2) == 0) continue;
                return diff;
            }
            return len1 > 0 ? 1 : (len2 > 0 ? -1 : 0);
        }

        @Override
        public Name append(Name name0) {
            NameImpl name = (NameImpl)name0;
            Assert.check(name.table == this.table);
            byte[] buf1 = this.getByteData();
            byte[] buf2 = name.getByteData();
            int off1 = this.getByteOffset();
            int off2 = name.getByteOffset();
            int len1 = this.getByteLength();
            int len2 = name.getByteLength();
            byte[] result = new byte[len1 + len2];
            System.arraycopy(buf1, off1, result, 0, len1);
            System.arraycopy(buf2, off2, result, len1, len2);
            try {
                return this.table.fromUtf(result, 0, result.length, Convert.Validation.NONE);
            }
            catch (InvalidUtfException e) {
                throw new AssertionError("invalid UTF8 data", e);
            }
        }

        @Override
        public Name append(char ch, Name name0) {
            Assert.check((ch & 0xFFFFFF80) == 0);
            NameImpl name = (NameImpl)name0;
            Assert.check(name.table == this.table);
            byte[] buf1 = this.getByteData();
            byte[] buf2 = name.getByteData();
            int off1 = this.getByteOffset();
            int off2 = name.getByteOffset();
            int len1 = this.getByteLength();
            int len2 = name.getByteLength();
            byte[] result = new byte[len1 + 1 + len2];
            System.arraycopy(buf1, off1, result, 0, len1);
            result[len1] = (byte)ch;
            System.arraycopy(buf2, off2, result, len1 + 1, len2);
            try {
                return this.table.fromUtf(result, 0, result.length, Convert.Validation.NONE);
            }
            catch (InvalidUtfException e) {
                throw new AssertionError("invalid UTF8 data", e);
            }
        }

        @Override
        public int lastIndexOfAscii(char ch) {
            int pos;
            Assert.check((ch & 0xFFFFFF80) == 0);
            byte b = (byte)ch;
            byte[] buf = this.getByteData();
            int off = this.getByteOffset();
            int len = this.getByteLength();
            for (pos = len - 1; pos >= 0 && buf[off + pos] != b; --pos) {
            }
            if (pos <= 0) {
                return pos;
            }
            return Convert.utfNumChars(buf, off, pos);
        }

        @Override
        public boolean startsWith(Name prefix0) {
            NameImpl prefix = (NameImpl)prefix0;
            Assert.check(prefix.table == this.table);
            int thisLen = this.getByteLength();
            int prefLen = prefix.getByteLength();
            if (thisLen < prefLen) {
                return false;
            }
            byte[] thisData = this.getByteData();
            byte[] prefData = prefix.getByteData();
            int thisOff = this.getByteOffset() + prefLen;
            int prefOff = prefix.getByteOffset() + prefLen;
            while (prefLen-- > 0) {
                if (thisData[--thisOff] == prefData[--prefOff]) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getUtf8Length() {
            return this.getByteLength();
        }

        @Override
        public void getUtf8Bytes(byte[] buf, int off) {
            System.arraycopy(this.getByteData(), this.getByteOffset(), buf, off, this.getByteLength());
        }
    }
}

