/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import org.springframework.expression.Expression;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.FileWritingMessageHandler;
import org.springframework.integration.file.support.FileExistsMode;

public class FileWritingMessageHandlerFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<FileWritingMessageHandler> {
    private File directory;
    private Expression directoryExpression;
    private String charset;
    private FileNameGenerator fileNameGenerator;
    private Boolean deleteSourceFiles;
    private Boolean autoCreateDirectory;
    private Boolean requiresReply;
    private Long sendTimeout;
    private String temporaryFileSuffix;
    private FileExistsMode fileExistsMode;
    private boolean expectReply = true;
    private Integer bufferSize;
    private Boolean appendNewLine;
    private Long flushInterval;
    private Boolean flushWhenIdle;
    private FileWritingMessageHandler.MessageFlushPredicate flushPredicate;
    private String chmod;
    private Boolean preserveTimestamp;

    public void setFileExistsMode(String fileExistsModeAsString) {
        this.fileExistsMode = FileExistsMode.getForString(fileExistsModeAsString);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDirectoryExpression(Expression directoryExpression) {
        this.directoryExpression = directoryExpression;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public void setDeleteSourceFiles(Boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setAppendNewLine(Boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushWhenIdle(boolean flushWhenIdle) {
        this.flushWhenIdle = flushWhenIdle;
    }

    public void setFlushPredicate(FileWritingMessageHandler.MessageFlushPredicate flushPredicate) {
        this.flushPredicate = flushPredicate;
    }

    public void setChmod(String chmod) {
        this.chmod = chmod;
    }

    public void setPreserveTimestamp(Boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    protected FileWritingMessageHandler createHandler() {
        FileWritingMessageHandler handler;
        if (this.directory != null && this.directoryExpression != null) {
            throw new IllegalStateException("Cannot set both directory and directoryExpression");
        }
        if (this.directory != null) {
            handler = new FileWritingMessageHandler(this.directory);
        } else if (this.directoryExpression != null) {
            handler = new FileWritingMessageHandler(this.directoryExpression);
        } else {
            throw new IllegalStateException("Either directory or directoryExpression must not be null");
        }
        handler.setExpectReply(this.expectReply);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.charset, handler::setCharset).acceptIfNotNull((Object)this.fileNameGenerator, handler::setFileNameGenerator).acceptIfNotNull((Object)this.deleteSourceFiles, handler::setDeleteSourceFiles).acceptIfNotNull((Object)this.autoCreateDirectory, handler::setAutoCreateDirectory).acceptIfNotNull((Object)this.requiresReply, arg_0 -> ((FileWritingMessageHandler)handler).setRequiresReply(arg_0)).acceptIfNotNull((Object)this.sendTimeout, arg_0 -> ((FileWritingMessageHandler)handler).setSendTimeout(arg_0)).acceptIfNotNull((Object)this.temporaryFileSuffix, handler::setTemporaryFileSuffix).acceptIfNotNull((Object)this.appendNewLine, handler::setAppendNewLine).acceptIfNotNull((Object)this.fileExistsMode, handler::setFileExistsMode).acceptIfNotNull((Object)this.bufferSize, handler::setBufferSize).acceptIfNotNull((Object)this.flushInterval, handler::setFlushInterval).acceptIfNotNull((Object)this.flushWhenIdle, handler::setFlushWhenIdle).acceptIfNotNull((Object)this.flushPredicate, handler::setFlushPredicate).acceptIfNotNull((Object)this.chmod, handler::setChmodOctal).acceptIfNotNull((Object)this.preserveTimestamp, handler::setPreserveTimestamp);
        return handler;
    }
}

