/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public final class EdDSAUtils {
    private static final int ED25519_LENGTH = 32;
    private static final int ED448_LENGTH = 57;
    private static final byte[] ED25519_X509_PREFIX = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 112, 3, 33, 0};
    private static final byte[] ED448_X509_PREFIX = new byte[]{48, 67, 48, 5, 6, 3, 43, 101, 113, 3, 58, 0};
    private static final byte[] ED25519_PKCS8_PREFIX = new byte[]{48, 46, 2, 1, 0, 48, 5, 6, 3, 43, 101, 112, 4, 34, 4, 32};
    private static final byte[] ED448_PKCS8_PREFIX = new byte[]{48, 71, 2, 1, 0, 48, 5, 6, 3, 43, 101, 113, 4, 59, 4, 57};
    private static final byte[] ED25519_OID = new byte[]{43, 101, 112};
    private static final byte[] ED448_OID = new byte[]{43, 101, 113};

    private EdDSAUtils() {
        throw new IllegalStateException("No instantiation");
    }

    private static boolean arrayEq(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int unequal = a.length ^ b.length;
        int length = Math.min(a.length, b.length);
        for (int i = 0; i < length; ++i) {
            unequal |= a[i] ^ b[i];
        }
        return unequal == 0;
    }

    private static boolean startsWith(byte[] data, byte[] prefix) {
        if (data == null || prefix == null || prefix.length == 0 || data.length < prefix.length) {
            return false;
        }
        int unequal = 0;
        int length = prefix.length;
        for (int i = 0; i < length; ++i) {
            unequal |= data[i] ^ prefix[i];
        }
        return unequal == 0;
    }

    public static byte[] getBytes(PublicKey key) throws InvalidKeyException {
        int n;
        if (!"X.509".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Cannot extract public key bytes from a non-X.509 encoding");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Public key " + key.getClass().getCanonicalName() + " does not support encoding");
        }
        if (encoded.length == 32 + ED25519_X509_PREFIX.length && EdDSAUtils.startsWith(encoded, ED25519_X509_PREFIX)) {
            n = 32;
        } else if (encoded.length == 57 + ED448_X509_PREFIX.length && EdDSAUtils.startsWith(encoded, ED448_X509_PREFIX)) {
            n = 57;
        } else {
            throw new InvalidKeyException("Public key is neither ed25519 nor ed448");
        }
        return Arrays.copyOfRange(encoded, encoded.length - n, encoded.length);
    }

    public static byte[] getBytes(PrivateKey key) throws InvalidKeyException {
        if (!"PKCS#8".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Cannot extract private key bytes from a non-PKCS#8 encoding");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Private key " + key.getClass().getCanonicalName() + " does not support encoding");
        }
        try {
            byte[] byArray = EdDSAUtils.asn1Parse(encoded);
            return byArray;
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] asn1Parse(byte[] encoded) throws InvalidKeyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeySpec createPublicKeySpec(byte[] keyData) throws InvalidKeyException {
        if (keyData.length == 32) {
            byte[] x509 = Arrays.copyOf(ED25519_X509_PREFIX, ED25519_X509_PREFIX.length + 32);
            System.arraycopy(keyData, 0, x509, ED25519_X509_PREFIX.length, 32);
            return new X509EncodedKeySpec(x509);
        }
        if (keyData.length == 57) {
            byte[] x509 = Arrays.copyOf(ED448_X509_PREFIX, ED448_X509_PREFIX.length + 57);
            System.arraycopy(keyData, 0, x509, ED448_X509_PREFIX.length, 57);
            return new X509EncodedKeySpec(x509);
        }
        throw new InvalidKeyException("Public key data is neither ed25519 nor ed448");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeySpec createPrivateKeySpec(byte[] keyData) throws InvalidKeyException {
        if (keyData.length == 32) {
            byte[] pkcs8 = Arrays.copyOf(ED25519_PKCS8_PREFIX, ED25519_PKCS8_PREFIX.length + 32);
            try {
                System.arraycopy(keyData, 0, pkcs8, ED25519_PKCS8_PREFIX.length, 32);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(pkcs8);
                return pKCS8EncodedKeySpec;
            }
            finally {
                Arrays.fill(pkcs8, (byte)0);
            }
        }
        if (keyData.length == 57) {
            byte[] pkcs8 = Arrays.copyOf(ED448_PKCS8_PREFIX, ED448_PKCS8_PREFIX.length + 57);
            try {
                System.arraycopy(keyData, 0, pkcs8, ED448_PKCS8_PREFIX.length, 57);
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(pkcs8);
                return pKCS8EncodedKeySpec;
            }
            finally {
                Arrays.fill(pkcs8, (byte)0);
            }
        }
        throw new InvalidKeyException("Private key data is neither ed25519 nor ed448");
    }
}

