/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.function.Consumer;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.impl.MvndBaseLogger;
import org.slf4j.impl.SimpleLoggerConfiguration;

public class MvndSimpleLogger
extends MvndBaseLogger {
    static final String TID_PREFIX = "tid=";
    static long START_TIME = System.currentTimeMillis();
    static boolean INITIALIZED = false;
    static final SimpleLoggerConfiguration CONFIG_PARAMS = new SimpleLoggerConfiguration();
    static Consumer<String> LOG_SINK;
    private transient String shortLogName = null;

    static void lazyInit() {
        if (INITIALIZED) {
            return;
        }
        INITIALIZED = true;
        MvndSimpleLogger.init();
    }

    static void init() {
        CONFIG_PARAMS.init();
    }

    public static void setLogSink(Consumer<String> logSink) {
        LOG_SINK = logSink;
    }

    MvndSimpleLogger(String name) {
        super(name);
        this.configure(MvndSimpleLogger.CONFIG_PARAMS.defaultLogLevel);
    }

    String recursivelyComputeLevelString() {
        String tempName = this.name;
        String levelString = null;
        int indexOfLastDot = tempName.length();
        while (levelString == null && indexOfLastDot > -1) {
            tempName = tempName.substring(0, indexOfLastDot);
            levelString = CONFIG_PARAMS.getStringProperty("org.slf4j.simpleLogger.log." + tempName, null);
            indexOfLastDot = tempName.lastIndexOf(".");
        }
        return levelString;
    }

    @Override
    protected void doLog(int level, String message, Throwable t) {
        StringBuilder buf = new StringBuilder(32);
        if (MvndSimpleLogger.CONFIG_PARAMS.showDateTime) {
            if (MvndSimpleLogger.CONFIG_PARAMS.dateFormatter != null) {
                buf.append(this.getFormattedDate());
                buf.append(' ');
            } else {
                buf.append(System.currentTimeMillis() - START_TIME);
                buf.append(' ');
            }
        }
        if (MvndSimpleLogger.CONFIG_PARAMS.showThreadName) {
            buf.append('[');
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
        }
        if (MvndSimpleLogger.CONFIG_PARAMS.showThreadId) {
            buf.append(TID_PREFIX);
            buf.append(Thread.currentThread().getId());
            buf.append(' ');
        }
        if (MvndSimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append('[');
        }
        String levelStr = this.renderLevel(level);
        buf.append(levelStr);
        if (MvndSimpleLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append(']');
        }
        buf.append(' ');
        if (MvndSimpleLogger.CONFIG_PARAMS.showShortLogName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.computeShortName();
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (MvndSimpleLogger.CONFIG_PARAMS.showLogName) {
            buf.append(String.valueOf(this.name)).append(" - ");
        }
        buf.append(message);
        this.writeThrowable(t, buf);
        Consumer<String> sink = LOG_SINK;
        if (sink != null) {
            sink.accept(buf.toString());
        } else {
            MvndSimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream().println(buf.toString());
        }
    }

    protected String getFormattedDate() {
        Date now = new Date();
        return MvndSimpleLogger.CONFIG_PARAMS.dateFormatter.format(now);
    }

    private String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return MessageUtils.level().debug("TRACE").toString();
            }
            case 10: {
                return MessageUtils.level().debug("DEBUG").toString();
            }
            case 20: {
                return MessageUtils.level().info("INFO").toString();
            }
            case 30: {
                return MessageUtils.level().warning("WARNING").toString();
            }
        }
        return MessageUtils.level().error("ERROR").toString();
    }

    protected void writeThrowable(Throwable t, StringBuilder sb) {
        if (t == null) {
            return;
        }
        MessageBuilder builder = MessageUtils.buffer((StringBuilder)sb);
        builder.newline();
        builder.failure((Object)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ");
            builder.failure((Object)t.getMessage());
        }
        builder.newline();
        this.printStackTrace(t, builder, "");
    }

    private void printStackTrace(Throwable t, MessageBuilder builder, String prefix) {
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            builder.a((CharSequence)prefix);
            builder.a((CharSequence)"    ");
            builder.strong((Object)"at");
            builder.a((CharSequence)(" " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName()));
            builder.a((CharSequence)" (").strong((Object)this.getLocation(stackTraceElement)).a((CharSequence)")");
            builder.newline();
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, builder, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.writeThrowable(cause, builder, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, MessageBuilder builder, String caption, String prefix) {
        builder.a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ");
            builder.failure((Object)t.getMessage());
        }
        builder.newline();
        this.printStackTrace(t, builder, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }

    public void configure(int defaultLogLevel) {
        String levelString = this.recursivelyComputeLevelString();
        this.currentLogLevel = levelString != null ? SimpleLoggerConfiguration.stringToLevel(levelString) : defaultLogLevel;
    }

    public void setLogLevel(int logLevel) {
        this.currentLogLevel = logLevel;
    }
}

