/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.matchhighlight;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.matchhighlight.OffsetRange;
import org.apache.lucene.search.matchhighlight.OffsetsFromMatchIterator;
import org.apache.lucene.search.matchhighlight.OffsetsFromPositions;
import org.apache.lucene.search.matchhighlight.OffsetsFromTokens;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategy;
import org.apache.lucene.search.matchhighlight.OffsetsRetrievalStrategySupplier;
import org.apache.lucene.util.IOSupplier;

public class MatchRegionRetriever {
    private final List<LeafReaderContext> leaves;
    private final Weight weight;
    private final TreeSet<String> affectedFields;
    private final Map<String, OffsetsRetrievalStrategy> offsetStrategies;
    private final Set<String> preloadFields;

    public MatchRegionRetriever(IndexSearcher searcher, Query query, Analyzer analyzer) throws IOException {
        this(searcher, query, MatchRegionRetriever.computeOffsetRetrievalStrategies(searcher.getIndexReader(), analyzer));
    }

    public MatchRegionRetriever(IndexSearcher searcher, Query query, OffsetsRetrievalStrategySupplier fieldOffsetStrategySupplier) throws IOException {
        this.leaves = searcher.getIndexReader().leaves();
        assert (this.checkOrderConsistency(this.leaves));
        this.weight = searcher.createWeight(query, ScoreMode.COMPLETE, 0.0f);
        this.affectedFields = new TreeSet();
        query.visit(new QueryVisitor(){

            public boolean acceptField(String field) {
                MatchRegionRetriever.this.affectedFields.add(field);
                return false;
            }
        });
        this.offsetStrategies = new HashMap<String, OffsetsRetrievalStrategy>();
        for (String field2 : this.affectedFields) {
            this.offsetStrategies.put(field2, (OffsetsRetrievalStrategy)fieldOffsetStrategySupplier.apply(field2));
        }
        this.preloadFields = new HashSet<String>();
        this.offsetStrategies.forEach((field, strategy) -> this.preloadFields.add((String)field));
        this.preloadFields.retainAll(this.affectedFields);
    }

    public void highlightDocuments(TopDocs topDocs, MatchOffsetsConsumer consumer) throws IOException {
        this.highlightDocuments(Arrays.stream(topDocs.scoreDocs).mapToInt(scoreDoc -> scoreDoc.doc).sorted().iterator(), consumer);
    }

    public void highlightDocuments(PrimitiveIterator.OfInt docIds, MatchOffsetsConsumer consumer) throws IOException {
        if (this.leaves.isEmpty()) {
            return;
        }
        Iterator<LeafReaderContext> ctx = this.leaves.iterator();
        LeafReaderContext currentContext = ctx.next();
        int previousDocId = -1;
        TreeMap<String, List<OffsetRange>> highlights = new TreeMap<String, List<OffsetRange>>();
        while (docIds.hasNext()) {
            int docId = docIds.nextInt();
            if (docId < previousDocId) {
                throw new RuntimeException("Input document IDs must be sorted (increasing).");
            }
            previousDocId = docId;
            while (docId >= currentContext.docBase + currentContext.reader().maxDoc()) {
                currentContext = ctx.next();
            }
            int contextRelativeDocId = docId - currentContext.docBase;
            DocumentFieldValueProvider docFieldsSupplier = new DocumentFieldValueProvider(currentContext, contextRelativeDocId, this.preloadFields);
            highlights.clear();
            this.highlightDocument(currentContext, contextRelativeDocId, docFieldsSupplier, field -> true, highlights);
            consumer.accept(docId, currentContext.reader(), contextRelativeDocId, highlights);
        }
    }

    public void highlightDocument(LeafReaderContext leafReaderContext, int contextDocId, FieldValueProvider doc, Predicate<String> acceptField, Map<String, List<OffsetRange>> outputHighlights) throws IOException {
        Matches matches = this.weight.matches(leafReaderContext, contextDocId);
        if (matches == null) {
            return;
        }
        for (String field : this.affectedFields) {
            MatchesIterator matchesIterator;
            if (!acceptField.test(field) || (matchesIterator = matches.getMatches(field)) == null) continue;
            OffsetsRetrievalStrategy offsetStrategy = this.offsetStrategies.get(field);
            if (offsetStrategy == null) {
                throw new IOException("Non-empty matches but no offset retrieval strategy for field: " + field);
            }
            List<OffsetRange> ranges = offsetStrategy.get(matchesIterator, doc);
            if (ranges.isEmpty()) continue;
            outputHighlights.put(field, ranges);
        }
    }

    private boolean checkOrderConsistency(List<LeafReaderContext> leaves) {
        for (int i = 1; i < leaves.size(); ++i) {
            LeafReaderContext prev = leaves.get(i - 1);
            LeafReaderContext next = leaves.get(i);
            assert (prev.docBase <= next.docBase);
            assert (prev.docBase + prev.reader().maxDoc() == next.docBase);
        }
        return true;
    }

    public static OffsetsRetrievalStrategySupplier computeOffsetRetrievalStrategies(IndexReader reader, Analyzer analyzer) {
        FieldInfos fieldInfos = FieldInfos.getMergedFieldInfos((IndexReader)reader);
        return field -> {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                return (mi, doc) -> {
                    throw new IOException("FieldInfo is null for field: " + field);
                };
            }
            switch (fieldInfo.getIndexOptions()) {
                case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                    return new OffsetsFromMatchIterator((String)field, new OffsetsFromPositions((String)field, analyzer));
                }
                case DOCS_AND_FREQS_AND_POSITIONS: {
                    return new OffsetsFromPositions((String)field, analyzer);
                }
                case DOCS_AND_FREQS: 
                case DOCS: {
                    return new OffsetsFromTokens((String)field, analyzer);
                }
            }
            return (matchesIterator, doc) -> {
                throw new IOException("Field is indexed without positions and/or offsets: " + field + ", " + String.valueOf(fieldInfo.getIndexOptions()));
            };
        };
    }

    private static final class DocumentFieldValueProvider
    implements FieldValueProvider {
        private final IOSupplier<Document> docSupplier = () -> currentContext.reader().storedFields().document(docId, preloadFields);
        private Document doc;

        public DocumentFieldValueProvider(LeafReaderContext currentContext, int docId, Set<String> preloadFields) {
        }

        @Override
        public List<CharSequence> getValues(String field) throws IOException {
            if (this.doc == null) {
                this.doc = Objects.requireNonNull((Document)this.docSupplier.get());
            }
            return Arrays.asList(this.doc.getValues(field));
        }
    }

    @FunctionalInterface
    public static interface FieldValueProvider {
        public List<CharSequence> getValues(String var1) throws IOException;
    }

    @FunctionalInterface
    public static interface MatchOffsetsConsumer {
        public void accept(int var1, LeafReader var2, int var3, Map<String, List<OffsetRange>> var4) throws IOException;
    }
}

