/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiPredicate;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.monitor.MonitorConfiguration;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.MonitorUpdateListener;
import org.apache.lucene.monitor.Presearcher;
import org.apache.lucene.monitor.QueryCacheEntry;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.monitor.QueryIndex;
import org.apache.lucene.monitor.TermsHashBuilder;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.NamedThreadFactory;

class WritableQueryIndex
extends QueryIndex {
    private final IndexWriter writer;
    private final Presearcher presearcher;
    private volatile Map<String, QueryCacheEntry> purgeCache = null;
    private final ReadWriteLock purgeLock = new ReentrantReadWriteLock();
    private final Object commitLock = new Object();
    private final ScheduledExecutorService purgeExecutor;
    protected volatile ConcurrentMap<String, QueryCacheEntry> queries;
    protected long lastPurged = -1L;
    private static final BytesRef EMPTY = new BytesRef();

    WritableQueryIndex(MonitorConfiguration configuration, Presearcher presearcher) throws IOException {
        this.writer = configuration.buildIndexWriter();
        this.queries = new ConcurrentHashMap<String, QueryCacheEntry>();
        this.manager = new SearcherManager(this.writer, true, true, (SearcherFactory)new TermsHashBuilder(this.termFilters));
        this.decomposer = configuration.getQueryDecomposer();
        this.serializer = configuration.getQuerySerializer();
        this.presearcher = presearcher;
        this.populateQueryCache(this.serializer, this.decomposer);
        long purgeFrequency = configuration.getPurgeFrequency();
        this.purgeExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("cache-purge"));
        this.purgeExecutor.scheduleAtFixedRate(() -> {
            try {
                this.purgeCache();
            }
            catch (Throwable e) {
                this.listeners.forEach(l -> l.onPurgeError(e));
            }
        }, purgeFrequency, purgeFrequency, configuration.getPurgeFrequencyUnits());
    }

    @Override
    public void commit(List<MonitorQuery> updates) throws IOException {
        this.commitWithoutNotify(updates);
        this.listeners.forEach(l -> l.afterUpdate(updates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWithoutNotify(List<MonitorQuery> updates) throws IOException {
        List<Indexable> indexables = this.buildIndexables(updates);
        Object object = this.commitLock;
        synchronized (object) {
            this.purgeLock.readLock().lock();
            try {
                if (indexables.size() > 0) {
                    HashSet<String> ids = new HashSet<String>();
                    for (Indexable update : indexables) {
                        ids.add(update.queryCacheEntry.queryId);
                    }
                    for (String id : ids) {
                        this.writer.deleteDocuments(new Term[]{new Term("_query_id", id)});
                    }
                    for (Indexable update : indexables) {
                        this.queries.put(update.queryCacheEntry.cacheId, update.queryCacheEntry);
                        this.writer.addDocument((Iterable)update.document);
                        if (this.purgeCache == null) continue;
                        this.purgeCache.put(update.queryCacheEntry.cacheId, update.queryCacheEntry);
                    }
                }
                this.writer.commit();
                this.manager.maybeRefresh();
            }
            finally {
                this.purgeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateQueryCache(MonitorQuerySerializer serializer, QueryDecomposer decomposer) throws IOException {
        if (serializer == null) {
            IndexSearcher searcher = (IndexSearcher)this.manager.acquire();
            try {
                if (searcher.count((Query)new MatchAllDocsQuery()) != 0) {
                    throw new IllegalStateException("Attempting to open a non-empty monitor query index with no MonitorQuerySerializer");
                }
            }
            finally {
                this.manager.release((Object)searcher);
            }
            return;
        }
        HashSet ids = new HashSet();
        ArrayList errors = new ArrayList();
        this.purgeCache(newCache -> this.scan((id, cacheEntry, dataValues) -> {
            if (ids.contains(id)) {
                return;
            }
            ids.add(id);
            try {
                MonitorQuery mq = serializer.deserialize(dataValues.mq.binaryValue());
                for (QueryCacheEntry entry : QueryCacheEntry.decompose(mq, decomposer)) {
                    newCache.put(entry.cacheId, entry);
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }));
        if (errors.size() > 0) {
            IllegalStateException e = new IllegalStateException("Couldn't parse some queries from the index");
            for (Exception parseError : errors) {
                e.addSuppressed(parseError);
            }
            throw e;
        }
    }

    private List<Indexable> buildIndexables(List<MonitorQuery> updates) {
        ArrayList<Indexable> indexables = new ArrayList<Indexable>();
        for (MonitorQuery mq : updates) {
            if (this.serializer != null && mq.getQueryString() == null) {
                throw new IllegalArgumentException("Cannot add a MonitorQuery with a null string representation to a non-ephemeral Monitor");
            }
            BytesRef serialized = this.serializer == null ? EMPTY : this.serializer.serialize(mq);
            for (QueryCacheEntry qce : QueryCacheEntry.decompose(mq, this.decomposer)) {
                Document doc = this.presearcher.indexQuery(qce.matchQuery, mq.getMetadata());
                doc.add((IndexableField)new StringField("_query_id", qce.queryId, Field.Store.NO));
                doc.add((IndexableField)new SortedDocValuesField("_cache_id", new BytesRef((CharSequence)qce.cacheId)));
                doc.add((IndexableField)new SortedDocValuesField("_query_id", new BytesRef((CharSequence)qce.queryId)));
                doc.add((IndexableField)new BinaryDocValuesField("_mq", serialized));
                indexables.add(new Indexable(qce, doc));
            }
        }
        return indexables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long search(QueryIndex.QueryBuilder queryBuilder, QueryIndex.QueryCollector matcher) throws IOException {
        long l;
        block7: {
            IndexSearcher searcher = null;
            try {
                ConcurrentMap<String, QueryCacheEntry> queries;
                this.purgeLock.readLock().lock();
                try {
                    searcher = (IndexSearcher)this.manager.acquire();
                    queries = this.queries;
                }
                finally {
                    this.purgeLock.readLock().unlock();
                }
                MonitorQueryCollector collector = new MonitorQueryCollector(queries, matcher);
                long buildTime = System.nanoTime();
                Query query = queryBuilder.buildQuery((BiPredicate)this.termFilters.get(searcher.getIndexReader().getReaderCacheHelper().getKey()));
                buildTime = System.nanoTime() - buildTime;
                searcher.search(query, (Collector)collector);
                l = buildTime;
                if (searcher == null) break block7;
            }
            catch (Throwable throwable) {
                if (searcher != null) {
                    this.manager.release(searcher);
                }
                throw throwable;
            }
            this.manager.release((Object)searcher);
        }
        return l;
    }

    @Override
    public void purgeCache() throws IOException {
        this.purgeCache(newCache -> this.scan((id, query, dataValues) -> {
            if (query != null) {
                newCache.put(query.cacheId, query);
            }
        }));
        this.lastPurged = System.nanoTime();
        this.listeners.forEach(MonitorUpdateListener::onPurge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void purgeCache(QueryIndex.CachePopulator populator) throws IOException {
        ConcurrentHashMap<String, QueryCacheEntry> newCache = new ConcurrentHashMap<String, QueryCacheEntry>();
        Object object = this.commitLock;
        synchronized (object) {
            this.purgeLock.writeLock().lock();
            try {
                this.purgeCache = new ConcurrentHashMap<String, QueryCacheEntry>();
            }
            finally {
                this.purgeLock.writeLock().unlock();
            }
        }
        populator.populateCacheWithIndex(newCache);
        object = this.commitLock;
        synchronized (object) {
            this.purgeLock.writeLock().lock();
            try {
                newCache.putAll(this.purgeCache);
                this.purgeCache = null;
                this.queries = newCache;
            }
            finally {
                this.purgeLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.purgeExecutor.shutdown();
        IOUtils.close((Closeable[])new Closeable[]{this.manager, this.writer, this.writer.getDirectory()});
    }

    @Override
    public int numDocs() throws IOException {
        return this.writer.getDocStats().numDocs;
    }

    @Override
    public int cacheSize() {
        return this.queries.size();
    }

    @Override
    public void deleteQueries(List<String> ids) throws IOException {
        for (String id : ids) {
            this.writer.deleteDocuments(new Term[]{new Term("_query_id", id)});
        }
        this.commitWithoutNotify(Collections.emptyList());
        this.listeners.forEach(l -> l.afterDelete(ids));
    }

    @Override
    public void clear() throws IOException {
        this.writer.deleteAll();
        this.commitWithoutNotify(Collections.emptyList());
        this.listeners.forEach(MonitorUpdateListener::afterClear);
    }

    @Override
    public long getLastPurged() {
        return this.lastPurged;
    }

    static final class MonitorQueryCollector
    extends SimpleCollector {
        private final Map<String, QueryCacheEntry> queries;
        private final QueryIndex.QueryCollector matcher;
        private final QueryIndex.DataValues dataValues = new QueryIndex.DataValues();

        MonitorQueryCollector(Map<String, QueryCacheEntry> queries, QueryIndex.QueryCollector matcher) {
            this.queries = queries;
            this.matcher = matcher;
        }

        public void setWeight(Weight weight) {
            this.dataValues.weight = weight;
        }

        public void collect(int doc) throws IOException {
            this.dataValues.advanceTo(doc);
            BytesRef cache_id = this.dataValues.cacheId.lookupOrd(this.dataValues.cacheId.ordValue());
            BytesRef query_id = this.dataValues.queryId.lookupOrd(this.dataValues.queryId.ordValue());
            QueryCacheEntry query = this.queries.get(cache_id.utf8ToString());
            this.matcher.matchQuery(query_id.utf8ToString(), query, this.dataValues);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.dataValues.cacheId = context.reader().getSortedDocValues("_cache_id");
            this.dataValues.queryId = context.reader().getSortedDocValues("_query_id");
            this.dataValues.mq = context.reader().getBinaryDocValues("_mq");
            this.dataValues.ctx = context;
        }

        public ScoreMode scoreMode() {
            return this.matcher.scoreMode();
        }
    }

    private static class Indexable {
        final QueryCacheEntry queryCacheEntry;
        final Document document;

        private Indexable(QueryCacheEntry queryCacheEntry, Document document) {
            this.queryCacheEntry = queryCacheEntry;
            this.document = document;
        }
    }
}

