/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.monitor.TermWeightor;
import org.apache.lucene.util.BytesRef;

public abstract class QueryTree {
    public abstract double weight();

    public abstract void collectTerms(BiConsumer<String, BytesRef> var1);

    public abstract boolean advancePhase(double var1);

    public abstract String toString(int var1);

    public String toString() {
        return this.toString(0);
    }

    protected String space(int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static QueryTree term(Term term, TermWeightor weightor) {
        return QueryTree.term(term.field(), term.bytes(), weightor.applyAsDouble(term));
    }

    public static QueryTree term(Term term, double weight) {
        return QueryTree.term(term.field(), term.bytes(), weight);
    }

    public static QueryTree term(final String field, final BytesRef term, final double weight) {
        return new QueryTree(){

            @Override
            public double weight() {
                if (weight <= 0.0) {
                    throw new IllegalArgumentException("Term weights must be greater than 0");
                }
                return weight;
            }

            @Override
            public void collectTerms(BiConsumer<String, BytesRef> termCollector) {
                termCollector.accept(field, term);
            }

            @Override
            public boolean advancePhase(double minWeight) {
                return false;
            }

            @Override
            public String toString(int depth) {
                return this.space(depth) + field + ":" + term.utf8ToString() + "^" + weight;
            }
        };
    }

    public static QueryTree anyTerm(final String reason) {
        return new QueryTree(){

            @Override
            public double weight() {
                return 0.0;
            }

            @Override
            public void collectTerms(BiConsumer<String, BytesRef> termCollector) {
                termCollector.accept("__anytokenfield", new BytesRef((CharSequence)"__ANYTOKEN__"));
            }

            @Override
            public boolean advancePhase(double minWeight) {
                return false;
            }

            @Override
            public String toString(int depth) {
                return this.space(depth) + "ANY[" + reason + "]";
            }
        };
    }

    public static QueryTree conjunction(List<Function<TermWeightor, QueryTree>> children, TermWeightor weightor) {
        if (children.size() == 0) {
            throw new IllegalArgumentException("Cannot build a conjunction with no children");
        }
        if (children.size() == 1) {
            return children.get(0).apply(weightor);
        }
        List<QueryTree> qt = children.stream().map(f -> (QueryTree)f.apply(weightor)).collect(Collectors.toList());
        List restricted = qt.stream().filter(t -> t.weight() > 0.0).collect(Collectors.toList());
        if (restricted.size() == 0) {
            return (QueryTree)qt.get(0);
        }
        return new ConjunctionQueryTree(qt);
    }

    static QueryTree conjunction(QueryTree ... children) {
        return new ConjunctionQueryTree(Arrays.asList(children));
    }

    public static QueryTree disjunction(List<Function<TermWeightor, QueryTree>> children, TermWeightor weightor) {
        if (children.size() == 0) {
            throw new IllegalArgumentException("Cannot build a disjunction with no children");
        }
        if (children.size() == 1) {
            return children.get(0).apply(weightor);
        }
        List qt = children.stream().map(f -> (QueryTree)f.apply(weightor)).collect(Collectors.toList());
        Optional<QueryTree> firstAnyChild = qt.stream().filter(q -> q.weight() == 0.0).findAny();
        return firstAnyChild.orElseGet(() -> new DisjunctionQueryTree(qt));
    }

    static QueryTree disjunction(QueryTree ... children) {
        return new DisjunctionQueryTree(Arrays.asList(children));
    }

    private static class DisjunctionQueryTree
    extends QueryTree {
        final List<QueryTree> children = new ArrayList<QueryTree>();

        private DisjunctionQueryTree(List<QueryTree> children) {
            this.children.addAll(children);
            this.children.sort(Comparator.comparingDouble(QueryTree::weight));
        }

        @Override
        public double weight() {
            return this.children.get(0).weight();
        }

        @Override
        public void collectTerms(BiConsumer<String, BytesRef> termCollector) {
            for (QueryTree child : this.children) {
                child.collectTerms(termCollector);
            }
        }

        @Override
        public boolean advancePhase(double minWeight) {
            boolean changed = false;
            for (QueryTree child : this.children) {
                changed |= child.advancePhase(minWeight);
            }
            if (!changed) {
                return false;
            }
            this.children.sort(Comparator.comparingDouble(QueryTree::weight));
            return true;
        }

        @Override
        public String toString(int depth) {
            StringBuilder sb = new StringBuilder(this.space(depth)).append("Disjunction[");
            sb.append(this.children.size()).append("]^");
            sb.append(this.weight()).append("\n");
            for (QueryTree child : this.children) {
                sb.append(child.toString(depth + 2)).append("\n");
            }
            return sb.toString();
        }
    }

    private static class ConjunctionQueryTree
    extends QueryTree {
        private static final Comparator<QueryTree> COMPARATOR = Comparator.comparingDouble(QueryTree::weight).reversed();
        final List<QueryTree> children = new ArrayList<QueryTree>();

        ConjunctionQueryTree(List<QueryTree> children) {
            this.children.addAll(children);
            this.children.sort(COMPARATOR);
        }

        @Override
        public double weight() {
            return this.children.get(0).weight();
        }

        @Override
        public void collectTerms(BiConsumer<String, BytesRef> termCollector) {
            this.children.get(0).collectTerms(termCollector);
        }

        @Override
        public boolean advancePhase(double minWeight) {
            if (this.children.get(0).advancePhase(minWeight)) {
                this.children.sort(COMPARATOR);
                return true;
            }
            if (this.children.size() == 1) {
                return false;
            }
            if (this.children.get(1).weight() <= minWeight) {
                return false;
            }
            this.children.remove(0);
            return true;
        }

        @Override
        public String toString(int depth) {
            StringBuilder sb = new StringBuilder(this.space(depth)).append("Conjunction[").append(this.children.size()).append("]^").append(this.weight()).append("\n");
            for (QueryTree child : this.children) {
                sb.append(child.toString(depth + 2)).append("\n");
            }
            return sb.toString();
        }
    }
}

