/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.AssertingBulkScorer;
import org.apache.lucene.tests.search.AssertingMatches;
import org.apache.lucene.tests.search.AssertingScorer;
import org.apache.lucene.tests.util.LuceneTestCase;

class AssertingWeight
extends FilterWeight {
    final Random random;
    final ScoreMode scoreMode;

    AssertingWeight(Random random, Weight in, ScoreMode scoreMode) {
        super(in);
        this.random = random;
        this.scoreMode = scoreMode;
    }

    public int count(LeafReaderContext context) throws IOException {
        int count = this.in.count(context);
        if (count < -1 || count > context.reader().numDocs()) {
            throw new AssertionError((Object)("count=" + count + ", numDocs=" + context.reader().numDocs()));
        }
        return count;
    }

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        Matches matches = this.in.matches(context, doc);
        if (matches == null) {
            return null;
        }
        return new AssertingMatches(matches);
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        if (this.random.nextBoolean()) {
            Scorer inScorer = this.in.scorer(context);
            assert (inScorer == null || inScorer.docID() == -1);
            return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer, this.scoreMode, false);
        }
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        if (this.random.nextBoolean()) {
            scorerSupplier.cost();
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        final ScorerSupplier inScorerSupplier = this.in.scorerSupplier(context);
        if (inScorerSupplier == null) {
            return null;
        }
        return new ScorerSupplier(){
            private boolean getCalled = false;
            private boolean topLevelScoringClause = false;

            public Scorer get(long leadCost) throws IOException {
                assert (!this.getCalled);
                this.getCalled = true;
                assert (leadCost >= 0L) : leadCost;
                return AssertingScorer.wrap(new Random(AssertingWeight.this.random.nextLong()), inScorerSupplier.get(leadCost), AssertingWeight.this.scoreMode, this.topLevelScoringClause);
            }

            public long cost() {
                long cost = inScorerSupplier.cost();
                assert (cost >= 0L);
                return cost;
            }

            public void setTopLevelScoringClause() throws IOException {
                assert (!this.getCalled);
                this.topLevelScoringClause = true;
                inScorerSupplier.setTopLevelScoringClause();
            }
        };
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer inScorer = LuceneTestCase.usually(this.random) ? this.in.bulkScorer(context) : super.bulkScorer(context);
        if (inScorer == null) {
            return null;
        }
        return AssertingBulkScorer.wrap(new Random(this.random.nextLong()), inScorer, context.reader().maxDoc(), this.scoreMode);
    }
}

