/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.overview;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.overview.TermStats;
import org.apache.lucene.misc.HighFreqTerms;

final class TopTerms {
    private final IndexReader reader;
    private final Map<String, List<TermStats>> topTermsCache;

    TopTerms(IndexReader reader) {
        this.reader = Objects.requireNonNull(reader);
        this.topTermsCache = new WeakHashMap<String, List<TermStats>>();
    }

    List<TermStats> getTopTerms(String field, int numTerms) throws Exception {
        if (!this.topTermsCache.containsKey(field) || this.topTermsCache.get(field).size() < numTerms) {
            org.apache.lucene.misc.TermStats[] stats = HighFreqTerms.getHighFreqTerms((IndexReader)this.reader, (int)numTerms, (String)field, (Comparator)new HighFreqTerms.DocFreqComparator());
            List topTerms = Arrays.stream(stats).map(TermStats::of).collect(Collectors.toList());
            this.topTermsCache.put(field, topTerms);
        }
        return List.copyOf((Collection)this.topTermsCache.get(field));
    }
}

