/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.tests.analysis.standard;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.tests.analysis.BaseTokenStreamTestCase;

/**
 * This class was automatically generated by generateEmojiTokenizationTest.pl. from: <a
 * href="http://www.unicode.org/Public/emoji/12.1/emoji-test.txt"><code>
 * http://www.unicode.org/Public/emoji/12.1/emoji-test.txt</code></a>
 */
public final class EmojiTokenizationTestUnicode_12_1 {

  public static void test(Analyzer analyzer) throws Exception {
    for (int i = 0; i < TESTS.length; i += 2) {
      String test = TESTS[i + 1];
      try {
        BaseTokenStreamTestCase.assertAnalyzesTo(
            analyzer, test, new String[] {test}, new String[] {"<EMOJI>"});
      } catch (Throwable t) {
        throw new Exception("Failed to tokenize \"" + TESTS[i] + "\":", t);
      }
    }
  }

  private static String[] TESTS =
      new String[] {
        "1F600                                      ; fully-qualified     # 😀 E2.0 grinning face",
        "\uD83D\uDE00",
        "1F603                                      ; fully-qualified     # 😃 E2.0 grinning face with big eyes",
        "\uD83D\uDE03",
        "1F604                                      ; fully-qualified     # 😄 E2.0 grinning face with smiling eyes",
        "\uD83D\uDE04",
        "1F601                                      ; fully-qualified     # 😁 E2.0 beaming face with smiling eyes",
        "\uD83D\uDE01",
        "1F606                                      ; fully-qualified     # 😆 E2.0 grinning squinting face",
        "\uD83D\uDE06",
        "1F605                                      ; fully-qualified     # 😅 E2.0 grinning face with sweat",
        "\uD83D\uDE05",
        "1F923                                      ; fully-qualified     # 🤣 E4.0 rolling on the floor laughing",
        "\uD83E\uDD23",
        "1F602                                      ; fully-qualified     # 😂 E2.0 face with tears of joy",
        "\uD83D\uDE02",
        "1F642                                      ; fully-qualified     # 🙂 E2.0 slightly smiling face",
        "\uD83D\uDE42",
        "1F643                                      ; fully-qualified     # 🙃 E2.0 upside-down face",
        "\uD83D\uDE43",
        "1F609                                      ; fully-qualified     # 😉 E2.0 winking face",
        "\uD83D\uDE09",
        "1F60A                                      ; fully-qualified     # 😊 E2.0 smiling face with smiling eyes",
        "\uD83D\uDE0A",
        "1F607                                      ; fully-qualified     # 😇 E2.0 smiling face with halo",
        "\uD83D\uDE07",
        "1F970                                      ; fully-qualified     # 🥰 E11.0 smiling face with hearts",
        "\uD83E\uDD70",
        "1F60D                                      ; fully-qualified     # 😍 E2.0 smiling face with heart-eyes",
        "\uD83D\uDE0D",
        "1F929                                      ; fully-qualified     # 🤩 E5.0 star-struck",
        "\uD83E\uDD29",
        "1F618                                      ; fully-qualified     # 😘 E2.0 face blowing a kiss",
        "\uD83D\uDE18",
        "1F617                                      ; fully-qualified     # 😗 E2.0 kissing face",
        "\uD83D\uDE17",
        "263A FE0F                                  ; fully-qualified     # ☺️ E2.0 smiling face",
        "\u263A\uFE0F",
        "263A                                       ; unqualified         # ☺ E2.0 smiling face",
        "\u263A",
        "1F61A                                      ; fully-qualified     # 😚 E2.0 kissing face with closed eyes",
        "\uD83D\uDE1A",
        "1F619                                      ; fully-qualified     # 😙 E2.0 kissing face with smiling eyes",
        "\uD83D\uDE19",
        "1F60B                                      ; fully-qualified     # 😋 E2.0 face savoring food",
        "\uD83D\uDE0B",
        "1F61B                                      ; fully-qualified     # 😛 E2.0 face with tongue",
        "\uD83D\uDE1B",
        "1F61C                                      ; fully-qualified     # 😜 E2.0 winking face with tongue",
        "\uD83D\uDE1C",
        "1F92A                                      ; fully-qualified     # 🤪 E5.0 zany face",
        "\uD83E\uDD2A",
        "1F61D                                      ; fully-qualified     # 😝 E2.0 squinting face with tongue",
        "\uD83D\uDE1D",
        "1F911                                      ; fully-qualified     # 🤑 E2.0 money-mouth face",
        "\uD83E\uDD11",
        "1F917                                      ; fully-qualified     # 🤗 E2.0 hugging face",
        "\uD83E\uDD17",
        "1F92D                                      ; fully-qualified     # 🤭 E5.0 face with hand over mouth",
        "\uD83E\uDD2D",
        "1F92B                                      ; fully-qualified     # 🤫 E5.0 shushing face",
        "\uD83E\uDD2B",
        "1F914                                      ; fully-qualified     # 🤔 E2.0 thinking face",
        "\uD83E\uDD14",
        "1F910                                      ; fully-qualified     # 🤐 E2.0 zipper-mouth face",
        "\uD83E\uDD10",
        "1F928                                      ; fully-qualified     # 🤨 E5.0 face with raised eyebrow",
        "\uD83E\uDD28",
        "1F610                                      ; fully-qualified     # 😐 E2.0 neutral face",
        "\uD83D\uDE10",
        "1F611                                      ; fully-qualified     # 😑 E2.0 expressionless face",
        "\uD83D\uDE11",
        "1F636                                      ; fully-qualified     # 😶 E2.0 face without mouth",
        "\uD83D\uDE36",
        "1F60F                                      ; fully-qualified     # 😏 E2.0 smirking face",
        "\uD83D\uDE0F",
        "1F612                                      ; fully-qualified     # 😒 E2.0 unamused face",
        "\uD83D\uDE12",
        "1F644                                      ; fully-qualified     # 🙄 E2.0 face with rolling eyes",
        "\uD83D\uDE44",
        "1F62C                                      ; fully-qualified     # 😬 E2.0 grimacing face",
        "\uD83D\uDE2C",
        "1F925                                      ; fully-qualified     # 🤥 E4.0 lying face",
        "\uD83E\uDD25",
        "1F60C                                      ; fully-qualified     # 😌 E2.0 relieved face",
        "\uD83D\uDE0C",
        "1F614                                      ; fully-qualified     # 😔 E2.0 pensive face",
        "\uD83D\uDE14",
        "1F62A                                      ; fully-qualified     # 😪 E2.0 sleepy face",
        "\uD83D\uDE2A",
        "1F924                                      ; fully-qualified     # 🤤 E4.0 drooling face",
        "\uD83E\uDD24",
        "1F634                                      ; fully-qualified     # 😴 E2.0 sleeping face",
        "\uD83D\uDE34",
        "1F637                                      ; fully-qualified     # 😷 E2.0 face with medical mask",
        "\uD83D\uDE37",
        "1F912                                      ; fully-qualified     # 🤒 E2.0 face with thermometer",
        "\uD83E\uDD12",
        "1F915                                      ; fully-qualified     # 🤕 E2.0 face with head-bandage",
        "\uD83E\uDD15",
        "1F922                                      ; fully-qualified     # 🤢 E4.0 nauseated face",
        "\uD83E\uDD22",
        "1F92E                                      ; fully-qualified     # 🤮 E5.0 face vomiting",
        "\uD83E\uDD2E",
        "1F927                                      ; fully-qualified     # 🤧 E4.0 sneezing face",
        "\uD83E\uDD27",
        "1F975                                      ; fully-qualified     # 🥵 E11.0 hot face",
        "\uD83E\uDD75",
        "1F976                                      ; fully-qualified     # 🥶 E11.0 cold face",
        "\uD83E\uDD76",
        "1F974                                      ; fully-qualified     # 🥴 E11.0 woozy face",
        "\uD83E\uDD74",
        "1F635                                      ; fully-qualified     # 😵 E2.0 dizzy face",
        "\uD83D\uDE35",
        "1F92F                                      ; fully-qualified     # 🤯 E5.0 exploding head",
        "\uD83E\uDD2F",
        "1F920                                      ; fully-qualified     # 🤠 E4.0 cowboy hat face",
        "\uD83E\uDD20",
        "1F973                                      ; fully-qualified     # 🥳 E11.0 partying face",
        "\uD83E\uDD73",
        "1F60E                                      ; fully-qualified     # 😎 E2.0 smiling face with sunglasses",
        "\uD83D\uDE0E",
        "1F913                                      ; fully-qualified     # 🤓 E2.0 nerd face",
        "\uD83E\uDD13",
        "1F9D0                                      ; fully-qualified     # 🧐 E5.0 face with monocle",
        "\uD83E\uDDD0",
        "1F615                                      ; fully-qualified     # 😕 E2.0 confused face",
        "\uD83D\uDE15",
        "1F61F                                      ; fully-qualified     # 😟 E2.0 worried face",
        "\uD83D\uDE1F",
        "1F641                                      ; fully-qualified     # 🙁 E2.0 slightly frowning face",
        "\uD83D\uDE41",
        "2639 FE0F                                  ; fully-qualified     # ☹️ E2.0 frowning face",
        "\u2639\uFE0F",
        "2639                                       ; unqualified         # ☹ E2.0 frowning face",
        "\u2639",
        "1F62E                                      ; fully-qualified     # 😮 E2.0 face with open mouth",
        "\uD83D\uDE2E",
        "1F62F                                      ; fully-qualified     # 😯 E2.0 hushed face",
        "\uD83D\uDE2F",
        "1F632                                      ; fully-qualified     # 😲 E2.0 astonished face",
        "\uD83D\uDE32",
        "1F633                                      ; fully-qualified     # 😳 E2.0 flushed face",
        "\uD83D\uDE33",
        "1F97A                                      ; fully-qualified     # 🥺 E11.0 pleading face",
        "\uD83E\uDD7A",
        "1F626                                      ; fully-qualified     # 😦 E2.0 frowning face with open mouth",
        "\uD83D\uDE26",
        "1F627                                      ; fully-qualified     # 😧 E2.0 anguished face",
        "\uD83D\uDE27",
        "1F628                                      ; fully-qualified     # 😨 E2.0 fearful face",
        "\uD83D\uDE28",
        "1F630                                      ; fully-qualified     # 😰 E2.0 anxious face with sweat",
        "\uD83D\uDE30",
        "1F625                                      ; fully-qualified     # 😥 E2.0 sad but relieved face",
        "\uD83D\uDE25",
        "1F622                                      ; fully-qualified     # 😢 E2.0 crying face",
        "\uD83D\uDE22",
        "1F62D                                      ; fully-qualified     # 😭 E2.0 loudly crying face",
        "\uD83D\uDE2D",
        "1F631                                      ; fully-qualified     # 😱 E2.0 face screaming in fear",
        "\uD83D\uDE31",
        "1F616                                      ; fully-qualified     # 😖 E2.0 confounded face",
        "\uD83D\uDE16",
        "1F623                                      ; fully-qualified     # 😣 E2.0 persevering face",
        "\uD83D\uDE23",
        "1F61E                                      ; fully-qualified     # 😞 E2.0 disappointed face",
        "\uD83D\uDE1E",
        "1F613                                      ; fully-qualified     # 😓 E2.0 downcast face with sweat",
        "\uD83D\uDE13",
        "1F629                                      ; fully-qualified     # 😩 E2.0 weary face",
        "\uD83D\uDE29",
        "1F62B                                      ; fully-qualified     # 😫 E2.0 tired face",
        "\uD83D\uDE2B",
        "1F971                                      ; fully-qualified     # 🥱 E12.1 yawning face",
        "\uD83E\uDD71",
        "1F624                                      ; fully-qualified     # 😤 E2.0 face with steam from nose",
        "\uD83D\uDE24",
        "1F621                                      ; fully-qualified     # 😡 E2.0 pouting face",
        "\uD83D\uDE21",
        "1F620                                      ; fully-qualified     # 😠 E2.0 angry face",
        "\uD83D\uDE20",
        "1F92C                                      ; fully-qualified     # 🤬 E5.0 face with symbols on mouth",
        "\uD83E\uDD2C",
        "1F608                                      ; fully-qualified     # 😈 E2.0 smiling face with horns",
        "\uD83D\uDE08",
        "1F47F                                      ; fully-qualified     # 👿 E2.0 angry face with horns",
        "\uD83D\uDC7F",
        "1F480                                      ; fully-qualified     # 💀 E2.0 skull",
        "\uD83D\uDC80",
        "2620 FE0F                                  ; fully-qualified     # ☠️ E2.0 skull and crossbones",
        "\u2620\uFE0F",
        "2620                                       ; unqualified         # ☠ E2.0 skull and crossbones",
        "\u2620",
        "1F4A9                                      ; fully-qualified     # 💩 E2.0 pile of poo",
        "\uD83D\uDCA9",
        "1F921                                      ; fully-qualified     # 🤡 E4.0 clown face",
        "\uD83E\uDD21",
        "1F479                                      ; fully-qualified     # 👹 E2.0 ogre",
        "\uD83D\uDC79",
        "1F47A                                      ; fully-qualified     # 👺 E2.0 goblin",
        "\uD83D\uDC7A",
        "1F47B                                      ; fully-qualified     # 👻 E2.0 ghost",
        "\uD83D\uDC7B",
        "1F47D                                      ; fully-qualified     # 👽 E2.0 alien",
        "\uD83D\uDC7D",
        "1F47E                                      ; fully-qualified     # 👾 E2.0 alien monster",
        "\uD83D\uDC7E",
        "1F916                                      ; fully-qualified     # 🤖 E2.0 robot",
        "\uD83E\uDD16",
        "1F63A                                      ; fully-qualified     # 😺 E2.0 grinning cat",
        "\uD83D\uDE3A",
        "1F638                                      ; fully-qualified     # 😸 E2.0 grinning cat with smiling eyes",
        "\uD83D\uDE38",
        "1F639                                      ; fully-qualified     # 😹 E2.0 cat with tears of joy",
        "\uD83D\uDE39",
        "1F63B                                      ; fully-qualified     # 😻 E2.0 smiling cat with heart-eyes",
        "\uD83D\uDE3B",
        "1F63C                                      ; fully-qualified     # 😼 E2.0 cat with wry smile",
        "\uD83D\uDE3C",
        "1F63D                                      ; fully-qualified     # 😽 E2.0 kissing cat",
        "\uD83D\uDE3D",
        "1F640                                      ; fully-qualified     # 🙀 E2.0 weary cat",
        "\uD83D\uDE40",
        "1F63F                                      ; fully-qualified     # 😿 E2.0 crying cat",
        "\uD83D\uDE3F",
        "1F63E                                      ; fully-qualified     # 😾 E2.0 pouting cat",
        "\uD83D\uDE3E",
        "1F648                                      ; fully-qualified     # 🙈 E2.0 see-no-evil monkey",
        "\uD83D\uDE48",
        "1F649                                      ; fully-qualified     # 🙉 E2.0 hear-no-evil monkey",
        "\uD83D\uDE49",
        "1F64A                                      ; fully-qualified     # 🙊 E2.0 speak-no-evil monkey",
        "\uD83D\uDE4A",
        "1F48B                                      ; fully-qualified     # 💋 E2.0 kiss mark",
        "\uD83D\uDC8B",
        "1F48C                                      ; fully-qualified     # 💌 E2.0 love letter",
        "\uD83D\uDC8C",
        "1F498                                      ; fully-qualified     # 💘 E2.0 heart with arrow",
        "\uD83D\uDC98",
        "1F49D                                      ; fully-qualified     # 💝 E2.0 heart with ribbon",
        "\uD83D\uDC9D",
        "1F496                                      ; fully-qualified     # 💖 E2.0 sparkling heart",
        "\uD83D\uDC96",
        "1F497                                      ; fully-qualified     # 💗 E2.0 growing heart",
        "\uD83D\uDC97",
        "1F493                                      ; fully-qualified     # 💓 E2.0 beating heart",
        "\uD83D\uDC93",
        "1F49E                                      ; fully-qualified     # 💞 E2.0 revolving hearts",
        "\uD83D\uDC9E",
        "1F495                                      ; fully-qualified     # 💕 E2.0 two hearts",
        "\uD83D\uDC95",
        "1F49F                                      ; fully-qualified     # 💟 E2.0 heart decoration",
        "\uD83D\uDC9F",
        "2763 FE0F                                  ; fully-qualified     # ❣️ E2.0 heart exclamation",
        "\u2763\uFE0F",
        "2763                                       ; unqualified         # ❣ E2.0 heart exclamation",
        "\u2763",
        "1F494                                      ; fully-qualified     # 💔 E2.0 broken heart",
        "\uD83D\uDC94",
        "2764 FE0F                                  ; fully-qualified     # ❤️ E2.0 red heart",
        "\u2764\uFE0F",
        "2764                                       ; unqualified         # ❤ E2.0 red heart",
        "\u2764",
        "1F9E1                                      ; fully-qualified     # 🧡 E5.0 orange heart",
        "\uD83E\uDDE1",
        "1F49B                                      ; fully-qualified     # 💛 E2.0 yellow heart",
        "\uD83D\uDC9B",
        "1F49A                                      ; fully-qualified     # 💚 E2.0 green heart",
        "\uD83D\uDC9A",
        "1F499                                      ; fully-qualified     # 💙 E2.0 blue heart",
        "\uD83D\uDC99",
        "1F49C                                      ; fully-qualified     # 💜 E2.0 purple heart",
        "\uD83D\uDC9C",
        "1F90E                                      ; fully-qualified     # 🤎 E12.1 brown heart",
        "\uD83E\uDD0E",
        "1F5A4                                      ; fully-qualified     # 🖤 E4.0 black heart",
        "\uD83D\uDDA4",
        "1F90D                                      ; fully-qualified     # 🤍 E12.1 white heart",
        "\uD83E\uDD0D",
        "1F4AF                                      ; fully-qualified     # 💯 E2.0 hundred points",
        "\uD83D\uDCAF",
        "1F4A2                                      ; fully-qualified     # 💢 E2.0 anger symbol",
        "\uD83D\uDCA2",
        "1F4A5                                      ; fully-qualified     # 💥 E2.0 collision",
        "\uD83D\uDCA5",
        "1F4AB                                      ; fully-qualified     # 💫 E2.0 dizzy",
        "\uD83D\uDCAB",
        "1F4A6                                      ; fully-qualified     # 💦 E2.0 sweat droplets",
        "\uD83D\uDCA6",
        "1F4A8                                      ; fully-qualified     # 💨 E2.0 dashing away",
        "\uD83D\uDCA8",
        "1F573 FE0F                                 ; fully-qualified     # 🕳️ E2.0 hole",
        "\uD83D\uDD73\uFE0F",
        "1F573                                      ; unqualified         # 🕳 E2.0 hole",
        "\uD83D\uDD73",
        "1F4A3                                      ; fully-qualified     # 💣 E2.0 bomb",
        "\uD83D\uDCA3",
        "1F4AC                                      ; fully-qualified     # 💬 E2.0 speech balloon",
        "\uD83D\uDCAC",
        "1F441 FE0F 200D 1F5E8 FE0F                 ; fully-qualified     # 👁️‍🗨️ E2.0 eye in speech bubble",
        "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8\uFE0F",
        "1F441 200D 1F5E8 FE0F                      ; unqualified         # 👁‍🗨️ E2.0 eye in speech bubble",
        "\uD83D\uDC41\u200D\uD83D\uDDE8\uFE0F",
        "1F441 FE0F 200D 1F5E8                      ; unqualified         # 👁️‍🗨 E2.0 eye in speech bubble",
        "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8",
        "1F441 200D 1F5E8                           ; unqualified         # 👁‍🗨 E2.0 eye in speech bubble",
        "\uD83D\uDC41\u200D\uD83D\uDDE8",
        "1F5E8 FE0F                                 ; fully-qualified     # 🗨️ E2.0 left speech bubble",
        "\uD83D\uDDE8\uFE0F",
        "1F5E8                                      ; unqualified         # 🗨 E2.0 left speech bubble",
        "\uD83D\uDDE8",
        "1F5EF FE0F                                 ; fully-qualified     # 🗯️ E2.0 right anger bubble",
        "\uD83D\uDDEF\uFE0F",
        "1F5EF                                      ; unqualified         # 🗯 E2.0 right anger bubble",
        "\uD83D\uDDEF",
        "1F4AD                                      ; fully-qualified     # 💭 E2.0 thought balloon",
        "\uD83D\uDCAD",
        "1F4A4                                      ; fully-qualified     # 💤 E2.0 zzz",
        "\uD83D\uDCA4",
        "1F44B                                      ; fully-qualified     # 👋 E2.0 waving hand",
        "\uD83D\uDC4B",
        "1F44B 1F3FB                                ; fully-qualified     # 👋🏻 E2.0 waving hand: light skin tone",
        "\uD83D\uDC4B\uD83C\uDFFB",
        "1F44B 1F3FC                                ; fully-qualified     # 👋🏼 E2.0 waving hand: medium-light skin tone",
        "\uD83D\uDC4B\uD83C\uDFFC",
        "1F44B 1F3FD                                ; fully-qualified     # 👋🏽 E2.0 waving hand: medium skin tone",
        "\uD83D\uDC4B\uD83C\uDFFD",
        "1F44B 1F3FE                                ; fully-qualified     # 👋🏾 E2.0 waving hand: medium-dark skin tone",
        "\uD83D\uDC4B\uD83C\uDFFE",
        "1F44B 1F3FF                                ; fully-qualified     # 👋🏿 E2.0 waving hand: dark skin tone",
        "\uD83D\uDC4B\uD83C\uDFFF",
        "1F91A                                      ; fully-qualified     # 🤚 E4.0 raised back of hand",
        "\uD83E\uDD1A",
        "1F91A 1F3FB                                ; fully-qualified     # 🤚🏻 E4.0 raised back of hand: light skin tone",
        "\uD83E\uDD1A\uD83C\uDFFB",
        "1F91A 1F3FC                                ; fully-qualified     # 🤚🏼 E4.0 raised back of hand: medium-light skin tone",
        "\uD83E\uDD1A\uD83C\uDFFC",
        "1F91A 1F3FD                                ; fully-qualified     # 🤚🏽 E4.0 raised back of hand: medium skin tone",
        "\uD83E\uDD1A\uD83C\uDFFD",
        "1F91A 1F3FE                                ; fully-qualified     # 🤚🏾 E4.0 raised back of hand: medium-dark skin tone",
        "\uD83E\uDD1A\uD83C\uDFFE",
        "1F91A 1F3FF                                ; fully-qualified     # 🤚🏿 E4.0 raised back of hand: dark skin tone",
        "\uD83E\uDD1A\uD83C\uDFFF",
        "1F590 FE0F                                 ; fully-qualified     # 🖐️ E2.0 hand with fingers splayed",
        "\uD83D\uDD90\uFE0F",
        "1F590                                      ; unqualified         # 🖐 E2.0 hand with fingers splayed",
        "\uD83D\uDD90",
        "1F590 1F3FB                                ; fully-qualified     # 🖐🏻 E2.0 hand with fingers splayed: light skin tone",
        "\uD83D\uDD90\uD83C\uDFFB",
        "1F590 1F3FC                                ; fully-qualified     # 🖐🏼 E2.0 hand with fingers splayed: medium-light skin tone",
        "\uD83D\uDD90\uD83C\uDFFC",
        "1F590 1F3FD                                ; fully-qualified     # 🖐🏽 E2.0 hand with fingers splayed: medium skin tone",
        "\uD83D\uDD90\uD83C\uDFFD",
        "1F590 1F3FE                                ; fully-qualified     # 🖐🏾 E2.0 hand with fingers splayed: medium-dark skin tone",
        "\uD83D\uDD90\uD83C\uDFFE",
        "1F590 1F3FF                                ; fully-qualified     # 🖐🏿 E2.0 hand with fingers splayed: dark skin tone",
        "\uD83D\uDD90\uD83C\uDFFF",
        "270B                                       ; fully-qualified     # ✋ E2.0 raised hand",
        "\u270B",
        "270B 1F3FB                                 ; fully-qualified     # ✋🏻 E2.0 raised hand: light skin tone",
        "\u270B\uD83C\uDFFB",
        "270B 1F3FC                                 ; fully-qualified     # ✋🏼 E2.0 raised hand: medium-light skin tone",
        "\u270B\uD83C\uDFFC",
        "270B 1F3FD                                 ; fully-qualified     # ✋🏽 E2.0 raised hand: medium skin tone",
        "\u270B\uD83C\uDFFD",
        "270B 1F3FE                                 ; fully-qualified     # ✋🏾 E2.0 raised hand: medium-dark skin tone",
        "\u270B\uD83C\uDFFE",
        "270B 1F3FF                                 ; fully-qualified     # ✋🏿 E2.0 raised hand: dark skin tone",
        "\u270B\uD83C\uDFFF",
        "1F596                                      ; fully-qualified     # 🖖 E2.0 vulcan salute",
        "\uD83D\uDD96",
        "1F596 1F3FB                                ; fully-qualified     # 🖖🏻 E2.0 vulcan salute: light skin tone",
        "\uD83D\uDD96\uD83C\uDFFB",
        "1F596 1F3FC                                ; fully-qualified     # 🖖🏼 E2.0 vulcan salute: medium-light skin tone",
        "\uD83D\uDD96\uD83C\uDFFC",
        "1F596 1F3FD                                ; fully-qualified     # 🖖🏽 E2.0 vulcan salute: medium skin tone",
        "\uD83D\uDD96\uD83C\uDFFD",
        "1F596 1F3FE                                ; fully-qualified     # 🖖🏾 E2.0 vulcan salute: medium-dark skin tone",
        "\uD83D\uDD96\uD83C\uDFFE",
        "1F596 1F3FF                                ; fully-qualified     # 🖖🏿 E2.0 vulcan salute: dark skin tone",
        "\uD83D\uDD96\uD83C\uDFFF",
        "1F44C                                      ; fully-qualified     # 👌 E2.0 OK hand",
        "\uD83D\uDC4C",
        "1F44C 1F3FB                                ; fully-qualified     # 👌🏻 E2.0 OK hand: light skin tone",
        "\uD83D\uDC4C\uD83C\uDFFB",
        "1F44C 1F3FC                                ; fully-qualified     # 👌🏼 E2.0 OK hand: medium-light skin tone",
        "\uD83D\uDC4C\uD83C\uDFFC",
        "1F44C 1F3FD                                ; fully-qualified     # 👌🏽 E2.0 OK hand: medium skin tone",
        "\uD83D\uDC4C\uD83C\uDFFD",
        "1F44C 1F3FE                                ; fully-qualified     # 👌🏾 E2.0 OK hand: medium-dark skin tone",
        "\uD83D\uDC4C\uD83C\uDFFE",
        "1F44C 1F3FF                                ; fully-qualified     # 👌🏿 E2.0 OK hand: dark skin tone",
        "\uD83D\uDC4C\uD83C\uDFFF",
        "1F90F                                      ; fully-qualified     # 🤏 E12.1 pinching hand",
        "\uD83E\uDD0F",
        "1F90F 1F3FB                                ; fully-qualified     # 🤏🏻 E12.1 pinching hand: light skin tone",
        "\uD83E\uDD0F\uD83C\uDFFB",
        "1F90F 1F3FC                                ; fully-qualified     # 🤏🏼 E12.1 pinching hand: medium-light skin tone",
        "\uD83E\uDD0F\uD83C\uDFFC",
        "1F90F 1F3FD                                ; fully-qualified     # 🤏🏽 E12.1 pinching hand: medium skin tone",
        "\uD83E\uDD0F\uD83C\uDFFD",
        "1F90F 1F3FE                                ; fully-qualified     # 🤏🏾 E12.1 pinching hand: medium-dark skin tone",
        "\uD83E\uDD0F\uD83C\uDFFE",
        "1F90F 1F3FF                                ; fully-qualified     # 🤏🏿 E12.1 pinching hand: dark skin tone",
        "\uD83E\uDD0F\uD83C\uDFFF",
        "270C FE0F                                  ; fully-qualified     # ✌️ E2.0 victory hand",
        "\u270C\uFE0F",
        "270C                                       ; unqualified         # ✌ E2.0 victory hand",
        "\u270C",
        "270C 1F3FB                                 ; fully-qualified     # ✌🏻 E2.0 victory hand: light skin tone",
        "\u270C\uD83C\uDFFB",
        "270C 1F3FC                                 ; fully-qualified     # ✌🏼 E2.0 victory hand: medium-light skin tone",
        "\u270C\uD83C\uDFFC",
        "270C 1F3FD                                 ; fully-qualified     # ✌🏽 E2.0 victory hand: medium skin tone",
        "\u270C\uD83C\uDFFD",
        "270C 1F3FE                                 ; fully-qualified     # ✌🏾 E2.0 victory hand: medium-dark skin tone",
        "\u270C\uD83C\uDFFE",
        "270C 1F3FF                                 ; fully-qualified     # ✌🏿 E2.0 victory hand: dark skin tone",
        "\u270C\uD83C\uDFFF",
        "1F91E                                      ; fully-qualified     # 🤞 E4.0 crossed fingers",
        "\uD83E\uDD1E",
        "1F91E 1F3FB                                ; fully-qualified     # 🤞🏻 E4.0 crossed fingers: light skin tone",
        "\uD83E\uDD1E\uD83C\uDFFB",
        "1F91E 1F3FC                                ; fully-qualified     # 🤞🏼 E4.0 crossed fingers: medium-light skin tone",
        "\uD83E\uDD1E\uD83C\uDFFC",
        "1F91E 1F3FD                                ; fully-qualified     # 🤞🏽 E4.0 crossed fingers: medium skin tone",
        "\uD83E\uDD1E\uD83C\uDFFD",
        "1F91E 1F3FE                                ; fully-qualified     # 🤞🏾 E4.0 crossed fingers: medium-dark skin tone",
        "\uD83E\uDD1E\uD83C\uDFFE",
        "1F91E 1F3FF                                ; fully-qualified     # 🤞🏿 E4.0 crossed fingers: dark skin tone",
        "\uD83E\uDD1E\uD83C\uDFFF",
        "1F91F                                      ; fully-qualified     # 🤟 E5.0 love-you gesture",
        "\uD83E\uDD1F",
        "1F91F 1F3FB                                ; fully-qualified     # 🤟🏻 E5.0 love-you gesture: light skin tone",
        "\uD83E\uDD1F\uD83C\uDFFB",
        "1F91F 1F3FC                                ; fully-qualified     # 🤟🏼 E5.0 love-you gesture: medium-light skin tone",
        "\uD83E\uDD1F\uD83C\uDFFC",
        "1F91F 1F3FD                                ; fully-qualified     # 🤟🏽 E5.0 love-you gesture: medium skin tone",
        "\uD83E\uDD1F\uD83C\uDFFD",
        "1F91F 1F3FE                                ; fully-qualified     # 🤟🏾 E5.0 love-you gesture: medium-dark skin tone",
        "\uD83E\uDD1F\uD83C\uDFFE",
        "1F91F 1F3FF                                ; fully-qualified     # 🤟🏿 E5.0 love-you gesture: dark skin tone",
        "\uD83E\uDD1F\uD83C\uDFFF",
        "1F918                                      ; fully-qualified     # 🤘 E2.0 sign of the horns",
        "\uD83E\uDD18",
        "1F918 1F3FB                                ; fully-qualified     # 🤘🏻 E2.0 sign of the horns: light skin tone",
        "\uD83E\uDD18\uD83C\uDFFB",
        "1F918 1F3FC                                ; fully-qualified     # 🤘🏼 E2.0 sign of the horns: medium-light skin tone",
        "\uD83E\uDD18\uD83C\uDFFC",
        "1F918 1F3FD                                ; fully-qualified     # 🤘🏽 E2.0 sign of the horns: medium skin tone",
        "\uD83E\uDD18\uD83C\uDFFD",
        "1F918 1F3FE                                ; fully-qualified     # 🤘🏾 E2.0 sign of the horns: medium-dark skin tone",
        "\uD83E\uDD18\uD83C\uDFFE",
        "1F918 1F3FF                                ; fully-qualified     # 🤘🏿 E2.0 sign of the horns: dark skin tone",
        "\uD83E\uDD18\uD83C\uDFFF",
        "1F919                                      ; fully-qualified     # 🤙 E4.0 call me hand",
        "\uD83E\uDD19",
        "1F919 1F3FB                                ; fully-qualified     # 🤙🏻 E4.0 call me hand: light skin tone",
        "\uD83E\uDD19\uD83C\uDFFB",
        "1F919 1F3FC                                ; fully-qualified     # 🤙🏼 E4.0 call me hand: medium-light skin tone",
        "\uD83E\uDD19\uD83C\uDFFC",
        "1F919 1F3FD                                ; fully-qualified     # 🤙🏽 E4.0 call me hand: medium skin tone",
        "\uD83E\uDD19\uD83C\uDFFD",
        "1F919 1F3FE                                ; fully-qualified     # 🤙🏾 E4.0 call me hand: medium-dark skin tone",
        "\uD83E\uDD19\uD83C\uDFFE",
        "1F919 1F3FF                                ; fully-qualified     # 🤙🏿 E4.0 call me hand: dark skin tone",
        "\uD83E\uDD19\uD83C\uDFFF",
        "1F448                                      ; fully-qualified     # 👈 E2.0 backhand index pointing left",
        "\uD83D\uDC48",
        "1F448 1F3FB                                ; fully-qualified     # 👈🏻 E2.0 backhand index pointing left: light skin tone",
        "\uD83D\uDC48\uD83C\uDFFB",
        "1F448 1F3FC                                ; fully-qualified     # 👈🏼 E2.0 backhand index pointing left: medium-light skin tone",
        "\uD83D\uDC48\uD83C\uDFFC",
        "1F448 1F3FD                                ; fully-qualified     # 👈🏽 E2.0 backhand index pointing left: medium skin tone",
        "\uD83D\uDC48\uD83C\uDFFD",
        "1F448 1F3FE                                ; fully-qualified     # 👈🏾 E2.0 backhand index pointing left: medium-dark skin tone",
        "\uD83D\uDC48\uD83C\uDFFE",
        "1F448 1F3FF                                ; fully-qualified     # 👈🏿 E2.0 backhand index pointing left: dark skin tone",
        "\uD83D\uDC48\uD83C\uDFFF",
        "1F449                                      ; fully-qualified     # 👉 E2.0 backhand index pointing right",
        "\uD83D\uDC49",
        "1F449 1F3FB                                ; fully-qualified     # 👉🏻 E2.0 backhand index pointing right: light skin tone",
        "\uD83D\uDC49\uD83C\uDFFB",
        "1F449 1F3FC                                ; fully-qualified     # 👉🏼 E2.0 backhand index pointing right: medium-light skin tone",
        "\uD83D\uDC49\uD83C\uDFFC",
        "1F449 1F3FD                                ; fully-qualified     # 👉🏽 E2.0 backhand index pointing right: medium skin tone",
        "\uD83D\uDC49\uD83C\uDFFD",
        "1F449 1F3FE                                ; fully-qualified     # 👉🏾 E2.0 backhand index pointing right: medium-dark skin tone",
        "\uD83D\uDC49\uD83C\uDFFE",
        "1F449 1F3FF                                ; fully-qualified     # 👉🏿 E2.0 backhand index pointing right: dark skin tone",
        "\uD83D\uDC49\uD83C\uDFFF",
        "1F446                                      ; fully-qualified     # 👆 E2.0 backhand index pointing up",
        "\uD83D\uDC46",
        "1F446 1F3FB                                ; fully-qualified     # 👆🏻 E2.0 backhand index pointing up: light skin tone",
        "\uD83D\uDC46\uD83C\uDFFB",
        "1F446 1F3FC                                ; fully-qualified     # 👆🏼 E2.0 backhand index pointing up: medium-light skin tone",
        "\uD83D\uDC46\uD83C\uDFFC",
        "1F446 1F3FD                                ; fully-qualified     # 👆🏽 E2.0 backhand index pointing up: medium skin tone",
        "\uD83D\uDC46\uD83C\uDFFD",
        "1F446 1F3FE                                ; fully-qualified     # 👆🏾 E2.0 backhand index pointing up: medium-dark skin tone",
        "\uD83D\uDC46\uD83C\uDFFE",
        "1F446 1F3FF                                ; fully-qualified     # 👆🏿 E2.0 backhand index pointing up: dark skin tone",
        "\uD83D\uDC46\uD83C\uDFFF",
        "1F595                                      ; fully-qualified     # 🖕 E2.0 middle finger",
        "\uD83D\uDD95",
        "1F595 1F3FB                                ; fully-qualified     # 🖕🏻 E2.0 middle finger: light skin tone",
        "\uD83D\uDD95\uD83C\uDFFB",
        "1F595 1F3FC                                ; fully-qualified     # 🖕🏼 E2.0 middle finger: medium-light skin tone",
        "\uD83D\uDD95\uD83C\uDFFC",
        "1F595 1F3FD                                ; fully-qualified     # 🖕🏽 E2.0 middle finger: medium skin tone",
        "\uD83D\uDD95\uD83C\uDFFD",
        "1F595 1F3FE                                ; fully-qualified     # 🖕🏾 E2.0 middle finger: medium-dark skin tone",
        "\uD83D\uDD95\uD83C\uDFFE",
        "1F595 1F3FF                                ; fully-qualified     # 🖕🏿 E2.0 middle finger: dark skin tone",
        "\uD83D\uDD95\uD83C\uDFFF",
        "1F447                                      ; fully-qualified     # 👇 E2.0 backhand index pointing down",
        "\uD83D\uDC47",
        "1F447 1F3FB                                ; fully-qualified     # 👇🏻 E2.0 backhand index pointing down: light skin tone",
        "\uD83D\uDC47\uD83C\uDFFB",
        "1F447 1F3FC                                ; fully-qualified     # 👇🏼 E2.0 backhand index pointing down: medium-light skin tone",
        "\uD83D\uDC47\uD83C\uDFFC",
        "1F447 1F3FD                                ; fully-qualified     # 👇🏽 E2.0 backhand index pointing down: medium skin tone",
        "\uD83D\uDC47\uD83C\uDFFD",
        "1F447 1F3FE                                ; fully-qualified     # 👇🏾 E2.0 backhand index pointing down: medium-dark skin tone",
        "\uD83D\uDC47\uD83C\uDFFE",
        "1F447 1F3FF                                ; fully-qualified     # 👇🏿 E2.0 backhand index pointing down: dark skin tone",
        "\uD83D\uDC47\uD83C\uDFFF",
        "261D FE0F                                  ; fully-qualified     # ☝️ E2.0 index pointing up",
        "\u261D\uFE0F",
        "261D                                       ; unqualified         # ☝ E2.0 index pointing up",
        "\u261D",
        "261D 1F3FB                                 ; fully-qualified     # ☝🏻 E2.0 index pointing up: light skin tone",
        "\u261D\uD83C\uDFFB",
        "261D 1F3FC                                 ; fully-qualified     # ☝🏼 E2.0 index pointing up: medium-light skin tone",
        "\u261D\uD83C\uDFFC",
        "261D 1F3FD                                 ; fully-qualified     # ☝🏽 E2.0 index pointing up: medium skin tone",
        "\u261D\uD83C\uDFFD",
        "261D 1F3FE                                 ; fully-qualified     # ☝🏾 E2.0 index pointing up: medium-dark skin tone",
        "\u261D\uD83C\uDFFE",
        "261D 1F3FF                                 ; fully-qualified     # ☝🏿 E2.0 index pointing up: dark skin tone",
        "\u261D\uD83C\uDFFF",
        "1F44D                                      ; fully-qualified     # 👍 E2.0 thumbs up",
        "\uD83D\uDC4D",
        "1F44D 1F3FB                                ; fully-qualified     # 👍🏻 E2.0 thumbs up: light skin tone",
        "\uD83D\uDC4D\uD83C\uDFFB",
        "1F44D 1F3FC                                ; fully-qualified     # 👍🏼 E2.0 thumbs up: medium-light skin tone",
        "\uD83D\uDC4D\uD83C\uDFFC",
        "1F44D 1F3FD                                ; fully-qualified     # 👍🏽 E2.0 thumbs up: medium skin tone",
        "\uD83D\uDC4D\uD83C\uDFFD",
        "1F44D 1F3FE                                ; fully-qualified     # 👍🏾 E2.0 thumbs up: medium-dark skin tone",
        "\uD83D\uDC4D\uD83C\uDFFE",
        "1F44D 1F3FF                                ; fully-qualified     # 👍🏿 E2.0 thumbs up: dark skin tone",
        "\uD83D\uDC4D\uD83C\uDFFF",
        "1F44E                                      ; fully-qualified     # 👎 E2.0 thumbs down",
        "\uD83D\uDC4E",
        "1F44E 1F3FB                                ; fully-qualified     # 👎🏻 E2.0 thumbs down: light skin tone",
        "\uD83D\uDC4E\uD83C\uDFFB",
        "1F44E 1F3FC                                ; fully-qualified     # 👎🏼 E2.0 thumbs down: medium-light skin tone",
        "\uD83D\uDC4E\uD83C\uDFFC",
        "1F44E 1F3FD                                ; fully-qualified     # 👎🏽 E2.0 thumbs down: medium skin tone",
        "\uD83D\uDC4E\uD83C\uDFFD",
        "1F44E 1F3FE                                ; fully-qualified     # 👎🏾 E2.0 thumbs down: medium-dark skin tone",
        "\uD83D\uDC4E\uD83C\uDFFE",
        "1F44E 1F3FF                                ; fully-qualified     # 👎🏿 E2.0 thumbs down: dark skin tone",
        "\uD83D\uDC4E\uD83C\uDFFF",
        "270A                                       ; fully-qualified     # ✊ E2.0 raised fist",
        "\u270A",
        "270A 1F3FB                                 ; fully-qualified     # ✊🏻 E2.0 raised fist: light skin tone",
        "\u270A\uD83C\uDFFB",
        "270A 1F3FC                                 ; fully-qualified     # ✊🏼 E2.0 raised fist: medium-light skin tone",
        "\u270A\uD83C\uDFFC",
        "270A 1F3FD                                 ; fully-qualified     # ✊🏽 E2.0 raised fist: medium skin tone",
        "\u270A\uD83C\uDFFD",
        "270A 1F3FE                                 ; fully-qualified     # ✊🏾 E2.0 raised fist: medium-dark skin tone",
        "\u270A\uD83C\uDFFE",
        "270A 1F3FF                                 ; fully-qualified     # ✊🏿 E2.0 raised fist: dark skin tone",
        "\u270A\uD83C\uDFFF",
        "1F44A                                      ; fully-qualified     # 👊 E2.0 oncoming fist",
        "\uD83D\uDC4A",
        "1F44A 1F3FB                                ; fully-qualified     # 👊🏻 E2.0 oncoming fist: light skin tone",
        "\uD83D\uDC4A\uD83C\uDFFB",
        "1F44A 1F3FC                                ; fully-qualified     # 👊🏼 E2.0 oncoming fist: medium-light skin tone",
        "\uD83D\uDC4A\uD83C\uDFFC",
        "1F44A 1F3FD                                ; fully-qualified     # 👊🏽 E2.0 oncoming fist: medium skin tone",
        "\uD83D\uDC4A\uD83C\uDFFD",
        "1F44A 1F3FE                                ; fully-qualified     # 👊🏾 E2.0 oncoming fist: medium-dark skin tone",
        "\uD83D\uDC4A\uD83C\uDFFE",
        "1F44A 1F3FF                                ; fully-qualified     # 👊🏿 E2.0 oncoming fist: dark skin tone",
        "\uD83D\uDC4A\uD83C\uDFFF",
        "1F91B                                      ; fully-qualified     # 🤛 E4.0 left-facing fist",
        "\uD83E\uDD1B",
        "1F91B 1F3FB                                ; fully-qualified     # 🤛🏻 E4.0 left-facing fist: light skin tone",
        "\uD83E\uDD1B\uD83C\uDFFB",
        "1F91B 1F3FC                                ; fully-qualified     # 🤛🏼 E4.0 left-facing fist: medium-light skin tone",
        "\uD83E\uDD1B\uD83C\uDFFC",
        "1F91B 1F3FD                                ; fully-qualified     # 🤛🏽 E4.0 left-facing fist: medium skin tone",
        "\uD83E\uDD1B\uD83C\uDFFD",
        "1F91B 1F3FE                                ; fully-qualified     # 🤛🏾 E4.0 left-facing fist: medium-dark skin tone",
        "\uD83E\uDD1B\uD83C\uDFFE",
        "1F91B 1F3FF                                ; fully-qualified     # 🤛🏿 E4.0 left-facing fist: dark skin tone",
        "\uD83E\uDD1B\uD83C\uDFFF",
        "1F91C                                      ; fully-qualified     # 🤜 E4.0 right-facing fist",
        "\uD83E\uDD1C",
        "1F91C 1F3FB                                ; fully-qualified     # 🤜🏻 E4.0 right-facing fist: light skin tone",
        "\uD83E\uDD1C\uD83C\uDFFB",
        "1F91C 1F3FC                                ; fully-qualified     # 🤜🏼 E4.0 right-facing fist: medium-light skin tone",
        "\uD83E\uDD1C\uD83C\uDFFC",
        "1F91C 1F3FD                                ; fully-qualified     # 🤜🏽 E4.0 right-facing fist: medium skin tone",
        "\uD83E\uDD1C\uD83C\uDFFD",
        "1F91C 1F3FE                                ; fully-qualified     # 🤜🏾 E4.0 right-facing fist: medium-dark skin tone",
        "\uD83E\uDD1C\uD83C\uDFFE",
        "1F91C 1F3FF                                ; fully-qualified     # 🤜🏿 E4.0 right-facing fist: dark skin tone",
        "\uD83E\uDD1C\uD83C\uDFFF",
        "1F44F                                      ; fully-qualified     # 👏 E2.0 clapping hands",
        "\uD83D\uDC4F",
        "1F44F 1F3FB                                ; fully-qualified     # 👏🏻 E2.0 clapping hands: light skin tone",
        "\uD83D\uDC4F\uD83C\uDFFB",
        "1F44F 1F3FC                                ; fully-qualified     # 👏🏼 E2.0 clapping hands: medium-light skin tone",
        "\uD83D\uDC4F\uD83C\uDFFC",
        "1F44F 1F3FD                                ; fully-qualified     # 👏🏽 E2.0 clapping hands: medium skin tone",
        "\uD83D\uDC4F\uD83C\uDFFD",
        "1F44F 1F3FE                                ; fully-qualified     # 👏🏾 E2.0 clapping hands: medium-dark skin tone",
        "\uD83D\uDC4F\uD83C\uDFFE",
        "1F44F 1F3FF                                ; fully-qualified     # 👏🏿 E2.0 clapping hands: dark skin tone",
        "\uD83D\uDC4F\uD83C\uDFFF",
        "1F64C                                      ; fully-qualified     # 🙌 E2.0 raising hands",
        "\uD83D\uDE4C",
        "1F64C 1F3FB                                ; fully-qualified     # 🙌🏻 E2.0 raising hands: light skin tone",
        "\uD83D\uDE4C\uD83C\uDFFB",
        "1F64C 1F3FC                                ; fully-qualified     # 🙌🏼 E2.0 raising hands: medium-light skin tone",
        "\uD83D\uDE4C\uD83C\uDFFC",
        "1F64C 1F3FD                                ; fully-qualified     # 🙌🏽 E2.0 raising hands: medium skin tone",
        "\uD83D\uDE4C\uD83C\uDFFD",
        "1F64C 1F3FE                                ; fully-qualified     # 🙌🏾 E2.0 raising hands: medium-dark skin tone",
        "\uD83D\uDE4C\uD83C\uDFFE",
        "1F64C 1F3FF                                ; fully-qualified     # 🙌🏿 E2.0 raising hands: dark skin tone",
        "\uD83D\uDE4C\uD83C\uDFFF",
        "1F450                                      ; fully-qualified     # 👐 E2.0 open hands",
        "\uD83D\uDC50",
        "1F450 1F3FB                                ; fully-qualified     # 👐🏻 E2.0 open hands: light skin tone",
        "\uD83D\uDC50\uD83C\uDFFB",
        "1F450 1F3FC                                ; fully-qualified     # 👐🏼 E2.0 open hands: medium-light skin tone",
        "\uD83D\uDC50\uD83C\uDFFC",
        "1F450 1F3FD                                ; fully-qualified     # 👐🏽 E2.0 open hands: medium skin tone",
        "\uD83D\uDC50\uD83C\uDFFD",
        "1F450 1F3FE                                ; fully-qualified     # 👐🏾 E2.0 open hands: medium-dark skin tone",
        "\uD83D\uDC50\uD83C\uDFFE",
        "1F450 1F3FF                                ; fully-qualified     # 👐🏿 E2.0 open hands: dark skin tone",
        "\uD83D\uDC50\uD83C\uDFFF",
        "1F932                                      ; fully-qualified     # 🤲 E5.0 palms up together",
        "\uD83E\uDD32",
        "1F932 1F3FB                                ; fully-qualified     # 🤲🏻 E5.0 palms up together: light skin tone",
        "\uD83E\uDD32\uD83C\uDFFB",
        "1F932 1F3FC                                ; fully-qualified     # 🤲🏼 E5.0 palms up together: medium-light skin tone",
        "\uD83E\uDD32\uD83C\uDFFC",
        "1F932 1F3FD                                ; fully-qualified     # 🤲🏽 E5.0 palms up together: medium skin tone",
        "\uD83E\uDD32\uD83C\uDFFD",
        "1F932 1F3FE                                ; fully-qualified     # 🤲🏾 E5.0 palms up together: medium-dark skin tone",
        "\uD83E\uDD32\uD83C\uDFFE",
        "1F932 1F3FF                                ; fully-qualified     # 🤲🏿 E5.0 palms up together: dark skin tone",
        "\uD83E\uDD32\uD83C\uDFFF",
        "1F91D                                      ; fully-qualified     # 🤝 E4.0 handshake",
        "\uD83E\uDD1D",
        "1F64F                                      ; fully-qualified     # 🙏 E2.0 folded hands",
        "\uD83D\uDE4F",
        "1F64F 1F3FB                                ; fully-qualified     # 🙏🏻 E2.0 folded hands: light skin tone",
        "\uD83D\uDE4F\uD83C\uDFFB",
        "1F64F 1F3FC                                ; fully-qualified     # 🙏🏼 E2.0 folded hands: medium-light skin tone",
        "\uD83D\uDE4F\uD83C\uDFFC",
        "1F64F 1F3FD                                ; fully-qualified     # 🙏🏽 E2.0 folded hands: medium skin tone",
        "\uD83D\uDE4F\uD83C\uDFFD",
        "1F64F 1F3FE                                ; fully-qualified     # 🙏🏾 E2.0 folded hands: medium-dark skin tone",
        "\uD83D\uDE4F\uD83C\uDFFE",
        "1F64F 1F3FF                                ; fully-qualified     # 🙏🏿 E2.0 folded hands: dark skin tone",
        "\uD83D\uDE4F\uD83C\uDFFF",
        "270D FE0F                                  ; fully-qualified     # ✍️ E2.0 writing hand",
        "\u270D\uFE0F",
        "270D                                       ; unqualified         # ✍ E2.0 writing hand",
        "\u270D",
        "270D 1F3FB                                 ; fully-qualified     # ✍🏻 E2.0 writing hand: light skin tone",
        "\u270D\uD83C\uDFFB",
        "270D 1F3FC                                 ; fully-qualified     # ✍🏼 E2.0 writing hand: medium-light skin tone",
        "\u270D\uD83C\uDFFC",
        "270D 1F3FD                                 ; fully-qualified     # ✍🏽 E2.0 writing hand: medium skin tone",
        "\u270D\uD83C\uDFFD",
        "270D 1F3FE                                 ; fully-qualified     # ✍🏾 E2.0 writing hand: medium-dark skin tone",
        "\u270D\uD83C\uDFFE",
        "270D 1F3FF                                 ; fully-qualified     # ✍🏿 E2.0 writing hand: dark skin tone",
        "\u270D\uD83C\uDFFF",
        "1F485                                      ; fully-qualified     # 💅 E2.0 nail polish",
        "\uD83D\uDC85",
        "1F485 1F3FB                                ; fully-qualified     # 💅🏻 E2.0 nail polish: light skin tone",
        "\uD83D\uDC85\uD83C\uDFFB",
        "1F485 1F3FC                                ; fully-qualified     # 💅🏼 E2.0 nail polish: medium-light skin tone",
        "\uD83D\uDC85\uD83C\uDFFC",
        "1F485 1F3FD                                ; fully-qualified     # 💅🏽 E2.0 nail polish: medium skin tone",
        "\uD83D\uDC85\uD83C\uDFFD",
        "1F485 1F3FE                                ; fully-qualified     # 💅🏾 E2.0 nail polish: medium-dark skin tone",
        "\uD83D\uDC85\uD83C\uDFFE",
        "1F485 1F3FF                                ; fully-qualified     # 💅🏿 E2.0 nail polish: dark skin tone",
        "\uD83D\uDC85\uD83C\uDFFF",
        "1F933                                      ; fully-qualified     # 🤳 E4.0 selfie",
        "\uD83E\uDD33",
        "1F933 1F3FB                                ; fully-qualified     # 🤳🏻 E4.0 selfie: light skin tone",
        "\uD83E\uDD33\uD83C\uDFFB",
        "1F933 1F3FC                                ; fully-qualified     # 🤳🏼 E4.0 selfie: medium-light skin tone",
        "\uD83E\uDD33\uD83C\uDFFC",
        "1F933 1F3FD                                ; fully-qualified     # 🤳🏽 E4.0 selfie: medium skin tone",
        "\uD83E\uDD33\uD83C\uDFFD",
        "1F933 1F3FE                                ; fully-qualified     # 🤳🏾 E4.0 selfie: medium-dark skin tone",
        "\uD83E\uDD33\uD83C\uDFFE",
        "1F933 1F3FF                                ; fully-qualified     # 🤳🏿 E4.0 selfie: dark skin tone",
        "\uD83E\uDD33\uD83C\uDFFF",
        "1F4AA                                      ; fully-qualified     # 💪 E2.0 flexed biceps",
        "\uD83D\uDCAA",
        "1F4AA 1F3FB                                ; fully-qualified     # 💪🏻 E2.0 flexed biceps: light skin tone",
        "\uD83D\uDCAA\uD83C\uDFFB",
        "1F4AA 1F3FC                                ; fully-qualified     # 💪🏼 E2.0 flexed biceps: medium-light skin tone",
        "\uD83D\uDCAA\uD83C\uDFFC",
        "1F4AA 1F3FD                                ; fully-qualified     # 💪🏽 E2.0 flexed biceps: medium skin tone",
        "\uD83D\uDCAA\uD83C\uDFFD",
        "1F4AA 1F3FE                                ; fully-qualified     # 💪🏾 E2.0 flexed biceps: medium-dark skin tone",
        "\uD83D\uDCAA\uD83C\uDFFE",
        "1F4AA 1F3FF                                ; fully-qualified     # 💪🏿 E2.0 flexed biceps: dark skin tone",
        "\uD83D\uDCAA\uD83C\uDFFF",
        "1F9BE                                      ; fully-qualified     # 🦾 E12.1 mechanical arm",
        "\uD83E\uDDBE",
        "1F9BF                                      ; fully-qualified     # 🦿 E12.1 mechanical leg",
        "\uD83E\uDDBF",
        "1F9B5                                      ; fully-qualified     # 🦵 E11.0 leg",
        "\uD83E\uDDB5",
        "1F9B5 1F3FB                                ; fully-qualified     # 🦵🏻 E11.0 leg: light skin tone",
        "\uD83E\uDDB5\uD83C\uDFFB",
        "1F9B5 1F3FC                                ; fully-qualified     # 🦵🏼 E11.0 leg: medium-light skin tone",
        "\uD83E\uDDB5\uD83C\uDFFC",
        "1F9B5 1F3FD                                ; fully-qualified     # 🦵🏽 E11.0 leg: medium skin tone",
        "\uD83E\uDDB5\uD83C\uDFFD",
        "1F9B5 1F3FE                                ; fully-qualified     # 🦵🏾 E11.0 leg: medium-dark skin tone",
        "\uD83E\uDDB5\uD83C\uDFFE",
        "1F9B5 1F3FF                                ; fully-qualified     # 🦵🏿 E11.0 leg: dark skin tone",
        "\uD83E\uDDB5\uD83C\uDFFF",
        "1F9B6                                      ; fully-qualified     # 🦶 E11.0 foot",
        "\uD83E\uDDB6",
        "1F9B6 1F3FB                                ; fully-qualified     # 🦶🏻 E11.0 foot: light skin tone",
        "\uD83E\uDDB6\uD83C\uDFFB",
        "1F9B6 1F3FC                                ; fully-qualified     # 🦶🏼 E11.0 foot: medium-light skin tone",
        "\uD83E\uDDB6\uD83C\uDFFC",
        "1F9B6 1F3FD                                ; fully-qualified     # 🦶🏽 E11.0 foot: medium skin tone",
        "\uD83E\uDDB6\uD83C\uDFFD",
        "1F9B6 1F3FE                                ; fully-qualified     # 🦶🏾 E11.0 foot: medium-dark skin tone",
        "\uD83E\uDDB6\uD83C\uDFFE",
        "1F9B6 1F3FF                                ; fully-qualified     # 🦶🏿 E11.0 foot: dark skin tone",
        "\uD83E\uDDB6\uD83C\uDFFF",
        "1F442                                      ; fully-qualified     # 👂 E2.0 ear",
        "\uD83D\uDC42",
        "1F442 1F3FB                                ; fully-qualified     # 👂🏻 E2.0 ear: light skin tone",
        "\uD83D\uDC42\uD83C\uDFFB",
        "1F442 1F3FC                                ; fully-qualified     # 👂🏼 E2.0 ear: medium-light skin tone",
        "\uD83D\uDC42\uD83C\uDFFC",
        "1F442 1F3FD                                ; fully-qualified     # 👂🏽 E2.0 ear: medium skin tone",
        "\uD83D\uDC42\uD83C\uDFFD",
        "1F442 1F3FE                                ; fully-qualified     # 👂🏾 E2.0 ear: medium-dark skin tone",
        "\uD83D\uDC42\uD83C\uDFFE",
        "1F442 1F3FF                                ; fully-qualified     # 👂🏿 E2.0 ear: dark skin tone",
        "\uD83D\uDC42\uD83C\uDFFF",
        "1F9BB                                      ; fully-qualified     # 🦻 E12.1 ear with hearing aid",
        "\uD83E\uDDBB",
        "1F9BB 1F3FB                                ; fully-qualified     # 🦻🏻 E12.1 ear with hearing aid: light skin tone",
        "\uD83E\uDDBB\uD83C\uDFFB",
        "1F9BB 1F3FC                                ; fully-qualified     # 🦻🏼 E12.1 ear with hearing aid: medium-light skin tone",
        "\uD83E\uDDBB\uD83C\uDFFC",
        "1F9BB 1F3FD                                ; fully-qualified     # 🦻🏽 E12.1 ear with hearing aid: medium skin tone",
        "\uD83E\uDDBB\uD83C\uDFFD",
        "1F9BB 1F3FE                                ; fully-qualified     # 🦻🏾 E12.1 ear with hearing aid: medium-dark skin tone",
        "\uD83E\uDDBB\uD83C\uDFFE",
        "1F9BB 1F3FF                                ; fully-qualified     # 🦻🏿 E12.1 ear with hearing aid: dark skin tone",
        "\uD83E\uDDBB\uD83C\uDFFF",
        "1F443                                      ; fully-qualified     # 👃 E2.0 nose",
        "\uD83D\uDC43",
        "1F443 1F3FB                                ; fully-qualified     # 👃🏻 E2.0 nose: light skin tone",
        "\uD83D\uDC43\uD83C\uDFFB",
        "1F443 1F3FC                                ; fully-qualified     # 👃🏼 E2.0 nose: medium-light skin tone",
        "\uD83D\uDC43\uD83C\uDFFC",
        "1F443 1F3FD                                ; fully-qualified     # 👃🏽 E2.0 nose: medium skin tone",
        "\uD83D\uDC43\uD83C\uDFFD",
        "1F443 1F3FE                                ; fully-qualified     # 👃🏾 E2.0 nose: medium-dark skin tone",
        "\uD83D\uDC43\uD83C\uDFFE",
        "1F443 1F3FF                                ; fully-qualified     # 👃🏿 E2.0 nose: dark skin tone",
        "\uD83D\uDC43\uD83C\uDFFF",
        "1F9E0                                      ; fully-qualified     # 🧠 E5.0 brain",
        "\uD83E\uDDE0",
        "1F9B7                                      ; fully-qualified     # 🦷 E11.0 tooth",
        "\uD83E\uDDB7",
        "1F9B4                                      ; fully-qualified     # 🦴 E11.0 bone",
        "\uD83E\uDDB4",
        "1F440                                      ; fully-qualified     # 👀 E2.0 eyes",
        "\uD83D\uDC40",
        "1F441 FE0F                                 ; fully-qualified     # 👁️ E2.0 eye",
        "\uD83D\uDC41\uFE0F",
        "1F441                                      ; unqualified         # 👁 E2.0 eye",
        "\uD83D\uDC41",
        "1F445                                      ; fully-qualified     # 👅 E2.0 tongue",
        "\uD83D\uDC45",
        "1F444                                      ; fully-qualified     # 👄 E2.0 mouth",
        "\uD83D\uDC44",
        "1F476                                      ; fully-qualified     # 👶 E2.0 baby",
        "\uD83D\uDC76",
        "1F476 1F3FB                                ; fully-qualified     # 👶🏻 E2.0 baby: light skin tone",
        "\uD83D\uDC76\uD83C\uDFFB",
        "1F476 1F3FC                                ; fully-qualified     # 👶🏼 E2.0 baby: medium-light skin tone",
        "\uD83D\uDC76\uD83C\uDFFC",
        "1F476 1F3FD                                ; fully-qualified     # 👶🏽 E2.0 baby: medium skin tone",
        "\uD83D\uDC76\uD83C\uDFFD",
        "1F476 1F3FE                                ; fully-qualified     # 👶🏾 E2.0 baby: medium-dark skin tone",
        "\uD83D\uDC76\uD83C\uDFFE",
        "1F476 1F3FF                                ; fully-qualified     # 👶🏿 E2.0 baby: dark skin tone",
        "\uD83D\uDC76\uD83C\uDFFF",
        "1F9D2                                      ; fully-qualified     # 🧒 E5.0 child",
        "\uD83E\uDDD2",
        "1F9D2 1F3FB                                ; fully-qualified     # 🧒🏻 E5.0 child: light skin tone",
        "\uD83E\uDDD2\uD83C\uDFFB",
        "1F9D2 1F3FC                                ; fully-qualified     # 🧒🏼 E5.0 child: medium-light skin tone",
        "\uD83E\uDDD2\uD83C\uDFFC",
        "1F9D2 1F3FD                                ; fully-qualified     # 🧒🏽 E5.0 child: medium skin tone",
        "\uD83E\uDDD2\uD83C\uDFFD",
        "1F9D2 1F3FE                                ; fully-qualified     # 🧒🏾 E5.0 child: medium-dark skin tone",
        "\uD83E\uDDD2\uD83C\uDFFE",
        "1F9D2 1F3FF                                ; fully-qualified     # 🧒🏿 E5.0 child: dark skin tone",
        "\uD83E\uDDD2\uD83C\uDFFF",
        "1F466                                      ; fully-qualified     # 👦 E2.0 boy",
        "\uD83D\uDC66",
        "1F466 1F3FB                                ; fully-qualified     # 👦🏻 E2.0 boy: light skin tone",
        "\uD83D\uDC66\uD83C\uDFFB",
        "1F466 1F3FC                                ; fully-qualified     # 👦🏼 E2.0 boy: medium-light skin tone",
        "\uD83D\uDC66\uD83C\uDFFC",
        "1F466 1F3FD                                ; fully-qualified     # 👦🏽 E2.0 boy: medium skin tone",
        "\uD83D\uDC66\uD83C\uDFFD",
        "1F466 1F3FE                                ; fully-qualified     # 👦🏾 E2.0 boy: medium-dark skin tone",
        "\uD83D\uDC66\uD83C\uDFFE",
        "1F466 1F3FF                                ; fully-qualified     # 👦🏿 E2.0 boy: dark skin tone",
        "\uD83D\uDC66\uD83C\uDFFF",
        "1F467                                      ; fully-qualified     # 👧 E2.0 girl",
        "\uD83D\uDC67",
        "1F467 1F3FB                                ; fully-qualified     # 👧🏻 E2.0 girl: light skin tone",
        "\uD83D\uDC67\uD83C\uDFFB",
        "1F467 1F3FC                                ; fully-qualified     # 👧🏼 E2.0 girl: medium-light skin tone",
        "\uD83D\uDC67\uD83C\uDFFC",
        "1F467 1F3FD                                ; fully-qualified     # 👧🏽 E2.0 girl: medium skin tone",
        "\uD83D\uDC67\uD83C\uDFFD",
        "1F467 1F3FE                                ; fully-qualified     # 👧🏾 E2.0 girl: medium-dark skin tone",
        "\uD83D\uDC67\uD83C\uDFFE",
        "1F467 1F3FF                                ; fully-qualified     # 👧🏿 E2.0 girl: dark skin tone",
        "\uD83D\uDC67\uD83C\uDFFF",
        "1F9D1                                      ; fully-qualified     # 🧑 E5.0 person",
        "\uD83E\uDDD1",
        "1F9D1 1F3FB                                ; fully-qualified     # 🧑🏻 E5.0 person: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FC                                ; fully-qualified     # 🧑🏼 E5.0 person: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FD                                ; fully-qualified     # 🧑🏽 E5.0 person: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FE                                ; fully-qualified     # 🧑🏾 E5.0 person: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FF                                ; fully-qualified     # 🧑🏿 E5.0 person: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF",
        "1F471                                      ; fully-qualified     # 👱 E2.0 person: blond hair",
        "\uD83D\uDC71",
        "1F471 1F3FB                                ; fully-qualified     # 👱🏻 E2.0 person: light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFB",
        "1F471 1F3FC                                ; fully-qualified     # 👱🏼 E2.0 person: medium-light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFC",
        "1F471 1F3FD                                ; fully-qualified     # 👱🏽 E2.0 person: medium skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFD",
        "1F471 1F3FE                                ; fully-qualified     # 👱🏾 E2.0 person: medium-dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFE",
        "1F471 1F3FF                                ; fully-qualified     # 👱🏿 E2.0 person: dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFF",
        "1F468                                      ; fully-qualified     # 👨 E2.0 man",
        "\uD83D\uDC68",
        "1F468 1F3FB                                ; fully-qualified     # 👨🏻 E2.0 man: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB",
        "1F468 1F3FC                                ; fully-qualified     # 👨🏼 E2.0 man: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC",
        "1F468 1F3FD                                ; fully-qualified     # 👨🏽 E2.0 man: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD",
        "1F468 1F3FE                                ; fully-qualified     # 👨🏾 E2.0 man: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE",
        "1F468 1F3FF                                ; fully-qualified     # 👨🏿 E2.0 man: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF",
        "1F9D4                                      ; fully-qualified     # 🧔 E5.0 man: beard",
        "\uD83E\uDDD4",
        "1F9D4 1F3FB                                ; fully-qualified     # 🧔🏻 E5.0 man: light skin tone, beard",
        "\uD83E\uDDD4\uD83C\uDFFB",
        "1F9D4 1F3FC                                ; fully-qualified     # 🧔🏼 E5.0 man: medium-light skin tone, beard",
        "\uD83E\uDDD4\uD83C\uDFFC",
        "1F9D4 1F3FD                                ; fully-qualified     # 🧔🏽 E5.0 man: medium skin tone, beard",
        "\uD83E\uDDD4\uD83C\uDFFD",
        "1F9D4 1F3FE                                ; fully-qualified     # 🧔🏾 E5.0 man: medium-dark skin tone, beard",
        "\uD83E\uDDD4\uD83C\uDFFE",
        "1F9D4 1F3FF                                ; fully-qualified     # 🧔🏿 E5.0 man: dark skin tone, beard",
        "\uD83E\uDDD4\uD83C\uDFFF",
        "1F468 200D 1F9B0                           ; fully-qualified     # 👨‍🦰 E11.0 man: red hair",
        "\uD83D\uDC68\u200D\uD83E\uDDB0",
        "1F468 1F3FB 200D 1F9B0                     ; fully-qualified     # 👨🏻‍🦰 E11.0 man: light skin tone, red hair",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB0",
        "1F468 1F3FC 200D 1F9B0                     ; fully-qualified     # 👨🏼‍🦰 E11.0 man: medium-light skin tone, red hair",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB0",
        "1F468 1F3FD 200D 1F9B0                     ; fully-qualified     # 👨🏽‍🦰 E11.0 man: medium skin tone, red hair",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB0",
        "1F468 1F3FE 200D 1F9B0                     ; fully-qualified     # 👨🏾‍🦰 E11.0 man: medium-dark skin tone, red hair",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB0",
        "1F468 1F3FF 200D 1F9B0                     ; fully-qualified     # 👨🏿‍🦰 E11.0 man: dark skin tone, red hair",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB0",
        "1F468 200D 1F9B1                           ; fully-qualified     # 👨‍🦱 E11.0 man: curly hair",
        "\uD83D\uDC68\u200D\uD83E\uDDB1",
        "1F468 1F3FB 200D 1F9B1                     ; fully-qualified     # 👨🏻‍🦱 E11.0 man: light skin tone, curly hair",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB1",
        "1F468 1F3FC 200D 1F9B1                     ; fully-qualified     # 👨🏼‍🦱 E11.0 man: medium-light skin tone, curly hair",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB1",
        "1F468 1F3FD 200D 1F9B1                     ; fully-qualified     # 👨🏽‍🦱 E11.0 man: medium skin tone, curly hair",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB1",
        "1F468 1F3FE 200D 1F9B1                     ; fully-qualified     # 👨🏾‍🦱 E11.0 man: medium-dark skin tone, curly hair",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB1",
        "1F468 1F3FF 200D 1F9B1                     ; fully-qualified     # 👨🏿‍🦱 E11.0 man: dark skin tone, curly hair",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB1",
        "1F468 200D 1F9B3                           ; fully-qualified     # 👨‍🦳 E11.0 man: white hair",
        "\uD83D\uDC68\u200D\uD83E\uDDB3",
        "1F468 1F3FB 200D 1F9B3                     ; fully-qualified     # 👨🏻‍🦳 E11.0 man: light skin tone, white hair",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB3",
        "1F468 1F3FC 200D 1F9B3                     ; fully-qualified     # 👨🏼‍🦳 E11.0 man: medium-light skin tone, white hair",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB3",
        "1F468 1F3FD 200D 1F9B3                     ; fully-qualified     # 👨🏽‍🦳 E11.0 man: medium skin tone, white hair",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB3",
        "1F468 1F3FE 200D 1F9B3                     ; fully-qualified     # 👨🏾‍🦳 E11.0 man: medium-dark skin tone, white hair",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB3",
        "1F468 1F3FF 200D 1F9B3                     ; fully-qualified     # 👨🏿‍🦳 E11.0 man: dark skin tone, white hair",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB3",
        "1F468 200D 1F9B2                           ; fully-qualified     # 👨‍🦲 E11.0 man: bald",
        "\uD83D\uDC68\u200D\uD83E\uDDB2",
        "1F468 1F3FB 200D 1F9B2                     ; fully-qualified     # 👨🏻‍🦲 E11.0 man: light skin tone, bald",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDB2",
        "1F468 1F3FC 200D 1F9B2                     ; fully-qualified     # 👨🏼‍🦲 E11.0 man: medium-light skin tone, bald",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDB2",
        "1F468 1F3FD 200D 1F9B2                     ; fully-qualified     # 👨🏽‍🦲 E11.0 man: medium skin tone, bald",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDB2",
        "1F468 1F3FE 200D 1F9B2                     ; fully-qualified     # 👨🏾‍🦲 E11.0 man: medium-dark skin tone, bald",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDB2",
        "1F468 1F3FF 200D 1F9B2                     ; fully-qualified     # 👨🏿‍🦲 E11.0 man: dark skin tone, bald",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDB2",
        "1F469                                      ; fully-qualified     # 👩 E2.0 woman",
        "\uD83D\uDC69",
        "1F469 1F3FB                                ; fully-qualified     # 👩🏻 E2.0 woman: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB",
        "1F469 1F3FC                                ; fully-qualified     # 👩🏼 E2.0 woman: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC",
        "1F469 1F3FD                                ; fully-qualified     # 👩🏽 E2.0 woman: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD",
        "1F469 1F3FE                                ; fully-qualified     # 👩🏾 E2.0 woman: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE",
        "1F469 1F3FF                                ; fully-qualified     # 👩🏿 E2.0 woman: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF",
        "1F469 200D 1F9B0                           ; fully-qualified     # 👩‍🦰 E11.0 woman: red hair",
        "\uD83D\uDC69\u200D\uD83E\uDDB0",
        "1F469 1F3FB 200D 1F9B0                     ; fully-qualified     # 👩🏻‍🦰 E11.0 woman: light skin tone, red hair",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB0",
        "1F469 1F3FC 200D 1F9B0                     ; fully-qualified     # 👩🏼‍🦰 E11.0 woman: medium-light skin tone, red hair",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB0",
        "1F469 1F3FD 200D 1F9B0                     ; fully-qualified     # 👩🏽‍🦰 E11.0 woman: medium skin tone, red hair",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB0",
        "1F469 1F3FE 200D 1F9B0                     ; fully-qualified     # 👩🏾‍🦰 E11.0 woman: medium-dark skin tone, red hair",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB0",
        "1F469 1F3FF 200D 1F9B0                     ; fully-qualified     # 👩🏿‍🦰 E11.0 woman: dark skin tone, red hair",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB0",
        "1F9D1 200D 1F9B0                           ; fully-qualified     # 🧑‍🦰 E12.1 person: red hair",
        "\uD83E\uDDD1\u200D\uD83E\uDDB0",
        "1F9D1 1F3FB 200D 1F9B0                     ; fully-qualified     # 🧑🏻‍🦰 E12.1 person: light skin tone, red hair",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB0",
        "1F9D1 1F3FC 200D 1F9B0                     ; fully-qualified     # 🧑🏼‍🦰 E12.1 person: medium-light skin tone, red hair",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB0",
        "1F9D1 1F3FD 200D 1F9B0                     ; fully-qualified     # 🧑🏽‍🦰 E12.1 person: medium skin tone, red hair",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB0",
        "1F9D1 1F3FE 200D 1F9B0                     ; fully-qualified     # 🧑🏾‍🦰 E12.1 person: medium-dark skin tone, red hair",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB0",
        "1F9D1 1F3FF 200D 1F9B0                     ; fully-qualified     # 🧑🏿‍🦰 E12.1 person: dark skin tone, red hair",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB0",
        "1F469 200D 1F9B1                           ; fully-qualified     # 👩‍🦱 E11.0 woman: curly hair",
        "\uD83D\uDC69\u200D\uD83E\uDDB1",
        "1F469 1F3FB 200D 1F9B1                     ; fully-qualified     # 👩🏻‍🦱 E11.0 woman: light skin tone, curly hair",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB1",
        "1F469 1F3FC 200D 1F9B1                     ; fully-qualified     # 👩🏼‍🦱 E11.0 woman: medium-light skin tone, curly hair",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB1",
        "1F469 1F3FD 200D 1F9B1                     ; fully-qualified     # 👩🏽‍🦱 E11.0 woman: medium skin tone, curly hair",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB1",
        "1F469 1F3FE 200D 1F9B1                     ; fully-qualified     # 👩🏾‍🦱 E11.0 woman: medium-dark skin tone, curly hair",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB1",
        "1F469 1F3FF 200D 1F9B1                     ; fully-qualified     # 👩🏿‍🦱 E11.0 woman: dark skin tone, curly hair",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB1",
        "1F9D1 200D 1F9B1                           ; fully-qualified     # 🧑‍🦱 E12.1 person: curly hair",
        "\uD83E\uDDD1\u200D\uD83E\uDDB1",
        "1F9D1 1F3FB 200D 1F9B1                     ; fully-qualified     # 🧑🏻‍🦱 E12.1 person: light skin tone, curly hair",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB1",
        "1F9D1 1F3FC 200D 1F9B1                     ; fully-qualified     # 🧑🏼‍🦱 E12.1 person: medium-light skin tone, curly hair",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB1",
        "1F9D1 1F3FD 200D 1F9B1                     ; fully-qualified     # 🧑🏽‍🦱 E12.1 person: medium skin tone, curly hair",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB1",
        "1F9D1 1F3FE 200D 1F9B1                     ; fully-qualified     # 🧑🏾‍🦱 E12.1 person: medium-dark skin tone, curly hair",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB1",
        "1F9D1 1F3FF 200D 1F9B1                     ; fully-qualified     # 🧑🏿‍🦱 E12.1 person: dark skin tone, curly hair",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB1",
        "1F469 200D 1F9B3                           ; fully-qualified     # 👩‍🦳 E11.0 woman: white hair",
        "\uD83D\uDC69\u200D\uD83E\uDDB3",
        "1F469 1F3FB 200D 1F9B3                     ; fully-qualified     # 👩🏻‍🦳 E11.0 woman: light skin tone, white hair",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB3",
        "1F469 1F3FC 200D 1F9B3                     ; fully-qualified     # 👩🏼‍🦳 E11.0 woman: medium-light skin tone, white hair",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB3",
        "1F469 1F3FD 200D 1F9B3                     ; fully-qualified     # 👩🏽‍🦳 E11.0 woman: medium skin tone, white hair",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB3",
        "1F469 1F3FE 200D 1F9B3                     ; fully-qualified     # 👩🏾‍🦳 E11.0 woman: medium-dark skin tone, white hair",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB3",
        "1F469 1F3FF 200D 1F9B3                     ; fully-qualified     # 👩🏿‍🦳 E11.0 woman: dark skin tone, white hair",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB3",
        "1F9D1 200D 1F9B3                           ; fully-qualified     # 🧑‍🦳 E12.1 person: white hair",
        "\uD83E\uDDD1\u200D\uD83E\uDDB3",
        "1F9D1 1F3FB 200D 1F9B3                     ; fully-qualified     # 🧑🏻‍🦳 E12.1 person: light skin tone, white hair",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB3",
        "1F9D1 1F3FC 200D 1F9B3                     ; fully-qualified     # 🧑🏼‍🦳 E12.1 person: medium-light skin tone, white hair",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB3",
        "1F9D1 1F3FD 200D 1F9B3                     ; fully-qualified     # 🧑🏽‍🦳 E12.1 person: medium skin tone, white hair",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB3",
        "1F9D1 1F3FE 200D 1F9B3                     ; fully-qualified     # 🧑🏾‍🦳 E12.1 person: medium-dark skin tone, white hair",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB3",
        "1F9D1 1F3FF 200D 1F9B3                     ; fully-qualified     # 🧑🏿‍🦳 E12.1 person: dark skin tone, white hair",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB3",
        "1F469 200D 1F9B2                           ; fully-qualified     # 👩‍🦲 E11.0 woman: bald",
        "\uD83D\uDC69\u200D\uD83E\uDDB2",
        "1F469 1F3FB 200D 1F9B2                     ; fully-qualified     # 👩🏻‍🦲 E11.0 woman: light skin tone, bald",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDB2",
        "1F469 1F3FC 200D 1F9B2                     ; fully-qualified     # 👩🏼‍🦲 E11.0 woman: medium-light skin tone, bald",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDB2",
        "1F469 1F3FD 200D 1F9B2                     ; fully-qualified     # 👩🏽‍🦲 E11.0 woman: medium skin tone, bald",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDB2",
        "1F469 1F3FE 200D 1F9B2                     ; fully-qualified     # 👩🏾‍🦲 E11.0 woman: medium-dark skin tone, bald",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDB2",
        "1F469 1F3FF 200D 1F9B2                     ; fully-qualified     # 👩🏿‍🦲 E11.0 woman: dark skin tone, bald",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDB2",
        "1F9D1 200D 1F9B2                           ; fully-qualified     # 🧑‍🦲 E12.1 person: bald",
        "\uD83E\uDDD1\u200D\uD83E\uDDB2",
        "1F9D1 1F3FB 200D 1F9B2                     ; fully-qualified     # 🧑🏻‍🦲 E12.1 person: light skin tone, bald",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDB2",
        "1F9D1 1F3FC 200D 1F9B2                     ; fully-qualified     # 🧑🏼‍🦲 E12.1 person: medium-light skin tone, bald",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDB2",
        "1F9D1 1F3FD 200D 1F9B2                     ; fully-qualified     # 🧑🏽‍🦲 E12.1 person: medium skin tone, bald",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDB2",
        "1F9D1 1F3FE 200D 1F9B2                     ; fully-qualified     # 🧑🏾‍🦲 E12.1 person: medium-dark skin tone, bald",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDB2",
        "1F9D1 1F3FF 200D 1F9B2                     ; fully-qualified     # 🧑🏿‍🦲 E12.1 person: dark skin tone, bald",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDB2",
        "1F471 200D 2640 FE0F                       ; fully-qualified     # 👱‍♀️ E4.0 woman: blond hair",
        "\uD83D\uDC71\u200D\u2640\uFE0F",
        "1F471 200D 2640                            ; minimally-qualified # 👱‍♀ E4.0 woman: blond hair",
        "\uD83D\uDC71\u200D\u2640",
        "1F471 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👱🏻‍♀️ E4.0 woman: light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F471 1F3FB 200D 2640                      ; minimally-qualified # 👱🏻‍♀ E4.0 woman: light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFB\u200D\u2640",
        "1F471 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👱🏼‍♀️ E4.0 woman: medium-light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F471 1F3FC 200D 2640                      ; minimally-qualified # 👱🏼‍♀ E4.0 woman: medium-light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFC\u200D\u2640",
        "1F471 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👱🏽‍♀️ E4.0 woman: medium skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F471 1F3FD 200D 2640                      ; minimally-qualified # 👱🏽‍♀ E4.0 woman: medium skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFD\u200D\u2640",
        "1F471 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👱🏾‍♀️ E4.0 woman: medium-dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F471 1F3FE 200D 2640                      ; minimally-qualified # 👱🏾‍♀ E4.0 woman: medium-dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFE\u200D\u2640",
        "1F471 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👱🏿‍♀️ E4.0 woman: dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F471 1F3FF 200D 2640                      ; minimally-qualified # 👱🏿‍♀ E4.0 woman: dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFF\u200D\u2640",
        "1F471 200D 2642 FE0F                       ; fully-qualified     # 👱‍♂️ E4.0 man: blond hair",
        "\uD83D\uDC71\u200D\u2642\uFE0F",
        "1F471 200D 2642                            ; minimally-qualified # 👱‍♂ E4.0 man: blond hair",
        "\uD83D\uDC71\u200D\u2642",
        "1F471 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👱🏻‍♂️ E4.0 man: light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F471 1F3FB 200D 2642                      ; minimally-qualified # 👱🏻‍♂ E4.0 man: light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFB\u200D\u2642",
        "1F471 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👱🏼‍♂️ E4.0 man: medium-light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F471 1F3FC 200D 2642                      ; minimally-qualified # 👱🏼‍♂ E4.0 man: medium-light skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFC\u200D\u2642",
        "1F471 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👱🏽‍♂️ E4.0 man: medium skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F471 1F3FD 200D 2642                      ; minimally-qualified # 👱🏽‍♂ E4.0 man: medium skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFD\u200D\u2642",
        "1F471 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👱🏾‍♂️ E4.0 man: medium-dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F471 1F3FE 200D 2642                      ; minimally-qualified # 👱🏾‍♂ E4.0 man: medium-dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFE\u200D\u2642",
        "1F471 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👱🏿‍♂️ E4.0 man: dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F471 1F3FF 200D 2642                      ; minimally-qualified # 👱🏿‍♂ E4.0 man: dark skin tone, blond hair",
        "\uD83D\uDC71\uD83C\uDFFF\u200D\u2642",
        "1F9D3                                      ; fully-qualified     # 🧓 E5.0 older person",
        "\uD83E\uDDD3",
        "1F9D3 1F3FB                                ; fully-qualified     # 🧓🏻 E5.0 older person: light skin tone",
        "\uD83E\uDDD3\uD83C\uDFFB",
        "1F9D3 1F3FC                                ; fully-qualified     # 🧓🏼 E5.0 older person: medium-light skin tone",
        "\uD83E\uDDD3\uD83C\uDFFC",
        "1F9D3 1F3FD                                ; fully-qualified     # 🧓🏽 E5.0 older person: medium skin tone",
        "\uD83E\uDDD3\uD83C\uDFFD",
        "1F9D3 1F3FE                                ; fully-qualified     # 🧓🏾 E5.0 older person: medium-dark skin tone",
        "\uD83E\uDDD3\uD83C\uDFFE",
        "1F9D3 1F3FF                                ; fully-qualified     # 🧓🏿 E5.0 older person: dark skin tone",
        "\uD83E\uDDD3\uD83C\uDFFF",
        "1F474                                      ; fully-qualified     # 👴 E2.0 old man",
        "\uD83D\uDC74",
        "1F474 1F3FB                                ; fully-qualified     # 👴🏻 E2.0 old man: light skin tone",
        "\uD83D\uDC74\uD83C\uDFFB",
        "1F474 1F3FC                                ; fully-qualified     # 👴🏼 E2.0 old man: medium-light skin tone",
        "\uD83D\uDC74\uD83C\uDFFC",
        "1F474 1F3FD                                ; fully-qualified     # 👴🏽 E2.0 old man: medium skin tone",
        "\uD83D\uDC74\uD83C\uDFFD",
        "1F474 1F3FE                                ; fully-qualified     # 👴🏾 E2.0 old man: medium-dark skin tone",
        "\uD83D\uDC74\uD83C\uDFFE",
        "1F474 1F3FF                                ; fully-qualified     # 👴🏿 E2.0 old man: dark skin tone",
        "\uD83D\uDC74\uD83C\uDFFF",
        "1F475                                      ; fully-qualified     # 👵 E2.0 old woman",
        "\uD83D\uDC75",
        "1F475 1F3FB                                ; fully-qualified     # 👵🏻 E2.0 old woman: light skin tone",
        "\uD83D\uDC75\uD83C\uDFFB",
        "1F475 1F3FC                                ; fully-qualified     # 👵🏼 E2.0 old woman: medium-light skin tone",
        "\uD83D\uDC75\uD83C\uDFFC",
        "1F475 1F3FD                                ; fully-qualified     # 👵🏽 E2.0 old woman: medium skin tone",
        "\uD83D\uDC75\uD83C\uDFFD",
        "1F475 1F3FE                                ; fully-qualified     # 👵🏾 E2.0 old woman: medium-dark skin tone",
        "\uD83D\uDC75\uD83C\uDFFE",
        "1F475 1F3FF                                ; fully-qualified     # 👵🏿 E2.0 old woman: dark skin tone",
        "\uD83D\uDC75\uD83C\uDFFF",
        "1F64D                                      ; fully-qualified     # 🙍 E2.0 person frowning",
        "\uD83D\uDE4D",
        "1F64D 1F3FB                                ; fully-qualified     # 🙍🏻 E2.0 person frowning: light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFB",
        "1F64D 1F3FC                                ; fully-qualified     # 🙍🏼 E2.0 person frowning: medium-light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFC",
        "1F64D 1F3FD                                ; fully-qualified     # 🙍🏽 E2.0 person frowning: medium skin tone",
        "\uD83D\uDE4D\uD83C\uDFFD",
        "1F64D 1F3FE                                ; fully-qualified     # 🙍🏾 E2.0 person frowning: medium-dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFE",
        "1F64D 1F3FF                                ; fully-qualified     # 🙍🏿 E2.0 person frowning: dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFF",
        "1F64D 200D 2642 FE0F                       ; fully-qualified     # 🙍‍♂️ E4.0 man frowning",
        "\uD83D\uDE4D\u200D\u2642\uFE0F",
        "1F64D 200D 2642                            ; minimally-qualified # 🙍‍♂ E4.0 man frowning",
        "\uD83D\uDE4D\u200D\u2642",
        "1F64D 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙍🏻‍♂️ E4.0 man frowning: light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F64D 1F3FB 200D 2642                      ; minimally-qualified # 🙍🏻‍♂ E4.0 man frowning: light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2642",
        "1F64D 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙍🏼‍♂️ E4.0 man frowning: medium-light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F64D 1F3FC 200D 2642                      ; minimally-qualified # 🙍🏼‍♂ E4.0 man frowning: medium-light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2642",
        "1F64D 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙍🏽‍♂️ E4.0 man frowning: medium skin tone",
        "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F64D 1F3FD 200D 2642                      ; minimally-qualified # 🙍🏽‍♂ E4.0 man frowning: medium skin tone",
        "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2642",
        "1F64D 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙍🏾‍♂️ E4.0 man frowning: medium-dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F64D 1F3FE 200D 2642                      ; minimally-qualified # 🙍🏾‍♂ E4.0 man frowning: medium-dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2642",
        "1F64D 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙍🏿‍♂️ E4.0 man frowning: dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F64D 1F3FF 200D 2642                      ; minimally-qualified # 🙍🏿‍♂ E4.0 man frowning: dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2642",
        "1F64D 200D 2640 FE0F                       ; fully-qualified     # 🙍‍♀️ E4.0 woman frowning",
        "\uD83D\uDE4D\u200D\u2640\uFE0F",
        "1F64D 200D 2640                            ; minimally-qualified # 🙍‍♀ E4.0 woman frowning",
        "\uD83D\uDE4D\u200D\u2640",
        "1F64D 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙍🏻‍♀️ E4.0 woman frowning: light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F64D 1F3FB 200D 2640                      ; minimally-qualified # 🙍🏻‍♀ E4.0 woman frowning: light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFB\u200D\u2640",
        "1F64D 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙍🏼‍♀️ E4.0 woman frowning: medium-light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F64D 1F3FC 200D 2640                      ; minimally-qualified # 🙍🏼‍♀ E4.0 woman frowning: medium-light skin tone",
        "\uD83D\uDE4D\uD83C\uDFFC\u200D\u2640",
        "1F64D 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙍🏽‍♀️ E4.0 woman frowning: medium skin tone",
        "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F64D 1F3FD 200D 2640                      ; minimally-qualified # 🙍🏽‍♀ E4.0 woman frowning: medium skin tone",
        "\uD83D\uDE4D\uD83C\uDFFD\u200D\u2640",
        "1F64D 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙍🏾‍♀️ E4.0 woman frowning: medium-dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F64D 1F3FE 200D 2640                      ; minimally-qualified # 🙍🏾‍♀ E4.0 woman frowning: medium-dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFE\u200D\u2640",
        "1F64D 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙍🏿‍♀️ E4.0 woman frowning: dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F64D 1F3FF 200D 2640                      ; minimally-qualified # 🙍🏿‍♀ E4.0 woman frowning: dark skin tone",
        "\uD83D\uDE4D\uD83C\uDFFF\u200D\u2640",
        "1F64E                                      ; fully-qualified     # 🙎 E2.0 person pouting",
        "\uD83D\uDE4E",
        "1F64E 1F3FB                                ; fully-qualified     # 🙎🏻 E2.0 person pouting: light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFB",
        "1F64E 1F3FC                                ; fully-qualified     # 🙎🏼 E2.0 person pouting: medium-light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFC",
        "1F64E 1F3FD                                ; fully-qualified     # 🙎🏽 E2.0 person pouting: medium skin tone",
        "\uD83D\uDE4E\uD83C\uDFFD",
        "1F64E 1F3FE                                ; fully-qualified     # 🙎🏾 E2.0 person pouting: medium-dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFE",
        "1F64E 1F3FF                                ; fully-qualified     # 🙎🏿 E2.0 person pouting: dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFF",
        "1F64E 200D 2642 FE0F                       ; fully-qualified     # 🙎‍♂️ E4.0 man pouting",
        "\uD83D\uDE4E\u200D\u2642\uFE0F",
        "1F64E 200D 2642                            ; minimally-qualified # 🙎‍♂ E4.0 man pouting",
        "\uD83D\uDE4E\u200D\u2642",
        "1F64E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙎🏻‍♂️ E4.0 man pouting: light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F64E 1F3FB 200D 2642                      ; minimally-qualified # 🙎🏻‍♂ E4.0 man pouting: light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2642",
        "1F64E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙎🏼‍♂️ E4.0 man pouting: medium-light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F64E 1F3FC 200D 2642                      ; minimally-qualified # 🙎🏼‍♂ E4.0 man pouting: medium-light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2642",
        "1F64E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙎🏽‍♂️ E4.0 man pouting: medium skin tone",
        "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F64E 1F3FD 200D 2642                      ; minimally-qualified # 🙎🏽‍♂ E4.0 man pouting: medium skin tone",
        "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2642",
        "1F64E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙎🏾‍♂️ E4.0 man pouting: medium-dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F64E 1F3FE 200D 2642                      ; minimally-qualified # 🙎🏾‍♂ E4.0 man pouting: medium-dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2642",
        "1F64E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙎🏿‍♂️ E4.0 man pouting: dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F64E 1F3FF 200D 2642                      ; minimally-qualified # 🙎🏿‍♂ E4.0 man pouting: dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2642",
        "1F64E 200D 2640 FE0F                       ; fully-qualified     # 🙎‍♀️ E4.0 woman pouting",
        "\uD83D\uDE4E\u200D\u2640\uFE0F",
        "1F64E 200D 2640                            ; minimally-qualified # 🙎‍♀ E4.0 woman pouting",
        "\uD83D\uDE4E\u200D\u2640",
        "1F64E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙎🏻‍♀️ E4.0 woman pouting: light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F64E 1F3FB 200D 2640                      ; minimally-qualified # 🙎🏻‍♀ E4.0 woman pouting: light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFB\u200D\u2640",
        "1F64E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙎🏼‍♀️ E4.0 woman pouting: medium-light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F64E 1F3FC 200D 2640                      ; minimally-qualified # 🙎🏼‍♀ E4.0 woman pouting: medium-light skin tone",
        "\uD83D\uDE4E\uD83C\uDFFC\u200D\u2640",
        "1F64E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙎🏽‍♀️ E4.0 woman pouting: medium skin tone",
        "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F64E 1F3FD 200D 2640                      ; minimally-qualified # 🙎🏽‍♀ E4.0 woman pouting: medium skin tone",
        "\uD83D\uDE4E\uD83C\uDFFD\u200D\u2640",
        "1F64E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙎🏾‍♀️ E4.0 woman pouting: medium-dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F64E 1F3FE 200D 2640                      ; minimally-qualified # 🙎🏾‍♀ E4.0 woman pouting: medium-dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFE\u200D\u2640",
        "1F64E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙎🏿‍♀️ E4.0 woman pouting: dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F64E 1F3FF 200D 2640                      ; minimally-qualified # 🙎🏿‍♀ E4.0 woman pouting: dark skin tone",
        "\uD83D\uDE4E\uD83C\uDFFF\u200D\u2640",
        "1F645                                      ; fully-qualified     # 🙅 E2.0 person gesturing NO",
        "\uD83D\uDE45",
        "1F645 1F3FB                                ; fully-qualified     # 🙅🏻 E2.0 person gesturing NO: light skin tone",
        "\uD83D\uDE45\uD83C\uDFFB",
        "1F645 1F3FC                                ; fully-qualified     # 🙅🏼 E2.0 person gesturing NO: medium-light skin tone",
        "\uD83D\uDE45\uD83C\uDFFC",
        "1F645 1F3FD                                ; fully-qualified     # 🙅🏽 E2.0 person gesturing NO: medium skin tone",
        "\uD83D\uDE45\uD83C\uDFFD",
        "1F645 1F3FE                                ; fully-qualified     # 🙅🏾 E2.0 person gesturing NO: medium-dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFE",
        "1F645 1F3FF                                ; fully-qualified     # 🙅🏿 E2.0 person gesturing NO: dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFF",
        "1F645 200D 2642 FE0F                       ; fully-qualified     # 🙅‍♂️ E4.0 man gesturing NO",
        "\uD83D\uDE45\u200D\u2642\uFE0F",
        "1F645 200D 2642                            ; minimally-qualified # 🙅‍♂ E4.0 man gesturing NO",
        "\uD83D\uDE45\u200D\u2642",
        "1F645 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙅🏻‍♂️ E4.0 man gesturing NO: light skin tone",
        "\uD83D\uDE45\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F645 1F3FB 200D 2642                      ; minimally-qualified # 🙅🏻‍♂ E4.0 man gesturing NO: light skin tone",
        "\uD83D\uDE45\uD83C\uDFFB\u200D\u2642",
        "1F645 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙅🏼‍♂️ E4.0 man gesturing NO: medium-light skin tone",
        "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F645 1F3FC 200D 2642                      ; minimally-qualified # 🙅🏼‍♂ E4.0 man gesturing NO: medium-light skin tone",
        "\uD83D\uDE45\uD83C\uDFFC\u200D\u2642",
        "1F645 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙅🏽‍♂️ E4.0 man gesturing NO: medium skin tone",
        "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F645 1F3FD 200D 2642                      ; minimally-qualified # 🙅🏽‍♂ E4.0 man gesturing NO: medium skin tone",
        "\uD83D\uDE45\uD83C\uDFFD\u200D\u2642",
        "1F645 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙅🏾‍♂️ E4.0 man gesturing NO: medium-dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F645 1F3FE 200D 2642                      ; minimally-qualified # 🙅🏾‍♂ E4.0 man gesturing NO: medium-dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFE\u200D\u2642",
        "1F645 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙅🏿‍♂️ E4.0 man gesturing NO: dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F645 1F3FF 200D 2642                      ; minimally-qualified # 🙅🏿‍♂ E4.0 man gesturing NO: dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFF\u200D\u2642",
        "1F645 200D 2640 FE0F                       ; fully-qualified     # 🙅‍♀️ E4.0 woman gesturing NO",
        "\uD83D\uDE45\u200D\u2640\uFE0F",
        "1F645 200D 2640                            ; minimally-qualified # 🙅‍♀ E4.0 woman gesturing NO",
        "\uD83D\uDE45\u200D\u2640",
        "1F645 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙅🏻‍♀️ E4.0 woman gesturing NO: light skin tone",
        "\uD83D\uDE45\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F645 1F3FB 200D 2640                      ; minimally-qualified # 🙅🏻‍♀ E4.0 woman gesturing NO: light skin tone",
        "\uD83D\uDE45\uD83C\uDFFB\u200D\u2640",
        "1F645 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙅🏼‍♀️ E4.0 woman gesturing NO: medium-light skin tone",
        "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F645 1F3FC 200D 2640                      ; minimally-qualified # 🙅🏼‍♀ E4.0 woman gesturing NO: medium-light skin tone",
        "\uD83D\uDE45\uD83C\uDFFC\u200D\u2640",
        "1F645 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙅🏽‍♀️ E4.0 woman gesturing NO: medium skin tone",
        "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F645 1F3FD 200D 2640                      ; minimally-qualified # 🙅🏽‍♀ E4.0 woman gesturing NO: medium skin tone",
        "\uD83D\uDE45\uD83C\uDFFD\u200D\u2640",
        "1F645 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙅🏾‍♀️ E4.0 woman gesturing NO: medium-dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F645 1F3FE 200D 2640                      ; minimally-qualified # 🙅🏾‍♀ E4.0 woman gesturing NO: medium-dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFE\u200D\u2640",
        "1F645 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙅🏿‍♀️ E4.0 woman gesturing NO: dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F645 1F3FF 200D 2640                      ; minimally-qualified # 🙅🏿‍♀ E4.0 woman gesturing NO: dark skin tone",
        "\uD83D\uDE45\uD83C\uDFFF\u200D\u2640",
        "1F646                                      ; fully-qualified     # 🙆 E2.0 person gesturing OK",
        "\uD83D\uDE46",
        "1F646 1F3FB                                ; fully-qualified     # 🙆🏻 E2.0 person gesturing OK: light skin tone",
        "\uD83D\uDE46\uD83C\uDFFB",
        "1F646 1F3FC                                ; fully-qualified     # 🙆🏼 E2.0 person gesturing OK: medium-light skin tone",
        "\uD83D\uDE46\uD83C\uDFFC",
        "1F646 1F3FD                                ; fully-qualified     # 🙆🏽 E2.0 person gesturing OK: medium skin tone",
        "\uD83D\uDE46\uD83C\uDFFD",
        "1F646 1F3FE                                ; fully-qualified     # 🙆🏾 E2.0 person gesturing OK: medium-dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFE",
        "1F646 1F3FF                                ; fully-qualified     # 🙆🏿 E2.0 person gesturing OK: dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFF",
        "1F646 200D 2642 FE0F                       ; fully-qualified     # 🙆‍♂️ E4.0 man gesturing OK",
        "\uD83D\uDE46\u200D\u2642\uFE0F",
        "1F646 200D 2642                            ; minimally-qualified # 🙆‍♂ E4.0 man gesturing OK",
        "\uD83D\uDE46\u200D\u2642",
        "1F646 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙆🏻‍♂️ E4.0 man gesturing OK: light skin tone",
        "\uD83D\uDE46\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F646 1F3FB 200D 2642                      ; minimally-qualified # 🙆🏻‍♂ E4.0 man gesturing OK: light skin tone",
        "\uD83D\uDE46\uD83C\uDFFB\u200D\u2642",
        "1F646 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙆🏼‍♂️ E4.0 man gesturing OK: medium-light skin tone",
        "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F646 1F3FC 200D 2642                      ; minimally-qualified # 🙆🏼‍♂ E4.0 man gesturing OK: medium-light skin tone",
        "\uD83D\uDE46\uD83C\uDFFC\u200D\u2642",
        "1F646 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙆🏽‍♂️ E4.0 man gesturing OK: medium skin tone",
        "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F646 1F3FD 200D 2642                      ; minimally-qualified # 🙆🏽‍♂ E4.0 man gesturing OK: medium skin tone",
        "\uD83D\uDE46\uD83C\uDFFD\u200D\u2642",
        "1F646 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙆🏾‍♂️ E4.0 man gesturing OK: medium-dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F646 1F3FE 200D 2642                      ; minimally-qualified # 🙆🏾‍♂ E4.0 man gesturing OK: medium-dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFE\u200D\u2642",
        "1F646 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙆🏿‍♂️ E4.0 man gesturing OK: dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F646 1F3FF 200D 2642                      ; minimally-qualified # 🙆🏿‍♂ E4.0 man gesturing OK: dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFF\u200D\u2642",
        "1F646 200D 2640 FE0F                       ; fully-qualified     # 🙆‍♀️ E4.0 woman gesturing OK",
        "\uD83D\uDE46\u200D\u2640\uFE0F",
        "1F646 200D 2640                            ; minimally-qualified # 🙆‍♀ E4.0 woman gesturing OK",
        "\uD83D\uDE46\u200D\u2640",
        "1F646 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙆🏻‍♀️ E4.0 woman gesturing OK: light skin tone",
        "\uD83D\uDE46\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F646 1F3FB 200D 2640                      ; minimally-qualified # 🙆🏻‍♀ E4.0 woman gesturing OK: light skin tone",
        "\uD83D\uDE46\uD83C\uDFFB\u200D\u2640",
        "1F646 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙆🏼‍♀️ E4.0 woman gesturing OK: medium-light skin tone",
        "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F646 1F3FC 200D 2640                      ; minimally-qualified # 🙆🏼‍♀ E4.0 woman gesturing OK: medium-light skin tone",
        "\uD83D\uDE46\uD83C\uDFFC\u200D\u2640",
        "1F646 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙆🏽‍♀️ E4.0 woman gesturing OK: medium skin tone",
        "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F646 1F3FD 200D 2640                      ; minimally-qualified # 🙆🏽‍♀ E4.0 woman gesturing OK: medium skin tone",
        "\uD83D\uDE46\uD83C\uDFFD\u200D\u2640",
        "1F646 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙆🏾‍♀️ E4.0 woman gesturing OK: medium-dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F646 1F3FE 200D 2640                      ; minimally-qualified # 🙆🏾‍♀ E4.0 woman gesturing OK: medium-dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFE\u200D\u2640",
        "1F646 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙆🏿‍♀️ E4.0 woman gesturing OK: dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F646 1F3FF 200D 2640                      ; minimally-qualified # 🙆🏿‍♀ E4.0 woman gesturing OK: dark skin tone",
        "\uD83D\uDE46\uD83C\uDFFF\u200D\u2640",
        "1F481                                      ; fully-qualified     # 💁 E2.0 person tipping hand",
        "\uD83D\uDC81",
        "1F481 1F3FB                                ; fully-qualified     # 💁🏻 E2.0 person tipping hand: light skin tone",
        "\uD83D\uDC81\uD83C\uDFFB",
        "1F481 1F3FC                                ; fully-qualified     # 💁🏼 E2.0 person tipping hand: medium-light skin tone",
        "\uD83D\uDC81\uD83C\uDFFC",
        "1F481 1F3FD                                ; fully-qualified     # 💁🏽 E2.0 person tipping hand: medium skin tone",
        "\uD83D\uDC81\uD83C\uDFFD",
        "1F481 1F3FE                                ; fully-qualified     # 💁🏾 E2.0 person tipping hand: medium-dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFE",
        "1F481 1F3FF                                ; fully-qualified     # 💁🏿 E2.0 person tipping hand: dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFF",
        "1F481 200D 2642 FE0F                       ; fully-qualified     # 💁‍♂️ E4.0 man tipping hand",
        "\uD83D\uDC81\u200D\u2642\uFE0F",
        "1F481 200D 2642                            ; minimally-qualified # 💁‍♂ E4.0 man tipping hand",
        "\uD83D\uDC81\u200D\u2642",
        "1F481 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💁🏻‍♂️ E4.0 man tipping hand: light skin tone",
        "\uD83D\uDC81\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F481 1F3FB 200D 2642                      ; minimally-qualified # 💁🏻‍♂ E4.0 man tipping hand: light skin tone",
        "\uD83D\uDC81\uD83C\uDFFB\u200D\u2642",
        "1F481 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💁🏼‍♂️ E4.0 man tipping hand: medium-light skin tone",
        "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F481 1F3FC 200D 2642                      ; minimally-qualified # 💁🏼‍♂ E4.0 man tipping hand: medium-light skin tone",
        "\uD83D\uDC81\uD83C\uDFFC\u200D\u2642",
        "1F481 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💁🏽‍♂️ E4.0 man tipping hand: medium skin tone",
        "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F481 1F3FD 200D 2642                      ; minimally-qualified # 💁🏽‍♂ E4.0 man tipping hand: medium skin tone",
        "\uD83D\uDC81\uD83C\uDFFD\u200D\u2642",
        "1F481 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💁🏾‍♂️ E4.0 man tipping hand: medium-dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F481 1F3FE 200D 2642                      ; minimally-qualified # 💁🏾‍♂ E4.0 man tipping hand: medium-dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFE\u200D\u2642",
        "1F481 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💁🏿‍♂️ E4.0 man tipping hand: dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F481 1F3FF 200D 2642                      ; minimally-qualified # 💁🏿‍♂ E4.0 man tipping hand: dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFF\u200D\u2642",
        "1F481 200D 2640 FE0F                       ; fully-qualified     # 💁‍♀️ E4.0 woman tipping hand",
        "\uD83D\uDC81\u200D\u2640\uFE0F",
        "1F481 200D 2640                            ; minimally-qualified # 💁‍♀ E4.0 woman tipping hand",
        "\uD83D\uDC81\u200D\u2640",
        "1F481 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💁🏻‍♀️ E4.0 woman tipping hand: light skin tone",
        "\uD83D\uDC81\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F481 1F3FB 200D 2640                      ; minimally-qualified # 💁🏻‍♀ E4.0 woman tipping hand: light skin tone",
        "\uD83D\uDC81\uD83C\uDFFB\u200D\u2640",
        "1F481 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💁🏼‍♀️ E4.0 woman tipping hand: medium-light skin tone",
        "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F481 1F3FC 200D 2640                      ; minimally-qualified # 💁🏼‍♀ E4.0 woman tipping hand: medium-light skin tone",
        "\uD83D\uDC81\uD83C\uDFFC\u200D\u2640",
        "1F481 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💁🏽‍♀️ E4.0 woman tipping hand: medium skin tone",
        "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F481 1F3FD 200D 2640                      ; minimally-qualified # 💁🏽‍♀ E4.0 woman tipping hand: medium skin tone",
        "\uD83D\uDC81\uD83C\uDFFD\u200D\u2640",
        "1F481 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💁🏾‍♀️ E4.0 woman tipping hand: medium-dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F481 1F3FE 200D 2640                      ; minimally-qualified # 💁🏾‍♀ E4.0 woman tipping hand: medium-dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFE\u200D\u2640",
        "1F481 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💁🏿‍♀️ E4.0 woman tipping hand: dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F481 1F3FF 200D 2640                      ; minimally-qualified # 💁🏿‍♀ E4.0 woman tipping hand: dark skin tone",
        "\uD83D\uDC81\uD83C\uDFFF\u200D\u2640",
        "1F64B                                      ; fully-qualified     # 🙋 E2.0 person raising hand",
        "\uD83D\uDE4B",
        "1F64B 1F3FB                                ; fully-qualified     # 🙋🏻 E2.0 person raising hand: light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFB",
        "1F64B 1F3FC                                ; fully-qualified     # 🙋🏼 E2.0 person raising hand: medium-light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFC",
        "1F64B 1F3FD                                ; fully-qualified     # 🙋🏽 E2.0 person raising hand: medium skin tone",
        "\uD83D\uDE4B\uD83C\uDFFD",
        "1F64B 1F3FE                                ; fully-qualified     # 🙋🏾 E2.0 person raising hand: medium-dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFE",
        "1F64B 1F3FF                                ; fully-qualified     # 🙋🏿 E2.0 person raising hand: dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFF",
        "1F64B 200D 2642 FE0F                       ; fully-qualified     # 🙋‍♂️ E4.0 man raising hand",
        "\uD83D\uDE4B\u200D\u2642\uFE0F",
        "1F64B 200D 2642                            ; minimally-qualified # 🙋‍♂ E4.0 man raising hand",
        "\uD83D\uDE4B\u200D\u2642",
        "1F64B 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙋🏻‍♂️ E4.0 man raising hand: light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F64B 1F3FB 200D 2642                      ; minimally-qualified # 🙋🏻‍♂ E4.0 man raising hand: light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2642",
        "1F64B 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙋🏼‍♂️ E4.0 man raising hand: medium-light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F64B 1F3FC 200D 2642                      ; minimally-qualified # 🙋🏼‍♂ E4.0 man raising hand: medium-light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2642",
        "1F64B 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙋🏽‍♂️ E4.0 man raising hand: medium skin tone",
        "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F64B 1F3FD 200D 2642                      ; minimally-qualified # 🙋🏽‍♂ E4.0 man raising hand: medium skin tone",
        "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2642",
        "1F64B 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙋🏾‍♂️ E4.0 man raising hand: medium-dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F64B 1F3FE 200D 2642                      ; minimally-qualified # 🙋🏾‍♂ E4.0 man raising hand: medium-dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2642",
        "1F64B 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙋🏿‍♂️ E4.0 man raising hand: dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F64B 1F3FF 200D 2642                      ; minimally-qualified # 🙋🏿‍♂ E4.0 man raising hand: dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2642",
        "1F64B 200D 2640 FE0F                       ; fully-qualified     # 🙋‍♀️ E4.0 woman raising hand",
        "\uD83D\uDE4B\u200D\u2640\uFE0F",
        "1F64B 200D 2640                            ; minimally-qualified # 🙋‍♀ E4.0 woman raising hand",
        "\uD83D\uDE4B\u200D\u2640",
        "1F64B 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙋🏻‍♀️ E4.0 woman raising hand: light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F64B 1F3FB 200D 2640                      ; minimally-qualified # 🙋🏻‍♀ E4.0 woman raising hand: light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFB\u200D\u2640",
        "1F64B 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙋🏼‍♀️ E4.0 woman raising hand: medium-light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F64B 1F3FC 200D 2640                      ; minimally-qualified # 🙋🏼‍♀ E4.0 woman raising hand: medium-light skin tone",
        "\uD83D\uDE4B\uD83C\uDFFC\u200D\u2640",
        "1F64B 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙋🏽‍♀️ E4.0 woman raising hand: medium skin tone",
        "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F64B 1F3FD 200D 2640                      ; minimally-qualified # 🙋🏽‍♀ E4.0 woman raising hand: medium skin tone",
        "\uD83D\uDE4B\uD83C\uDFFD\u200D\u2640",
        "1F64B 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙋🏾‍♀️ E4.0 woman raising hand: medium-dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F64B 1F3FE 200D 2640                      ; minimally-qualified # 🙋🏾‍♀ E4.0 woman raising hand: medium-dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFE\u200D\u2640",
        "1F64B 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙋🏿‍♀️ E4.0 woman raising hand: dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F64B 1F3FF 200D 2640                      ; minimally-qualified # 🙋🏿‍♀ E4.0 woman raising hand: dark skin tone",
        "\uD83D\uDE4B\uD83C\uDFFF\u200D\u2640",
        "1F9CF                                      ; fully-qualified     # 🧏 E12.1 deaf person",
        "\uD83E\uDDCF",
        "1F9CF 1F3FB                                ; fully-qualified     # 🧏🏻 E12.1 deaf person: light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFB",
        "1F9CF 1F3FC                                ; fully-qualified     # 🧏🏼 E12.1 deaf person: medium-light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFC",
        "1F9CF 1F3FD                                ; fully-qualified     # 🧏🏽 E12.1 deaf person: medium skin tone",
        "\uD83E\uDDCF\uD83C\uDFFD",
        "1F9CF 1F3FE                                ; fully-qualified     # 🧏🏾 E12.1 deaf person: medium-dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFE",
        "1F9CF 1F3FF                                ; fully-qualified     # 🧏🏿 E12.1 deaf person: dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFF",
        "1F9CF 200D 2642 FE0F                       ; fully-qualified     # 🧏‍♂️ E12.1 deaf man",
        "\uD83E\uDDCF\u200D\u2642\uFE0F",
        "1F9CF 200D 2642                            ; minimally-qualified # 🧏‍♂ E12.1 deaf man",
        "\uD83E\uDDCF\u200D\u2642",
        "1F9CF 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧏🏻‍♂️ E12.1 deaf man: light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9CF 1F3FB 200D 2642                      ; minimally-qualified # 🧏🏻‍♂ E12.1 deaf man: light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2642",
        "1F9CF 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧏🏼‍♂️ E12.1 deaf man: medium-light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9CF 1F3FC 200D 2642                      ; minimally-qualified # 🧏🏼‍♂ E12.1 deaf man: medium-light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2642",
        "1F9CF 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧏🏽‍♂️ E12.1 deaf man: medium skin tone",
        "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9CF 1F3FD 200D 2642                      ; minimally-qualified # 🧏🏽‍♂ E12.1 deaf man: medium skin tone",
        "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2642",
        "1F9CF 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧏🏾‍♂️ E12.1 deaf man: medium-dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9CF 1F3FE 200D 2642                      ; minimally-qualified # 🧏🏾‍♂ E12.1 deaf man: medium-dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2642",
        "1F9CF 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧏🏿‍♂️ E12.1 deaf man: dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9CF 1F3FF 200D 2642                      ; minimally-qualified # 🧏🏿‍♂ E12.1 deaf man: dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2642",
        "1F9CF 200D 2640 FE0F                       ; fully-qualified     # 🧏‍♀️ E12.1 deaf woman",
        "\uD83E\uDDCF\u200D\u2640\uFE0F",
        "1F9CF 200D 2640                            ; minimally-qualified # 🧏‍♀ E12.1 deaf woman",
        "\uD83E\uDDCF\u200D\u2640",
        "1F9CF 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧏🏻‍♀️ E12.1 deaf woman: light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9CF 1F3FB 200D 2640                      ; minimally-qualified # 🧏🏻‍♀ E12.1 deaf woman: light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFB\u200D\u2640",
        "1F9CF 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧏🏼‍♀️ E12.1 deaf woman: medium-light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9CF 1F3FC 200D 2640                      ; minimally-qualified # 🧏🏼‍♀ E12.1 deaf woman: medium-light skin tone",
        "\uD83E\uDDCF\uD83C\uDFFC\u200D\u2640",
        "1F9CF 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧏🏽‍♀️ E12.1 deaf woman: medium skin tone",
        "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9CF 1F3FD 200D 2640                      ; minimally-qualified # 🧏🏽‍♀ E12.1 deaf woman: medium skin tone",
        "\uD83E\uDDCF\uD83C\uDFFD\u200D\u2640",
        "1F9CF 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧏🏾‍♀️ E12.1 deaf woman: medium-dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9CF 1F3FE 200D 2640                      ; minimally-qualified # 🧏🏾‍♀ E12.1 deaf woman: medium-dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFE\u200D\u2640",
        "1F9CF 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧏🏿‍♀️ E12.1 deaf woman: dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9CF 1F3FF 200D 2640                      ; minimally-qualified # 🧏🏿‍♀ E12.1 deaf woman: dark skin tone",
        "\uD83E\uDDCF\uD83C\uDFFF\u200D\u2640",
        "1F647                                      ; fully-qualified     # 🙇 E2.0 person bowing",
        "\uD83D\uDE47",
        "1F647 1F3FB                                ; fully-qualified     # 🙇🏻 E2.0 person bowing: light skin tone",
        "\uD83D\uDE47\uD83C\uDFFB",
        "1F647 1F3FC                                ; fully-qualified     # 🙇🏼 E2.0 person bowing: medium-light skin tone",
        "\uD83D\uDE47\uD83C\uDFFC",
        "1F647 1F3FD                                ; fully-qualified     # 🙇🏽 E2.0 person bowing: medium skin tone",
        "\uD83D\uDE47\uD83C\uDFFD",
        "1F647 1F3FE                                ; fully-qualified     # 🙇🏾 E2.0 person bowing: medium-dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFE",
        "1F647 1F3FF                                ; fully-qualified     # 🙇🏿 E2.0 person bowing: dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFF",
        "1F647 200D 2642 FE0F                       ; fully-qualified     # 🙇‍♂️ E4.0 man bowing",
        "\uD83D\uDE47\u200D\u2642\uFE0F",
        "1F647 200D 2642                            ; minimally-qualified # 🙇‍♂ E4.0 man bowing",
        "\uD83D\uDE47\u200D\u2642",
        "1F647 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🙇🏻‍♂️ E4.0 man bowing: light skin tone",
        "\uD83D\uDE47\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F647 1F3FB 200D 2642                      ; minimally-qualified # 🙇🏻‍♂ E4.0 man bowing: light skin tone",
        "\uD83D\uDE47\uD83C\uDFFB\u200D\u2642",
        "1F647 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🙇🏼‍♂️ E4.0 man bowing: medium-light skin tone",
        "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F647 1F3FC 200D 2642                      ; minimally-qualified # 🙇🏼‍♂ E4.0 man bowing: medium-light skin tone",
        "\uD83D\uDE47\uD83C\uDFFC\u200D\u2642",
        "1F647 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🙇🏽‍♂️ E4.0 man bowing: medium skin tone",
        "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F647 1F3FD 200D 2642                      ; minimally-qualified # 🙇🏽‍♂ E4.0 man bowing: medium skin tone",
        "\uD83D\uDE47\uD83C\uDFFD\u200D\u2642",
        "1F647 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🙇🏾‍♂️ E4.0 man bowing: medium-dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F647 1F3FE 200D 2642                      ; minimally-qualified # 🙇🏾‍♂ E4.0 man bowing: medium-dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFE\u200D\u2642",
        "1F647 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🙇🏿‍♂️ E4.0 man bowing: dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F647 1F3FF 200D 2642                      ; minimally-qualified # 🙇🏿‍♂ E4.0 man bowing: dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFF\u200D\u2642",
        "1F647 200D 2640 FE0F                       ; fully-qualified     # 🙇‍♀️ E4.0 woman bowing",
        "\uD83D\uDE47\u200D\u2640\uFE0F",
        "1F647 200D 2640                            ; minimally-qualified # 🙇‍♀ E4.0 woman bowing",
        "\uD83D\uDE47\u200D\u2640",
        "1F647 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🙇🏻‍♀️ E4.0 woman bowing: light skin tone",
        "\uD83D\uDE47\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F647 1F3FB 200D 2640                      ; minimally-qualified # 🙇🏻‍♀ E4.0 woman bowing: light skin tone",
        "\uD83D\uDE47\uD83C\uDFFB\u200D\u2640",
        "1F647 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🙇🏼‍♀️ E4.0 woman bowing: medium-light skin tone",
        "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F647 1F3FC 200D 2640                      ; minimally-qualified # 🙇🏼‍♀ E4.0 woman bowing: medium-light skin tone",
        "\uD83D\uDE47\uD83C\uDFFC\u200D\u2640",
        "1F647 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🙇🏽‍♀️ E4.0 woman bowing: medium skin tone",
        "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F647 1F3FD 200D 2640                      ; minimally-qualified # 🙇🏽‍♀ E4.0 woman bowing: medium skin tone",
        "\uD83D\uDE47\uD83C\uDFFD\u200D\u2640",
        "1F647 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🙇🏾‍♀️ E4.0 woman bowing: medium-dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F647 1F3FE 200D 2640                      ; minimally-qualified # 🙇🏾‍♀ E4.0 woman bowing: medium-dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFE\u200D\u2640",
        "1F647 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🙇🏿‍♀️ E4.0 woman bowing: dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F647 1F3FF 200D 2640                      ; minimally-qualified # 🙇🏿‍♀ E4.0 woman bowing: dark skin tone",
        "\uD83D\uDE47\uD83C\uDFFF\u200D\u2640",
        "1F926                                      ; fully-qualified     # 🤦 E4.0 person facepalming",
        "\uD83E\uDD26",
        "1F926 1F3FB                                ; fully-qualified     # 🤦🏻 E4.0 person facepalming: light skin tone",
        "\uD83E\uDD26\uD83C\uDFFB",
        "1F926 1F3FC                                ; fully-qualified     # 🤦🏼 E4.0 person facepalming: medium-light skin tone",
        "\uD83E\uDD26\uD83C\uDFFC",
        "1F926 1F3FD                                ; fully-qualified     # 🤦🏽 E4.0 person facepalming: medium skin tone",
        "\uD83E\uDD26\uD83C\uDFFD",
        "1F926 1F3FE                                ; fully-qualified     # 🤦🏾 E4.0 person facepalming: medium-dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFE",
        "1F926 1F3FF                                ; fully-qualified     # 🤦🏿 E4.0 person facepalming: dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFF",
        "1F926 200D 2642 FE0F                       ; fully-qualified     # 🤦‍♂️ E4.0 man facepalming",
        "\uD83E\uDD26\u200D\u2642\uFE0F",
        "1F926 200D 2642                            ; minimally-qualified # 🤦‍♂ E4.0 man facepalming",
        "\uD83E\uDD26\u200D\u2642",
        "1F926 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤦🏻‍♂️ E4.0 man facepalming: light skin tone",
        "\uD83E\uDD26\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F926 1F3FB 200D 2642                      ; minimally-qualified # 🤦🏻‍♂ E4.0 man facepalming: light skin tone",
        "\uD83E\uDD26\uD83C\uDFFB\u200D\u2642",
        "1F926 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤦🏼‍♂️ E4.0 man facepalming: medium-light skin tone",
        "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F926 1F3FC 200D 2642                      ; minimally-qualified # 🤦🏼‍♂ E4.0 man facepalming: medium-light skin tone",
        "\uD83E\uDD26\uD83C\uDFFC\u200D\u2642",
        "1F926 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤦🏽‍♂️ E4.0 man facepalming: medium skin tone",
        "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F926 1F3FD 200D 2642                      ; minimally-qualified # 🤦🏽‍♂ E4.0 man facepalming: medium skin tone",
        "\uD83E\uDD26\uD83C\uDFFD\u200D\u2642",
        "1F926 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤦🏾‍♂️ E4.0 man facepalming: medium-dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F926 1F3FE 200D 2642                      ; minimally-qualified # 🤦🏾‍♂ E4.0 man facepalming: medium-dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFE\u200D\u2642",
        "1F926 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤦🏿‍♂️ E4.0 man facepalming: dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F926 1F3FF 200D 2642                      ; minimally-qualified # 🤦🏿‍♂ E4.0 man facepalming: dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFF\u200D\u2642",
        "1F926 200D 2640 FE0F                       ; fully-qualified     # 🤦‍♀️ E4.0 woman facepalming",
        "\uD83E\uDD26\u200D\u2640\uFE0F",
        "1F926 200D 2640                            ; minimally-qualified # 🤦‍♀ E4.0 woman facepalming",
        "\uD83E\uDD26\u200D\u2640",
        "1F926 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤦🏻‍♀️ E4.0 woman facepalming: light skin tone",
        "\uD83E\uDD26\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F926 1F3FB 200D 2640                      ; minimally-qualified # 🤦🏻‍♀ E4.0 woman facepalming: light skin tone",
        "\uD83E\uDD26\uD83C\uDFFB\u200D\u2640",
        "1F926 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤦🏼‍♀️ E4.0 woman facepalming: medium-light skin tone",
        "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F926 1F3FC 200D 2640                      ; minimally-qualified # 🤦🏼‍♀ E4.0 woman facepalming: medium-light skin tone",
        "\uD83E\uDD26\uD83C\uDFFC\u200D\u2640",
        "1F926 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤦🏽‍♀️ E4.0 woman facepalming: medium skin tone",
        "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F926 1F3FD 200D 2640                      ; minimally-qualified # 🤦🏽‍♀ E4.0 woman facepalming: medium skin tone",
        "\uD83E\uDD26\uD83C\uDFFD\u200D\u2640",
        "1F926 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤦🏾‍♀️ E4.0 woman facepalming: medium-dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F926 1F3FE 200D 2640                      ; minimally-qualified # 🤦🏾‍♀ E4.0 woman facepalming: medium-dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFE\u200D\u2640",
        "1F926 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤦🏿‍♀️ E4.0 woman facepalming: dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F926 1F3FF 200D 2640                      ; minimally-qualified # 🤦🏿‍♀ E4.0 woman facepalming: dark skin tone",
        "\uD83E\uDD26\uD83C\uDFFF\u200D\u2640",
        "1F937                                      ; fully-qualified     # 🤷 E4.0 person shrugging",
        "\uD83E\uDD37",
        "1F937 1F3FB                                ; fully-qualified     # 🤷🏻 E4.0 person shrugging: light skin tone",
        "\uD83E\uDD37\uD83C\uDFFB",
        "1F937 1F3FC                                ; fully-qualified     # 🤷🏼 E4.0 person shrugging: medium-light skin tone",
        "\uD83E\uDD37\uD83C\uDFFC",
        "1F937 1F3FD                                ; fully-qualified     # 🤷🏽 E4.0 person shrugging: medium skin tone",
        "\uD83E\uDD37\uD83C\uDFFD",
        "1F937 1F3FE                                ; fully-qualified     # 🤷🏾 E4.0 person shrugging: medium-dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFE",
        "1F937 1F3FF                                ; fully-qualified     # 🤷🏿 E4.0 person shrugging: dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFF",
        "1F937 200D 2642 FE0F                       ; fully-qualified     # 🤷‍♂️ E4.0 man shrugging",
        "\uD83E\uDD37\u200D\u2642\uFE0F",
        "1F937 200D 2642                            ; minimally-qualified # 🤷‍♂ E4.0 man shrugging",
        "\uD83E\uDD37\u200D\u2642",
        "1F937 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤷🏻‍♂️ E4.0 man shrugging: light skin tone",
        "\uD83E\uDD37\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F937 1F3FB 200D 2642                      ; minimally-qualified # 🤷🏻‍♂ E4.0 man shrugging: light skin tone",
        "\uD83E\uDD37\uD83C\uDFFB\u200D\u2642",
        "1F937 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤷🏼‍♂️ E4.0 man shrugging: medium-light skin tone",
        "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F937 1F3FC 200D 2642                      ; minimally-qualified # 🤷🏼‍♂ E4.0 man shrugging: medium-light skin tone",
        "\uD83E\uDD37\uD83C\uDFFC\u200D\u2642",
        "1F937 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤷🏽‍♂️ E4.0 man shrugging: medium skin tone",
        "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F937 1F3FD 200D 2642                      ; minimally-qualified # 🤷🏽‍♂ E4.0 man shrugging: medium skin tone",
        "\uD83E\uDD37\uD83C\uDFFD\u200D\u2642",
        "1F937 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤷🏾‍♂️ E4.0 man shrugging: medium-dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F937 1F3FE 200D 2642                      ; minimally-qualified # 🤷🏾‍♂ E4.0 man shrugging: medium-dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFE\u200D\u2642",
        "1F937 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤷🏿‍♂️ E4.0 man shrugging: dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F937 1F3FF 200D 2642                      ; minimally-qualified # 🤷🏿‍♂ E4.0 man shrugging: dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFF\u200D\u2642",
        "1F937 200D 2640 FE0F                       ; fully-qualified     # 🤷‍♀️ E4.0 woman shrugging",
        "\uD83E\uDD37\u200D\u2640\uFE0F",
        "1F937 200D 2640                            ; minimally-qualified # 🤷‍♀ E4.0 woman shrugging",
        "\uD83E\uDD37\u200D\u2640",
        "1F937 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤷🏻‍♀️ E4.0 woman shrugging: light skin tone",
        "\uD83E\uDD37\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F937 1F3FB 200D 2640                      ; minimally-qualified # 🤷🏻‍♀ E4.0 woman shrugging: light skin tone",
        "\uD83E\uDD37\uD83C\uDFFB\u200D\u2640",
        "1F937 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤷🏼‍♀️ E4.0 woman shrugging: medium-light skin tone",
        "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F937 1F3FC 200D 2640                      ; minimally-qualified # 🤷🏼‍♀ E4.0 woman shrugging: medium-light skin tone",
        "\uD83E\uDD37\uD83C\uDFFC\u200D\u2640",
        "1F937 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤷🏽‍♀️ E4.0 woman shrugging: medium skin tone",
        "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F937 1F3FD 200D 2640                      ; minimally-qualified # 🤷🏽‍♀ E4.0 woman shrugging: medium skin tone",
        "\uD83E\uDD37\uD83C\uDFFD\u200D\u2640",
        "1F937 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤷🏾‍♀️ E4.0 woman shrugging: medium-dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F937 1F3FE 200D 2640                      ; minimally-qualified # 🤷🏾‍♀ E4.0 woman shrugging: medium-dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFE\u200D\u2640",
        "1F937 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤷🏿‍♀️ E4.0 woman shrugging: dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F937 1F3FF 200D 2640                      ; minimally-qualified # 🤷🏿‍♀ E4.0 woman shrugging: dark skin tone",
        "\uD83E\uDD37\uD83C\uDFFF\u200D\u2640",
        "1F9D1 200D 2695 FE0F                       ; fully-qualified     # 🧑‍⚕️ E12.1 health worker",
        "\uD83E\uDDD1\u200D\u2695\uFE0F",
        "1F9D1 200D 2695                            ; minimally-qualified # 🧑‍⚕ E12.1 health worker",
        "\uD83E\uDDD1\u200D\u2695",
        "1F9D1 1F3FB 200D 2695 FE0F                 ; fully-qualified     # 🧑🏻‍⚕️ E12.1 health worker: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2695\uFE0F",
        "1F9D1 1F3FB 200D 2695                      ; minimally-qualified # 🧑🏻‍⚕ E12.1 health worker: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2695",
        "1F9D1 1F3FC 200D 2695 FE0F                 ; fully-qualified     # 🧑🏼‍⚕️ E12.1 health worker: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2695\uFE0F",
        "1F9D1 1F3FC 200D 2695                      ; minimally-qualified # 🧑🏼‍⚕ E12.1 health worker: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2695",
        "1F9D1 1F3FD 200D 2695 FE0F                 ; fully-qualified     # 🧑🏽‍⚕️ E12.1 health worker: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2695\uFE0F",
        "1F9D1 1F3FD 200D 2695                      ; minimally-qualified # 🧑🏽‍⚕ E12.1 health worker: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2695",
        "1F9D1 1F3FE 200D 2695 FE0F                 ; fully-qualified     # 🧑🏾‍⚕️ E12.1 health worker: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2695\uFE0F",
        "1F9D1 1F3FE 200D 2695                      ; minimally-qualified # 🧑🏾‍⚕ E12.1 health worker: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2695",
        "1F9D1 1F3FF 200D 2695 FE0F                 ; fully-qualified     # 🧑🏿‍⚕️ E12.1 health worker: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2695\uFE0F",
        "1F9D1 1F3FF 200D 2695                      ; minimally-qualified # 🧑🏿‍⚕ E12.1 health worker: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2695",
        "1F468 200D 2695 FE0F                       ; fully-qualified     # 👨‍⚕️ E4.0 man health worker",
        "\uD83D\uDC68\u200D\u2695\uFE0F",
        "1F468 200D 2695                            ; minimally-qualified # 👨‍⚕ E4.0 man health worker",
        "\uD83D\uDC68\u200D\u2695",
        "1F468 1F3FB 200D 2695 FE0F                 ; fully-qualified     # 👨🏻‍⚕️ E4.0 man health worker: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2695\uFE0F",
        "1F468 1F3FB 200D 2695                      ; minimally-qualified # 👨🏻‍⚕ E4.0 man health worker: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2695",
        "1F468 1F3FC 200D 2695 FE0F                 ; fully-qualified     # 👨🏼‍⚕️ E4.0 man health worker: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695\uFE0F",
        "1F468 1F3FC 200D 2695                      ; minimally-qualified # 👨🏼‍⚕ E4.0 man health worker: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2695",
        "1F468 1F3FD 200D 2695 FE0F                 ; fully-qualified     # 👨🏽‍⚕️ E4.0 man health worker: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695\uFE0F",
        "1F468 1F3FD 200D 2695                      ; minimally-qualified # 👨🏽‍⚕ E4.0 man health worker: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2695",
        "1F468 1F3FE 200D 2695 FE0F                 ; fully-qualified     # 👨🏾‍⚕️ E4.0 man health worker: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695\uFE0F",
        "1F468 1F3FE 200D 2695                      ; minimally-qualified # 👨🏾‍⚕ E4.0 man health worker: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2695",
        "1F468 1F3FF 200D 2695 FE0F                 ; fully-qualified     # 👨🏿‍⚕️ E4.0 man health worker: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695\uFE0F",
        "1F468 1F3FF 200D 2695                      ; minimally-qualified # 👨🏿‍⚕ E4.0 man health worker: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2695",
        "1F469 200D 2695 FE0F                       ; fully-qualified     # 👩‍⚕️ E4.0 woman health worker",
        "\uD83D\uDC69\u200D\u2695\uFE0F",
        "1F469 200D 2695                            ; minimally-qualified # 👩‍⚕ E4.0 woman health worker",
        "\uD83D\uDC69\u200D\u2695",
        "1F469 1F3FB 200D 2695 FE0F                 ; fully-qualified     # 👩🏻‍⚕️ E4.0 woman health worker: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2695\uFE0F",
        "1F469 1F3FB 200D 2695                      ; minimally-qualified # 👩🏻‍⚕ E4.0 woman health worker: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2695",
        "1F469 1F3FC 200D 2695 FE0F                 ; fully-qualified     # 👩🏼‍⚕️ E4.0 woman health worker: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695\uFE0F",
        "1F469 1F3FC 200D 2695                      ; minimally-qualified # 👩🏼‍⚕ E4.0 woman health worker: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2695",
        "1F469 1F3FD 200D 2695 FE0F                 ; fully-qualified     # 👩🏽‍⚕️ E4.0 woman health worker: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695\uFE0F",
        "1F469 1F3FD 200D 2695                      ; minimally-qualified # 👩🏽‍⚕ E4.0 woman health worker: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2695",
        "1F469 1F3FE 200D 2695 FE0F                 ; fully-qualified     # 👩🏾‍⚕️ E4.0 woman health worker: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695\uFE0F",
        "1F469 1F3FE 200D 2695                      ; minimally-qualified # 👩🏾‍⚕ E4.0 woman health worker: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2695",
        "1F469 1F3FF 200D 2695 FE0F                 ; fully-qualified     # 👩🏿‍⚕️ E4.0 woman health worker: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695\uFE0F",
        "1F469 1F3FF 200D 2695                      ; minimally-qualified # 👩🏿‍⚕ E4.0 woman health worker: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2695",
        "1F9D1 200D 1F393                           ; fully-qualified     # 🧑‍🎓 E12.1 student",
        "\uD83E\uDDD1\u200D\uD83C\uDF93",
        "1F9D1 1F3FB 200D 1F393                     ; fully-qualified     # 🧑🏻‍🎓 E12.1 student: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF93",
        "1F9D1 1F3FC 200D 1F393                     ; fully-qualified     # 🧑🏼‍🎓 E12.1 student: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF93",
        "1F9D1 1F3FD 200D 1F393                     ; fully-qualified     # 🧑🏽‍🎓 E12.1 student: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF93",
        "1F9D1 1F3FE 200D 1F393                     ; fully-qualified     # 🧑🏾‍🎓 E12.1 student: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF93",
        "1F9D1 1F3FF 200D 1F393                     ; fully-qualified     # 🧑🏿‍🎓 E12.1 student: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF93",
        "1F468 200D 1F393                           ; fully-qualified     # 👨‍🎓 E4.0 man student",
        "\uD83D\uDC68\u200D\uD83C\uDF93",
        "1F468 1F3FB 200D 1F393                     ; fully-qualified     # 👨🏻‍🎓 E4.0 man student: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF93",
        "1F468 1F3FC 200D 1F393                     ; fully-qualified     # 👨🏼‍🎓 E4.0 man student: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF93",
        "1F468 1F3FD 200D 1F393                     ; fully-qualified     # 👨🏽‍🎓 E4.0 man student: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF93",
        "1F468 1F3FE 200D 1F393                     ; fully-qualified     # 👨🏾‍🎓 E4.0 man student: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF93",
        "1F468 1F3FF 200D 1F393                     ; fully-qualified     # 👨🏿‍🎓 E4.0 man student: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF93",
        "1F469 200D 1F393                           ; fully-qualified     # 👩‍🎓 E4.0 woman student",
        "\uD83D\uDC69\u200D\uD83C\uDF93",
        "1F469 1F3FB 200D 1F393                     ; fully-qualified     # 👩🏻‍🎓 E4.0 woman student: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF93",
        "1F469 1F3FC 200D 1F393                     ; fully-qualified     # 👩🏼‍🎓 E4.0 woman student: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF93",
        "1F469 1F3FD 200D 1F393                     ; fully-qualified     # 👩🏽‍🎓 E4.0 woman student: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF93",
        "1F469 1F3FE 200D 1F393                     ; fully-qualified     # 👩🏾‍🎓 E4.0 woman student: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF93",
        "1F469 1F3FF 200D 1F393                     ; fully-qualified     # 👩🏿‍🎓 E4.0 woman student: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF93",
        "1F9D1 200D 1F3EB                           ; fully-qualified     # 🧑‍🏫 E12.1 teacher",
        "\uD83E\uDDD1\u200D\uD83C\uDFEB",
        "1F9D1 1F3FB 200D 1F3EB                     ; fully-qualified     # 🧑🏻‍🏫 E12.1 teacher: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFEB",
        "1F9D1 1F3FC 200D 1F3EB                     ; fully-qualified     # 🧑🏼‍🏫 E12.1 teacher: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFEB",
        "1F9D1 1F3FD 200D 1F3EB                     ; fully-qualified     # 🧑🏽‍🏫 E12.1 teacher: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFEB",
        "1F9D1 1F3FE 200D 1F3EB                     ; fully-qualified     # 🧑🏾‍🏫 E12.1 teacher: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFEB",
        "1F9D1 1F3FF 200D 1F3EB                     ; fully-qualified     # 🧑🏿‍🏫 E12.1 teacher: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFEB",
        "1F468 200D 1F3EB                           ; fully-qualified     # 👨‍🏫 E4.0 man teacher",
        "\uD83D\uDC68\u200D\uD83C\uDFEB",
        "1F468 1F3FB 200D 1F3EB                     ; fully-qualified     # 👨🏻‍🏫 E4.0 man teacher: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFEB",
        "1F468 1F3FC 200D 1F3EB                     ; fully-qualified     # 👨🏼‍🏫 E4.0 man teacher: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFEB",
        "1F468 1F3FD 200D 1F3EB                     ; fully-qualified     # 👨🏽‍🏫 E4.0 man teacher: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFEB",
        "1F468 1F3FE 200D 1F3EB                     ; fully-qualified     # 👨🏾‍🏫 E4.0 man teacher: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFEB",
        "1F468 1F3FF 200D 1F3EB                     ; fully-qualified     # 👨🏿‍🏫 E4.0 man teacher: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFEB",
        "1F469 200D 1F3EB                           ; fully-qualified     # 👩‍🏫 E4.0 woman teacher",
        "\uD83D\uDC69\u200D\uD83C\uDFEB",
        "1F469 1F3FB 200D 1F3EB                     ; fully-qualified     # 👩🏻‍🏫 E4.0 woman teacher: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFEB",
        "1F469 1F3FC 200D 1F3EB                     ; fully-qualified     # 👩🏼‍🏫 E4.0 woman teacher: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFEB",
        "1F469 1F3FD 200D 1F3EB                     ; fully-qualified     # 👩🏽‍🏫 E4.0 woman teacher: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFEB",
        "1F469 1F3FE 200D 1F3EB                     ; fully-qualified     # 👩🏾‍🏫 E4.0 woman teacher: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFEB",
        "1F469 1F3FF 200D 1F3EB                     ; fully-qualified     # 👩🏿‍🏫 E4.0 woman teacher: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFEB",
        "1F9D1 200D 2696 FE0F                       ; fully-qualified     # 🧑‍⚖️ E12.1 judge",
        "\uD83E\uDDD1\u200D\u2696\uFE0F",
        "1F9D1 200D 2696                            ; minimally-qualified # 🧑‍⚖ E12.1 judge",
        "\uD83E\uDDD1\u200D\u2696",
        "1F9D1 1F3FB 200D 2696 FE0F                 ; fully-qualified     # 🧑🏻‍⚖️ E12.1 judge: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2696\uFE0F",
        "1F9D1 1F3FB 200D 2696                      ; minimally-qualified # 🧑🏻‍⚖ E12.1 judge: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2696",
        "1F9D1 1F3FC 200D 2696 FE0F                 ; fully-qualified     # 🧑🏼‍⚖️ E12.1 judge: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2696\uFE0F",
        "1F9D1 1F3FC 200D 2696                      ; minimally-qualified # 🧑🏼‍⚖ E12.1 judge: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2696",
        "1F9D1 1F3FD 200D 2696 FE0F                 ; fully-qualified     # 🧑🏽‍⚖️ E12.1 judge: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2696\uFE0F",
        "1F9D1 1F3FD 200D 2696                      ; minimally-qualified # 🧑🏽‍⚖ E12.1 judge: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2696",
        "1F9D1 1F3FE 200D 2696 FE0F                 ; fully-qualified     # 🧑🏾‍⚖️ E12.1 judge: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2696\uFE0F",
        "1F9D1 1F3FE 200D 2696                      ; minimally-qualified # 🧑🏾‍⚖ E12.1 judge: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2696",
        "1F9D1 1F3FF 200D 2696 FE0F                 ; fully-qualified     # 🧑🏿‍⚖️ E12.1 judge: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2696\uFE0F",
        "1F9D1 1F3FF 200D 2696                      ; minimally-qualified # 🧑🏿‍⚖ E12.1 judge: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2696",
        "1F468 200D 2696 FE0F                       ; fully-qualified     # 👨‍⚖️ E4.0 man judge",
        "\uD83D\uDC68\u200D\u2696\uFE0F",
        "1F468 200D 2696                            ; minimally-qualified # 👨‍⚖ E4.0 man judge",
        "\uD83D\uDC68\u200D\u2696",
        "1F468 1F3FB 200D 2696 FE0F                 ; fully-qualified     # 👨🏻‍⚖️ E4.0 man judge: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2696\uFE0F",
        "1F468 1F3FB 200D 2696                      ; minimally-qualified # 👨🏻‍⚖ E4.0 man judge: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2696",
        "1F468 1F3FC 200D 2696 FE0F                 ; fully-qualified     # 👨🏼‍⚖️ E4.0 man judge: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696\uFE0F",
        "1F468 1F3FC 200D 2696                      ; minimally-qualified # 👨🏼‍⚖ E4.0 man judge: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2696",
        "1F468 1F3FD 200D 2696 FE0F                 ; fully-qualified     # 👨🏽‍⚖️ E4.0 man judge: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696\uFE0F",
        "1F468 1F3FD 200D 2696                      ; minimally-qualified # 👨🏽‍⚖ E4.0 man judge: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2696",
        "1F468 1F3FE 200D 2696 FE0F                 ; fully-qualified     # 👨🏾‍⚖️ E4.0 man judge: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696\uFE0F",
        "1F468 1F3FE 200D 2696                      ; minimally-qualified # 👨🏾‍⚖ E4.0 man judge: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2696",
        "1F468 1F3FF 200D 2696 FE0F                 ; fully-qualified     # 👨🏿‍⚖️ E4.0 man judge: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696\uFE0F",
        "1F468 1F3FF 200D 2696                      ; minimally-qualified # 👨🏿‍⚖ E4.0 man judge: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2696",
        "1F469 200D 2696 FE0F                       ; fully-qualified     # 👩‍⚖️ E4.0 woman judge",
        "\uD83D\uDC69\u200D\u2696\uFE0F",
        "1F469 200D 2696                            ; minimally-qualified # 👩‍⚖ E4.0 woman judge",
        "\uD83D\uDC69\u200D\u2696",
        "1F469 1F3FB 200D 2696 FE0F                 ; fully-qualified     # 👩🏻‍⚖️ E4.0 woman judge: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2696\uFE0F",
        "1F469 1F3FB 200D 2696                      ; minimally-qualified # 👩🏻‍⚖ E4.0 woman judge: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2696",
        "1F469 1F3FC 200D 2696 FE0F                 ; fully-qualified     # 👩🏼‍⚖️ E4.0 woman judge: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696\uFE0F",
        "1F469 1F3FC 200D 2696                      ; minimally-qualified # 👩🏼‍⚖ E4.0 woman judge: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2696",
        "1F469 1F3FD 200D 2696 FE0F                 ; fully-qualified     # 👩🏽‍⚖️ E4.0 woman judge: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696\uFE0F",
        "1F469 1F3FD 200D 2696                      ; minimally-qualified # 👩🏽‍⚖ E4.0 woman judge: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2696",
        "1F469 1F3FE 200D 2696 FE0F                 ; fully-qualified     # 👩🏾‍⚖️ E4.0 woman judge: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696\uFE0F",
        "1F469 1F3FE 200D 2696                      ; minimally-qualified # 👩🏾‍⚖ E4.0 woman judge: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2696",
        "1F469 1F3FF 200D 2696 FE0F                 ; fully-qualified     # 👩🏿‍⚖️ E4.0 woman judge: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696\uFE0F",
        "1F469 1F3FF 200D 2696                      ; minimally-qualified # 👩🏿‍⚖ E4.0 woman judge: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2696",
        "1F9D1 200D 1F33E                           ; fully-qualified     # 🧑‍🌾 E12.1 farmer",
        "\uD83E\uDDD1\u200D\uD83C\uDF3E",
        "1F9D1 1F3FB 200D 1F33E                     ; fully-qualified     # 🧑🏻‍🌾 E12.1 farmer: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF3E",
        "1F9D1 1F3FC 200D 1F33E                     ; fully-qualified     # 🧑🏼‍🌾 E12.1 farmer: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF3E",
        "1F9D1 1F3FD 200D 1F33E                     ; fully-qualified     # 🧑🏽‍🌾 E12.1 farmer: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF3E",
        "1F9D1 1F3FE 200D 1F33E                     ; fully-qualified     # 🧑🏾‍🌾 E12.1 farmer: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF3E",
        "1F9D1 1F3FF 200D 1F33E                     ; fully-qualified     # 🧑🏿‍🌾 E12.1 farmer: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF3E",
        "1F468 200D 1F33E                           ; fully-qualified     # 👨‍🌾 E4.0 man farmer",
        "\uD83D\uDC68\u200D\uD83C\uDF3E",
        "1F468 1F3FB 200D 1F33E                     ; fully-qualified     # 👨🏻‍🌾 E4.0 man farmer: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF3E",
        "1F468 1F3FC 200D 1F33E                     ; fully-qualified     # 👨🏼‍🌾 E4.0 man farmer: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF3E",
        "1F468 1F3FD 200D 1F33E                     ; fully-qualified     # 👨🏽‍🌾 E4.0 man farmer: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF3E",
        "1F468 1F3FE 200D 1F33E                     ; fully-qualified     # 👨🏾‍🌾 E4.0 man farmer: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF3E",
        "1F468 1F3FF 200D 1F33E                     ; fully-qualified     # 👨🏿‍🌾 E4.0 man farmer: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF3E",
        "1F469 200D 1F33E                           ; fully-qualified     # 👩‍🌾 E4.0 woman farmer",
        "\uD83D\uDC69\u200D\uD83C\uDF3E",
        "1F469 1F3FB 200D 1F33E                     ; fully-qualified     # 👩🏻‍🌾 E4.0 woman farmer: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF3E",
        "1F469 1F3FC 200D 1F33E                     ; fully-qualified     # 👩🏼‍🌾 E4.0 woman farmer: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF3E",
        "1F469 1F3FD 200D 1F33E                     ; fully-qualified     # 👩🏽‍🌾 E4.0 woman farmer: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF3E",
        "1F469 1F3FE 200D 1F33E                     ; fully-qualified     # 👩🏾‍🌾 E4.0 woman farmer: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF3E",
        "1F469 1F3FF 200D 1F33E                     ; fully-qualified     # 👩🏿‍🌾 E4.0 woman farmer: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF3E",
        "1F9D1 200D 1F373                           ; fully-qualified     # 🧑‍🍳 E12.1 cook",
        "\uD83E\uDDD1\u200D\uD83C\uDF73",
        "1F9D1 1F3FB 200D 1F373                     ; fully-qualified     # 🧑🏻‍🍳 E12.1 cook: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDF73",
        "1F9D1 1F3FC 200D 1F373                     ; fully-qualified     # 🧑🏼‍🍳 E12.1 cook: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDF73",
        "1F9D1 1F3FD 200D 1F373                     ; fully-qualified     # 🧑🏽‍🍳 E12.1 cook: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDF73",
        "1F9D1 1F3FE 200D 1F373                     ; fully-qualified     # 🧑🏾‍🍳 E12.1 cook: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDF73",
        "1F9D1 1F3FF 200D 1F373                     ; fully-qualified     # 🧑🏿‍🍳 E12.1 cook: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDF73",
        "1F468 200D 1F373                           ; fully-qualified     # 👨‍🍳 E4.0 man cook",
        "\uD83D\uDC68\u200D\uD83C\uDF73",
        "1F468 1F3FB 200D 1F373                     ; fully-qualified     # 👨🏻‍🍳 E4.0 man cook: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDF73",
        "1F468 1F3FC 200D 1F373                     ; fully-qualified     # 👨🏼‍🍳 E4.0 man cook: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDF73",
        "1F468 1F3FD 200D 1F373                     ; fully-qualified     # 👨🏽‍🍳 E4.0 man cook: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDF73",
        "1F468 1F3FE 200D 1F373                     ; fully-qualified     # 👨🏾‍🍳 E4.0 man cook: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDF73",
        "1F468 1F3FF 200D 1F373                     ; fully-qualified     # 👨🏿‍🍳 E4.0 man cook: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDF73",
        "1F469 200D 1F373                           ; fully-qualified     # 👩‍🍳 E4.0 woman cook",
        "\uD83D\uDC69\u200D\uD83C\uDF73",
        "1F469 1F3FB 200D 1F373                     ; fully-qualified     # 👩🏻‍🍳 E4.0 woman cook: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDF73",
        "1F469 1F3FC 200D 1F373                     ; fully-qualified     # 👩🏼‍🍳 E4.0 woman cook: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDF73",
        "1F469 1F3FD 200D 1F373                     ; fully-qualified     # 👩🏽‍🍳 E4.0 woman cook: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDF73",
        "1F469 1F3FE 200D 1F373                     ; fully-qualified     # 👩🏾‍🍳 E4.0 woman cook: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDF73",
        "1F469 1F3FF 200D 1F373                     ; fully-qualified     # 👩🏿‍🍳 E4.0 woman cook: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDF73",
        "1F9D1 200D 1F527                           ; fully-qualified     # 🧑‍🔧 E12.1 mechanic",
        "\uD83E\uDDD1\u200D\uD83D\uDD27",
        "1F9D1 1F3FB 200D 1F527                     ; fully-qualified     # 🧑🏻‍🔧 E12.1 mechanic: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD27",
        "1F9D1 1F3FC 200D 1F527                     ; fully-qualified     # 🧑🏼‍🔧 E12.1 mechanic: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD27",
        "1F9D1 1F3FD 200D 1F527                     ; fully-qualified     # 🧑🏽‍🔧 E12.1 mechanic: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD27",
        "1F9D1 1F3FE 200D 1F527                     ; fully-qualified     # 🧑🏾‍🔧 E12.1 mechanic: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD27",
        "1F9D1 1F3FF 200D 1F527                     ; fully-qualified     # 🧑🏿‍🔧 E12.1 mechanic: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD27",
        "1F468 200D 1F527                           ; fully-qualified     # 👨‍🔧 E4.0 man mechanic",
        "\uD83D\uDC68\u200D\uD83D\uDD27",
        "1F468 1F3FB 200D 1F527                     ; fully-qualified     # 👨🏻‍🔧 E4.0 man mechanic: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD27",
        "1F468 1F3FC 200D 1F527                     ; fully-qualified     # 👨🏼‍🔧 E4.0 man mechanic: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD27",
        "1F468 1F3FD 200D 1F527                     ; fully-qualified     # 👨🏽‍🔧 E4.0 man mechanic: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD27",
        "1F468 1F3FE 200D 1F527                     ; fully-qualified     # 👨🏾‍🔧 E4.0 man mechanic: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD27",
        "1F468 1F3FF 200D 1F527                     ; fully-qualified     # 👨🏿‍🔧 E4.0 man mechanic: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD27",
        "1F469 200D 1F527                           ; fully-qualified     # 👩‍🔧 E4.0 woman mechanic",
        "\uD83D\uDC69\u200D\uD83D\uDD27",
        "1F469 1F3FB 200D 1F527                     ; fully-qualified     # 👩🏻‍🔧 E4.0 woman mechanic: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD27",
        "1F469 1F3FC 200D 1F527                     ; fully-qualified     # 👩🏼‍🔧 E4.0 woman mechanic: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD27",
        "1F469 1F3FD 200D 1F527                     ; fully-qualified     # 👩🏽‍🔧 E4.0 woman mechanic: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD27",
        "1F469 1F3FE 200D 1F527                     ; fully-qualified     # 👩🏾‍🔧 E4.0 woman mechanic: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD27",
        "1F469 1F3FF 200D 1F527                     ; fully-qualified     # 👩🏿‍🔧 E4.0 woman mechanic: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD27",
        "1F9D1 200D 1F3ED                           ; fully-qualified     # 🧑‍🏭 E12.1 factory worker",
        "\uD83E\uDDD1\u200D\uD83C\uDFED",
        "1F9D1 1F3FB 200D 1F3ED                     ; fully-qualified     # 🧑🏻‍🏭 E12.1 factory worker: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFED",
        "1F9D1 1F3FC 200D 1F3ED                     ; fully-qualified     # 🧑🏼‍🏭 E12.1 factory worker: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFED",
        "1F9D1 1F3FD 200D 1F3ED                     ; fully-qualified     # 🧑🏽‍🏭 E12.1 factory worker: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFED",
        "1F9D1 1F3FE 200D 1F3ED                     ; fully-qualified     # 🧑🏾‍🏭 E12.1 factory worker: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFED",
        "1F9D1 1F3FF 200D 1F3ED                     ; fully-qualified     # 🧑🏿‍🏭 E12.1 factory worker: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFED",
        "1F468 200D 1F3ED                           ; fully-qualified     # 👨‍🏭 E4.0 man factory worker",
        "\uD83D\uDC68\u200D\uD83C\uDFED",
        "1F468 1F3FB 200D 1F3ED                     ; fully-qualified     # 👨🏻‍🏭 E4.0 man factory worker: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFED",
        "1F468 1F3FC 200D 1F3ED                     ; fully-qualified     # 👨🏼‍🏭 E4.0 man factory worker: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFED",
        "1F468 1F3FD 200D 1F3ED                     ; fully-qualified     # 👨🏽‍🏭 E4.0 man factory worker: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFED",
        "1F468 1F3FE 200D 1F3ED                     ; fully-qualified     # 👨🏾‍🏭 E4.0 man factory worker: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFED",
        "1F468 1F3FF 200D 1F3ED                     ; fully-qualified     # 👨🏿‍🏭 E4.0 man factory worker: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFED",
        "1F469 200D 1F3ED                           ; fully-qualified     # 👩‍🏭 E4.0 woman factory worker",
        "\uD83D\uDC69\u200D\uD83C\uDFED",
        "1F469 1F3FB 200D 1F3ED                     ; fully-qualified     # 👩🏻‍🏭 E4.0 woman factory worker: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFED",
        "1F469 1F3FC 200D 1F3ED                     ; fully-qualified     # 👩🏼‍🏭 E4.0 woman factory worker: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFED",
        "1F469 1F3FD 200D 1F3ED                     ; fully-qualified     # 👩🏽‍🏭 E4.0 woman factory worker: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFED",
        "1F469 1F3FE 200D 1F3ED                     ; fully-qualified     # 👩🏾‍🏭 E4.0 woman factory worker: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFED",
        "1F469 1F3FF 200D 1F3ED                     ; fully-qualified     # 👩🏿‍🏭 E4.0 woman factory worker: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFED",
        "1F9D1 200D 1F4BC                           ; fully-qualified     # 🧑‍💼 E12.1 office worker",
        "\uD83E\uDDD1\u200D\uD83D\uDCBC",
        "1F9D1 1F3FB 200D 1F4BC                     ; fully-qualified     # 🧑🏻‍💼 E12.1 office worker: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBC",
        "1F9D1 1F3FC 200D 1F4BC                     ; fully-qualified     # 🧑🏼‍💼 E12.1 office worker: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBC",
        "1F9D1 1F3FD 200D 1F4BC                     ; fully-qualified     # 🧑🏽‍💼 E12.1 office worker: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBC",
        "1F9D1 1F3FE 200D 1F4BC                     ; fully-qualified     # 🧑🏾‍💼 E12.1 office worker: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBC",
        "1F9D1 1F3FF 200D 1F4BC                     ; fully-qualified     # 🧑🏿‍💼 E12.1 office worker: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBC",
        "1F468 200D 1F4BC                           ; fully-qualified     # 👨‍💼 E4.0 man office worker",
        "\uD83D\uDC68\u200D\uD83D\uDCBC",
        "1F468 1F3FB 200D 1F4BC                     ; fully-qualified     # 👨🏻‍💼 E4.0 man office worker: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBC",
        "1F468 1F3FC 200D 1F4BC                     ; fully-qualified     # 👨🏼‍💼 E4.0 man office worker: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBC",
        "1F468 1F3FD 200D 1F4BC                     ; fully-qualified     # 👨🏽‍💼 E4.0 man office worker: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBC",
        "1F468 1F3FE 200D 1F4BC                     ; fully-qualified     # 👨🏾‍💼 E4.0 man office worker: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBC",
        "1F468 1F3FF 200D 1F4BC                     ; fully-qualified     # 👨🏿‍💼 E4.0 man office worker: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBC",
        "1F469 200D 1F4BC                           ; fully-qualified     # 👩‍💼 E4.0 woman office worker",
        "\uD83D\uDC69\u200D\uD83D\uDCBC",
        "1F469 1F3FB 200D 1F4BC                     ; fully-qualified     # 👩🏻‍💼 E4.0 woman office worker: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBC",
        "1F469 1F3FC 200D 1F4BC                     ; fully-qualified     # 👩🏼‍💼 E4.0 woman office worker: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBC",
        "1F469 1F3FD 200D 1F4BC                     ; fully-qualified     # 👩🏽‍💼 E4.0 woman office worker: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBC",
        "1F469 1F3FE 200D 1F4BC                     ; fully-qualified     # 👩🏾‍💼 E4.0 woman office worker: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBC",
        "1F469 1F3FF 200D 1F4BC                     ; fully-qualified     # 👩🏿‍💼 E4.0 woman office worker: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBC",
        "1F9D1 200D 1F52C                           ; fully-qualified     # 🧑‍🔬 E12.1 scientist",
        "\uD83E\uDDD1\u200D\uD83D\uDD2C",
        "1F9D1 1F3FB 200D 1F52C                     ; fully-qualified     # 🧑🏻‍🔬 E12.1 scientist: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDD2C",
        "1F9D1 1F3FC 200D 1F52C                     ; fully-qualified     # 🧑🏼‍🔬 E12.1 scientist: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDD2C",
        "1F9D1 1F3FD 200D 1F52C                     ; fully-qualified     # 🧑🏽‍🔬 E12.1 scientist: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDD2C",
        "1F9D1 1F3FE 200D 1F52C                     ; fully-qualified     # 🧑🏾‍🔬 E12.1 scientist: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDD2C",
        "1F9D1 1F3FF 200D 1F52C                     ; fully-qualified     # 🧑🏿‍🔬 E12.1 scientist: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDD2C",
        "1F468 200D 1F52C                           ; fully-qualified     # 👨‍🔬 E4.0 man scientist",
        "\uD83D\uDC68\u200D\uD83D\uDD2C",
        "1F468 1F3FB 200D 1F52C                     ; fully-qualified     # 👨🏻‍🔬 E4.0 man scientist: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDD2C",
        "1F468 1F3FC 200D 1F52C                     ; fully-qualified     # 👨🏼‍🔬 E4.0 man scientist: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDD2C",
        "1F468 1F3FD 200D 1F52C                     ; fully-qualified     # 👨🏽‍🔬 E4.0 man scientist: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDD2C",
        "1F468 1F3FE 200D 1F52C                     ; fully-qualified     # 👨🏾‍🔬 E4.0 man scientist: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDD2C",
        "1F468 1F3FF 200D 1F52C                     ; fully-qualified     # 👨🏿‍🔬 E4.0 man scientist: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDD2C",
        "1F469 200D 1F52C                           ; fully-qualified     # 👩‍🔬 E4.0 woman scientist",
        "\uD83D\uDC69\u200D\uD83D\uDD2C",
        "1F469 1F3FB 200D 1F52C                     ; fully-qualified     # 👩🏻‍🔬 E4.0 woman scientist: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDD2C",
        "1F469 1F3FC 200D 1F52C                     ; fully-qualified     # 👩🏼‍🔬 E4.0 woman scientist: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDD2C",
        "1F469 1F3FD 200D 1F52C                     ; fully-qualified     # 👩🏽‍🔬 E4.0 woman scientist: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDD2C",
        "1F469 1F3FE 200D 1F52C                     ; fully-qualified     # 👩🏾‍🔬 E4.0 woman scientist: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDD2C",
        "1F469 1F3FF 200D 1F52C                     ; fully-qualified     # 👩🏿‍🔬 E4.0 woman scientist: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDD2C",
        "1F9D1 200D 1F4BB                           ; fully-qualified     # 🧑‍💻 E12.1 technologist",
        "\uD83E\uDDD1\u200D\uD83D\uDCBB",
        "1F9D1 1F3FB 200D 1F4BB                     ; fully-qualified     # 🧑🏻‍💻 E12.1 technologist: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDCBB",
        "1F9D1 1F3FC 200D 1F4BB                     ; fully-qualified     # 🧑🏼‍💻 E12.1 technologist: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDCBB",
        "1F9D1 1F3FD 200D 1F4BB                     ; fully-qualified     # 🧑🏽‍💻 E12.1 technologist: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDCBB",
        "1F9D1 1F3FE 200D 1F4BB                     ; fully-qualified     # 🧑🏾‍💻 E12.1 technologist: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDCBB",
        "1F9D1 1F3FF 200D 1F4BB                     ; fully-qualified     # 🧑🏿‍💻 E12.1 technologist: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDCBB",
        "1F468 200D 1F4BB                           ; fully-qualified     # 👨‍💻 E4.0 man technologist",
        "\uD83D\uDC68\u200D\uD83D\uDCBB",
        "1F468 1F3FB 200D 1F4BB                     ; fully-qualified     # 👨🏻‍💻 E4.0 man technologist: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDCBB",
        "1F468 1F3FC 200D 1F4BB                     ; fully-qualified     # 👨🏼‍💻 E4.0 man technologist: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDCBB",
        "1F468 1F3FD 200D 1F4BB                     ; fully-qualified     # 👨🏽‍💻 E4.0 man technologist: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDCBB",
        "1F468 1F3FE 200D 1F4BB                     ; fully-qualified     # 👨🏾‍💻 E4.0 man technologist: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDCBB",
        "1F468 1F3FF 200D 1F4BB                     ; fully-qualified     # 👨🏿‍💻 E4.0 man technologist: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDCBB",
        "1F469 200D 1F4BB                           ; fully-qualified     # 👩‍💻 E4.0 woman technologist",
        "\uD83D\uDC69\u200D\uD83D\uDCBB",
        "1F469 1F3FB 200D 1F4BB                     ; fully-qualified     # 👩🏻‍💻 E4.0 woman technologist: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDCBB",
        "1F469 1F3FC 200D 1F4BB                     ; fully-qualified     # 👩🏼‍💻 E4.0 woman technologist: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDCBB",
        "1F469 1F3FD 200D 1F4BB                     ; fully-qualified     # 👩🏽‍💻 E4.0 woman technologist: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDCBB",
        "1F469 1F3FE 200D 1F4BB                     ; fully-qualified     # 👩🏾‍💻 E4.0 woman technologist: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDCBB",
        "1F469 1F3FF 200D 1F4BB                     ; fully-qualified     # 👩🏿‍💻 E4.0 woman technologist: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDCBB",
        "1F9D1 200D 1F3A4                           ; fully-qualified     # 🧑‍🎤 E12.1 singer",
        "\uD83E\uDDD1\u200D\uD83C\uDFA4",
        "1F9D1 1F3FB 200D 1F3A4                     ; fully-qualified     # 🧑🏻‍🎤 E12.1 singer: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA4",
        "1F9D1 1F3FC 200D 1F3A4                     ; fully-qualified     # 🧑🏼‍🎤 E12.1 singer: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA4",
        "1F9D1 1F3FD 200D 1F3A4                     ; fully-qualified     # 🧑🏽‍🎤 E12.1 singer: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA4",
        "1F9D1 1F3FE 200D 1F3A4                     ; fully-qualified     # 🧑🏾‍🎤 E12.1 singer: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA4",
        "1F9D1 1F3FF 200D 1F3A4                     ; fully-qualified     # 🧑🏿‍🎤 E12.1 singer: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA4",
        "1F468 200D 1F3A4                           ; fully-qualified     # 👨‍🎤 E4.0 man singer",
        "\uD83D\uDC68\u200D\uD83C\uDFA4",
        "1F468 1F3FB 200D 1F3A4                     ; fully-qualified     # 👨🏻‍🎤 E4.0 man singer: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA4",
        "1F468 1F3FC 200D 1F3A4                     ; fully-qualified     # 👨🏼‍🎤 E4.0 man singer: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA4",
        "1F468 1F3FD 200D 1F3A4                     ; fully-qualified     # 👨🏽‍🎤 E4.0 man singer: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA4",
        "1F468 1F3FE 200D 1F3A4                     ; fully-qualified     # 👨🏾‍🎤 E4.0 man singer: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA4",
        "1F468 1F3FF 200D 1F3A4                     ; fully-qualified     # 👨🏿‍🎤 E4.0 man singer: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA4",
        "1F469 200D 1F3A4                           ; fully-qualified     # 👩‍🎤 E4.0 woman singer",
        "\uD83D\uDC69\u200D\uD83C\uDFA4",
        "1F469 1F3FB 200D 1F3A4                     ; fully-qualified     # 👩🏻‍🎤 E4.0 woman singer: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA4",
        "1F469 1F3FC 200D 1F3A4                     ; fully-qualified     # 👩🏼‍🎤 E4.0 woman singer: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA4",
        "1F469 1F3FD 200D 1F3A4                     ; fully-qualified     # 👩🏽‍🎤 E4.0 woman singer: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA4",
        "1F469 1F3FE 200D 1F3A4                     ; fully-qualified     # 👩🏾‍🎤 E4.0 woman singer: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA4",
        "1F469 1F3FF 200D 1F3A4                     ; fully-qualified     # 👩🏿‍🎤 E4.0 woman singer: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA4",
        "1F9D1 200D 1F3A8                           ; fully-qualified     # 🧑‍🎨 E12.1 artist",
        "\uD83E\uDDD1\u200D\uD83C\uDFA8",
        "1F9D1 1F3FB 200D 1F3A8                     ; fully-qualified     # 🧑🏻‍🎨 E12.1 artist: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83C\uDFA8",
        "1F9D1 1F3FC 200D 1F3A8                     ; fully-qualified     # 🧑🏼‍🎨 E12.1 artist: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83C\uDFA8",
        "1F9D1 1F3FD 200D 1F3A8                     ; fully-qualified     # 🧑🏽‍🎨 E12.1 artist: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83C\uDFA8",
        "1F9D1 1F3FE 200D 1F3A8                     ; fully-qualified     # 🧑🏾‍🎨 E12.1 artist: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83C\uDFA8",
        "1F9D1 1F3FF 200D 1F3A8                     ; fully-qualified     # 🧑🏿‍🎨 E12.1 artist: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83C\uDFA8",
        "1F468 200D 1F3A8                           ; fully-qualified     # 👨‍🎨 E4.0 man artist",
        "\uD83D\uDC68\u200D\uD83C\uDFA8",
        "1F468 1F3FB 200D 1F3A8                     ; fully-qualified     # 👨🏻‍🎨 E4.0 man artist: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83C\uDFA8",
        "1F468 1F3FC 200D 1F3A8                     ; fully-qualified     # 👨🏼‍🎨 E4.0 man artist: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83C\uDFA8",
        "1F468 1F3FD 200D 1F3A8                     ; fully-qualified     # 👨🏽‍🎨 E4.0 man artist: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83C\uDFA8",
        "1F468 1F3FE 200D 1F3A8                     ; fully-qualified     # 👨🏾‍🎨 E4.0 man artist: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83C\uDFA8",
        "1F468 1F3FF 200D 1F3A8                     ; fully-qualified     # 👨🏿‍🎨 E4.0 man artist: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83C\uDFA8",
        "1F469 200D 1F3A8                           ; fully-qualified     # 👩‍🎨 E4.0 woman artist",
        "\uD83D\uDC69\u200D\uD83C\uDFA8",
        "1F469 1F3FB 200D 1F3A8                     ; fully-qualified     # 👩🏻‍🎨 E4.0 woman artist: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83C\uDFA8",
        "1F469 1F3FC 200D 1F3A8                     ; fully-qualified     # 👩🏼‍🎨 E4.0 woman artist: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83C\uDFA8",
        "1F469 1F3FD 200D 1F3A8                     ; fully-qualified     # 👩🏽‍🎨 E4.0 woman artist: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83C\uDFA8",
        "1F469 1F3FE 200D 1F3A8                     ; fully-qualified     # 👩🏾‍🎨 E4.0 woman artist: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83C\uDFA8",
        "1F469 1F3FF 200D 1F3A8                     ; fully-qualified     # 👩🏿‍🎨 E4.0 woman artist: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83C\uDFA8",
        "1F9D1 200D 2708 FE0F                       ; fully-qualified     # 🧑‍✈️ E12.1 pilot",
        "\uD83E\uDDD1\u200D\u2708\uFE0F",
        "1F9D1 200D 2708                            ; minimally-qualified # 🧑‍✈ E12.1 pilot",
        "\uD83E\uDDD1\u200D\u2708",
        "1F9D1 1F3FB 200D 2708 FE0F                 ; fully-qualified     # 🧑🏻‍✈️ E12.1 pilot: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2708\uFE0F",
        "1F9D1 1F3FB 200D 2708                      ; minimally-qualified # 🧑🏻‍✈ E12.1 pilot: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\u2708",
        "1F9D1 1F3FC 200D 2708 FE0F                 ; fully-qualified     # 🧑🏼‍✈️ E12.1 pilot: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2708\uFE0F",
        "1F9D1 1F3FC 200D 2708                      ; minimally-qualified # 🧑🏼‍✈ E12.1 pilot: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\u2708",
        "1F9D1 1F3FD 200D 2708 FE0F                 ; fully-qualified     # 🧑🏽‍✈️ E12.1 pilot: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2708\uFE0F",
        "1F9D1 1F3FD 200D 2708                      ; minimally-qualified # 🧑🏽‍✈ E12.1 pilot: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\u2708",
        "1F9D1 1F3FE 200D 2708 FE0F                 ; fully-qualified     # 🧑🏾‍✈️ E12.1 pilot: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2708\uFE0F",
        "1F9D1 1F3FE 200D 2708                      ; minimally-qualified # 🧑🏾‍✈ E12.1 pilot: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\u2708",
        "1F9D1 1F3FF 200D 2708 FE0F                 ; fully-qualified     # 🧑🏿‍✈️ E12.1 pilot: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2708\uFE0F",
        "1F9D1 1F3FF 200D 2708                      ; minimally-qualified # 🧑🏿‍✈ E12.1 pilot: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\u2708",
        "1F468 200D 2708 FE0F                       ; fully-qualified     # 👨‍✈️ E4.0 man pilot",
        "\uD83D\uDC68\u200D\u2708\uFE0F",
        "1F468 200D 2708                            ; minimally-qualified # 👨‍✈ E4.0 man pilot",
        "\uD83D\uDC68\u200D\u2708",
        "1F468 1F3FB 200D 2708 FE0F                 ; fully-qualified     # 👨🏻‍✈️ E4.0 man pilot: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2708\uFE0F",
        "1F468 1F3FB 200D 2708                      ; minimally-qualified # 👨🏻‍✈ E4.0 man pilot: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\u2708",
        "1F468 1F3FC 200D 2708 FE0F                 ; fully-qualified     # 👨🏼‍✈️ E4.0 man pilot: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708\uFE0F",
        "1F468 1F3FC 200D 2708                      ; minimally-qualified # 👨🏼‍✈ E4.0 man pilot: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\u2708",
        "1F468 1F3FD 200D 2708 FE0F                 ; fully-qualified     # 👨🏽‍✈️ E4.0 man pilot: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708\uFE0F",
        "1F468 1F3FD 200D 2708                      ; minimally-qualified # 👨🏽‍✈ E4.0 man pilot: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\u2708",
        "1F468 1F3FE 200D 2708 FE0F                 ; fully-qualified     # 👨🏾‍✈️ E4.0 man pilot: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708\uFE0F",
        "1F468 1F3FE 200D 2708                      ; minimally-qualified # 👨🏾‍✈ E4.0 man pilot: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\u2708",
        "1F468 1F3FF 200D 2708 FE0F                 ; fully-qualified     # 👨🏿‍✈️ E4.0 man pilot: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708\uFE0F",
        "1F468 1F3FF 200D 2708                      ; minimally-qualified # 👨🏿‍✈ E4.0 man pilot: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\u2708",
        "1F469 200D 2708 FE0F                       ; fully-qualified     # 👩‍✈️ E4.0 woman pilot",
        "\uD83D\uDC69\u200D\u2708\uFE0F",
        "1F469 200D 2708                            ; minimally-qualified # 👩‍✈ E4.0 woman pilot",
        "\uD83D\uDC69\u200D\u2708",
        "1F469 1F3FB 200D 2708 FE0F                 ; fully-qualified     # 👩🏻‍✈️ E4.0 woman pilot: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2708\uFE0F",
        "1F469 1F3FB 200D 2708                      ; minimally-qualified # 👩🏻‍✈ E4.0 woman pilot: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\u2708",
        "1F469 1F3FC 200D 2708 FE0F                 ; fully-qualified     # 👩🏼‍✈️ E4.0 woman pilot: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708\uFE0F",
        "1F469 1F3FC 200D 2708                      ; minimally-qualified # 👩🏼‍✈ E4.0 woman pilot: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\u2708",
        "1F469 1F3FD 200D 2708 FE0F                 ; fully-qualified     # 👩🏽‍✈️ E4.0 woman pilot: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708\uFE0F",
        "1F469 1F3FD 200D 2708                      ; minimally-qualified # 👩🏽‍✈ E4.0 woman pilot: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\u2708",
        "1F469 1F3FE 200D 2708 FE0F                 ; fully-qualified     # 👩🏾‍✈️ E4.0 woman pilot: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708\uFE0F",
        "1F469 1F3FE 200D 2708                      ; minimally-qualified # 👩🏾‍✈ E4.0 woman pilot: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\u2708",
        "1F469 1F3FF 200D 2708 FE0F                 ; fully-qualified     # 👩🏿‍✈️ E4.0 woman pilot: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708\uFE0F",
        "1F469 1F3FF 200D 2708                      ; minimally-qualified # 👩🏿‍✈ E4.0 woman pilot: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\u2708",
        "1F9D1 200D 1F680                           ; fully-qualified     # 🧑‍🚀 E12.1 astronaut",
        "\uD83E\uDDD1\u200D\uD83D\uDE80",
        "1F9D1 1F3FB 200D 1F680                     ; fully-qualified     # 🧑🏻‍🚀 E12.1 astronaut: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE80",
        "1F9D1 1F3FC 200D 1F680                     ; fully-qualified     # 🧑🏼‍🚀 E12.1 astronaut: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE80",
        "1F9D1 1F3FD 200D 1F680                     ; fully-qualified     # 🧑🏽‍🚀 E12.1 astronaut: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE80",
        "1F9D1 1F3FE 200D 1F680                     ; fully-qualified     # 🧑🏾‍🚀 E12.1 astronaut: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE80",
        "1F9D1 1F3FF 200D 1F680                     ; fully-qualified     # 🧑🏿‍🚀 E12.1 astronaut: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE80",
        "1F468 200D 1F680                           ; fully-qualified     # 👨‍🚀 E4.0 man astronaut",
        "\uD83D\uDC68\u200D\uD83D\uDE80",
        "1F468 1F3FB 200D 1F680                     ; fully-qualified     # 👨🏻‍🚀 E4.0 man astronaut: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE80",
        "1F468 1F3FC 200D 1F680                     ; fully-qualified     # 👨🏼‍🚀 E4.0 man astronaut: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE80",
        "1F468 1F3FD 200D 1F680                     ; fully-qualified     # 👨🏽‍🚀 E4.0 man astronaut: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE80",
        "1F468 1F3FE 200D 1F680                     ; fully-qualified     # 👨🏾‍🚀 E4.0 man astronaut: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE80",
        "1F468 1F3FF 200D 1F680                     ; fully-qualified     # 👨🏿‍🚀 E4.0 man astronaut: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE80",
        "1F469 200D 1F680                           ; fully-qualified     # 👩‍🚀 E4.0 woman astronaut",
        "\uD83D\uDC69\u200D\uD83D\uDE80",
        "1F469 1F3FB 200D 1F680                     ; fully-qualified     # 👩🏻‍🚀 E4.0 woman astronaut: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE80",
        "1F469 1F3FC 200D 1F680                     ; fully-qualified     # 👩🏼‍🚀 E4.0 woman astronaut: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE80",
        "1F469 1F3FD 200D 1F680                     ; fully-qualified     # 👩🏽‍🚀 E4.0 woman astronaut: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE80",
        "1F469 1F3FE 200D 1F680                     ; fully-qualified     # 👩🏾‍🚀 E4.0 woman astronaut: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE80",
        "1F469 1F3FF 200D 1F680                     ; fully-qualified     # 👩🏿‍🚀 E4.0 woman astronaut: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE80",
        "1F9D1 200D 1F692                           ; fully-qualified     # 🧑‍🚒 E12.1 firefighter",
        "\uD83E\uDDD1\u200D\uD83D\uDE92",
        "1F9D1 1F3FB 200D 1F692                     ; fully-qualified     # 🧑🏻‍🚒 E12.1 firefighter: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83D\uDE92",
        "1F9D1 1F3FC 200D 1F692                     ; fully-qualified     # 🧑🏼‍🚒 E12.1 firefighter: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83D\uDE92",
        "1F9D1 1F3FD 200D 1F692                     ; fully-qualified     # 🧑🏽‍🚒 E12.1 firefighter: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83D\uDE92",
        "1F9D1 1F3FE 200D 1F692                     ; fully-qualified     # 🧑🏾‍🚒 E12.1 firefighter: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83D\uDE92",
        "1F9D1 1F3FF 200D 1F692                     ; fully-qualified     # 🧑🏿‍🚒 E12.1 firefighter: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83D\uDE92",
        "1F468 200D 1F692                           ; fully-qualified     # 👨‍🚒 E4.0 man firefighter",
        "\uD83D\uDC68\u200D\uD83D\uDE92",
        "1F468 1F3FB 200D 1F692                     ; fully-qualified     # 👨🏻‍🚒 E4.0 man firefighter: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83D\uDE92",
        "1F468 1F3FC 200D 1F692                     ; fully-qualified     # 👨🏼‍🚒 E4.0 man firefighter: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83D\uDE92",
        "1F468 1F3FD 200D 1F692                     ; fully-qualified     # 👨🏽‍🚒 E4.0 man firefighter: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83D\uDE92",
        "1F468 1F3FE 200D 1F692                     ; fully-qualified     # 👨🏾‍🚒 E4.0 man firefighter: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83D\uDE92",
        "1F468 1F3FF 200D 1F692                     ; fully-qualified     # 👨🏿‍🚒 E4.0 man firefighter: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83D\uDE92",
        "1F469 200D 1F692                           ; fully-qualified     # 👩‍🚒 E4.0 woman firefighter",
        "\uD83D\uDC69\u200D\uD83D\uDE92",
        "1F469 1F3FB 200D 1F692                     ; fully-qualified     # 👩🏻‍🚒 E4.0 woman firefighter: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83D\uDE92",
        "1F469 1F3FC 200D 1F692                     ; fully-qualified     # 👩🏼‍🚒 E4.0 woman firefighter: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83D\uDE92",
        "1F469 1F3FD 200D 1F692                     ; fully-qualified     # 👩🏽‍🚒 E4.0 woman firefighter: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83D\uDE92",
        "1F469 1F3FE 200D 1F692                     ; fully-qualified     # 👩🏾‍🚒 E4.0 woman firefighter: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83D\uDE92",
        "1F469 1F3FF 200D 1F692                     ; fully-qualified     # 👩🏿‍🚒 E4.0 woman firefighter: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83D\uDE92",
        "1F46E                                      ; fully-qualified     # 👮 E2.0 police officer",
        "\uD83D\uDC6E",
        "1F46E 1F3FB                                ; fully-qualified     # 👮🏻 E2.0 police officer: light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFB",
        "1F46E 1F3FC                                ; fully-qualified     # 👮🏼 E2.0 police officer: medium-light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFC",
        "1F46E 1F3FD                                ; fully-qualified     # 👮🏽 E2.0 police officer: medium skin tone",
        "\uD83D\uDC6E\uD83C\uDFFD",
        "1F46E 1F3FE                                ; fully-qualified     # 👮🏾 E2.0 police officer: medium-dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFE",
        "1F46E 1F3FF                                ; fully-qualified     # 👮🏿 E2.0 police officer: dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFF",
        "1F46E 200D 2642 FE0F                       ; fully-qualified     # 👮‍♂️ E4.0 man police officer",
        "\uD83D\uDC6E\u200D\u2642\uFE0F",
        "1F46E 200D 2642                            ; minimally-qualified # 👮‍♂ E4.0 man police officer",
        "\uD83D\uDC6E\u200D\u2642",
        "1F46E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👮🏻‍♂️ E4.0 man police officer: light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F46E 1F3FB 200D 2642                      ; minimally-qualified # 👮🏻‍♂ E4.0 man police officer: light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2642",
        "1F46E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👮🏼‍♂️ E4.0 man police officer: medium-light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F46E 1F3FC 200D 2642                      ; minimally-qualified # 👮🏼‍♂ E4.0 man police officer: medium-light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2642",
        "1F46E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👮🏽‍♂️ E4.0 man police officer: medium skin tone",
        "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F46E 1F3FD 200D 2642                      ; minimally-qualified # 👮🏽‍♂ E4.0 man police officer: medium skin tone",
        "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2642",
        "1F46E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👮🏾‍♂️ E4.0 man police officer: medium-dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F46E 1F3FE 200D 2642                      ; minimally-qualified # 👮🏾‍♂ E4.0 man police officer: medium-dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2642",
        "1F46E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👮🏿‍♂️ E4.0 man police officer: dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F46E 1F3FF 200D 2642                      ; minimally-qualified # 👮🏿‍♂ E4.0 man police officer: dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2642",
        "1F46E 200D 2640 FE0F                       ; fully-qualified     # 👮‍♀️ E4.0 woman police officer",
        "\uD83D\uDC6E\u200D\u2640\uFE0F",
        "1F46E 200D 2640                            ; minimally-qualified # 👮‍♀ E4.0 woman police officer",
        "\uD83D\uDC6E\u200D\u2640",
        "1F46E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👮🏻‍♀️ E4.0 woman police officer: light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F46E 1F3FB 200D 2640                      ; minimally-qualified # 👮🏻‍♀ E4.0 woman police officer: light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFB\u200D\u2640",
        "1F46E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👮🏼‍♀️ E4.0 woman police officer: medium-light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F46E 1F3FC 200D 2640                      ; minimally-qualified # 👮🏼‍♀ E4.0 woman police officer: medium-light skin tone",
        "\uD83D\uDC6E\uD83C\uDFFC\u200D\u2640",
        "1F46E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👮🏽‍♀️ E4.0 woman police officer: medium skin tone",
        "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F46E 1F3FD 200D 2640                      ; minimally-qualified # 👮🏽‍♀ E4.0 woman police officer: medium skin tone",
        "\uD83D\uDC6E\uD83C\uDFFD\u200D\u2640",
        "1F46E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👮🏾‍♀️ E4.0 woman police officer: medium-dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F46E 1F3FE 200D 2640                      ; minimally-qualified # 👮🏾‍♀ E4.0 woman police officer: medium-dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFE\u200D\u2640",
        "1F46E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👮🏿‍♀️ E4.0 woman police officer: dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F46E 1F3FF 200D 2640                      ; minimally-qualified # 👮🏿‍♀ E4.0 woman police officer: dark skin tone",
        "\uD83D\uDC6E\uD83C\uDFFF\u200D\u2640",
        "1F575 FE0F                                 ; fully-qualified     # 🕵️ E2.0 detective",
        "\uD83D\uDD75\uFE0F",
        "1F575                                      ; unqualified         # 🕵 E2.0 detective",
        "\uD83D\uDD75",
        "1F575 1F3FB                                ; fully-qualified     # 🕵🏻 E2.0 detective: light skin tone",
        "\uD83D\uDD75\uD83C\uDFFB",
        "1F575 1F3FC                                ; fully-qualified     # 🕵🏼 E2.0 detective: medium-light skin tone",
        "\uD83D\uDD75\uD83C\uDFFC",
        "1F575 1F3FD                                ; fully-qualified     # 🕵🏽 E2.0 detective: medium skin tone",
        "\uD83D\uDD75\uD83C\uDFFD",
        "1F575 1F3FE                                ; fully-qualified     # 🕵🏾 E2.0 detective: medium-dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFE",
        "1F575 1F3FF                                ; fully-qualified     # 🕵🏿 E2.0 detective: dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFF",
        "1F575 FE0F 200D 2642 FE0F                  ; fully-qualified     # 🕵️‍♂️ E4.0 man detective",
        "\uD83D\uDD75\uFE0F\u200D\u2642\uFE0F",
        "1F575 200D 2642 FE0F                       ; unqualified         # 🕵‍♂️ E4.0 man detective",
        "\uD83D\uDD75\u200D\u2642\uFE0F",
        "1F575 FE0F 200D 2642                       ; unqualified         # 🕵️‍♂ E4.0 man detective",
        "\uD83D\uDD75\uFE0F\u200D\u2642",
        "1F575 200D 2642                            ; unqualified         # 🕵‍♂ E4.0 man detective",
        "\uD83D\uDD75\u200D\u2642",
        "1F575 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🕵🏻‍♂️ E4.0 man detective: light skin tone",
        "\uD83D\uDD75\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F575 1F3FB 200D 2642                      ; minimally-qualified # 🕵🏻‍♂ E4.0 man detective: light skin tone",
        "\uD83D\uDD75\uD83C\uDFFB\u200D\u2642",
        "1F575 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🕵🏼‍♂️ E4.0 man detective: medium-light skin tone",
        "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F575 1F3FC 200D 2642                      ; minimally-qualified # 🕵🏼‍♂ E4.0 man detective: medium-light skin tone",
        "\uD83D\uDD75\uD83C\uDFFC\u200D\u2642",
        "1F575 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🕵🏽‍♂️ E4.0 man detective: medium skin tone",
        "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F575 1F3FD 200D 2642                      ; minimally-qualified # 🕵🏽‍♂ E4.0 man detective: medium skin tone",
        "\uD83D\uDD75\uD83C\uDFFD\u200D\u2642",
        "1F575 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🕵🏾‍♂️ E4.0 man detective: medium-dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F575 1F3FE 200D 2642                      ; minimally-qualified # 🕵🏾‍♂ E4.0 man detective: medium-dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFE\u200D\u2642",
        "1F575 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🕵🏿‍♂️ E4.0 man detective: dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F575 1F3FF 200D 2642                      ; minimally-qualified # 🕵🏿‍♂ E4.0 man detective: dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFF\u200D\u2642",
        "1F575 FE0F 200D 2640 FE0F                  ; fully-qualified     # 🕵️‍♀️ E4.0 woman detective",
        "\uD83D\uDD75\uFE0F\u200D\u2640\uFE0F",
        "1F575 200D 2640 FE0F                       ; unqualified         # 🕵‍♀️ E4.0 woman detective",
        "\uD83D\uDD75\u200D\u2640\uFE0F",
        "1F575 FE0F 200D 2640                       ; unqualified         # 🕵️‍♀ E4.0 woman detective",
        "\uD83D\uDD75\uFE0F\u200D\u2640",
        "1F575 200D 2640                            ; unqualified         # 🕵‍♀ E4.0 woman detective",
        "\uD83D\uDD75\u200D\u2640",
        "1F575 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🕵🏻‍♀️ E4.0 woman detective: light skin tone",
        "\uD83D\uDD75\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F575 1F3FB 200D 2640                      ; minimally-qualified # 🕵🏻‍♀ E4.0 woman detective: light skin tone",
        "\uD83D\uDD75\uD83C\uDFFB\u200D\u2640",
        "1F575 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🕵🏼‍♀️ E4.0 woman detective: medium-light skin tone",
        "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F575 1F3FC 200D 2640                      ; minimally-qualified # 🕵🏼‍♀ E4.0 woman detective: medium-light skin tone",
        "\uD83D\uDD75\uD83C\uDFFC\u200D\u2640",
        "1F575 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🕵🏽‍♀️ E4.0 woman detective: medium skin tone",
        "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F575 1F3FD 200D 2640                      ; minimally-qualified # 🕵🏽‍♀ E4.0 woman detective: medium skin tone",
        "\uD83D\uDD75\uD83C\uDFFD\u200D\u2640",
        "1F575 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🕵🏾‍♀️ E4.0 woman detective: medium-dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F575 1F3FE 200D 2640                      ; minimally-qualified # 🕵🏾‍♀ E4.0 woman detective: medium-dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFE\u200D\u2640",
        "1F575 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🕵🏿‍♀️ E4.0 woman detective: dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F575 1F3FF 200D 2640                      ; minimally-qualified # 🕵🏿‍♀ E4.0 woman detective: dark skin tone",
        "\uD83D\uDD75\uD83C\uDFFF\u200D\u2640",
        "1F482                                      ; fully-qualified     # 💂 E2.0 guard",
        "\uD83D\uDC82",
        "1F482 1F3FB                                ; fully-qualified     # 💂🏻 E2.0 guard: light skin tone",
        "\uD83D\uDC82\uD83C\uDFFB",
        "1F482 1F3FC                                ; fully-qualified     # 💂🏼 E2.0 guard: medium-light skin tone",
        "\uD83D\uDC82\uD83C\uDFFC",
        "1F482 1F3FD                                ; fully-qualified     # 💂🏽 E2.0 guard: medium skin tone",
        "\uD83D\uDC82\uD83C\uDFFD",
        "1F482 1F3FE                                ; fully-qualified     # 💂🏾 E2.0 guard: medium-dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFE",
        "1F482 1F3FF                                ; fully-qualified     # 💂🏿 E2.0 guard: dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFF",
        "1F482 200D 2642 FE0F                       ; fully-qualified     # 💂‍♂️ E4.0 man guard",
        "\uD83D\uDC82\u200D\u2642\uFE0F",
        "1F482 200D 2642                            ; minimally-qualified # 💂‍♂ E4.0 man guard",
        "\uD83D\uDC82\u200D\u2642",
        "1F482 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💂🏻‍♂️ E4.0 man guard: light skin tone",
        "\uD83D\uDC82\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F482 1F3FB 200D 2642                      ; minimally-qualified # 💂🏻‍♂ E4.0 man guard: light skin tone",
        "\uD83D\uDC82\uD83C\uDFFB\u200D\u2642",
        "1F482 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💂🏼‍♂️ E4.0 man guard: medium-light skin tone",
        "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F482 1F3FC 200D 2642                      ; minimally-qualified # 💂🏼‍♂ E4.0 man guard: medium-light skin tone",
        "\uD83D\uDC82\uD83C\uDFFC\u200D\u2642",
        "1F482 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💂🏽‍♂️ E4.0 man guard: medium skin tone",
        "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F482 1F3FD 200D 2642                      ; minimally-qualified # 💂🏽‍♂ E4.0 man guard: medium skin tone",
        "\uD83D\uDC82\uD83C\uDFFD\u200D\u2642",
        "1F482 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💂🏾‍♂️ E4.0 man guard: medium-dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F482 1F3FE 200D 2642                      ; minimally-qualified # 💂🏾‍♂ E4.0 man guard: medium-dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFE\u200D\u2642",
        "1F482 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💂🏿‍♂️ E4.0 man guard: dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F482 1F3FF 200D 2642                      ; minimally-qualified # 💂🏿‍♂ E4.0 man guard: dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFF\u200D\u2642",
        "1F482 200D 2640 FE0F                       ; fully-qualified     # 💂‍♀️ E4.0 woman guard",
        "\uD83D\uDC82\u200D\u2640\uFE0F",
        "1F482 200D 2640                            ; minimally-qualified # 💂‍♀ E4.0 woman guard",
        "\uD83D\uDC82\u200D\u2640",
        "1F482 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💂🏻‍♀️ E4.0 woman guard: light skin tone",
        "\uD83D\uDC82\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F482 1F3FB 200D 2640                      ; minimally-qualified # 💂🏻‍♀ E4.0 woman guard: light skin tone",
        "\uD83D\uDC82\uD83C\uDFFB\u200D\u2640",
        "1F482 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💂🏼‍♀️ E4.0 woman guard: medium-light skin tone",
        "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F482 1F3FC 200D 2640                      ; minimally-qualified # 💂🏼‍♀ E4.0 woman guard: medium-light skin tone",
        "\uD83D\uDC82\uD83C\uDFFC\u200D\u2640",
        "1F482 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💂🏽‍♀️ E4.0 woman guard: medium skin tone",
        "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F482 1F3FD 200D 2640                      ; minimally-qualified # 💂🏽‍♀ E4.0 woman guard: medium skin tone",
        "\uD83D\uDC82\uD83C\uDFFD\u200D\u2640",
        "1F482 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💂🏾‍♀️ E4.0 woman guard: medium-dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F482 1F3FE 200D 2640                      ; minimally-qualified # 💂🏾‍♀ E4.0 woman guard: medium-dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFE\u200D\u2640",
        "1F482 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💂🏿‍♀️ E4.0 woman guard: dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F482 1F3FF 200D 2640                      ; minimally-qualified # 💂🏿‍♀ E4.0 woman guard: dark skin tone",
        "\uD83D\uDC82\uD83C\uDFFF\u200D\u2640",
        "1F477                                      ; fully-qualified     # 👷 E2.0 construction worker",
        "\uD83D\uDC77",
        "1F477 1F3FB                                ; fully-qualified     # 👷🏻 E2.0 construction worker: light skin tone",
        "\uD83D\uDC77\uD83C\uDFFB",
        "1F477 1F3FC                                ; fully-qualified     # 👷🏼 E2.0 construction worker: medium-light skin tone",
        "\uD83D\uDC77\uD83C\uDFFC",
        "1F477 1F3FD                                ; fully-qualified     # 👷🏽 E2.0 construction worker: medium skin tone",
        "\uD83D\uDC77\uD83C\uDFFD",
        "1F477 1F3FE                                ; fully-qualified     # 👷🏾 E2.0 construction worker: medium-dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFE",
        "1F477 1F3FF                                ; fully-qualified     # 👷🏿 E2.0 construction worker: dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFF",
        "1F477 200D 2642 FE0F                       ; fully-qualified     # 👷‍♂️ E4.0 man construction worker",
        "\uD83D\uDC77\u200D\u2642\uFE0F",
        "1F477 200D 2642                            ; minimally-qualified # 👷‍♂ E4.0 man construction worker",
        "\uD83D\uDC77\u200D\u2642",
        "1F477 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👷🏻‍♂️ E4.0 man construction worker: light skin tone",
        "\uD83D\uDC77\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F477 1F3FB 200D 2642                      ; minimally-qualified # 👷🏻‍♂ E4.0 man construction worker: light skin tone",
        "\uD83D\uDC77\uD83C\uDFFB\u200D\u2642",
        "1F477 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👷🏼‍♂️ E4.0 man construction worker: medium-light skin tone",
        "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F477 1F3FC 200D 2642                      ; minimally-qualified # 👷🏼‍♂ E4.0 man construction worker: medium-light skin tone",
        "\uD83D\uDC77\uD83C\uDFFC\u200D\u2642",
        "1F477 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👷🏽‍♂️ E4.0 man construction worker: medium skin tone",
        "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F477 1F3FD 200D 2642                      ; minimally-qualified # 👷🏽‍♂ E4.0 man construction worker: medium skin tone",
        "\uD83D\uDC77\uD83C\uDFFD\u200D\u2642",
        "1F477 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👷🏾‍♂️ E4.0 man construction worker: medium-dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F477 1F3FE 200D 2642                      ; minimally-qualified # 👷🏾‍♂ E4.0 man construction worker: medium-dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFE\u200D\u2642",
        "1F477 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👷🏿‍♂️ E4.0 man construction worker: dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F477 1F3FF 200D 2642                      ; minimally-qualified # 👷🏿‍♂ E4.0 man construction worker: dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFF\u200D\u2642",
        "1F477 200D 2640 FE0F                       ; fully-qualified     # 👷‍♀️ E4.0 woman construction worker",
        "\uD83D\uDC77\u200D\u2640\uFE0F",
        "1F477 200D 2640                            ; minimally-qualified # 👷‍♀ E4.0 woman construction worker",
        "\uD83D\uDC77\u200D\u2640",
        "1F477 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👷🏻‍♀️ E4.0 woman construction worker: light skin tone",
        "\uD83D\uDC77\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F477 1F3FB 200D 2640                      ; minimally-qualified # 👷🏻‍♀ E4.0 woman construction worker: light skin tone",
        "\uD83D\uDC77\uD83C\uDFFB\u200D\u2640",
        "1F477 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👷🏼‍♀️ E4.0 woman construction worker: medium-light skin tone",
        "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F477 1F3FC 200D 2640                      ; minimally-qualified # 👷🏼‍♀ E4.0 woman construction worker: medium-light skin tone",
        "\uD83D\uDC77\uD83C\uDFFC\u200D\u2640",
        "1F477 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👷🏽‍♀️ E4.0 woman construction worker: medium skin tone",
        "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F477 1F3FD 200D 2640                      ; minimally-qualified # 👷🏽‍♀ E4.0 woman construction worker: medium skin tone",
        "\uD83D\uDC77\uD83C\uDFFD\u200D\u2640",
        "1F477 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👷🏾‍♀️ E4.0 woman construction worker: medium-dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F477 1F3FE 200D 2640                      ; minimally-qualified # 👷🏾‍♀ E4.0 woman construction worker: medium-dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFE\u200D\u2640",
        "1F477 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👷🏿‍♀️ E4.0 woman construction worker: dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F477 1F3FF 200D 2640                      ; minimally-qualified # 👷🏿‍♀ E4.0 woman construction worker: dark skin tone",
        "\uD83D\uDC77\uD83C\uDFFF\u200D\u2640",
        "1F934                                      ; fully-qualified     # 🤴 E4.0 prince",
        "\uD83E\uDD34",
        "1F934 1F3FB                                ; fully-qualified     # 🤴🏻 E4.0 prince: light skin tone",
        "\uD83E\uDD34\uD83C\uDFFB",
        "1F934 1F3FC                                ; fully-qualified     # 🤴🏼 E4.0 prince: medium-light skin tone",
        "\uD83E\uDD34\uD83C\uDFFC",
        "1F934 1F3FD                                ; fully-qualified     # 🤴🏽 E4.0 prince: medium skin tone",
        "\uD83E\uDD34\uD83C\uDFFD",
        "1F934 1F3FE                                ; fully-qualified     # 🤴🏾 E4.0 prince: medium-dark skin tone",
        "\uD83E\uDD34\uD83C\uDFFE",
        "1F934 1F3FF                                ; fully-qualified     # 🤴🏿 E4.0 prince: dark skin tone",
        "\uD83E\uDD34\uD83C\uDFFF",
        "1F478                                      ; fully-qualified     # 👸 E2.0 princess",
        "\uD83D\uDC78",
        "1F478 1F3FB                                ; fully-qualified     # 👸🏻 E2.0 princess: light skin tone",
        "\uD83D\uDC78\uD83C\uDFFB",
        "1F478 1F3FC                                ; fully-qualified     # 👸🏼 E2.0 princess: medium-light skin tone",
        "\uD83D\uDC78\uD83C\uDFFC",
        "1F478 1F3FD                                ; fully-qualified     # 👸🏽 E2.0 princess: medium skin tone",
        "\uD83D\uDC78\uD83C\uDFFD",
        "1F478 1F3FE                                ; fully-qualified     # 👸🏾 E2.0 princess: medium-dark skin tone",
        "\uD83D\uDC78\uD83C\uDFFE",
        "1F478 1F3FF                                ; fully-qualified     # 👸🏿 E2.0 princess: dark skin tone",
        "\uD83D\uDC78\uD83C\uDFFF",
        "1F473                                      ; fully-qualified     # 👳 E2.0 person wearing turban",
        "\uD83D\uDC73",
        "1F473 1F3FB                                ; fully-qualified     # 👳🏻 E2.0 person wearing turban: light skin tone",
        "\uD83D\uDC73\uD83C\uDFFB",
        "1F473 1F3FC                                ; fully-qualified     # 👳🏼 E2.0 person wearing turban: medium-light skin tone",
        "\uD83D\uDC73\uD83C\uDFFC",
        "1F473 1F3FD                                ; fully-qualified     # 👳🏽 E2.0 person wearing turban: medium skin tone",
        "\uD83D\uDC73\uD83C\uDFFD",
        "1F473 1F3FE                                ; fully-qualified     # 👳🏾 E2.0 person wearing turban: medium-dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFE",
        "1F473 1F3FF                                ; fully-qualified     # 👳🏿 E2.0 person wearing turban: dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFF",
        "1F473 200D 2642 FE0F                       ; fully-qualified     # 👳‍♂️ E4.0 man wearing turban",
        "\uD83D\uDC73\u200D\u2642\uFE0F",
        "1F473 200D 2642                            ; minimally-qualified # 👳‍♂ E4.0 man wearing turban",
        "\uD83D\uDC73\u200D\u2642",
        "1F473 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 👳🏻‍♂️ E4.0 man wearing turban: light skin tone",
        "\uD83D\uDC73\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F473 1F3FB 200D 2642                      ; minimally-qualified # 👳🏻‍♂ E4.0 man wearing turban: light skin tone",
        "\uD83D\uDC73\uD83C\uDFFB\u200D\u2642",
        "1F473 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 👳🏼‍♂️ E4.0 man wearing turban: medium-light skin tone",
        "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F473 1F3FC 200D 2642                      ; minimally-qualified # 👳🏼‍♂ E4.0 man wearing turban: medium-light skin tone",
        "\uD83D\uDC73\uD83C\uDFFC\u200D\u2642",
        "1F473 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 👳🏽‍♂️ E4.0 man wearing turban: medium skin tone",
        "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F473 1F3FD 200D 2642                      ; minimally-qualified # 👳🏽‍♂ E4.0 man wearing turban: medium skin tone",
        "\uD83D\uDC73\uD83C\uDFFD\u200D\u2642",
        "1F473 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 👳🏾‍♂️ E4.0 man wearing turban: medium-dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F473 1F3FE 200D 2642                      ; minimally-qualified # 👳🏾‍♂ E4.0 man wearing turban: medium-dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFE\u200D\u2642",
        "1F473 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 👳🏿‍♂️ E4.0 man wearing turban: dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F473 1F3FF 200D 2642                      ; minimally-qualified # 👳🏿‍♂ E4.0 man wearing turban: dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFF\u200D\u2642",
        "1F473 200D 2640 FE0F                       ; fully-qualified     # 👳‍♀️ E4.0 woman wearing turban",
        "\uD83D\uDC73\u200D\u2640\uFE0F",
        "1F473 200D 2640                            ; minimally-qualified # 👳‍♀ E4.0 woman wearing turban",
        "\uD83D\uDC73\u200D\u2640",
        "1F473 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 👳🏻‍♀️ E4.0 woman wearing turban: light skin tone",
        "\uD83D\uDC73\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F473 1F3FB 200D 2640                      ; minimally-qualified # 👳🏻‍♀ E4.0 woman wearing turban: light skin tone",
        "\uD83D\uDC73\uD83C\uDFFB\u200D\u2640",
        "1F473 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 👳🏼‍♀️ E4.0 woman wearing turban: medium-light skin tone",
        "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F473 1F3FC 200D 2640                      ; minimally-qualified # 👳🏼‍♀ E4.0 woman wearing turban: medium-light skin tone",
        "\uD83D\uDC73\uD83C\uDFFC\u200D\u2640",
        "1F473 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 👳🏽‍♀️ E4.0 woman wearing turban: medium skin tone",
        "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F473 1F3FD 200D 2640                      ; minimally-qualified # 👳🏽‍♀ E4.0 woman wearing turban: medium skin tone",
        "\uD83D\uDC73\uD83C\uDFFD\u200D\u2640",
        "1F473 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 👳🏾‍♀️ E4.0 woman wearing turban: medium-dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F473 1F3FE 200D 2640                      ; minimally-qualified # 👳🏾‍♀ E4.0 woman wearing turban: medium-dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFE\u200D\u2640",
        "1F473 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 👳🏿‍♀️ E4.0 woman wearing turban: dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F473 1F3FF 200D 2640                      ; minimally-qualified # 👳🏿‍♀ E4.0 woman wearing turban: dark skin tone",
        "\uD83D\uDC73\uD83C\uDFFF\u200D\u2640",
        "1F472                                      ; fully-qualified     # 👲 E2.0 man with skullcap",
        "\uD83D\uDC72",
        "1F472 1F3FB                                ; fully-qualified     # 👲🏻 E2.0 man with skullcap: light skin tone",
        "\uD83D\uDC72\uD83C\uDFFB",
        "1F472 1F3FC                                ; fully-qualified     # 👲🏼 E2.0 man with skullcap: medium-light skin tone",
        "\uD83D\uDC72\uD83C\uDFFC",
        "1F472 1F3FD                                ; fully-qualified     # 👲🏽 E2.0 man with skullcap: medium skin tone",
        "\uD83D\uDC72\uD83C\uDFFD",
        "1F472 1F3FE                                ; fully-qualified     # 👲🏾 E2.0 man with skullcap: medium-dark skin tone",
        "\uD83D\uDC72\uD83C\uDFFE",
        "1F472 1F3FF                                ; fully-qualified     # 👲🏿 E2.0 man with skullcap: dark skin tone",
        "\uD83D\uDC72\uD83C\uDFFF",
        "1F9D5                                      ; fully-qualified     # 🧕 E5.0 woman with headscarf",
        "\uD83E\uDDD5",
        "1F9D5 1F3FB                                ; fully-qualified     # 🧕🏻 E5.0 woman with headscarf: light skin tone",
        "\uD83E\uDDD5\uD83C\uDFFB",
        "1F9D5 1F3FC                                ; fully-qualified     # 🧕🏼 E5.0 woman with headscarf: medium-light skin tone",
        "\uD83E\uDDD5\uD83C\uDFFC",
        "1F9D5 1F3FD                                ; fully-qualified     # 🧕🏽 E5.0 woman with headscarf: medium skin tone",
        "\uD83E\uDDD5\uD83C\uDFFD",
        "1F9D5 1F3FE                                ; fully-qualified     # 🧕🏾 E5.0 woman with headscarf: medium-dark skin tone",
        "\uD83E\uDDD5\uD83C\uDFFE",
        "1F9D5 1F3FF                                ; fully-qualified     # 🧕🏿 E5.0 woman with headscarf: dark skin tone",
        "\uD83E\uDDD5\uD83C\uDFFF",
        "1F935                                      ; fully-qualified     # 🤵 E4.0 man in tuxedo",
        "\uD83E\uDD35",
        "1F935 1F3FB                                ; fully-qualified     # 🤵🏻 E4.0 man in tuxedo: light skin tone",
        "\uD83E\uDD35\uD83C\uDFFB",
        "1F935 1F3FC                                ; fully-qualified     # 🤵🏼 E4.0 man in tuxedo: medium-light skin tone",
        "\uD83E\uDD35\uD83C\uDFFC",
        "1F935 1F3FD                                ; fully-qualified     # 🤵🏽 E4.0 man in tuxedo: medium skin tone",
        "\uD83E\uDD35\uD83C\uDFFD",
        "1F935 1F3FE                                ; fully-qualified     # 🤵🏾 E4.0 man in tuxedo: medium-dark skin tone",
        "\uD83E\uDD35\uD83C\uDFFE",
        "1F935 1F3FF                                ; fully-qualified     # 🤵🏿 E4.0 man in tuxedo: dark skin tone",
        "\uD83E\uDD35\uD83C\uDFFF",
        "1F470                                      ; fully-qualified     # 👰 E2.0 bride with veil",
        "\uD83D\uDC70",
        "1F470 1F3FB                                ; fully-qualified     # 👰🏻 E2.0 bride with veil: light skin tone",
        "\uD83D\uDC70\uD83C\uDFFB",
        "1F470 1F3FC                                ; fully-qualified     # 👰🏼 E2.0 bride with veil: medium-light skin tone",
        "\uD83D\uDC70\uD83C\uDFFC",
        "1F470 1F3FD                                ; fully-qualified     # 👰🏽 E2.0 bride with veil: medium skin tone",
        "\uD83D\uDC70\uD83C\uDFFD",
        "1F470 1F3FE                                ; fully-qualified     # 👰🏾 E2.0 bride with veil: medium-dark skin tone",
        "\uD83D\uDC70\uD83C\uDFFE",
        "1F470 1F3FF                                ; fully-qualified     # 👰🏿 E2.0 bride with veil: dark skin tone",
        "\uD83D\uDC70\uD83C\uDFFF",
        "1F930                                      ; fully-qualified     # 🤰 E4.0 pregnant woman",
        "\uD83E\uDD30",
        "1F930 1F3FB                                ; fully-qualified     # 🤰🏻 E4.0 pregnant woman: light skin tone",
        "\uD83E\uDD30\uD83C\uDFFB",
        "1F930 1F3FC                                ; fully-qualified     # 🤰🏼 E4.0 pregnant woman: medium-light skin tone",
        "\uD83E\uDD30\uD83C\uDFFC",
        "1F930 1F3FD                                ; fully-qualified     # 🤰🏽 E4.0 pregnant woman: medium skin tone",
        "\uD83E\uDD30\uD83C\uDFFD",
        "1F930 1F3FE                                ; fully-qualified     # 🤰🏾 E4.0 pregnant woman: medium-dark skin tone",
        "\uD83E\uDD30\uD83C\uDFFE",
        "1F930 1F3FF                                ; fully-qualified     # 🤰🏿 E4.0 pregnant woman: dark skin tone",
        "\uD83E\uDD30\uD83C\uDFFF",
        "1F931                                      ; fully-qualified     # 🤱 E5.0 breast-feeding",
        "\uD83E\uDD31",
        "1F931 1F3FB                                ; fully-qualified     # 🤱🏻 E5.0 breast-feeding: light skin tone",
        "\uD83E\uDD31\uD83C\uDFFB",
        "1F931 1F3FC                                ; fully-qualified     # 🤱🏼 E5.0 breast-feeding: medium-light skin tone",
        "\uD83E\uDD31\uD83C\uDFFC",
        "1F931 1F3FD                                ; fully-qualified     # 🤱🏽 E5.0 breast-feeding: medium skin tone",
        "\uD83E\uDD31\uD83C\uDFFD",
        "1F931 1F3FE                                ; fully-qualified     # 🤱🏾 E5.0 breast-feeding: medium-dark skin tone",
        "\uD83E\uDD31\uD83C\uDFFE",
        "1F931 1F3FF                                ; fully-qualified     # 🤱🏿 E5.0 breast-feeding: dark skin tone",
        "\uD83E\uDD31\uD83C\uDFFF",
        "1F47C                                      ; fully-qualified     # 👼 E2.0 baby angel",
        "\uD83D\uDC7C",
        "1F47C 1F3FB                                ; fully-qualified     # 👼🏻 E2.0 baby angel: light skin tone",
        "\uD83D\uDC7C\uD83C\uDFFB",
        "1F47C 1F3FC                                ; fully-qualified     # 👼🏼 E2.0 baby angel: medium-light skin tone",
        "\uD83D\uDC7C\uD83C\uDFFC",
        "1F47C 1F3FD                                ; fully-qualified     # 👼🏽 E2.0 baby angel: medium skin tone",
        "\uD83D\uDC7C\uD83C\uDFFD",
        "1F47C 1F3FE                                ; fully-qualified     # 👼🏾 E2.0 baby angel: medium-dark skin tone",
        "\uD83D\uDC7C\uD83C\uDFFE",
        "1F47C 1F3FF                                ; fully-qualified     # 👼🏿 E2.0 baby angel: dark skin tone",
        "\uD83D\uDC7C\uD83C\uDFFF",
        "1F385                                      ; fully-qualified     # 🎅 E2.0 Santa Claus",
        "\uD83C\uDF85",
        "1F385 1F3FB                                ; fully-qualified     # 🎅🏻 E2.0 Santa Claus: light skin tone",
        "\uD83C\uDF85\uD83C\uDFFB",
        "1F385 1F3FC                                ; fully-qualified     # 🎅🏼 E2.0 Santa Claus: medium-light skin tone",
        "\uD83C\uDF85\uD83C\uDFFC",
        "1F385 1F3FD                                ; fully-qualified     # 🎅🏽 E2.0 Santa Claus: medium skin tone",
        "\uD83C\uDF85\uD83C\uDFFD",
        "1F385 1F3FE                                ; fully-qualified     # 🎅🏾 E2.0 Santa Claus: medium-dark skin tone",
        "\uD83C\uDF85\uD83C\uDFFE",
        "1F385 1F3FF                                ; fully-qualified     # 🎅🏿 E2.0 Santa Claus: dark skin tone",
        "\uD83C\uDF85\uD83C\uDFFF",
        "1F936                                      ; fully-qualified     # 🤶 E4.0 Mrs. Claus",
        "\uD83E\uDD36",
        "1F936 1F3FB                                ; fully-qualified     # 🤶🏻 E4.0 Mrs. Claus: light skin tone",
        "\uD83E\uDD36\uD83C\uDFFB",
        "1F936 1F3FC                                ; fully-qualified     # 🤶🏼 E4.0 Mrs. Claus: medium-light skin tone",
        "\uD83E\uDD36\uD83C\uDFFC",
        "1F936 1F3FD                                ; fully-qualified     # 🤶🏽 E4.0 Mrs. Claus: medium skin tone",
        "\uD83E\uDD36\uD83C\uDFFD",
        "1F936 1F3FE                                ; fully-qualified     # 🤶🏾 E4.0 Mrs. Claus: medium-dark skin tone",
        "\uD83E\uDD36\uD83C\uDFFE",
        "1F936 1F3FF                                ; fully-qualified     # 🤶🏿 E4.0 Mrs. Claus: dark skin tone",
        "\uD83E\uDD36\uD83C\uDFFF",
        "1F9B8                                      ; fully-qualified     # 🦸 E11.0 superhero",
        "\uD83E\uDDB8",
        "1F9B8 1F3FB                                ; fully-qualified     # 🦸🏻 E11.0 superhero: light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFB",
        "1F9B8 1F3FC                                ; fully-qualified     # 🦸🏼 E11.0 superhero: medium-light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFC",
        "1F9B8 1F3FD                                ; fully-qualified     # 🦸🏽 E11.0 superhero: medium skin tone",
        "\uD83E\uDDB8\uD83C\uDFFD",
        "1F9B8 1F3FE                                ; fully-qualified     # 🦸🏾 E11.0 superhero: medium-dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFE",
        "1F9B8 1F3FF                                ; fully-qualified     # 🦸🏿 E11.0 superhero: dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFF",
        "1F9B8 200D 2642 FE0F                       ; fully-qualified     # 🦸‍♂️ E11.0 man superhero",
        "\uD83E\uDDB8\u200D\u2642\uFE0F",
        "1F9B8 200D 2642                            ; minimally-qualified # 🦸‍♂ E11.0 man superhero",
        "\uD83E\uDDB8\u200D\u2642",
        "1F9B8 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🦸🏻‍♂️ E11.0 man superhero: light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9B8 1F3FB 200D 2642                      ; minimally-qualified # 🦸🏻‍♂ E11.0 man superhero: light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2642",
        "1F9B8 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🦸🏼‍♂️ E11.0 man superhero: medium-light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9B8 1F3FC 200D 2642                      ; minimally-qualified # 🦸🏼‍♂ E11.0 man superhero: medium-light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2642",
        "1F9B8 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🦸🏽‍♂️ E11.0 man superhero: medium skin tone",
        "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9B8 1F3FD 200D 2642                      ; minimally-qualified # 🦸🏽‍♂ E11.0 man superhero: medium skin tone",
        "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2642",
        "1F9B8 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🦸🏾‍♂️ E11.0 man superhero: medium-dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9B8 1F3FE 200D 2642                      ; minimally-qualified # 🦸🏾‍♂ E11.0 man superhero: medium-dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2642",
        "1F9B8 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🦸🏿‍♂️ E11.0 man superhero: dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9B8 1F3FF 200D 2642                      ; minimally-qualified # 🦸🏿‍♂ E11.0 man superhero: dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2642",
        "1F9B8 200D 2640 FE0F                       ; fully-qualified     # 🦸‍♀️ E11.0 woman superhero",
        "\uD83E\uDDB8\u200D\u2640\uFE0F",
        "1F9B8 200D 2640                            ; minimally-qualified # 🦸‍♀ E11.0 woman superhero",
        "\uD83E\uDDB8\u200D\u2640",
        "1F9B8 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🦸🏻‍♀️ E11.0 woman superhero: light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9B8 1F3FB 200D 2640                      ; minimally-qualified # 🦸🏻‍♀ E11.0 woman superhero: light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFB\u200D\u2640",
        "1F9B8 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🦸🏼‍♀️ E11.0 woman superhero: medium-light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9B8 1F3FC 200D 2640                      ; minimally-qualified # 🦸🏼‍♀ E11.0 woman superhero: medium-light skin tone",
        "\uD83E\uDDB8\uD83C\uDFFC\u200D\u2640",
        "1F9B8 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🦸🏽‍♀️ E11.0 woman superhero: medium skin tone",
        "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9B8 1F3FD 200D 2640                      ; minimally-qualified # 🦸🏽‍♀ E11.0 woman superhero: medium skin tone",
        "\uD83E\uDDB8\uD83C\uDFFD\u200D\u2640",
        "1F9B8 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🦸🏾‍♀️ E11.0 woman superhero: medium-dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9B8 1F3FE 200D 2640                      ; minimally-qualified # 🦸🏾‍♀ E11.0 woman superhero: medium-dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFE\u200D\u2640",
        "1F9B8 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🦸🏿‍♀️ E11.0 woman superhero: dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9B8 1F3FF 200D 2640                      ; minimally-qualified # 🦸🏿‍♀ E11.0 woman superhero: dark skin tone",
        "\uD83E\uDDB8\uD83C\uDFFF\u200D\u2640",
        "1F9B9                                      ; fully-qualified     # 🦹 E11.0 supervillain",
        "\uD83E\uDDB9",
        "1F9B9 1F3FB                                ; fully-qualified     # 🦹🏻 E11.0 supervillain: light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFB",
        "1F9B9 1F3FC                                ; fully-qualified     # 🦹🏼 E11.0 supervillain: medium-light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFC",
        "1F9B9 1F3FD                                ; fully-qualified     # 🦹🏽 E11.0 supervillain: medium skin tone",
        "\uD83E\uDDB9\uD83C\uDFFD",
        "1F9B9 1F3FE                                ; fully-qualified     # 🦹🏾 E11.0 supervillain: medium-dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFE",
        "1F9B9 1F3FF                                ; fully-qualified     # 🦹🏿 E11.0 supervillain: dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFF",
        "1F9B9 200D 2642 FE0F                       ; fully-qualified     # 🦹‍♂️ E11.0 man supervillain",
        "\uD83E\uDDB9\u200D\u2642\uFE0F",
        "1F9B9 200D 2642                            ; minimally-qualified # 🦹‍♂ E11.0 man supervillain",
        "\uD83E\uDDB9\u200D\u2642",
        "1F9B9 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🦹🏻‍♂️ E11.0 man supervillain: light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9B9 1F3FB 200D 2642                      ; minimally-qualified # 🦹🏻‍♂ E11.0 man supervillain: light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2642",
        "1F9B9 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🦹🏼‍♂️ E11.0 man supervillain: medium-light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9B9 1F3FC 200D 2642                      ; minimally-qualified # 🦹🏼‍♂ E11.0 man supervillain: medium-light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2642",
        "1F9B9 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🦹🏽‍♂️ E11.0 man supervillain: medium skin tone",
        "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9B9 1F3FD 200D 2642                      ; minimally-qualified # 🦹🏽‍♂ E11.0 man supervillain: medium skin tone",
        "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2642",
        "1F9B9 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🦹🏾‍♂️ E11.0 man supervillain: medium-dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9B9 1F3FE 200D 2642                      ; minimally-qualified # 🦹🏾‍♂ E11.0 man supervillain: medium-dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2642",
        "1F9B9 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🦹🏿‍♂️ E11.0 man supervillain: dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9B9 1F3FF 200D 2642                      ; minimally-qualified # 🦹🏿‍♂ E11.0 man supervillain: dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2642",
        "1F9B9 200D 2640 FE0F                       ; fully-qualified     # 🦹‍♀️ E11.0 woman supervillain",
        "\uD83E\uDDB9\u200D\u2640\uFE0F",
        "1F9B9 200D 2640                            ; minimally-qualified # 🦹‍♀ E11.0 woman supervillain",
        "\uD83E\uDDB9\u200D\u2640",
        "1F9B9 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🦹🏻‍♀️ E11.0 woman supervillain: light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9B9 1F3FB 200D 2640                      ; minimally-qualified # 🦹🏻‍♀ E11.0 woman supervillain: light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFB\u200D\u2640",
        "1F9B9 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🦹🏼‍♀️ E11.0 woman supervillain: medium-light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9B9 1F3FC 200D 2640                      ; minimally-qualified # 🦹🏼‍♀ E11.0 woman supervillain: medium-light skin tone",
        "\uD83E\uDDB9\uD83C\uDFFC\u200D\u2640",
        "1F9B9 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🦹🏽‍♀️ E11.0 woman supervillain: medium skin tone",
        "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9B9 1F3FD 200D 2640                      ; minimally-qualified # 🦹🏽‍♀ E11.0 woman supervillain: medium skin tone",
        "\uD83E\uDDB9\uD83C\uDFFD\u200D\u2640",
        "1F9B9 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🦹🏾‍♀️ E11.0 woman supervillain: medium-dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9B9 1F3FE 200D 2640                      ; minimally-qualified # 🦹🏾‍♀ E11.0 woman supervillain: medium-dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFE\u200D\u2640",
        "1F9B9 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🦹🏿‍♀️ E11.0 woman supervillain: dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9B9 1F3FF 200D 2640                      ; minimally-qualified # 🦹🏿‍♀ E11.0 woman supervillain: dark skin tone",
        "\uD83E\uDDB9\uD83C\uDFFF\u200D\u2640",
        "1F9D9                                      ; fully-qualified     # 🧙 E5.0 mage",
        "\uD83E\uDDD9",
        "1F9D9 1F3FB                                ; fully-qualified     # 🧙🏻 E5.0 mage: light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFB",
        "1F9D9 1F3FC                                ; fully-qualified     # 🧙🏼 E5.0 mage: medium-light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFC",
        "1F9D9 1F3FD                                ; fully-qualified     # 🧙🏽 E5.0 mage: medium skin tone",
        "\uD83E\uDDD9\uD83C\uDFFD",
        "1F9D9 1F3FE                                ; fully-qualified     # 🧙🏾 E5.0 mage: medium-dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFE",
        "1F9D9 1F3FF                                ; fully-qualified     # 🧙🏿 E5.0 mage: dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFF",
        "1F9D9 200D 2642 FE0F                       ; fully-qualified     # 🧙‍♂️ E5.0 man mage",
        "\uD83E\uDDD9\u200D\u2642\uFE0F",
        "1F9D9 200D 2642                            ; minimally-qualified # 🧙‍♂ E5.0 man mage",
        "\uD83E\uDDD9\u200D\u2642",
        "1F9D9 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧙🏻‍♂️ E5.0 man mage: light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9D9 1F3FB 200D 2642                      ; minimally-qualified # 🧙🏻‍♂ E5.0 man mage: light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2642",
        "1F9D9 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧙🏼‍♂️ E5.0 man mage: medium-light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9D9 1F3FC 200D 2642                      ; minimally-qualified # 🧙🏼‍♂ E5.0 man mage: medium-light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2642",
        "1F9D9 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧙🏽‍♂️ E5.0 man mage: medium skin tone",
        "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9D9 1F3FD 200D 2642                      ; minimally-qualified # 🧙🏽‍♂ E5.0 man mage: medium skin tone",
        "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2642",
        "1F9D9 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧙🏾‍♂️ E5.0 man mage: medium-dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9D9 1F3FE 200D 2642                      ; minimally-qualified # 🧙🏾‍♂ E5.0 man mage: medium-dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2642",
        "1F9D9 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧙🏿‍♂️ E5.0 man mage: dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9D9 1F3FF 200D 2642                      ; minimally-qualified # 🧙🏿‍♂ E5.0 man mage: dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2642",
        "1F9D9 200D 2640 FE0F                       ; fully-qualified     # 🧙‍♀️ E5.0 woman mage",
        "\uD83E\uDDD9\u200D\u2640\uFE0F",
        "1F9D9 200D 2640                            ; minimally-qualified # 🧙‍♀ E5.0 woman mage",
        "\uD83E\uDDD9\u200D\u2640",
        "1F9D9 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧙🏻‍♀️ E5.0 woman mage: light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9D9 1F3FB 200D 2640                      ; minimally-qualified # 🧙🏻‍♀ E5.0 woman mage: light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFB\u200D\u2640",
        "1F9D9 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧙🏼‍♀️ E5.0 woman mage: medium-light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9D9 1F3FC 200D 2640                      ; minimally-qualified # 🧙🏼‍♀ E5.0 woman mage: medium-light skin tone",
        "\uD83E\uDDD9\uD83C\uDFFC\u200D\u2640",
        "1F9D9 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧙🏽‍♀️ E5.0 woman mage: medium skin tone",
        "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9D9 1F3FD 200D 2640                      ; minimally-qualified # 🧙🏽‍♀ E5.0 woman mage: medium skin tone",
        "\uD83E\uDDD9\uD83C\uDFFD\u200D\u2640",
        "1F9D9 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧙🏾‍♀️ E5.0 woman mage: medium-dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9D9 1F3FE 200D 2640                      ; minimally-qualified # 🧙🏾‍♀ E5.0 woman mage: medium-dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFE\u200D\u2640",
        "1F9D9 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧙🏿‍♀️ E5.0 woman mage: dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9D9 1F3FF 200D 2640                      ; minimally-qualified # 🧙🏿‍♀ E5.0 woman mage: dark skin tone",
        "\uD83E\uDDD9\uD83C\uDFFF\u200D\u2640",
        "1F9DA                                      ; fully-qualified     # 🧚 E5.0 fairy",
        "\uD83E\uDDDA",
        "1F9DA 1F3FB                                ; fully-qualified     # 🧚🏻 E5.0 fairy: light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFB",
        "1F9DA 1F3FC                                ; fully-qualified     # 🧚🏼 E5.0 fairy: medium-light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFC",
        "1F9DA 1F3FD                                ; fully-qualified     # 🧚🏽 E5.0 fairy: medium skin tone",
        "\uD83E\uDDDA\uD83C\uDFFD",
        "1F9DA 1F3FE                                ; fully-qualified     # 🧚🏾 E5.0 fairy: medium-dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFE",
        "1F9DA 1F3FF                                ; fully-qualified     # 🧚🏿 E5.0 fairy: dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFF",
        "1F9DA 200D 2642 FE0F                       ; fully-qualified     # 🧚‍♂️ E5.0 man fairy",
        "\uD83E\uDDDA\u200D\u2642\uFE0F",
        "1F9DA 200D 2642                            ; minimally-qualified # 🧚‍♂ E5.0 man fairy",
        "\uD83E\uDDDA\u200D\u2642",
        "1F9DA 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧚🏻‍♂️ E5.0 man fairy: light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9DA 1F3FB 200D 2642                      ; minimally-qualified # 🧚🏻‍♂ E5.0 man fairy: light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2642",
        "1F9DA 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧚🏼‍♂️ E5.0 man fairy: medium-light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9DA 1F3FC 200D 2642                      ; minimally-qualified # 🧚🏼‍♂ E5.0 man fairy: medium-light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2642",
        "1F9DA 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧚🏽‍♂️ E5.0 man fairy: medium skin tone",
        "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9DA 1F3FD 200D 2642                      ; minimally-qualified # 🧚🏽‍♂ E5.0 man fairy: medium skin tone",
        "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2642",
        "1F9DA 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧚🏾‍♂️ E5.0 man fairy: medium-dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9DA 1F3FE 200D 2642                      ; minimally-qualified # 🧚🏾‍♂ E5.0 man fairy: medium-dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2642",
        "1F9DA 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧚🏿‍♂️ E5.0 man fairy: dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9DA 1F3FF 200D 2642                      ; minimally-qualified # 🧚🏿‍♂ E5.0 man fairy: dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2642",
        "1F9DA 200D 2640 FE0F                       ; fully-qualified     # 🧚‍♀️ E5.0 woman fairy",
        "\uD83E\uDDDA\u200D\u2640\uFE0F",
        "1F9DA 200D 2640                            ; minimally-qualified # 🧚‍♀ E5.0 woman fairy",
        "\uD83E\uDDDA\u200D\u2640",
        "1F9DA 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧚🏻‍♀️ E5.0 woman fairy: light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9DA 1F3FB 200D 2640                      ; minimally-qualified # 🧚🏻‍♀ E5.0 woman fairy: light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFB\u200D\u2640",
        "1F9DA 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧚🏼‍♀️ E5.0 woman fairy: medium-light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9DA 1F3FC 200D 2640                      ; minimally-qualified # 🧚🏼‍♀ E5.0 woman fairy: medium-light skin tone",
        "\uD83E\uDDDA\uD83C\uDFFC\u200D\u2640",
        "1F9DA 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧚🏽‍♀️ E5.0 woman fairy: medium skin tone",
        "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9DA 1F3FD 200D 2640                      ; minimally-qualified # 🧚🏽‍♀ E5.0 woman fairy: medium skin tone",
        "\uD83E\uDDDA\uD83C\uDFFD\u200D\u2640",
        "1F9DA 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧚🏾‍♀️ E5.0 woman fairy: medium-dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9DA 1F3FE 200D 2640                      ; minimally-qualified # 🧚🏾‍♀ E5.0 woman fairy: medium-dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFE\u200D\u2640",
        "1F9DA 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧚🏿‍♀️ E5.0 woman fairy: dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9DA 1F3FF 200D 2640                      ; minimally-qualified # 🧚🏿‍♀ E5.0 woman fairy: dark skin tone",
        "\uD83E\uDDDA\uD83C\uDFFF\u200D\u2640",
        "1F9DB                                      ; fully-qualified     # 🧛 E5.0 vampire",
        "\uD83E\uDDDB",
        "1F9DB 1F3FB                                ; fully-qualified     # 🧛🏻 E5.0 vampire: light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFB",
        "1F9DB 1F3FC                                ; fully-qualified     # 🧛🏼 E5.0 vampire: medium-light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFC",
        "1F9DB 1F3FD                                ; fully-qualified     # 🧛🏽 E5.0 vampire: medium skin tone",
        "\uD83E\uDDDB\uD83C\uDFFD",
        "1F9DB 1F3FE                                ; fully-qualified     # 🧛🏾 E5.0 vampire: medium-dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFE",
        "1F9DB 1F3FF                                ; fully-qualified     # 🧛🏿 E5.0 vampire: dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFF",
        "1F9DB 200D 2642 FE0F                       ; fully-qualified     # 🧛‍♂️ E5.0 man vampire",
        "\uD83E\uDDDB\u200D\u2642\uFE0F",
        "1F9DB 200D 2642                            ; minimally-qualified # 🧛‍♂ E5.0 man vampire",
        "\uD83E\uDDDB\u200D\u2642",
        "1F9DB 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧛🏻‍♂️ E5.0 man vampire: light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9DB 1F3FB 200D 2642                      ; minimally-qualified # 🧛🏻‍♂ E5.0 man vampire: light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2642",
        "1F9DB 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧛🏼‍♂️ E5.0 man vampire: medium-light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9DB 1F3FC 200D 2642                      ; minimally-qualified # 🧛🏼‍♂ E5.0 man vampire: medium-light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2642",
        "1F9DB 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧛🏽‍♂️ E5.0 man vampire: medium skin tone",
        "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9DB 1F3FD 200D 2642                      ; minimally-qualified # 🧛🏽‍♂ E5.0 man vampire: medium skin tone",
        "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2642",
        "1F9DB 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧛🏾‍♂️ E5.0 man vampire: medium-dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9DB 1F3FE 200D 2642                      ; minimally-qualified # 🧛🏾‍♂ E5.0 man vampire: medium-dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2642",
        "1F9DB 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧛🏿‍♂️ E5.0 man vampire: dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9DB 1F3FF 200D 2642                      ; minimally-qualified # 🧛🏿‍♂ E5.0 man vampire: dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2642",
        "1F9DB 200D 2640 FE0F                       ; fully-qualified     # 🧛‍♀️ E5.0 woman vampire",
        "\uD83E\uDDDB\u200D\u2640\uFE0F",
        "1F9DB 200D 2640                            ; minimally-qualified # 🧛‍♀ E5.0 woman vampire",
        "\uD83E\uDDDB\u200D\u2640",
        "1F9DB 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧛🏻‍♀️ E5.0 woman vampire: light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9DB 1F3FB 200D 2640                      ; minimally-qualified # 🧛🏻‍♀ E5.0 woman vampire: light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFB\u200D\u2640",
        "1F9DB 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧛🏼‍♀️ E5.0 woman vampire: medium-light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9DB 1F3FC 200D 2640                      ; minimally-qualified # 🧛🏼‍♀ E5.0 woman vampire: medium-light skin tone",
        "\uD83E\uDDDB\uD83C\uDFFC\u200D\u2640",
        "1F9DB 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧛🏽‍♀️ E5.0 woman vampire: medium skin tone",
        "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9DB 1F3FD 200D 2640                      ; minimally-qualified # 🧛🏽‍♀ E5.0 woman vampire: medium skin tone",
        "\uD83E\uDDDB\uD83C\uDFFD\u200D\u2640",
        "1F9DB 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧛🏾‍♀️ E5.0 woman vampire: medium-dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9DB 1F3FE 200D 2640                      ; minimally-qualified # 🧛🏾‍♀ E5.0 woman vampire: medium-dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFE\u200D\u2640",
        "1F9DB 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧛🏿‍♀️ E5.0 woman vampire: dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9DB 1F3FF 200D 2640                      ; minimally-qualified # 🧛🏿‍♀ E5.0 woman vampire: dark skin tone",
        "\uD83E\uDDDB\uD83C\uDFFF\u200D\u2640",
        "1F9DC                                      ; fully-qualified     # 🧜 E5.0 merperson",
        "\uD83E\uDDDC",
        "1F9DC 1F3FB                                ; fully-qualified     # 🧜🏻 E5.0 merperson: light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFB",
        "1F9DC 1F3FC                                ; fully-qualified     # 🧜🏼 E5.0 merperson: medium-light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFC",
        "1F9DC 1F3FD                                ; fully-qualified     # 🧜🏽 E5.0 merperson: medium skin tone",
        "\uD83E\uDDDC\uD83C\uDFFD",
        "1F9DC 1F3FE                                ; fully-qualified     # 🧜🏾 E5.0 merperson: medium-dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFE",
        "1F9DC 1F3FF                                ; fully-qualified     # 🧜🏿 E5.0 merperson: dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFF",
        "1F9DC 200D 2642 FE0F                       ; fully-qualified     # 🧜‍♂️ E5.0 merman",
        "\uD83E\uDDDC\u200D\u2642\uFE0F",
        "1F9DC 200D 2642                            ; minimally-qualified # 🧜‍♂ E5.0 merman",
        "\uD83E\uDDDC\u200D\u2642",
        "1F9DC 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧜🏻‍♂️ E5.0 merman: light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9DC 1F3FB 200D 2642                      ; minimally-qualified # 🧜🏻‍♂ E5.0 merman: light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2642",
        "1F9DC 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧜🏼‍♂️ E5.0 merman: medium-light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9DC 1F3FC 200D 2642                      ; minimally-qualified # 🧜🏼‍♂ E5.0 merman: medium-light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2642",
        "1F9DC 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧜🏽‍♂️ E5.0 merman: medium skin tone",
        "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9DC 1F3FD 200D 2642                      ; minimally-qualified # 🧜🏽‍♂ E5.0 merman: medium skin tone",
        "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2642",
        "1F9DC 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧜🏾‍♂️ E5.0 merman: medium-dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9DC 1F3FE 200D 2642                      ; minimally-qualified # 🧜🏾‍♂ E5.0 merman: medium-dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2642",
        "1F9DC 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧜🏿‍♂️ E5.0 merman: dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9DC 1F3FF 200D 2642                      ; minimally-qualified # 🧜🏿‍♂ E5.0 merman: dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2642",
        "1F9DC 200D 2640 FE0F                       ; fully-qualified     # 🧜‍♀️ E5.0 mermaid",
        "\uD83E\uDDDC\u200D\u2640\uFE0F",
        "1F9DC 200D 2640                            ; minimally-qualified # 🧜‍♀ E5.0 mermaid",
        "\uD83E\uDDDC\u200D\u2640",
        "1F9DC 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧜🏻‍♀️ E5.0 mermaid: light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9DC 1F3FB 200D 2640                      ; minimally-qualified # 🧜🏻‍♀ E5.0 mermaid: light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFB\u200D\u2640",
        "1F9DC 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧜🏼‍♀️ E5.0 mermaid: medium-light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9DC 1F3FC 200D 2640                      ; minimally-qualified # 🧜🏼‍♀ E5.0 mermaid: medium-light skin tone",
        "\uD83E\uDDDC\uD83C\uDFFC\u200D\u2640",
        "1F9DC 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧜🏽‍♀️ E5.0 mermaid: medium skin tone",
        "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9DC 1F3FD 200D 2640                      ; minimally-qualified # 🧜🏽‍♀ E5.0 mermaid: medium skin tone",
        "\uD83E\uDDDC\uD83C\uDFFD\u200D\u2640",
        "1F9DC 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧜🏾‍♀️ E5.0 mermaid: medium-dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9DC 1F3FE 200D 2640                      ; minimally-qualified # 🧜🏾‍♀ E5.0 mermaid: medium-dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFE\u200D\u2640",
        "1F9DC 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧜🏿‍♀️ E5.0 mermaid: dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9DC 1F3FF 200D 2640                      ; minimally-qualified # 🧜🏿‍♀ E5.0 mermaid: dark skin tone",
        "\uD83E\uDDDC\uD83C\uDFFF\u200D\u2640",
        "1F9DD                                      ; fully-qualified     # 🧝 E5.0 elf",
        "\uD83E\uDDDD",
        "1F9DD 1F3FB                                ; fully-qualified     # 🧝🏻 E5.0 elf: light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFB",
        "1F9DD 1F3FC                                ; fully-qualified     # 🧝🏼 E5.0 elf: medium-light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFC",
        "1F9DD 1F3FD                                ; fully-qualified     # 🧝🏽 E5.0 elf: medium skin tone",
        "\uD83E\uDDDD\uD83C\uDFFD",
        "1F9DD 1F3FE                                ; fully-qualified     # 🧝🏾 E5.0 elf: medium-dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFE",
        "1F9DD 1F3FF                                ; fully-qualified     # 🧝🏿 E5.0 elf: dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFF",
        "1F9DD 200D 2642 FE0F                       ; fully-qualified     # 🧝‍♂️ E5.0 man elf",
        "\uD83E\uDDDD\u200D\u2642\uFE0F",
        "1F9DD 200D 2642                            ; minimally-qualified # 🧝‍♂ E5.0 man elf",
        "\uD83E\uDDDD\u200D\u2642",
        "1F9DD 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧝🏻‍♂️ E5.0 man elf: light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9DD 1F3FB 200D 2642                      ; minimally-qualified # 🧝🏻‍♂ E5.0 man elf: light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2642",
        "1F9DD 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧝🏼‍♂️ E5.0 man elf: medium-light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9DD 1F3FC 200D 2642                      ; minimally-qualified # 🧝🏼‍♂ E5.0 man elf: medium-light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2642",
        "1F9DD 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧝🏽‍♂️ E5.0 man elf: medium skin tone",
        "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9DD 1F3FD 200D 2642                      ; minimally-qualified # 🧝🏽‍♂ E5.0 man elf: medium skin tone",
        "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2642",
        "1F9DD 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧝🏾‍♂️ E5.0 man elf: medium-dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9DD 1F3FE 200D 2642                      ; minimally-qualified # 🧝🏾‍♂ E5.0 man elf: medium-dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2642",
        "1F9DD 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧝🏿‍♂️ E5.0 man elf: dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9DD 1F3FF 200D 2642                      ; minimally-qualified # 🧝🏿‍♂ E5.0 man elf: dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2642",
        "1F9DD 200D 2640 FE0F                       ; fully-qualified     # 🧝‍♀️ E5.0 woman elf",
        "\uD83E\uDDDD\u200D\u2640\uFE0F",
        "1F9DD 200D 2640                            ; minimally-qualified # 🧝‍♀ E5.0 woman elf",
        "\uD83E\uDDDD\u200D\u2640",
        "1F9DD 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧝🏻‍♀️ E5.0 woman elf: light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9DD 1F3FB 200D 2640                      ; minimally-qualified # 🧝🏻‍♀ E5.0 woman elf: light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFB\u200D\u2640",
        "1F9DD 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧝🏼‍♀️ E5.0 woman elf: medium-light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9DD 1F3FC 200D 2640                      ; minimally-qualified # 🧝🏼‍♀ E5.0 woman elf: medium-light skin tone",
        "\uD83E\uDDDD\uD83C\uDFFC\u200D\u2640",
        "1F9DD 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧝🏽‍♀️ E5.0 woman elf: medium skin tone",
        "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9DD 1F3FD 200D 2640                      ; minimally-qualified # 🧝🏽‍♀ E5.0 woman elf: medium skin tone",
        "\uD83E\uDDDD\uD83C\uDFFD\u200D\u2640",
        "1F9DD 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧝🏾‍♀️ E5.0 woman elf: medium-dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9DD 1F3FE 200D 2640                      ; minimally-qualified # 🧝🏾‍♀ E5.0 woman elf: medium-dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFE\u200D\u2640",
        "1F9DD 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧝🏿‍♀️ E5.0 woman elf: dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9DD 1F3FF 200D 2640                      ; minimally-qualified # 🧝🏿‍♀ E5.0 woman elf: dark skin tone",
        "\uD83E\uDDDD\uD83C\uDFFF\u200D\u2640",
        "1F9DE                                      ; fully-qualified     # 🧞 E5.0 genie",
        "\uD83E\uDDDE",
        "1F9DE 200D 2642 FE0F                       ; fully-qualified     # 🧞‍♂️ E5.0 man genie",
        "\uD83E\uDDDE\u200D\u2642\uFE0F",
        "1F9DE 200D 2642                            ; minimally-qualified # 🧞‍♂ E5.0 man genie",
        "\uD83E\uDDDE\u200D\u2642",
        "1F9DE 200D 2640 FE0F                       ; fully-qualified     # 🧞‍♀️ E5.0 woman genie",
        "\uD83E\uDDDE\u200D\u2640\uFE0F",
        "1F9DE 200D 2640                            ; minimally-qualified # 🧞‍♀ E5.0 woman genie",
        "\uD83E\uDDDE\u200D\u2640",
        "1F9DF                                      ; fully-qualified     # 🧟 E5.0 zombie",
        "\uD83E\uDDDF",
        "1F9DF 200D 2642 FE0F                       ; fully-qualified     # 🧟‍♂️ E5.0 man zombie",
        "\uD83E\uDDDF\u200D\u2642\uFE0F",
        "1F9DF 200D 2642                            ; minimally-qualified # 🧟‍♂ E5.0 man zombie",
        "\uD83E\uDDDF\u200D\u2642",
        "1F9DF 200D 2640 FE0F                       ; fully-qualified     # 🧟‍♀️ E5.0 woman zombie",
        "\uD83E\uDDDF\u200D\u2640\uFE0F",
        "1F9DF 200D 2640                            ; minimally-qualified # 🧟‍♀ E5.0 woman zombie",
        "\uD83E\uDDDF\u200D\u2640",
        "1F486                                      ; fully-qualified     # 💆 E2.0 person getting massage",
        "\uD83D\uDC86",
        "1F486 1F3FB                                ; fully-qualified     # 💆🏻 E2.0 person getting massage: light skin tone",
        "\uD83D\uDC86\uD83C\uDFFB",
        "1F486 1F3FC                                ; fully-qualified     # 💆🏼 E2.0 person getting massage: medium-light skin tone",
        "\uD83D\uDC86\uD83C\uDFFC",
        "1F486 1F3FD                                ; fully-qualified     # 💆🏽 E2.0 person getting massage: medium skin tone",
        "\uD83D\uDC86\uD83C\uDFFD",
        "1F486 1F3FE                                ; fully-qualified     # 💆🏾 E2.0 person getting massage: medium-dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFE",
        "1F486 1F3FF                                ; fully-qualified     # 💆🏿 E2.0 person getting massage: dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFF",
        "1F486 200D 2642 FE0F                       ; fully-qualified     # 💆‍♂️ E4.0 man getting massage",
        "\uD83D\uDC86\u200D\u2642\uFE0F",
        "1F486 200D 2642                            ; minimally-qualified # 💆‍♂ E4.0 man getting massage",
        "\uD83D\uDC86\u200D\u2642",
        "1F486 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💆🏻‍♂️ E4.0 man getting massage: light skin tone",
        "\uD83D\uDC86\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F486 1F3FB 200D 2642                      ; minimally-qualified # 💆🏻‍♂ E4.0 man getting massage: light skin tone",
        "\uD83D\uDC86\uD83C\uDFFB\u200D\u2642",
        "1F486 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💆🏼‍♂️ E4.0 man getting massage: medium-light skin tone",
        "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F486 1F3FC 200D 2642                      ; minimally-qualified # 💆🏼‍♂ E4.0 man getting massage: medium-light skin tone",
        "\uD83D\uDC86\uD83C\uDFFC\u200D\u2642",
        "1F486 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💆🏽‍♂️ E4.0 man getting massage: medium skin tone",
        "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F486 1F3FD 200D 2642                      ; minimally-qualified # 💆🏽‍♂ E4.0 man getting massage: medium skin tone",
        "\uD83D\uDC86\uD83C\uDFFD\u200D\u2642",
        "1F486 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💆🏾‍♂️ E4.0 man getting massage: medium-dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F486 1F3FE 200D 2642                      ; minimally-qualified # 💆🏾‍♂ E4.0 man getting massage: medium-dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFE\u200D\u2642",
        "1F486 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💆🏿‍♂️ E4.0 man getting massage: dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F486 1F3FF 200D 2642                      ; minimally-qualified # 💆🏿‍♂ E4.0 man getting massage: dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFF\u200D\u2642",
        "1F486 200D 2640 FE0F                       ; fully-qualified     # 💆‍♀️ E4.0 woman getting massage",
        "\uD83D\uDC86\u200D\u2640\uFE0F",
        "1F486 200D 2640                            ; minimally-qualified # 💆‍♀ E4.0 woman getting massage",
        "\uD83D\uDC86\u200D\u2640",
        "1F486 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💆🏻‍♀️ E4.0 woman getting massage: light skin tone",
        "\uD83D\uDC86\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F486 1F3FB 200D 2640                      ; minimally-qualified # 💆🏻‍♀ E4.0 woman getting massage: light skin tone",
        "\uD83D\uDC86\uD83C\uDFFB\u200D\u2640",
        "1F486 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💆🏼‍♀️ E4.0 woman getting massage: medium-light skin tone",
        "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F486 1F3FC 200D 2640                      ; minimally-qualified # 💆🏼‍♀ E4.0 woman getting massage: medium-light skin tone",
        "\uD83D\uDC86\uD83C\uDFFC\u200D\u2640",
        "1F486 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💆🏽‍♀️ E4.0 woman getting massage: medium skin tone",
        "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F486 1F3FD 200D 2640                      ; minimally-qualified # 💆🏽‍♀ E4.0 woman getting massage: medium skin tone",
        "\uD83D\uDC86\uD83C\uDFFD\u200D\u2640",
        "1F486 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💆🏾‍♀️ E4.0 woman getting massage: medium-dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F486 1F3FE 200D 2640                      ; minimally-qualified # 💆🏾‍♀ E4.0 woman getting massage: medium-dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFE\u200D\u2640",
        "1F486 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💆🏿‍♀️ E4.0 woman getting massage: dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F486 1F3FF 200D 2640                      ; minimally-qualified # 💆🏿‍♀ E4.0 woman getting massage: dark skin tone",
        "\uD83D\uDC86\uD83C\uDFFF\u200D\u2640",
        "1F487                                      ; fully-qualified     # 💇 E2.0 person getting haircut",
        "\uD83D\uDC87",
        "1F487 1F3FB                                ; fully-qualified     # 💇🏻 E2.0 person getting haircut: light skin tone",
        "\uD83D\uDC87\uD83C\uDFFB",
        "1F487 1F3FC                                ; fully-qualified     # 💇🏼 E2.0 person getting haircut: medium-light skin tone",
        "\uD83D\uDC87\uD83C\uDFFC",
        "1F487 1F3FD                                ; fully-qualified     # 💇🏽 E2.0 person getting haircut: medium skin tone",
        "\uD83D\uDC87\uD83C\uDFFD",
        "1F487 1F3FE                                ; fully-qualified     # 💇🏾 E2.0 person getting haircut: medium-dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFE",
        "1F487 1F3FF                                ; fully-qualified     # 💇🏿 E2.0 person getting haircut: dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFF",
        "1F487 200D 2642 FE0F                       ; fully-qualified     # 💇‍♂️ E4.0 man getting haircut",
        "\uD83D\uDC87\u200D\u2642\uFE0F",
        "1F487 200D 2642                            ; minimally-qualified # 💇‍♂ E4.0 man getting haircut",
        "\uD83D\uDC87\u200D\u2642",
        "1F487 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 💇🏻‍♂️ E4.0 man getting haircut: light skin tone",
        "\uD83D\uDC87\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F487 1F3FB 200D 2642                      ; minimally-qualified # 💇🏻‍♂ E4.0 man getting haircut: light skin tone",
        "\uD83D\uDC87\uD83C\uDFFB\u200D\u2642",
        "1F487 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 💇🏼‍♂️ E4.0 man getting haircut: medium-light skin tone",
        "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F487 1F3FC 200D 2642                      ; minimally-qualified # 💇🏼‍♂ E4.0 man getting haircut: medium-light skin tone",
        "\uD83D\uDC87\uD83C\uDFFC\u200D\u2642",
        "1F487 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 💇🏽‍♂️ E4.0 man getting haircut: medium skin tone",
        "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F487 1F3FD 200D 2642                      ; minimally-qualified # 💇🏽‍♂ E4.0 man getting haircut: medium skin tone",
        "\uD83D\uDC87\uD83C\uDFFD\u200D\u2642",
        "1F487 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 💇🏾‍♂️ E4.0 man getting haircut: medium-dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F487 1F3FE 200D 2642                      ; minimally-qualified # 💇🏾‍♂ E4.0 man getting haircut: medium-dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFE\u200D\u2642",
        "1F487 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 💇🏿‍♂️ E4.0 man getting haircut: dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F487 1F3FF 200D 2642                      ; minimally-qualified # 💇🏿‍♂ E4.0 man getting haircut: dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFF\u200D\u2642",
        "1F487 200D 2640 FE0F                       ; fully-qualified     # 💇‍♀️ E4.0 woman getting haircut",
        "\uD83D\uDC87\u200D\u2640\uFE0F",
        "1F487 200D 2640                            ; minimally-qualified # 💇‍♀ E4.0 woman getting haircut",
        "\uD83D\uDC87\u200D\u2640",
        "1F487 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 💇🏻‍♀️ E4.0 woman getting haircut: light skin tone",
        "\uD83D\uDC87\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F487 1F3FB 200D 2640                      ; minimally-qualified # 💇🏻‍♀ E4.0 woman getting haircut: light skin tone",
        "\uD83D\uDC87\uD83C\uDFFB\u200D\u2640",
        "1F487 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 💇🏼‍♀️ E4.0 woman getting haircut: medium-light skin tone",
        "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F487 1F3FC 200D 2640                      ; minimally-qualified # 💇🏼‍♀ E4.0 woman getting haircut: medium-light skin tone",
        "\uD83D\uDC87\uD83C\uDFFC\u200D\u2640",
        "1F487 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 💇🏽‍♀️ E4.0 woman getting haircut: medium skin tone",
        "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F487 1F3FD 200D 2640                      ; minimally-qualified # 💇🏽‍♀ E4.0 woman getting haircut: medium skin tone",
        "\uD83D\uDC87\uD83C\uDFFD\u200D\u2640",
        "1F487 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 💇🏾‍♀️ E4.0 woman getting haircut: medium-dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F487 1F3FE 200D 2640                      ; minimally-qualified # 💇🏾‍♀ E4.0 woman getting haircut: medium-dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFE\u200D\u2640",
        "1F487 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 💇🏿‍♀️ E4.0 woman getting haircut: dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F487 1F3FF 200D 2640                      ; minimally-qualified # 💇🏿‍♀ E4.0 woman getting haircut: dark skin tone",
        "\uD83D\uDC87\uD83C\uDFFF\u200D\u2640",
        "1F6B6                                      ; fully-qualified     # 🚶 E2.0 person walking",
        "\uD83D\uDEB6",
        "1F6B6 1F3FB                                ; fully-qualified     # 🚶🏻 E2.0 person walking: light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFB",
        "1F6B6 1F3FC                                ; fully-qualified     # 🚶🏼 E2.0 person walking: medium-light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFC",
        "1F6B6 1F3FD                                ; fully-qualified     # 🚶🏽 E2.0 person walking: medium skin tone",
        "\uD83D\uDEB6\uD83C\uDFFD",
        "1F6B6 1F3FE                                ; fully-qualified     # 🚶🏾 E2.0 person walking: medium-dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFE",
        "1F6B6 1F3FF                                ; fully-qualified     # 🚶🏿 E2.0 person walking: dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFF",
        "1F6B6 200D 2642 FE0F                       ; fully-qualified     # 🚶‍♂️ E4.0 man walking",
        "\uD83D\uDEB6\u200D\u2642\uFE0F",
        "1F6B6 200D 2642                            ; minimally-qualified # 🚶‍♂ E4.0 man walking",
        "\uD83D\uDEB6\u200D\u2642",
        "1F6B6 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚶🏻‍♂️ E4.0 man walking: light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F6B6 1F3FB 200D 2642                      ; minimally-qualified # 🚶🏻‍♂ E4.0 man walking: light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2642",
        "1F6B6 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚶🏼‍♂️ E4.0 man walking: medium-light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F6B6 1F3FC 200D 2642                      ; minimally-qualified # 🚶🏼‍♂ E4.0 man walking: medium-light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2642",
        "1F6B6 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚶🏽‍♂️ E4.0 man walking: medium skin tone",
        "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F6B6 1F3FD 200D 2642                      ; minimally-qualified # 🚶🏽‍♂ E4.0 man walking: medium skin tone",
        "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2642",
        "1F6B6 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚶🏾‍♂️ E4.0 man walking: medium-dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F6B6 1F3FE 200D 2642                      ; minimally-qualified # 🚶🏾‍♂ E4.0 man walking: medium-dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2642",
        "1F6B6 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚶🏿‍♂️ E4.0 man walking: dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F6B6 1F3FF 200D 2642                      ; minimally-qualified # 🚶🏿‍♂ E4.0 man walking: dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2642",
        "1F6B6 200D 2640 FE0F                       ; fully-qualified     # 🚶‍♀️ E4.0 woman walking",
        "\uD83D\uDEB6\u200D\u2640\uFE0F",
        "1F6B6 200D 2640                            ; minimally-qualified # 🚶‍♀ E4.0 woman walking",
        "\uD83D\uDEB6\u200D\u2640",
        "1F6B6 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚶🏻‍♀️ E4.0 woman walking: light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F6B6 1F3FB 200D 2640                      ; minimally-qualified # 🚶🏻‍♀ E4.0 woman walking: light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFB\u200D\u2640",
        "1F6B6 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚶🏼‍♀️ E4.0 woman walking: medium-light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F6B6 1F3FC 200D 2640                      ; minimally-qualified # 🚶🏼‍♀ E4.0 woman walking: medium-light skin tone",
        "\uD83D\uDEB6\uD83C\uDFFC\u200D\u2640",
        "1F6B6 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚶🏽‍♀️ E4.0 woman walking: medium skin tone",
        "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F6B6 1F3FD 200D 2640                      ; minimally-qualified # 🚶🏽‍♀ E4.0 woman walking: medium skin tone",
        "\uD83D\uDEB6\uD83C\uDFFD\u200D\u2640",
        "1F6B6 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚶🏾‍♀️ E4.0 woman walking: medium-dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F6B6 1F3FE 200D 2640                      ; minimally-qualified # 🚶🏾‍♀ E4.0 woman walking: medium-dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFE\u200D\u2640",
        "1F6B6 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚶🏿‍♀️ E4.0 woman walking: dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F6B6 1F3FF 200D 2640                      ; minimally-qualified # 🚶🏿‍♀ E4.0 woman walking: dark skin tone",
        "\uD83D\uDEB6\uD83C\uDFFF\u200D\u2640",
        "1F9CD                                      ; fully-qualified     # 🧍 E12.1 person standing",
        "\uD83E\uDDCD",
        "1F9CD 1F3FB                                ; fully-qualified     # 🧍🏻 E12.1 person standing: light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFB",
        "1F9CD 1F3FC                                ; fully-qualified     # 🧍🏼 E12.1 person standing: medium-light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFC",
        "1F9CD 1F3FD                                ; fully-qualified     # 🧍🏽 E12.1 person standing: medium skin tone",
        "\uD83E\uDDCD\uD83C\uDFFD",
        "1F9CD 1F3FE                                ; fully-qualified     # 🧍🏾 E12.1 person standing: medium-dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFE",
        "1F9CD 1F3FF                                ; fully-qualified     # 🧍🏿 E12.1 person standing: dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFF",
        "1F9CD 200D 2642 FE0F                       ; fully-qualified     # 🧍‍♂️ E12.1 man standing",
        "\uD83E\uDDCD\u200D\u2642\uFE0F",
        "1F9CD 200D 2642                            ; minimally-qualified # 🧍‍♂ E12.1 man standing",
        "\uD83E\uDDCD\u200D\u2642",
        "1F9CD 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧍🏻‍♂️ E12.1 man standing: light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9CD 1F3FB 200D 2642                      ; minimally-qualified # 🧍🏻‍♂ E12.1 man standing: light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2642",
        "1F9CD 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧍🏼‍♂️ E12.1 man standing: medium-light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9CD 1F3FC 200D 2642                      ; minimally-qualified # 🧍🏼‍♂ E12.1 man standing: medium-light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2642",
        "1F9CD 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧍🏽‍♂️ E12.1 man standing: medium skin tone",
        "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9CD 1F3FD 200D 2642                      ; minimally-qualified # 🧍🏽‍♂ E12.1 man standing: medium skin tone",
        "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2642",
        "1F9CD 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧍🏾‍♂️ E12.1 man standing: medium-dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9CD 1F3FE 200D 2642                      ; minimally-qualified # 🧍🏾‍♂ E12.1 man standing: medium-dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2642",
        "1F9CD 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧍🏿‍♂️ E12.1 man standing: dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9CD 1F3FF 200D 2642                      ; minimally-qualified # 🧍🏿‍♂ E12.1 man standing: dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2642",
        "1F9CD 200D 2640 FE0F                       ; fully-qualified     # 🧍‍♀️ E12.1 woman standing",
        "\uD83E\uDDCD\u200D\u2640\uFE0F",
        "1F9CD 200D 2640                            ; minimally-qualified # 🧍‍♀ E12.1 woman standing",
        "\uD83E\uDDCD\u200D\u2640",
        "1F9CD 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧍🏻‍♀️ E12.1 woman standing: light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9CD 1F3FB 200D 2640                      ; minimally-qualified # 🧍🏻‍♀ E12.1 woman standing: light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFB\u200D\u2640",
        "1F9CD 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧍🏼‍♀️ E12.1 woman standing: medium-light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9CD 1F3FC 200D 2640                      ; minimally-qualified # 🧍🏼‍♀ E12.1 woman standing: medium-light skin tone",
        "\uD83E\uDDCD\uD83C\uDFFC\u200D\u2640",
        "1F9CD 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧍🏽‍♀️ E12.1 woman standing: medium skin tone",
        "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9CD 1F3FD 200D 2640                      ; minimally-qualified # 🧍🏽‍♀ E12.1 woman standing: medium skin tone",
        "\uD83E\uDDCD\uD83C\uDFFD\u200D\u2640",
        "1F9CD 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧍🏾‍♀️ E12.1 woman standing: medium-dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9CD 1F3FE 200D 2640                      ; minimally-qualified # 🧍🏾‍♀ E12.1 woman standing: medium-dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFE\u200D\u2640",
        "1F9CD 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧍🏿‍♀️ E12.1 woman standing: dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9CD 1F3FF 200D 2640                      ; minimally-qualified # 🧍🏿‍♀ E12.1 woman standing: dark skin tone",
        "\uD83E\uDDCD\uD83C\uDFFF\u200D\u2640",
        "1F9CE                                      ; fully-qualified     # 🧎 E12.1 person kneeling",
        "\uD83E\uDDCE",
        "1F9CE 1F3FB                                ; fully-qualified     # 🧎🏻 E12.1 person kneeling: light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFB",
        "1F9CE 1F3FC                                ; fully-qualified     # 🧎🏼 E12.1 person kneeling: medium-light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFC",
        "1F9CE 1F3FD                                ; fully-qualified     # 🧎🏽 E12.1 person kneeling: medium skin tone",
        "\uD83E\uDDCE\uD83C\uDFFD",
        "1F9CE 1F3FE                                ; fully-qualified     # 🧎🏾 E12.1 person kneeling: medium-dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFE",
        "1F9CE 1F3FF                                ; fully-qualified     # 🧎🏿 E12.1 person kneeling: dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFF",
        "1F9CE 200D 2642 FE0F                       ; fully-qualified     # 🧎‍♂️ E12.1 man kneeling",
        "\uD83E\uDDCE\u200D\u2642\uFE0F",
        "1F9CE 200D 2642                            ; minimally-qualified # 🧎‍♂ E12.1 man kneeling",
        "\uD83E\uDDCE\u200D\u2642",
        "1F9CE 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧎🏻‍♂️ E12.1 man kneeling: light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9CE 1F3FB 200D 2642                      ; minimally-qualified # 🧎🏻‍♂ E12.1 man kneeling: light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2642",
        "1F9CE 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧎🏼‍♂️ E12.1 man kneeling: medium-light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9CE 1F3FC 200D 2642                      ; minimally-qualified # 🧎🏼‍♂ E12.1 man kneeling: medium-light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2642",
        "1F9CE 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧎🏽‍♂️ E12.1 man kneeling: medium skin tone",
        "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9CE 1F3FD 200D 2642                      ; minimally-qualified # 🧎🏽‍♂ E12.1 man kneeling: medium skin tone",
        "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2642",
        "1F9CE 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧎🏾‍♂️ E12.1 man kneeling: medium-dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9CE 1F3FE 200D 2642                      ; minimally-qualified # 🧎🏾‍♂ E12.1 man kneeling: medium-dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2642",
        "1F9CE 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧎🏿‍♂️ E12.1 man kneeling: dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9CE 1F3FF 200D 2642                      ; minimally-qualified # 🧎🏿‍♂ E12.1 man kneeling: dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2642",
        "1F9CE 200D 2640 FE0F                       ; fully-qualified     # 🧎‍♀️ E12.1 woman kneeling",
        "\uD83E\uDDCE\u200D\u2640\uFE0F",
        "1F9CE 200D 2640                            ; minimally-qualified # 🧎‍♀ E12.1 woman kneeling",
        "\uD83E\uDDCE\u200D\u2640",
        "1F9CE 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧎🏻‍♀️ E12.1 woman kneeling: light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9CE 1F3FB 200D 2640                      ; minimally-qualified # 🧎🏻‍♀ E12.1 woman kneeling: light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFB\u200D\u2640",
        "1F9CE 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧎🏼‍♀️ E12.1 woman kneeling: medium-light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9CE 1F3FC 200D 2640                      ; minimally-qualified # 🧎🏼‍♀ E12.1 woman kneeling: medium-light skin tone",
        "\uD83E\uDDCE\uD83C\uDFFC\u200D\u2640",
        "1F9CE 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧎🏽‍♀️ E12.1 woman kneeling: medium skin tone",
        "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9CE 1F3FD 200D 2640                      ; minimally-qualified # 🧎🏽‍♀ E12.1 woman kneeling: medium skin tone",
        "\uD83E\uDDCE\uD83C\uDFFD\u200D\u2640",
        "1F9CE 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧎🏾‍♀️ E12.1 woman kneeling: medium-dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9CE 1F3FE 200D 2640                      ; minimally-qualified # 🧎🏾‍♀ E12.1 woman kneeling: medium-dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFE\u200D\u2640",
        "1F9CE 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧎🏿‍♀️ E12.1 woman kneeling: dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9CE 1F3FF 200D 2640                      ; minimally-qualified # 🧎🏿‍♀ E12.1 woman kneeling: dark skin tone",
        "\uD83E\uDDCE\uD83C\uDFFF\u200D\u2640",
        "1F9D1 200D 1F9AF                           ; fully-qualified     # 🧑‍🦯 E12.1 person with probing cane",
        "\uD83E\uDDD1\u200D\uD83E\uDDAF",
        "1F9D1 1F3FB 200D 1F9AF                     ; fully-qualified     # 🧑🏻‍🦯 E12.1 person with probing cane: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDAF",
        "1F9D1 1F3FC 200D 1F9AF                     ; fully-qualified     # 🧑🏼‍🦯 E12.1 person with probing cane: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDAF",
        "1F9D1 1F3FD 200D 1F9AF                     ; fully-qualified     # 🧑🏽‍🦯 E12.1 person with probing cane: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDAF",
        "1F9D1 1F3FE 200D 1F9AF                     ; fully-qualified     # 🧑🏾‍🦯 E12.1 person with probing cane: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDAF",
        "1F9D1 1F3FF 200D 1F9AF                     ; fully-qualified     # 🧑🏿‍🦯 E12.1 person with probing cane: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDAF",
        "1F468 200D 1F9AF                           ; fully-qualified     # 👨‍🦯 E12.1 man with probing cane",
        "\uD83D\uDC68\u200D\uD83E\uDDAF",
        "1F468 1F3FB 200D 1F9AF                     ; fully-qualified     # 👨🏻‍🦯 E12.1 man with probing cane: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDAF",
        "1F468 1F3FC 200D 1F9AF                     ; fully-qualified     # 👨🏼‍🦯 E12.1 man with probing cane: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDAF",
        "1F468 1F3FD 200D 1F9AF                     ; fully-qualified     # 👨🏽‍🦯 E12.1 man with probing cane: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDAF",
        "1F468 1F3FE 200D 1F9AF                     ; fully-qualified     # 👨🏾‍🦯 E12.1 man with probing cane: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDAF",
        "1F468 1F3FF 200D 1F9AF                     ; fully-qualified     # 👨🏿‍🦯 E12.1 man with probing cane: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDAF",
        "1F469 200D 1F9AF                           ; fully-qualified     # 👩‍🦯 E12.1 woman with probing cane",
        "\uD83D\uDC69\u200D\uD83E\uDDAF",
        "1F469 1F3FB 200D 1F9AF                     ; fully-qualified     # 👩🏻‍🦯 E12.1 woman with probing cane: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDAF",
        "1F469 1F3FC 200D 1F9AF                     ; fully-qualified     # 👩🏼‍🦯 E12.1 woman with probing cane: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDAF",
        "1F469 1F3FD 200D 1F9AF                     ; fully-qualified     # 👩🏽‍🦯 E12.1 woman with probing cane: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDAF",
        "1F469 1F3FE 200D 1F9AF                     ; fully-qualified     # 👩🏾‍🦯 E12.1 woman with probing cane: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDAF",
        "1F469 1F3FF 200D 1F9AF                     ; fully-qualified     # 👩🏿‍🦯 E12.1 woman with probing cane: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDAF",
        "1F9D1 200D 1F9BC                           ; fully-qualified     # 🧑‍🦼 E12.1 person in motorized wheelchair",
        "\uD83E\uDDD1\u200D\uD83E\uDDBC",
        "1F9D1 1F3FB 200D 1F9BC                     ; fully-qualified     # 🧑🏻‍🦼 E12.1 person in motorized wheelchair: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBC",
        "1F9D1 1F3FC 200D 1F9BC                     ; fully-qualified     # 🧑🏼‍🦼 E12.1 person in motorized wheelchair: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBC",
        "1F9D1 1F3FD 200D 1F9BC                     ; fully-qualified     # 🧑🏽‍🦼 E12.1 person in motorized wheelchair: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBC",
        "1F9D1 1F3FE 200D 1F9BC                     ; fully-qualified     # 🧑🏾‍🦼 E12.1 person in motorized wheelchair: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBC",
        "1F9D1 1F3FF 200D 1F9BC                     ; fully-qualified     # 🧑🏿‍🦼 E12.1 person in motorized wheelchair: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBC",
        "1F468 200D 1F9BC                           ; fully-qualified     # 👨‍🦼 E12.1 man in motorized wheelchair",
        "\uD83D\uDC68\u200D\uD83E\uDDBC",
        "1F468 1F3FB 200D 1F9BC                     ; fully-qualified     # 👨🏻‍🦼 E12.1 man in motorized wheelchair: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBC",
        "1F468 1F3FC 200D 1F9BC                     ; fully-qualified     # 👨🏼‍🦼 E12.1 man in motorized wheelchair: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBC",
        "1F468 1F3FD 200D 1F9BC                     ; fully-qualified     # 👨🏽‍🦼 E12.1 man in motorized wheelchair: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBC",
        "1F468 1F3FE 200D 1F9BC                     ; fully-qualified     # 👨🏾‍🦼 E12.1 man in motorized wheelchair: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBC",
        "1F468 1F3FF 200D 1F9BC                     ; fully-qualified     # 👨🏿‍🦼 E12.1 man in motorized wheelchair: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBC",
        "1F469 200D 1F9BC                           ; fully-qualified     # 👩‍🦼 E12.1 woman in motorized wheelchair",
        "\uD83D\uDC69\u200D\uD83E\uDDBC",
        "1F469 1F3FB 200D 1F9BC                     ; fully-qualified     # 👩🏻‍🦼 E12.1 woman in motorized wheelchair: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBC",
        "1F469 1F3FC 200D 1F9BC                     ; fully-qualified     # 👩🏼‍🦼 E12.1 woman in motorized wheelchair: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBC",
        "1F469 1F3FD 200D 1F9BC                     ; fully-qualified     # 👩🏽‍🦼 E12.1 woman in motorized wheelchair: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBC",
        "1F469 1F3FE 200D 1F9BC                     ; fully-qualified     # 👩🏾‍🦼 E12.1 woman in motorized wheelchair: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBC",
        "1F469 1F3FF 200D 1F9BC                     ; fully-qualified     # 👩🏿‍🦼 E12.1 woman in motorized wheelchair: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBC",
        "1F9D1 200D 1F9BD                           ; fully-qualified     # 🧑‍🦽 E12.1 person in manual wheelchair",
        "\uD83E\uDDD1\u200D\uD83E\uDDBD",
        "1F9D1 1F3FB 200D 1F9BD                     ; fully-qualified     # 🧑🏻‍🦽 E12.1 person in manual wheelchair: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDDBD",
        "1F9D1 1F3FC 200D 1F9BD                     ; fully-qualified     # 🧑🏼‍🦽 E12.1 person in manual wheelchair: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDDBD",
        "1F9D1 1F3FD 200D 1F9BD                     ; fully-qualified     # 🧑🏽‍🦽 E12.1 person in manual wheelchair: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDDBD",
        "1F9D1 1F3FE 200D 1F9BD                     ; fully-qualified     # 🧑🏾‍🦽 E12.1 person in manual wheelchair: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDDBD",
        "1F9D1 1F3FF 200D 1F9BD                     ; fully-qualified     # 🧑🏿‍🦽 E12.1 person in manual wheelchair: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDDBD",
        "1F468 200D 1F9BD                           ; fully-qualified     # 👨‍🦽 E12.1 man in manual wheelchair",
        "\uD83D\uDC68\u200D\uD83E\uDDBD",
        "1F468 1F3FB 200D 1F9BD                     ; fully-qualified     # 👨🏻‍🦽 E12.1 man in manual wheelchair: light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDDBD",
        "1F468 1F3FC 200D 1F9BD                     ; fully-qualified     # 👨🏼‍🦽 E12.1 man in manual wheelchair: medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDDBD",
        "1F468 1F3FD 200D 1F9BD                     ; fully-qualified     # 👨🏽‍🦽 E12.1 man in manual wheelchair: medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDDBD",
        "1F468 1F3FE 200D 1F9BD                     ; fully-qualified     # 👨🏾‍🦽 E12.1 man in manual wheelchair: medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDDBD",
        "1F468 1F3FF 200D 1F9BD                     ; fully-qualified     # 👨🏿‍🦽 E12.1 man in manual wheelchair: dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDDBD",
        "1F469 200D 1F9BD                           ; fully-qualified     # 👩‍🦽 E12.1 woman in manual wheelchair",
        "\uD83D\uDC69\u200D\uD83E\uDDBD",
        "1F469 1F3FB 200D 1F9BD                     ; fully-qualified     # 👩🏻‍🦽 E12.1 woman in manual wheelchair: light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDDBD",
        "1F469 1F3FC 200D 1F9BD                     ; fully-qualified     # 👩🏼‍🦽 E12.1 woman in manual wheelchair: medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDDBD",
        "1F469 1F3FD 200D 1F9BD                     ; fully-qualified     # 👩🏽‍🦽 E12.1 woman in manual wheelchair: medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDDBD",
        "1F469 1F3FE 200D 1F9BD                     ; fully-qualified     # 👩🏾‍🦽 E12.1 woman in manual wheelchair: medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDDBD",
        "1F469 1F3FF 200D 1F9BD                     ; fully-qualified     # 👩🏿‍🦽 E12.1 woman in manual wheelchair: dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDDBD",
        "1F3C3                                      ; fully-qualified     # 🏃 E2.0 person running",
        "\uD83C\uDFC3",
        "1F3C3 1F3FB                                ; fully-qualified     # 🏃🏻 E2.0 person running: light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFB",
        "1F3C3 1F3FC                                ; fully-qualified     # 🏃🏼 E2.0 person running: medium-light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFC",
        "1F3C3 1F3FD                                ; fully-qualified     # 🏃🏽 E2.0 person running: medium skin tone",
        "\uD83C\uDFC3\uD83C\uDFFD",
        "1F3C3 1F3FE                                ; fully-qualified     # 🏃🏾 E2.0 person running: medium-dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFE",
        "1F3C3 1F3FF                                ; fully-qualified     # 🏃🏿 E2.0 person running: dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFF",
        "1F3C3 200D 2642 FE0F                       ; fully-qualified     # 🏃‍♂️ E4.0 man running",
        "\uD83C\uDFC3\u200D\u2642\uFE0F",
        "1F3C3 200D 2642                            ; minimally-qualified # 🏃‍♂ E4.0 man running",
        "\uD83C\uDFC3\u200D\u2642",
        "1F3C3 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏃🏻‍♂️ E4.0 man running: light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F3C3 1F3FB 200D 2642                      ; minimally-qualified # 🏃🏻‍♂ E4.0 man running: light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2642",
        "1F3C3 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏃🏼‍♂️ E4.0 man running: medium-light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F3C3 1F3FC 200D 2642                      ; minimally-qualified # 🏃🏼‍♂ E4.0 man running: medium-light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2642",
        "1F3C3 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏃🏽‍♂️ E4.0 man running: medium skin tone",
        "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F3C3 1F3FD 200D 2642                      ; minimally-qualified # 🏃🏽‍♂ E4.0 man running: medium skin tone",
        "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2642",
        "1F3C3 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏃🏾‍♂️ E4.0 man running: medium-dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F3C3 1F3FE 200D 2642                      ; minimally-qualified # 🏃🏾‍♂ E4.0 man running: medium-dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2642",
        "1F3C3 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏃🏿‍♂️ E4.0 man running: dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F3C3 1F3FF 200D 2642                      ; minimally-qualified # 🏃🏿‍♂ E4.0 man running: dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2642",
        "1F3C3 200D 2640 FE0F                       ; fully-qualified     # 🏃‍♀️ E4.0 woman running",
        "\uD83C\uDFC3\u200D\u2640\uFE0F",
        "1F3C3 200D 2640                            ; minimally-qualified # 🏃‍♀ E4.0 woman running",
        "\uD83C\uDFC3\u200D\u2640",
        "1F3C3 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏃🏻‍♀️ E4.0 woman running: light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F3C3 1F3FB 200D 2640                      ; minimally-qualified # 🏃🏻‍♀ E4.0 woman running: light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFB\u200D\u2640",
        "1F3C3 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏃🏼‍♀️ E4.0 woman running: medium-light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F3C3 1F3FC 200D 2640                      ; minimally-qualified # 🏃🏼‍♀ E4.0 woman running: medium-light skin tone",
        "\uD83C\uDFC3\uD83C\uDFFC\u200D\u2640",
        "1F3C3 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏃🏽‍♀️ E4.0 woman running: medium skin tone",
        "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F3C3 1F3FD 200D 2640                      ; minimally-qualified # 🏃🏽‍♀ E4.0 woman running: medium skin tone",
        "\uD83C\uDFC3\uD83C\uDFFD\u200D\u2640",
        "1F3C3 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏃🏾‍♀️ E4.0 woman running: medium-dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F3C3 1F3FE 200D 2640                      ; minimally-qualified # 🏃🏾‍♀ E4.0 woman running: medium-dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFE\u200D\u2640",
        "1F3C3 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏃🏿‍♀️ E4.0 woman running: dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F3C3 1F3FF 200D 2640                      ; minimally-qualified # 🏃🏿‍♀ E4.0 woman running: dark skin tone",
        "\uD83C\uDFC3\uD83C\uDFFF\u200D\u2640",
        "1F483                                      ; fully-qualified     # 💃 E2.0 woman dancing",
        "\uD83D\uDC83",
        "1F483 1F3FB                                ; fully-qualified     # 💃🏻 E2.0 woman dancing: light skin tone",
        "\uD83D\uDC83\uD83C\uDFFB",
        "1F483 1F3FC                                ; fully-qualified     # 💃🏼 E2.0 woman dancing: medium-light skin tone",
        "\uD83D\uDC83\uD83C\uDFFC",
        "1F483 1F3FD                                ; fully-qualified     # 💃🏽 E2.0 woman dancing: medium skin tone",
        "\uD83D\uDC83\uD83C\uDFFD",
        "1F483 1F3FE                                ; fully-qualified     # 💃🏾 E2.0 woman dancing: medium-dark skin tone",
        "\uD83D\uDC83\uD83C\uDFFE",
        "1F483 1F3FF                                ; fully-qualified     # 💃🏿 E2.0 woman dancing: dark skin tone",
        "\uD83D\uDC83\uD83C\uDFFF",
        "1F57A                                      ; fully-qualified     # 🕺 E4.0 man dancing",
        "\uD83D\uDD7A",
        "1F57A 1F3FB                                ; fully-qualified     # 🕺🏻 E4.0 man dancing: light skin tone",
        "\uD83D\uDD7A\uD83C\uDFFB",
        "1F57A 1F3FC                                ; fully-qualified     # 🕺🏼 E4.0 man dancing: medium-light skin tone",
        "\uD83D\uDD7A\uD83C\uDFFC",
        "1F57A 1F3FD                                ; fully-qualified     # 🕺🏽 E4.0 man dancing: medium skin tone",
        "\uD83D\uDD7A\uD83C\uDFFD",
        "1F57A 1F3FE                                ; fully-qualified     # 🕺🏾 E4.0 man dancing: medium-dark skin tone",
        "\uD83D\uDD7A\uD83C\uDFFE",
        "1F57A 1F3FF                                ; fully-qualified     # 🕺🏿 E4.0 man dancing: dark skin tone",
        "\uD83D\uDD7A\uD83C\uDFFF",
        "1F574 FE0F                                 ; fully-qualified     # 🕴️ E2.0 man in suit levitating",
        "\uD83D\uDD74\uFE0F",
        "1F574                                      ; unqualified         # 🕴 E2.0 man in suit levitating",
        "\uD83D\uDD74",
        "1F574 1F3FB                                ; fully-qualified     # 🕴🏻 E4.0 man in suit levitating: light skin tone",
        "\uD83D\uDD74\uD83C\uDFFB",
        "1F574 1F3FC                                ; fully-qualified     # 🕴🏼 E4.0 man in suit levitating: medium-light skin tone",
        "\uD83D\uDD74\uD83C\uDFFC",
        "1F574 1F3FD                                ; fully-qualified     # 🕴🏽 E4.0 man in suit levitating: medium skin tone",
        "\uD83D\uDD74\uD83C\uDFFD",
        "1F574 1F3FE                                ; fully-qualified     # 🕴🏾 E4.0 man in suit levitating: medium-dark skin tone",
        "\uD83D\uDD74\uD83C\uDFFE",
        "1F574 1F3FF                                ; fully-qualified     # 🕴🏿 E4.0 man in suit levitating: dark skin tone",
        "\uD83D\uDD74\uD83C\uDFFF",
        "1F46F                                      ; fully-qualified     # 👯 E2.0 people with bunny ears",
        "\uD83D\uDC6F",
        "1F46F 200D 2642 FE0F                       ; fully-qualified     # 👯‍♂️ E4.0 men with bunny ears",
        "\uD83D\uDC6F\u200D\u2642\uFE0F",
        "1F46F 200D 2642                            ; minimally-qualified # 👯‍♂ E4.0 men with bunny ears",
        "\uD83D\uDC6F\u200D\u2642",
        "1F46F 200D 2640 FE0F                       ; fully-qualified     # 👯‍♀️ E4.0 women with bunny ears",
        "\uD83D\uDC6F\u200D\u2640\uFE0F",
        "1F46F 200D 2640                            ; minimally-qualified # 👯‍♀ E4.0 women with bunny ears",
        "\uD83D\uDC6F\u200D\u2640",
        "1F9D6                                      ; fully-qualified     # 🧖 E5.0 person in steamy room",
        "\uD83E\uDDD6",
        "1F9D6 1F3FB                                ; fully-qualified     # 🧖🏻 E5.0 person in steamy room: light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFB",
        "1F9D6 1F3FC                                ; fully-qualified     # 🧖🏼 E5.0 person in steamy room: medium-light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFC",
        "1F9D6 1F3FD                                ; fully-qualified     # 🧖🏽 E5.0 person in steamy room: medium skin tone",
        "\uD83E\uDDD6\uD83C\uDFFD",
        "1F9D6 1F3FE                                ; fully-qualified     # 🧖🏾 E5.0 person in steamy room: medium-dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFE",
        "1F9D6 1F3FF                                ; fully-qualified     # 🧖🏿 E5.0 person in steamy room: dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFF",
        "1F9D6 200D 2642 FE0F                       ; fully-qualified     # 🧖‍♂️ E5.0 man in steamy room",
        "\uD83E\uDDD6\u200D\u2642\uFE0F",
        "1F9D6 200D 2642                            ; minimally-qualified # 🧖‍♂ E5.0 man in steamy room",
        "\uD83E\uDDD6\u200D\u2642",
        "1F9D6 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧖🏻‍♂️ E5.0 man in steamy room: light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9D6 1F3FB 200D 2642                      ; minimally-qualified # 🧖🏻‍♂ E5.0 man in steamy room: light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2642",
        "1F9D6 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧖🏼‍♂️ E5.0 man in steamy room: medium-light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9D6 1F3FC 200D 2642                      ; minimally-qualified # 🧖🏼‍♂ E5.0 man in steamy room: medium-light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2642",
        "1F9D6 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧖🏽‍♂️ E5.0 man in steamy room: medium skin tone",
        "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9D6 1F3FD 200D 2642                      ; minimally-qualified # 🧖🏽‍♂ E5.0 man in steamy room: medium skin tone",
        "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2642",
        "1F9D6 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧖🏾‍♂️ E5.0 man in steamy room: medium-dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9D6 1F3FE 200D 2642                      ; minimally-qualified # 🧖🏾‍♂ E5.0 man in steamy room: medium-dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2642",
        "1F9D6 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧖🏿‍♂️ E5.0 man in steamy room: dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9D6 1F3FF 200D 2642                      ; minimally-qualified # 🧖🏿‍♂ E5.0 man in steamy room: dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2642",
        "1F9D6 200D 2640 FE0F                       ; fully-qualified     # 🧖‍♀️ E5.0 woman in steamy room",
        "\uD83E\uDDD6\u200D\u2640\uFE0F",
        "1F9D6 200D 2640                            ; minimally-qualified # 🧖‍♀ E5.0 woman in steamy room",
        "\uD83E\uDDD6\u200D\u2640",
        "1F9D6 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧖🏻‍♀️ E5.0 woman in steamy room: light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9D6 1F3FB 200D 2640                      ; minimally-qualified # 🧖🏻‍♀ E5.0 woman in steamy room: light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFB\u200D\u2640",
        "1F9D6 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧖🏼‍♀️ E5.0 woman in steamy room: medium-light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9D6 1F3FC 200D 2640                      ; minimally-qualified # 🧖🏼‍♀ E5.0 woman in steamy room: medium-light skin tone",
        "\uD83E\uDDD6\uD83C\uDFFC\u200D\u2640",
        "1F9D6 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧖🏽‍♀️ E5.0 woman in steamy room: medium skin tone",
        "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9D6 1F3FD 200D 2640                      ; minimally-qualified # 🧖🏽‍♀ E5.0 woman in steamy room: medium skin tone",
        "\uD83E\uDDD6\uD83C\uDFFD\u200D\u2640",
        "1F9D6 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧖🏾‍♀️ E5.0 woman in steamy room: medium-dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9D6 1F3FE 200D 2640                      ; minimally-qualified # 🧖🏾‍♀ E5.0 woman in steamy room: medium-dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFE\u200D\u2640",
        "1F9D6 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧖🏿‍♀️ E5.0 woman in steamy room: dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9D6 1F3FF 200D 2640                      ; minimally-qualified # 🧖🏿‍♀ E5.0 woman in steamy room: dark skin tone",
        "\uD83E\uDDD6\uD83C\uDFFF\u200D\u2640",
        "1F9D7                                      ; fully-qualified     # 🧗 E5.0 person climbing",
        "\uD83E\uDDD7",
        "1F9D7 1F3FB                                ; fully-qualified     # 🧗🏻 E5.0 person climbing: light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFB",
        "1F9D7 1F3FC                                ; fully-qualified     # 🧗🏼 E5.0 person climbing: medium-light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFC",
        "1F9D7 1F3FD                                ; fully-qualified     # 🧗🏽 E5.0 person climbing: medium skin tone",
        "\uD83E\uDDD7\uD83C\uDFFD",
        "1F9D7 1F3FE                                ; fully-qualified     # 🧗🏾 E5.0 person climbing: medium-dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFE",
        "1F9D7 1F3FF                                ; fully-qualified     # 🧗🏿 E5.0 person climbing: dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFF",
        "1F9D7 200D 2642 FE0F                       ; fully-qualified     # 🧗‍♂️ E5.0 man climbing",
        "\uD83E\uDDD7\u200D\u2642\uFE0F",
        "1F9D7 200D 2642                            ; minimally-qualified # 🧗‍♂ E5.0 man climbing",
        "\uD83E\uDDD7\u200D\u2642",
        "1F9D7 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧗🏻‍♂️ E5.0 man climbing: light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9D7 1F3FB 200D 2642                      ; minimally-qualified # 🧗🏻‍♂ E5.0 man climbing: light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2642",
        "1F9D7 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧗🏼‍♂️ E5.0 man climbing: medium-light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9D7 1F3FC 200D 2642                      ; minimally-qualified # 🧗🏼‍♂ E5.0 man climbing: medium-light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2642",
        "1F9D7 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧗🏽‍♂️ E5.0 man climbing: medium skin tone",
        "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9D7 1F3FD 200D 2642                      ; minimally-qualified # 🧗🏽‍♂ E5.0 man climbing: medium skin tone",
        "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2642",
        "1F9D7 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧗🏾‍♂️ E5.0 man climbing: medium-dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9D7 1F3FE 200D 2642                      ; minimally-qualified # 🧗🏾‍♂ E5.0 man climbing: medium-dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2642",
        "1F9D7 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧗🏿‍♂️ E5.0 man climbing: dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9D7 1F3FF 200D 2642                      ; minimally-qualified # 🧗🏿‍♂ E5.0 man climbing: dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2642",
        "1F9D7 200D 2640 FE0F                       ; fully-qualified     # 🧗‍♀️ E5.0 woman climbing",
        "\uD83E\uDDD7\u200D\u2640\uFE0F",
        "1F9D7 200D 2640                            ; minimally-qualified # 🧗‍♀ E5.0 woman climbing",
        "\uD83E\uDDD7\u200D\u2640",
        "1F9D7 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧗🏻‍♀️ E5.0 woman climbing: light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9D7 1F3FB 200D 2640                      ; minimally-qualified # 🧗🏻‍♀ E5.0 woman climbing: light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFB\u200D\u2640",
        "1F9D7 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧗🏼‍♀️ E5.0 woman climbing: medium-light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9D7 1F3FC 200D 2640                      ; minimally-qualified # 🧗🏼‍♀ E5.0 woman climbing: medium-light skin tone",
        "\uD83E\uDDD7\uD83C\uDFFC\u200D\u2640",
        "1F9D7 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧗🏽‍♀️ E5.0 woman climbing: medium skin tone",
        "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9D7 1F3FD 200D 2640                      ; minimally-qualified # 🧗🏽‍♀ E5.0 woman climbing: medium skin tone",
        "\uD83E\uDDD7\uD83C\uDFFD\u200D\u2640",
        "1F9D7 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧗🏾‍♀️ E5.0 woman climbing: medium-dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9D7 1F3FE 200D 2640                      ; minimally-qualified # 🧗🏾‍♀ E5.0 woman climbing: medium-dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFE\u200D\u2640",
        "1F9D7 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧗🏿‍♀️ E5.0 woman climbing: dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9D7 1F3FF 200D 2640                      ; minimally-qualified # 🧗🏿‍♀ E5.0 woman climbing: dark skin tone",
        "\uD83E\uDDD7\uD83C\uDFFF\u200D\u2640",
        "1F93A                                      ; fully-qualified     # 🤺 E4.0 person fencing",
        "\uD83E\uDD3A",
        "1F3C7                                      ; fully-qualified     # 🏇 E2.0 horse racing",
        "\uD83C\uDFC7",
        "1F3C7 1F3FB                                ; fully-qualified     # 🏇🏻 E4.0 horse racing: light skin tone",
        "\uD83C\uDFC7\uD83C\uDFFB",
        "1F3C7 1F3FC                                ; fully-qualified     # 🏇🏼 E4.0 horse racing: medium-light skin tone",
        "\uD83C\uDFC7\uD83C\uDFFC",
        "1F3C7 1F3FD                                ; fully-qualified     # 🏇🏽 E4.0 horse racing: medium skin tone",
        "\uD83C\uDFC7\uD83C\uDFFD",
        "1F3C7 1F3FE                                ; fully-qualified     # 🏇🏾 E4.0 horse racing: medium-dark skin tone",
        "\uD83C\uDFC7\uD83C\uDFFE",
        "1F3C7 1F3FF                                ; fully-qualified     # 🏇🏿 E4.0 horse racing: dark skin tone",
        "\uD83C\uDFC7\uD83C\uDFFF",
        "26F7 FE0F                                  ; fully-qualified     # ⛷️ E2.0 skier",
        "\u26F7\uFE0F",
        "26F7                                       ; unqualified         # ⛷ E2.0 skier",
        "\u26F7",
        "1F3C2                                      ; fully-qualified     # 🏂 E2.0 snowboarder",
        "\uD83C\uDFC2",
        "1F3C2 1F3FB                                ; fully-qualified     # 🏂🏻 E4.0 snowboarder: light skin tone",
        "\uD83C\uDFC2\uD83C\uDFFB",
        "1F3C2 1F3FC                                ; fully-qualified     # 🏂🏼 E4.0 snowboarder: medium-light skin tone",
        "\uD83C\uDFC2\uD83C\uDFFC",
        "1F3C2 1F3FD                                ; fully-qualified     # 🏂🏽 E4.0 snowboarder: medium skin tone",
        "\uD83C\uDFC2\uD83C\uDFFD",
        "1F3C2 1F3FE                                ; fully-qualified     # 🏂🏾 E4.0 snowboarder: medium-dark skin tone",
        "\uD83C\uDFC2\uD83C\uDFFE",
        "1F3C2 1F3FF                                ; fully-qualified     # 🏂🏿 E4.0 snowboarder: dark skin tone",
        "\uD83C\uDFC2\uD83C\uDFFF",
        "1F3CC FE0F                                 ; fully-qualified     # 🏌️ E2.0 person golfing",
        "\uD83C\uDFCC\uFE0F",
        "1F3CC                                      ; unqualified         # 🏌 E2.0 person golfing",
        "\uD83C\uDFCC",
        "1F3CC 1F3FB                                ; fully-qualified     # 🏌🏻 E4.0 person golfing: light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFB",
        "1F3CC 1F3FC                                ; fully-qualified     # 🏌🏼 E4.0 person golfing: medium-light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFC",
        "1F3CC 1F3FD                                ; fully-qualified     # 🏌🏽 E4.0 person golfing: medium skin tone",
        "\uD83C\uDFCC\uD83C\uDFFD",
        "1F3CC 1F3FE                                ; fully-qualified     # 🏌🏾 E4.0 person golfing: medium-dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFE",
        "1F3CC 1F3FF                                ; fully-qualified     # 🏌🏿 E4.0 person golfing: dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFF",
        "1F3CC FE0F 200D 2642 FE0F                  ; fully-qualified     # 🏌️‍♂️ E4.0 man golfing",
        "\uD83C\uDFCC\uFE0F\u200D\u2642\uFE0F",
        "1F3CC 200D 2642 FE0F                       ; unqualified         # 🏌‍♂️ E4.0 man golfing",
        "\uD83C\uDFCC\u200D\u2642\uFE0F",
        "1F3CC FE0F 200D 2642                       ; unqualified         # 🏌️‍♂ E4.0 man golfing",
        "\uD83C\uDFCC\uFE0F\u200D\u2642",
        "1F3CC 200D 2642                            ; unqualified         # 🏌‍♂ E4.0 man golfing",
        "\uD83C\uDFCC\u200D\u2642",
        "1F3CC 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏌🏻‍♂️ E4.0 man golfing: light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F3CC 1F3FB 200D 2642                      ; minimally-qualified # 🏌🏻‍♂ E4.0 man golfing: light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2642",
        "1F3CC 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏌🏼‍♂️ E4.0 man golfing: medium-light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F3CC 1F3FC 200D 2642                      ; minimally-qualified # 🏌🏼‍♂ E4.0 man golfing: medium-light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2642",
        "1F3CC 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏌🏽‍♂️ E4.0 man golfing: medium skin tone",
        "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F3CC 1F3FD 200D 2642                      ; minimally-qualified # 🏌🏽‍♂ E4.0 man golfing: medium skin tone",
        "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2642",
        "1F3CC 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏌🏾‍♂️ E4.0 man golfing: medium-dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F3CC 1F3FE 200D 2642                      ; minimally-qualified # 🏌🏾‍♂ E4.0 man golfing: medium-dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2642",
        "1F3CC 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏌🏿‍♂️ E4.0 man golfing: dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F3CC 1F3FF 200D 2642                      ; minimally-qualified # 🏌🏿‍♂ E4.0 man golfing: dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2642",
        "1F3CC FE0F 200D 2640 FE0F                  ; fully-qualified     # 🏌️‍♀️ E4.0 woman golfing",
        "\uD83C\uDFCC\uFE0F\u200D\u2640\uFE0F",
        "1F3CC 200D 2640 FE0F                       ; unqualified         # 🏌‍♀️ E4.0 woman golfing",
        "\uD83C\uDFCC\u200D\u2640\uFE0F",
        "1F3CC FE0F 200D 2640                       ; unqualified         # 🏌️‍♀ E4.0 woman golfing",
        "\uD83C\uDFCC\uFE0F\u200D\u2640",
        "1F3CC 200D 2640                            ; unqualified         # 🏌‍♀ E4.0 woman golfing",
        "\uD83C\uDFCC\u200D\u2640",
        "1F3CC 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏌🏻‍♀️ E4.0 woman golfing: light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F3CC 1F3FB 200D 2640                      ; minimally-qualified # 🏌🏻‍♀ E4.0 woman golfing: light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFB\u200D\u2640",
        "1F3CC 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏌🏼‍♀️ E4.0 woman golfing: medium-light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F3CC 1F3FC 200D 2640                      ; minimally-qualified # 🏌🏼‍♀ E4.0 woman golfing: medium-light skin tone",
        "\uD83C\uDFCC\uD83C\uDFFC\u200D\u2640",
        "1F3CC 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏌🏽‍♀️ E4.0 woman golfing: medium skin tone",
        "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F3CC 1F3FD 200D 2640                      ; minimally-qualified # 🏌🏽‍♀ E4.0 woman golfing: medium skin tone",
        "\uD83C\uDFCC\uD83C\uDFFD\u200D\u2640",
        "1F3CC 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏌🏾‍♀️ E4.0 woman golfing: medium-dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F3CC 1F3FE 200D 2640                      ; minimally-qualified # 🏌🏾‍♀ E4.0 woman golfing: medium-dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFE\u200D\u2640",
        "1F3CC 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏌🏿‍♀️ E4.0 woman golfing: dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F3CC 1F3FF 200D 2640                      ; minimally-qualified # 🏌🏿‍♀ E4.0 woman golfing: dark skin tone",
        "\uD83C\uDFCC\uD83C\uDFFF\u200D\u2640",
        "1F3C4                                      ; fully-qualified     # 🏄 E2.0 person surfing",
        "\uD83C\uDFC4",
        "1F3C4 1F3FB                                ; fully-qualified     # 🏄🏻 E2.0 person surfing: light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFB",
        "1F3C4 1F3FC                                ; fully-qualified     # 🏄🏼 E2.0 person surfing: medium-light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFC",
        "1F3C4 1F3FD                                ; fully-qualified     # 🏄🏽 E2.0 person surfing: medium skin tone",
        "\uD83C\uDFC4\uD83C\uDFFD",
        "1F3C4 1F3FE                                ; fully-qualified     # 🏄🏾 E2.0 person surfing: medium-dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFE",
        "1F3C4 1F3FF                                ; fully-qualified     # 🏄🏿 E2.0 person surfing: dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFF",
        "1F3C4 200D 2642 FE0F                       ; fully-qualified     # 🏄‍♂️ E4.0 man surfing",
        "\uD83C\uDFC4\u200D\u2642\uFE0F",
        "1F3C4 200D 2642                            ; minimally-qualified # 🏄‍♂ E4.0 man surfing",
        "\uD83C\uDFC4\u200D\u2642",
        "1F3C4 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏄🏻‍♂️ E4.0 man surfing: light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F3C4 1F3FB 200D 2642                      ; minimally-qualified # 🏄🏻‍♂ E4.0 man surfing: light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2642",
        "1F3C4 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏄🏼‍♂️ E4.0 man surfing: medium-light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F3C4 1F3FC 200D 2642                      ; minimally-qualified # 🏄🏼‍♂ E4.0 man surfing: medium-light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2642",
        "1F3C4 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏄🏽‍♂️ E4.0 man surfing: medium skin tone",
        "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F3C4 1F3FD 200D 2642                      ; minimally-qualified # 🏄🏽‍♂ E4.0 man surfing: medium skin tone",
        "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2642",
        "1F3C4 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏄🏾‍♂️ E4.0 man surfing: medium-dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F3C4 1F3FE 200D 2642                      ; minimally-qualified # 🏄🏾‍♂ E4.0 man surfing: medium-dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2642",
        "1F3C4 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏄🏿‍♂️ E4.0 man surfing: dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F3C4 1F3FF 200D 2642                      ; minimally-qualified # 🏄🏿‍♂ E4.0 man surfing: dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2642",
        "1F3C4 200D 2640 FE0F                       ; fully-qualified     # 🏄‍♀️ E4.0 woman surfing",
        "\uD83C\uDFC4\u200D\u2640\uFE0F",
        "1F3C4 200D 2640                            ; minimally-qualified # 🏄‍♀ E4.0 woman surfing",
        "\uD83C\uDFC4\u200D\u2640",
        "1F3C4 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏄🏻‍♀️ E4.0 woman surfing: light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F3C4 1F3FB 200D 2640                      ; minimally-qualified # 🏄🏻‍♀ E4.0 woman surfing: light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFB\u200D\u2640",
        "1F3C4 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏄🏼‍♀️ E4.0 woman surfing: medium-light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F3C4 1F3FC 200D 2640                      ; minimally-qualified # 🏄🏼‍♀ E4.0 woman surfing: medium-light skin tone",
        "\uD83C\uDFC4\uD83C\uDFFC\u200D\u2640",
        "1F3C4 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏄🏽‍♀️ E4.0 woman surfing: medium skin tone",
        "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F3C4 1F3FD 200D 2640                      ; minimally-qualified # 🏄🏽‍♀ E4.0 woman surfing: medium skin tone",
        "\uD83C\uDFC4\uD83C\uDFFD\u200D\u2640",
        "1F3C4 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏄🏾‍♀️ E4.0 woman surfing: medium-dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F3C4 1F3FE 200D 2640                      ; minimally-qualified # 🏄🏾‍♀ E4.0 woman surfing: medium-dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFE\u200D\u2640",
        "1F3C4 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏄🏿‍♀️ E4.0 woman surfing: dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F3C4 1F3FF 200D 2640                      ; minimally-qualified # 🏄🏿‍♀ E4.0 woman surfing: dark skin tone",
        "\uD83C\uDFC4\uD83C\uDFFF\u200D\u2640",
        "1F6A3                                      ; fully-qualified     # 🚣 E2.0 person rowing boat",
        "\uD83D\uDEA3",
        "1F6A3 1F3FB                                ; fully-qualified     # 🚣🏻 E2.0 person rowing boat: light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFB",
        "1F6A3 1F3FC                                ; fully-qualified     # 🚣🏼 E2.0 person rowing boat: medium-light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFC",
        "1F6A3 1F3FD                                ; fully-qualified     # 🚣🏽 E2.0 person rowing boat: medium skin tone",
        "\uD83D\uDEA3\uD83C\uDFFD",
        "1F6A3 1F3FE                                ; fully-qualified     # 🚣🏾 E2.0 person rowing boat: medium-dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFE",
        "1F6A3 1F3FF                                ; fully-qualified     # 🚣🏿 E2.0 person rowing boat: dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFF",
        "1F6A3 200D 2642 FE0F                       ; fully-qualified     # 🚣‍♂️ E4.0 man rowing boat",
        "\uD83D\uDEA3\u200D\u2642\uFE0F",
        "1F6A3 200D 2642                            ; minimally-qualified # 🚣‍♂ E4.0 man rowing boat",
        "\uD83D\uDEA3\u200D\u2642",
        "1F6A3 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚣🏻‍♂️ E4.0 man rowing boat: light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F6A3 1F3FB 200D 2642                      ; minimally-qualified # 🚣🏻‍♂ E4.0 man rowing boat: light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2642",
        "1F6A3 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚣🏼‍♂️ E4.0 man rowing boat: medium-light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F6A3 1F3FC 200D 2642                      ; minimally-qualified # 🚣🏼‍♂ E4.0 man rowing boat: medium-light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2642",
        "1F6A3 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚣🏽‍♂️ E4.0 man rowing boat: medium skin tone",
        "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F6A3 1F3FD 200D 2642                      ; minimally-qualified # 🚣🏽‍♂ E4.0 man rowing boat: medium skin tone",
        "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2642",
        "1F6A3 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚣🏾‍♂️ E4.0 man rowing boat: medium-dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F6A3 1F3FE 200D 2642                      ; minimally-qualified # 🚣🏾‍♂ E4.0 man rowing boat: medium-dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2642",
        "1F6A3 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚣🏿‍♂️ E4.0 man rowing boat: dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F6A3 1F3FF 200D 2642                      ; minimally-qualified # 🚣🏿‍♂ E4.0 man rowing boat: dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2642",
        "1F6A3 200D 2640 FE0F                       ; fully-qualified     # 🚣‍♀️ E4.0 woman rowing boat",
        "\uD83D\uDEA3\u200D\u2640\uFE0F",
        "1F6A3 200D 2640                            ; minimally-qualified # 🚣‍♀ E4.0 woman rowing boat",
        "\uD83D\uDEA3\u200D\u2640",
        "1F6A3 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚣🏻‍♀️ E4.0 woman rowing boat: light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F6A3 1F3FB 200D 2640                      ; minimally-qualified # 🚣🏻‍♀ E4.0 woman rowing boat: light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFB\u200D\u2640",
        "1F6A3 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚣🏼‍♀️ E4.0 woman rowing boat: medium-light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F6A3 1F3FC 200D 2640                      ; minimally-qualified # 🚣🏼‍♀ E4.0 woman rowing boat: medium-light skin tone",
        "\uD83D\uDEA3\uD83C\uDFFC\u200D\u2640",
        "1F6A3 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚣🏽‍♀️ E4.0 woman rowing boat: medium skin tone",
        "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F6A3 1F3FD 200D 2640                      ; minimally-qualified # 🚣🏽‍♀ E4.0 woman rowing boat: medium skin tone",
        "\uD83D\uDEA3\uD83C\uDFFD\u200D\u2640",
        "1F6A3 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚣🏾‍♀️ E4.0 woman rowing boat: medium-dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F6A3 1F3FE 200D 2640                      ; minimally-qualified # 🚣🏾‍♀ E4.0 woman rowing boat: medium-dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFE\u200D\u2640",
        "1F6A3 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚣🏿‍♀️ E4.0 woman rowing boat: dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F6A3 1F3FF 200D 2640                      ; minimally-qualified # 🚣🏿‍♀ E4.0 woman rowing boat: dark skin tone",
        "\uD83D\uDEA3\uD83C\uDFFF\u200D\u2640",
        "1F3CA                                      ; fully-qualified     # 🏊 E2.0 person swimming",
        "\uD83C\uDFCA",
        "1F3CA 1F3FB                                ; fully-qualified     # 🏊🏻 E2.0 person swimming: light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFB",
        "1F3CA 1F3FC                                ; fully-qualified     # 🏊🏼 E2.0 person swimming: medium-light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFC",
        "1F3CA 1F3FD                                ; fully-qualified     # 🏊🏽 E2.0 person swimming: medium skin tone",
        "\uD83C\uDFCA\uD83C\uDFFD",
        "1F3CA 1F3FE                                ; fully-qualified     # 🏊🏾 E2.0 person swimming: medium-dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFE",
        "1F3CA 1F3FF                                ; fully-qualified     # 🏊🏿 E2.0 person swimming: dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFF",
        "1F3CA 200D 2642 FE0F                       ; fully-qualified     # 🏊‍♂️ E4.0 man swimming",
        "\uD83C\uDFCA\u200D\u2642\uFE0F",
        "1F3CA 200D 2642                            ; minimally-qualified # 🏊‍♂ E4.0 man swimming",
        "\uD83C\uDFCA\u200D\u2642",
        "1F3CA 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏊🏻‍♂️ E4.0 man swimming: light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F3CA 1F3FB 200D 2642                      ; minimally-qualified # 🏊🏻‍♂ E4.0 man swimming: light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2642",
        "1F3CA 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏊🏼‍♂️ E4.0 man swimming: medium-light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F3CA 1F3FC 200D 2642                      ; minimally-qualified # 🏊🏼‍♂ E4.0 man swimming: medium-light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2642",
        "1F3CA 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏊🏽‍♂️ E4.0 man swimming: medium skin tone",
        "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F3CA 1F3FD 200D 2642                      ; minimally-qualified # 🏊🏽‍♂ E4.0 man swimming: medium skin tone",
        "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2642",
        "1F3CA 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏊🏾‍♂️ E4.0 man swimming: medium-dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F3CA 1F3FE 200D 2642                      ; minimally-qualified # 🏊🏾‍♂ E4.0 man swimming: medium-dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2642",
        "1F3CA 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏊🏿‍♂️ E4.0 man swimming: dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F3CA 1F3FF 200D 2642                      ; minimally-qualified # 🏊🏿‍♂ E4.0 man swimming: dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2642",
        "1F3CA 200D 2640 FE0F                       ; fully-qualified     # 🏊‍♀️ E4.0 woman swimming",
        "\uD83C\uDFCA\u200D\u2640\uFE0F",
        "1F3CA 200D 2640                            ; minimally-qualified # 🏊‍♀ E4.0 woman swimming",
        "\uD83C\uDFCA\u200D\u2640",
        "1F3CA 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏊🏻‍♀️ E4.0 woman swimming: light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F3CA 1F3FB 200D 2640                      ; minimally-qualified # 🏊🏻‍♀ E4.0 woman swimming: light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFB\u200D\u2640",
        "1F3CA 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏊🏼‍♀️ E4.0 woman swimming: medium-light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F3CA 1F3FC 200D 2640                      ; minimally-qualified # 🏊🏼‍♀ E4.0 woman swimming: medium-light skin tone",
        "\uD83C\uDFCA\uD83C\uDFFC\u200D\u2640",
        "1F3CA 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏊🏽‍♀️ E4.0 woman swimming: medium skin tone",
        "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F3CA 1F3FD 200D 2640                      ; minimally-qualified # 🏊🏽‍♀ E4.0 woman swimming: medium skin tone",
        "\uD83C\uDFCA\uD83C\uDFFD\u200D\u2640",
        "1F3CA 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏊🏾‍♀️ E4.0 woman swimming: medium-dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F3CA 1F3FE 200D 2640                      ; minimally-qualified # 🏊🏾‍♀ E4.0 woman swimming: medium-dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFE\u200D\u2640",
        "1F3CA 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏊🏿‍♀️ E4.0 woman swimming: dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F3CA 1F3FF 200D 2640                      ; minimally-qualified # 🏊🏿‍♀ E4.0 woman swimming: dark skin tone",
        "\uD83C\uDFCA\uD83C\uDFFF\u200D\u2640",
        "26F9 FE0F                                  ; fully-qualified     # ⛹️ E2.0 person bouncing ball",
        "\u26F9\uFE0F",
        "26F9                                       ; unqualified         # ⛹ E2.0 person bouncing ball",
        "\u26F9",
        "26F9 1F3FB                                 ; fully-qualified     # ⛹🏻 E2.0 person bouncing ball: light skin tone",
        "\u26F9\uD83C\uDFFB",
        "26F9 1F3FC                                 ; fully-qualified     # ⛹🏼 E2.0 person bouncing ball: medium-light skin tone",
        "\u26F9\uD83C\uDFFC",
        "26F9 1F3FD                                 ; fully-qualified     # ⛹🏽 E2.0 person bouncing ball: medium skin tone",
        "\u26F9\uD83C\uDFFD",
        "26F9 1F3FE                                 ; fully-qualified     # ⛹🏾 E2.0 person bouncing ball: medium-dark skin tone",
        "\u26F9\uD83C\uDFFE",
        "26F9 1F3FF                                 ; fully-qualified     # ⛹🏿 E2.0 person bouncing ball: dark skin tone",
        "\u26F9\uD83C\uDFFF",
        "26F9 FE0F 200D 2642 FE0F                   ; fully-qualified     # ⛹️‍♂️ E4.0 man bouncing ball",
        "\u26F9\uFE0F\u200D\u2642\uFE0F",
        "26F9 200D 2642 FE0F                        ; unqualified         # ⛹‍♂️ E4.0 man bouncing ball",
        "\u26F9\u200D\u2642\uFE0F",
        "26F9 FE0F 200D 2642                        ; unqualified         # ⛹️‍♂ E4.0 man bouncing ball",
        "\u26F9\uFE0F\u200D\u2642",
        "26F9 200D 2642                             ; unqualified         # ⛹‍♂ E4.0 man bouncing ball",
        "\u26F9\u200D\u2642",
        "26F9 1F3FB 200D 2642 FE0F                  ; fully-qualified     # ⛹🏻‍♂️ E4.0 man bouncing ball: light skin tone",
        "\u26F9\uD83C\uDFFB\u200D\u2642\uFE0F",
        "26F9 1F3FB 200D 2642                       ; minimally-qualified # ⛹🏻‍♂ E4.0 man bouncing ball: light skin tone",
        "\u26F9\uD83C\uDFFB\u200D\u2642",
        "26F9 1F3FC 200D 2642 FE0F                  ; fully-qualified     # ⛹🏼‍♂️ E4.0 man bouncing ball: medium-light skin tone",
        "\u26F9\uD83C\uDFFC\u200D\u2642\uFE0F",
        "26F9 1F3FC 200D 2642                       ; minimally-qualified # ⛹🏼‍♂ E4.0 man bouncing ball: medium-light skin tone",
        "\u26F9\uD83C\uDFFC\u200D\u2642",
        "26F9 1F3FD 200D 2642 FE0F                  ; fully-qualified     # ⛹🏽‍♂️ E4.0 man bouncing ball: medium skin tone",
        "\u26F9\uD83C\uDFFD\u200D\u2642\uFE0F",
        "26F9 1F3FD 200D 2642                       ; minimally-qualified # ⛹🏽‍♂ E4.0 man bouncing ball: medium skin tone",
        "\u26F9\uD83C\uDFFD\u200D\u2642",
        "26F9 1F3FE 200D 2642 FE0F                  ; fully-qualified     # ⛹🏾‍♂️ E4.0 man bouncing ball: medium-dark skin tone",
        "\u26F9\uD83C\uDFFE\u200D\u2642\uFE0F",
        "26F9 1F3FE 200D 2642                       ; minimally-qualified # ⛹🏾‍♂ E4.0 man bouncing ball: medium-dark skin tone",
        "\u26F9\uD83C\uDFFE\u200D\u2642",
        "26F9 1F3FF 200D 2642 FE0F                  ; fully-qualified     # ⛹🏿‍♂️ E4.0 man bouncing ball: dark skin tone",
        "\u26F9\uD83C\uDFFF\u200D\u2642\uFE0F",
        "26F9 1F3FF 200D 2642                       ; minimally-qualified # ⛹🏿‍♂ E4.0 man bouncing ball: dark skin tone",
        "\u26F9\uD83C\uDFFF\u200D\u2642",
        "26F9 FE0F 200D 2640 FE0F                   ; fully-qualified     # ⛹️‍♀️ E4.0 woman bouncing ball",
        "\u26F9\uFE0F\u200D\u2640\uFE0F",
        "26F9 200D 2640 FE0F                        ; unqualified         # ⛹‍♀️ E4.0 woman bouncing ball",
        "\u26F9\u200D\u2640\uFE0F",
        "26F9 FE0F 200D 2640                        ; unqualified         # ⛹️‍♀ E4.0 woman bouncing ball",
        "\u26F9\uFE0F\u200D\u2640",
        "26F9 200D 2640                             ; unqualified         # ⛹‍♀ E4.0 woman bouncing ball",
        "\u26F9\u200D\u2640",
        "26F9 1F3FB 200D 2640 FE0F                  ; fully-qualified     # ⛹🏻‍♀️ E4.0 woman bouncing ball: light skin tone",
        "\u26F9\uD83C\uDFFB\u200D\u2640\uFE0F",
        "26F9 1F3FB 200D 2640                       ; minimally-qualified # ⛹🏻‍♀ E4.0 woman bouncing ball: light skin tone",
        "\u26F9\uD83C\uDFFB\u200D\u2640",
        "26F9 1F3FC 200D 2640 FE0F                  ; fully-qualified     # ⛹🏼‍♀️ E4.0 woman bouncing ball: medium-light skin tone",
        "\u26F9\uD83C\uDFFC\u200D\u2640\uFE0F",
        "26F9 1F3FC 200D 2640                       ; minimally-qualified # ⛹🏼‍♀ E4.0 woman bouncing ball: medium-light skin tone",
        "\u26F9\uD83C\uDFFC\u200D\u2640",
        "26F9 1F3FD 200D 2640 FE0F                  ; fully-qualified     # ⛹🏽‍♀️ E4.0 woman bouncing ball: medium skin tone",
        "\u26F9\uD83C\uDFFD\u200D\u2640\uFE0F",
        "26F9 1F3FD 200D 2640                       ; minimally-qualified # ⛹🏽‍♀ E4.0 woman bouncing ball: medium skin tone",
        "\u26F9\uD83C\uDFFD\u200D\u2640",
        "26F9 1F3FE 200D 2640 FE0F                  ; fully-qualified     # ⛹🏾‍♀️ E4.0 woman bouncing ball: medium-dark skin tone",
        "\u26F9\uD83C\uDFFE\u200D\u2640\uFE0F",
        "26F9 1F3FE 200D 2640                       ; minimally-qualified # ⛹🏾‍♀ E4.0 woman bouncing ball: medium-dark skin tone",
        "\u26F9\uD83C\uDFFE\u200D\u2640",
        "26F9 1F3FF 200D 2640 FE0F                  ; fully-qualified     # ⛹🏿‍♀️ E4.0 woman bouncing ball: dark skin tone",
        "\u26F9\uD83C\uDFFF\u200D\u2640\uFE0F",
        "26F9 1F3FF 200D 2640                       ; minimally-qualified # ⛹🏿‍♀ E4.0 woman bouncing ball: dark skin tone",
        "\u26F9\uD83C\uDFFF\u200D\u2640",
        "1F3CB FE0F                                 ; fully-qualified     # 🏋️ E2.0 person lifting weights",
        "\uD83C\uDFCB\uFE0F",
        "1F3CB                                      ; unqualified         # 🏋 E2.0 person lifting weights",
        "\uD83C\uDFCB",
        "1F3CB 1F3FB                                ; fully-qualified     # 🏋🏻 E2.0 person lifting weights: light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFB",
        "1F3CB 1F3FC                                ; fully-qualified     # 🏋🏼 E2.0 person lifting weights: medium-light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFC",
        "1F3CB 1F3FD                                ; fully-qualified     # 🏋🏽 E2.0 person lifting weights: medium skin tone",
        "\uD83C\uDFCB\uD83C\uDFFD",
        "1F3CB 1F3FE                                ; fully-qualified     # 🏋🏾 E2.0 person lifting weights: medium-dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFE",
        "1F3CB 1F3FF                                ; fully-qualified     # 🏋🏿 E2.0 person lifting weights: dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFF",
        "1F3CB FE0F 200D 2642 FE0F                  ; fully-qualified     # 🏋️‍♂️ E4.0 man lifting weights",
        "\uD83C\uDFCB\uFE0F\u200D\u2642\uFE0F",
        "1F3CB 200D 2642 FE0F                       ; unqualified         # 🏋‍♂️ E4.0 man lifting weights",
        "\uD83C\uDFCB\u200D\u2642\uFE0F",
        "1F3CB FE0F 200D 2642                       ; unqualified         # 🏋️‍♂ E4.0 man lifting weights",
        "\uD83C\uDFCB\uFE0F\u200D\u2642",
        "1F3CB 200D 2642                            ; unqualified         # 🏋‍♂ E4.0 man lifting weights",
        "\uD83C\uDFCB\u200D\u2642",
        "1F3CB 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🏋🏻‍♂️ E4.0 man lifting weights: light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F3CB 1F3FB 200D 2642                      ; minimally-qualified # 🏋🏻‍♂ E4.0 man lifting weights: light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2642",
        "1F3CB 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🏋🏼‍♂️ E4.0 man lifting weights: medium-light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F3CB 1F3FC 200D 2642                      ; minimally-qualified # 🏋🏼‍♂ E4.0 man lifting weights: medium-light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2642",
        "1F3CB 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🏋🏽‍♂️ E4.0 man lifting weights: medium skin tone",
        "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F3CB 1F3FD 200D 2642                      ; minimally-qualified # 🏋🏽‍♂ E4.0 man lifting weights: medium skin tone",
        "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2642",
        "1F3CB 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🏋🏾‍♂️ E4.0 man lifting weights: medium-dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F3CB 1F3FE 200D 2642                      ; minimally-qualified # 🏋🏾‍♂ E4.0 man lifting weights: medium-dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2642",
        "1F3CB 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🏋🏿‍♂️ E4.0 man lifting weights: dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F3CB 1F3FF 200D 2642                      ; minimally-qualified # 🏋🏿‍♂ E4.0 man lifting weights: dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2642",
        "1F3CB FE0F 200D 2640 FE0F                  ; fully-qualified     # 🏋️‍♀️ E4.0 woman lifting weights",
        "\uD83C\uDFCB\uFE0F\u200D\u2640\uFE0F",
        "1F3CB 200D 2640 FE0F                       ; unqualified         # 🏋‍♀️ E4.0 woman lifting weights",
        "\uD83C\uDFCB\u200D\u2640\uFE0F",
        "1F3CB FE0F 200D 2640                       ; unqualified         # 🏋️‍♀ E4.0 woman lifting weights",
        "\uD83C\uDFCB\uFE0F\u200D\u2640",
        "1F3CB 200D 2640                            ; unqualified         # 🏋‍♀ E4.0 woman lifting weights",
        "\uD83C\uDFCB\u200D\u2640",
        "1F3CB 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🏋🏻‍♀️ E4.0 woman lifting weights: light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F3CB 1F3FB 200D 2640                      ; minimally-qualified # 🏋🏻‍♀ E4.0 woman lifting weights: light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFB\u200D\u2640",
        "1F3CB 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🏋🏼‍♀️ E4.0 woman lifting weights: medium-light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F3CB 1F3FC 200D 2640                      ; minimally-qualified # 🏋🏼‍♀ E4.0 woman lifting weights: medium-light skin tone",
        "\uD83C\uDFCB\uD83C\uDFFC\u200D\u2640",
        "1F3CB 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🏋🏽‍♀️ E4.0 woman lifting weights: medium skin tone",
        "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F3CB 1F3FD 200D 2640                      ; minimally-qualified # 🏋🏽‍♀ E4.0 woman lifting weights: medium skin tone",
        "\uD83C\uDFCB\uD83C\uDFFD\u200D\u2640",
        "1F3CB 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🏋🏾‍♀️ E4.0 woman lifting weights: medium-dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F3CB 1F3FE 200D 2640                      ; minimally-qualified # 🏋🏾‍♀ E4.0 woman lifting weights: medium-dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFE\u200D\u2640",
        "1F3CB 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🏋🏿‍♀️ E4.0 woman lifting weights: dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F3CB 1F3FF 200D 2640                      ; minimally-qualified # 🏋🏿‍♀ E4.0 woman lifting weights: dark skin tone",
        "\uD83C\uDFCB\uD83C\uDFFF\u200D\u2640",
        "1F6B4                                      ; fully-qualified     # 🚴 E2.0 person biking",
        "\uD83D\uDEB4",
        "1F6B4 1F3FB                                ; fully-qualified     # 🚴🏻 E2.0 person biking: light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFB",
        "1F6B4 1F3FC                                ; fully-qualified     # 🚴🏼 E2.0 person biking: medium-light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFC",
        "1F6B4 1F3FD                                ; fully-qualified     # 🚴🏽 E2.0 person biking: medium skin tone",
        "\uD83D\uDEB4\uD83C\uDFFD",
        "1F6B4 1F3FE                                ; fully-qualified     # 🚴🏾 E2.0 person biking: medium-dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFE",
        "1F6B4 1F3FF                                ; fully-qualified     # 🚴🏿 E2.0 person biking: dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFF",
        "1F6B4 200D 2642 FE0F                       ; fully-qualified     # 🚴‍♂️ E4.0 man biking",
        "\uD83D\uDEB4\u200D\u2642\uFE0F",
        "1F6B4 200D 2642                            ; minimally-qualified # 🚴‍♂ E4.0 man biking",
        "\uD83D\uDEB4\u200D\u2642",
        "1F6B4 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚴🏻‍♂️ E4.0 man biking: light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F6B4 1F3FB 200D 2642                      ; minimally-qualified # 🚴🏻‍♂ E4.0 man biking: light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2642",
        "1F6B4 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚴🏼‍♂️ E4.0 man biking: medium-light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F6B4 1F3FC 200D 2642                      ; minimally-qualified # 🚴🏼‍♂ E4.0 man biking: medium-light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2642",
        "1F6B4 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚴🏽‍♂️ E4.0 man biking: medium skin tone",
        "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F6B4 1F3FD 200D 2642                      ; minimally-qualified # 🚴🏽‍♂ E4.0 man biking: medium skin tone",
        "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2642",
        "1F6B4 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚴🏾‍♂️ E4.0 man biking: medium-dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F6B4 1F3FE 200D 2642                      ; minimally-qualified # 🚴🏾‍♂ E4.0 man biking: medium-dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2642",
        "1F6B4 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚴🏿‍♂️ E4.0 man biking: dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F6B4 1F3FF 200D 2642                      ; minimally-qualified # 🚴🏿‍♂ E4.0 man biking: dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2642",
        "1F6B4 200D 2640 FE0F                       ; fully-qualified     # 🚴‍♀️ E4.0 woman biking",
        "\uD83D\uDEB4\u200D\u2640\uFE0F",
        "1F6B4 200D 2640                            ; minimally-qualified # 🚴‍♀ E4.0 woman biking",
        "\uD83D\uDEB4\u200D\u2640",
        "1F6B4 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚴🏻‍♀️ E4.0 woman biking: light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F6B4 1F3FB 200D 2640                      ; minimally-qualified # 🚴🏻‍♀ E4.0 woman biking: light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFB\u200D\u2640",
        "1F6B4 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚴🏼‍♀️ E4.0 woman biking: medium-light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F6B4 1F3FC 200D 2640                      ; minimally-qualified # 🚴🏼‍♀ E4.0 woman biking: medium-light skin tone",
        "\uD83D\uDEB4\uD83C\uDFFC\u200D\u2640",
        "1F6B4 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚴🏽‍♀️ E4.0 woman biking: medium skin tone",
        "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F6B4 1F3FD 200D 2640                      ; minimally-qualified # 🚴🏽‍♀ E4.0 woman biking: medium skin tone",
        "\uD83D\uDEB4\uD83C\uDFFD\u200D\u2640",
        "1F6B4 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚴🏾‍♀️ E4.0 woman biking: medium-dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F6B4 1F3FE 200D 2640                      ; minimally-qualified # 🚴🏾‍♀ E4.0 woman biking: medium-dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFE\u200D\u2640",
        "1F6B4 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚴🏿‍♀️ E4.0 woman biking: dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F6B4 1F3FF 200D 2640                      ; minimally-qualified # 🚴🏿‍♀ E4.0 woman biking: dark skin tone",
        "\uD83D\uDEB4\uD83C\uDFFF\u200D\u2640",
        "1F6B5                                      ; fully-qualified     # 🚵 E2.0 person mountain biking",
        "\uD83D\uDEB5",
        "1F6B5 1F3FB                                ; fully-qualified     # 🚵🏻 E2.0 person mountain biking: light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFB",
        "1F6B5 1F3FC                                ; fully-qualified     # 🚵🏼 E2.0 person mountain biking: medium-light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFC",
        "1F6B5 1F3FD                                ; fully-qualified     # 🚵🏽 E2.0 person mountain biking: medium skin tone",
        "\uD83D\uDEB5\uD83C\uDFFD",
        "1F6B5 1F3FE                                ; fully-qualified     # 🚵🏾 E2.0 person mountain biking: medium-dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFE",
        "1F6B5 1F3FF                                ; fully-qualified     # 🚵🏿 E2.0 person mountain biking: dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFF",
        "1F6B5 200D 2642 FE0F                       ; fully-qualified     # 🚵‍♂️ E4.0 man mountain biking",
        "\uD83D\uDEB5\u200D\u2642\uFE0F",
        "1F6B5 200D 2642                            ; minimally-qualified # 🚵‍♂ E4.0 man mountain biking",
        "\uD83D\uDEB5\u200D\u2642",
        "1F6B5 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🚵🏻‍♂️ E4.0 man mountain biking: light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F6B5 1F3FB 200D 2642                      ; minimally-qualified # 🚵🏻‍♂ E4.0 man mountain biking: light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2642",
        "1F6B5 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🚵🏼‍♂️ E4.0 man mountain biking: medium-light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F6B5 1F3FC 200D 2642                      ; minimally-qualified # 🚵🏼‍♂ E4.0 man mountain biking: medium-light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2642",
        "1F6B5 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🚵🏽‍♂️ E4.0 man mountain biking: medium skin tone",
        "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F6B5 1F3FD 200D 2642                      ; minimally-qualified # 🚵🏽‍♂ E4.0 man mountain biking: medium skin tone",
        "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2642",
        "1F6B5 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🚵🏾‍♂️ E4.0 man mountain biking: medium-dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F6B5 1F3FE 200D 2642                      ; minimally-qualified # 🚵🏾‍♂ E4.0 man mountain biking: medium-dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2642",
        "1F6B5 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🚵🏿‍♂️ E4.0 man mountain biking: dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F6B5 1F3FF 200D 2642                      ; minimally-qualified # 🚵🏿‍♂ E4.0 man mountain biking: dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2642",
        "1F6B5 200D 2640 FE0F                       ; fully-qualified     # 🚵‍♀️ E4.0 woman mountain biking",
        "\uD83D\uDEB5\u200D\u2640\uFE0F",
        "1F6B5 200D 2640                            ; minimally-qualified # 🚵‍♀ E4.0 woman mountain biking",
        "\uD83D\uDEB5\u200D\u2640",
        "1F6B5 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🚵🏻‍♀️ E4.0 woman mountain biking: light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F6B5 1F3FB 200D 2640                      ; minimally-qualified # 🚵🏻‍♀ E4.0 woman mountain biking: light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFB\u200D\u2640",
        "1F6B5 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🚵🏼‍♀️ E4.0 woman mountain biking: medium-light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F6B5 1F3FC 200D 2640                      ; minimally-qualified # 🚵🏼‍♀ E4.0 woman mountain biking: medium-light skin tone",
        "\uD83D\uDEB5\uD83C\uDFFC\u200D\u2640",
        "1F6B5 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🚵🏽‍♀️ E4.0 woman mountain biking: medium skin tone",
        "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F6B5 1F3FD 200D 2640                      ; minimally-qualified # 🚵🏽‍♀ E4.0 woman mountain biking: medium skin tone",
        "\uD83D\uDEB5\uD83C\uDFFD\u200D\u2640",
        "1F6B5 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🚵🏾‍♀️ E4.0 woman mountain biking: medium-dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F6B5 1F3FE 200D 2640                      ; minimally-qualified # 🚵🏾‍♀ E4.0 woman mountain biking: medium-dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFE\u200D\u2640",
        "1F6B5 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🚵🏿‍♀️ E4.0 woman mountain biking: dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F6B5 1F3FF 200D 2640                      ; minimally-qualified # 🚵🏿‍♀ E4.0 woman mountain biking: dark skin tone",
        "\uD83D\uDEB5\uD83C\uDFFF\u200D\u2640",
        "1F938                                      ; fully-qualified     # 🤸 E4.0 person cartwheeling",
        "\uD83E\uDD38",
        "1F938 1F3FB                                ; fully-qualified     # 🤸🏻 E4.0 person cartwheeling: light skin tone",
        "\uD83E\uDD38\uD83C\uDFFB",
        "1F938 1F3FC                                ; fully-qualified     # 🤸🏼 E4.0 person cartwheeling: medium-light skin tone",
        "\uD83E\uDD38\uD83C\uDFFC",
        "1F938 1F3FD                                ; fully-qualified     # 🤸🏽 E4.0 person cartwheeling: medium skin tone",
        "\uD83E\uDD38\uD83C\uDFFD",
        "1F938 1F3FE                                ; fully-qualified     # 🤸🏾 E4.0 person cartwheeling: medium-dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFE",
        "1F938 1F3FF                                ; fully-qualified     # 🤸🏿 E4.0 person cartwheeling: dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFF",
        "1F938 200D 2642 FE0F                       ; fully-qualified     # 🤸‍♂️ E4.0 man cartwheeling",
        "\uD83E\uDD38\u200D\u2642\uFE0F",
        "1F938 200D 2642                            ; minimally-qualified # 🤸‍♂ E4.0 man cartwheeling",
        "\uD83E\uDD38\u200D\u2642",
        "1F938 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤸🏻‍♂️ E4.0 man cartwheeling: light skin tone",
        "\uD83E\uDD38\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F938 1F3FB 200D 2642                      ; minimally-qualified # 🤸🏻‍♂ E4.0 man cartwheeling: light skin tone",
        "\uD83E\uDD38\uD83C\uDFFB\u200D\u2642",
        "1F938 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤸🏼‍♂️ E4.0 man cartwheeling: medium-light skin tone",
        "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F938 1F3FC 200D 2642                      ; minimally-qualified # 🤸🏼‍♂ E4.0 man cartwheeling: medium-light skin tone",
        "\uD83E\uDD38\uD83C\uDFFC\u200D\u2642",
        "1F938 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤸🏽‍♂️ E4.0 man cartwheeling: medium skin tone",
        "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F938 1F3FD 200D 2642                      ; minimally-qualified # 🤸🏽‍♂ E4.0 man cartwheeling: medium skin tone",
        "\uD83E\uDD38\uD83C\uDFFD\u200D\u2642",
        "1F938 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤸🏾‍♂️ E4.0 man cartwheeling: medium-dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F938 1F3FE 200D 2642                      ; minimally-qualified # 🤸🏾‍♂ E4.0 man cartwheeling: medium-dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFE\u200D\u2642",
        "1F938 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤸🏿‍♂️ E4.0 man cartwheeling: dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F938 1F3FF 200D 2642                      ; minimally-qualified # 🤸🏿‍♂ E4.0 man cartwheeling: dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFF\u200D\u2642",
        "1F938 200D 2640 FE0F                       ; fully-qualified     # 🤸‍♀️ E4.0 woman cartwheeling",
        "\uD83E\uDD38\u200D\u2640\uFE0F",
        "1F938 200D 2640                            ; minimally-qualified # 🤸‍♀ E4.0 woman cartwheeling",
        "\uD83E\uDD38\u200D\u2640",
        "1F938 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤸🏻‍♀️ E4.0 woman cartwheeling: light skin tone",
        "\uD83E\uDD38\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F938 1F3FB 200D 2640                      ; minimally-qualified # 🤸🏻‍♀ E4.0 woman cartwheeling: light skin tone",
        "\uD83E\uDD38\uD83C\uDFFB\u200D\u2640",
        "1F938 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤸🏼‍♀️ E4.0 woman cartwheeling: medium-light skin tone",
        "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F938 1F3FC 200D 2640                      ; minimally-qualified # 🤸🏼‍♀ E4.0 woman cartwheeling: medium-light skin tone",
        "\uD83E\uDD38\uD83C\uDFFC\u200D\u2640",
        "1F938 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤸🏽‍♀️ E4.0 woman cartwheeling: medium skin tone",
        "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F938 1F3FD 200D 2640                      ; minimally-qualified # 🤸🏽‍♀ E4.0 woman cartwheeling: medium skin tone",
        "\uD83E\uDD38\uD83C\uDFFD\u200D\u2640",
        "1F938 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤸🏾‍♀️ E4.0 woman cartwheeling: medium-dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F938 1F3FE 200D 2640                      ; minimally-qualified # 🤸🏾‍♀ E4.0 woman cartwheeling: medium-dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFE\u200D\u2640",
        "1F938 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤸🏿‍♀️ E4.0 woman cartwheeling: dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F938 1F3FF 200D 2640                      ; minimally-qualified # 🤸🏿‍♀ E4.0 woman cartwheeling: dark skin tone",
        "\uD83E\uDD38\uD83C\uDFFF\u200D\u2640",
        "1F93C                                      ; fully-qualified     # 🤼 E4.0 people wrestling",
        "\uD83E\uDD3C",
        "1F93C 200D 2642 FE0F                       ; fully-qualified     # 🤼‍♂️ E4.0 men wrestling",
        "\uD83E\uDD3C\u200D\u2642\uFE0F",
        "1F93C 200D 2642                            ; minimally-qualified # 🤼‍♂ E4.0 men wrestling",
        "\uD83E\uDD3C\u200D\u2642",
        "1F93C 200D 2640 FE0F                       ; fully-qualified     # 🤼‍♀️ E4.0 women wrestling",
        "\uD83E\uDD3C\u200D\u2640\uFE0F",
        "1F93C 200D 2640                            ; minimally-qualified # 🤼‍♀ E4.0 women wrestling",
        "\uD83E\uDD3C\u200D\u2640",
        "1F93D                                      ; fully-qualified     # 🤽 E4.0 person playing water polo",
        "\uD83E\uDD3D",
        "1F93D 1F3FB                                ; fully-qualified     # 🤽🏻 E4.0 person playing water polo: light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFB",
        "1F93D 1F3FC                                ; fully-qualified     # 🤽🏼 E4.0 person playing water polo: medium-light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFC",
        "1F93D 1F3FD                                ; fully-qualified     # 🤽🏽 E4.0 person playing water polo: medium skin tone",
        "\uD83E\uDD3D\uD83C\uDFFD",
        "1F93D 1F3FE                                ; fully-qualified     # 🤽🏾 E4.0 person playing water polo: medium-dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFE",
        "1F93D 1F3FF                                ; fully-qualified     # 🤽🏿 E4.0 person playing water polo: dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFF",
        "1F93D 200D 2642 FE0F                       ; fully-qualified     # 🤽‍♂️ E4.0 man playing water polo",
        "\uD83E\uDD3D\u200D\u2642\uFE0F",
        "1F93D 200D 2642                            ; minimally-qualified # 🤽‍♂ E4.0 man playing water polo",
        "\uD83E\uDD3D\u200D\u2642",
        "1F93D 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤽🏻‍♂️ E4.0 man playing water polo: light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F93D 1F3FB 200D 2642                      ; minimally-qualified # 🤽🏻‍♂ E4.0 man playing water polo: light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2642",
        "1F93D 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤽🏼‍♂️ E4.0 man playing water polo: medium-light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F93D 1F3FC 200D 2642                      ; minimally-qualified # 🤽🏼‍♂ E4.0 man playing water polo: medium-light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2642",
        "1F93D 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤽🏽‍♂️ E4.0 man playing water polo: medium skin tone",
        "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F93D 1F3FD 200D 2642                      ; minimally-qualified # 🤽🏽‍♂ E4.0 man playing water polo: medium skin tone",
        "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2642",
        "1F93D 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤽🏾‍♂️ E4.0 man playing water polo: medium-dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F93D 1F3FE 200D 2642                      ; minimally-qualified # 🤽🏾‍♂ E4.0 man playing water polo: medium-dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2642",
        "1F93D 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤽🏿‍♂️ E4.0 man playing water polo: dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F93D 1F3FF 200D 2642                      ; minimally-qualified # 🤽🏿‍♂ E4.0 man playing water polo: dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2642",
        "1F93D 200D 2640 FE0F                       ; fully-qualified     # 🤽‍♀️ E4.0 woman playing water polo",
        "\uD83E\uDD3D\u200D\u2640\uFE0F",
        "1F93D 200D 2640                            ; minimally-qualified # 🤽‍♀ E4.0 woman playing water polo",
        "\uD83E\uDD3D\u200D\u2640",
        "1F93D 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤽🏻‍♀️ E4.0 woman playing water polo: light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F93D 1F3FB 200D 2640                      ; minimally-qualified # 🤽🏻‍♀ E4.0 woman playing water polo: light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFB\u200D\u2640",
        "1F93D 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤽🏼‍♀️ E4.0 woman playing water polo: medium-light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F93D 1F3FC 200D 2640                      ; minimally-qualified # 🤽🏼‍♀ E4.0 woman playing water polo: medium-light skin tone",
        "\uD83E\uDD3D\uD83C\uDFFC\u200D\u2640",
        "1F93D 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤽🏽‍♀️ E4.0 woman playing water polo: medium skin tone",
        "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F93D 1F3FD 200D 2640                      ; minimally-qualified # 🤽🏽‍♀ E4.0 woman playing water polo: medium skin tone",
        "\uD83E\uDD3D\uD83C\uDFFD\u200D\u2640",
        "1F93D 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤽🏾‍♀️ E4.0 woman playing water polo: medium-dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F93D 1F3FE 200D 2640                      ; minimally-qualified # 🤽🏾‍♀ E4.0 woman playing water polo: medium-dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFE\u200D\u2640",
        "1F93D 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤽🏿‍♀️ E4.0 woman playing water polo: dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F93D 1F3FF 200D 2640                      ; minimally-qualified # 🤽🏿‍♀ E4.0 woman playing water polo: dark skin tone",
        "\uD83E\uDD3D\uD83C\uDFFF\u200D\u2640",
        "1F93E                                      ; fully-qualified     # 🤾 E4.0 person playing handball",
        "\uD83E\uDD3E",
        "1F93E 1F3FB                                ; fully-qualified     # 🤾🏻 E4.0 person playing handball: light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFB",
        "1F93E 1F3FC                                ; fully-qualified     # 🤾🏼 E4.0 person playing handball: medium-light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFC",
        "1F93E 1F3FD                                ; fully-qualified     # 🤾🏽 E4.0 person playing handball: medium skin tone",
        "\uD83E\uDD3E\uD83C\uDFFD",
        "1F93E 1F3FE                                ; fully-qualified     # 🤾🏾 E4.0 person playing handball: medium-dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFE",
        "1F93E 1F3FF                                ; fully-qualified     # 🤾🏿 E4.0 person playing handball: dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFF",
        "1F93E 200D 2642 FE0F                       ; fully-qualified     # 🤾‍♂️ E4.0 man playing handball",
        "\uD83E\uDD3E\u200D\u2642\uFE0F",
        "1F93E 200D 2642                            ; minimally-qualified # 🤾‍♂ E4.0 man playing handball",
        "\uD83E\uDD3E\u200D\u2642",
        "1F93E 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤾🏻‍♂️ E4.0 man playing handball: light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F93E 1F3FB 200D 2642                      ; minimally-qualified # 🤾🏻‍♂ E4.0 man playing handball: light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2642",
        "1F93E 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤾🏼‍♂️ E4.0 man playing handball: medium-light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F93E 1F3FC 200D 2642                      ; minimally-qualified # 🤾🏼‍♂ E4.0 man playing handball: medium-light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2642",
        "1F93E 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤾🏽‍♂️ E4.0 man playing handball: medium skin tone",
        "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F93E 1F3FD 200D 2642                      ; minimally-qualified # 🤾🏽‍♂ E4.0 man playing handball: medium skin tone",
        "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2642",
        "1F93E 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤾🏾‍♂️ E4.0 man playing handball: medium-dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F93E 1F3FE 200D 2642                      ; minimally-qualified # 🤾🏾‍♂ E4.0 man playing handball: medium-dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2642",
        "1F93E 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤾🏿‍♂️ E4.0 man playing handball: dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F93E 1F3FF 200D 2642                      ; minimally-qualified # 🤾🏿‍♂ E4.0 man playing handball: dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2642",
        "1F93E 200D 2640 FE0F                       ; fully-qualified     # 🤾‍♀️ E4.0 woman playing handball",
        "\uD83E\uDD3E\u200D\u2640\uFE0F",
        "1F93E 200D 2640                            ; minimally-qualified # 🤾‍♀ E4.0 woman playing handball",
        "\uD83E\uDD3E\u200D\u2640",
        "1F93E 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤾🏻‍♀️ E4.0 woman playing handball: light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F93E 1F3FB 200D 2640                      ; minimally-qualified # 🤾🏻‍♀ E4.0 woman playing handball: light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFB\u200D\u2640",
        "1F93E 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤾🏼‍♀️ E4.0 woman playing handball: medium-light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F93E 1F3FC 200D 2640                      ; minimally-qualified # 🤾🏼‍♀ E4.0 woman playing handball: medium-light skin tone",
        "\uD83E\uDD3E\uD83C\uDFFC\u200D\u2640",
        "1F93E 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤾🏽‍♀️ E4.0 woman playing handball: medium skin tone",
        "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F93E 1F3FD 200D 2640                      ; minimally-qualified # 🤾🏽‍♀ E4.0 woman playing handball: medium skin tone",
        "\uD83E\uDD3E\uD83C\uDFFD\u200D\u2640",
        "1F93E 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤾🏾‍♀️ E4.0 woman playing handball: medium-dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F93E 1F3FE 200D 2640                      ; minimally-qualified # 🤾🏾‍♀ E4.0 woman playing handball: medium-dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFE\u200D\u2640",
        "1F93E 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤾🏿‍♀️ E4.0 woman playing handball: dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F93E 1F3FF 200D 2640                      ; minimally-qualified # 🤾🏿‍♀ E4.0 woman playing handball: dark skin tone",
        "\uD83E\uDD3E\uD83C\uDFFF\u200D\u2640",
        "1F939                                      ; fully-qualified     # 🤹 E4.0 person juggling",
        "\uD83E\uDD39",
        "1F939 1F3FB                                ; fully-qualified     # 🤹🏻 E4.0 person juggling: light skin tone",
        "\uD83E\uDD39\uD83C\uDFFB",
        "1F939 1F3FC                                ; fully-qualified     # 🤹🏼 E4.0 person juggling: medium-light skin tone",
        "\uD83E\uDD39\uD83C\uDFFC",
        "1F939 1F3FD                                ; fully-qualified     # 🤹🏽 E4.0 person juggling: medium skin tone",
        "\uD83E\uDD39\uD83C\uDFFD",
        "1F939 1F3FE                                ; fully-qualified     # 🤹🏾 E4.0 person juggling: medium-dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFE",
        "1F939 1F3FF                                ; fully-qualified     # 🤹🏿 E4.0 person juggling: dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFF",
        "1F939 200D 2642 FE0F                       ; fully-qualified     # 🤹‍♂️ E4.0 man juggling",
        "\uD83E\uDD39\u200D\u2642\uFE0F",
        "1F939 200D 2642                            ; minimally-qualified # 🤹‍♂ E4.0 man juggling",
        "\uD83E\uDD39\u200D\u2642",
        "1F939 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🤹🏻‍♂️ E4.0 man juggling: light skin tone",
        "\uD83E\uDD39\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F939 1F3FB 200D 2642                      ; minimally-qualified # 🤹🏻‍♂ E4.0 man juggling: light skin tone",
        "\uD83E\uDD39\uD83C\uDFFB\u200D\u2642",
        "1F939 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🤹🏼‍♂️ E4.0 man juggling: medium-light skin tone",
        "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F939 1F3FC 200D 2642                      ; minimally-qualified # 🤹🏼‍♂ E4.0 man juggling: medium-light skin tone",
        "\uD83E\uDD39\uD83C\uDFFC\u200D\u2642",
        "1F939 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🤹🏽‍♂️ E4.0 man juggling: medium skin tone",
        "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F939 1F3FD 200D 2642                      ; minimally-qualified # 🤹🏽‍♂ E4.0 man juggling: medium skin tone",
        "\uD83E\uDD39\uD83C\uDFFD\u200D\u2642",
        "1F939 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🤹🏾‍♂️ E4.0 man juggling: medium-dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F939 1F3FE 200D 2642                      ; minimally-qualified # 🤹🏾‍♂ E4.0 man juggling: medium-dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFE\u200D\u2642",
        "1F939 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🤹🏿‍♂️ E4.0 man juggling: dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F939 1F3FF 200D 2642                      ; minimally-qualified # 🤹🏿‍♂ E4.0 man juggling: dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFF\u200D\u2642",
        "1F939 200D 2640 FE0F                       ; fully-qualified     # 🤹‍♀️ E4.0 woman juggling",
        "\uD83E\uDD39\u200D\u2640\uFE0F",
        "1F939 200D 2640                            ; minimally-qualified # 🤹‍♀ E4.0 woman juggling",
        "\uD83E\uDD39\u200D\u2640",
        "1F939 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🤹🏻‍♀️ E4.0 woman juggling: light skin tone",
        "\uD83E\uDD39\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F939 1F3FB 200D 2640                      ; minimally-qualified # 🤹🏻‍♀ E4.0 woman juggling: light skin tone",
        "\uD83E\uDD39\uD83C\uDFFB\u200D\u2640",
        "1F939 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🤹🏼‍♀️ E4.0 woman juggling: medium-light skin tone",
        "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F939 1F3FC 200D 2640                      ; minimally-qualified # 🤹🏼‍♀ E4.0 woman juggling: medium-light skin tone",
        "\uD83E\uDD39\uD83C\uDFFC\u200D\u2640",
        "1F939 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🤹🏽‍♀️ E4.0 woman juggling: medium skin tone",
        "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F939 1F3FD 200D 2640                      ; minimally-qualified # 🤹🏽‍♀ E4.0 woman juggling: medium skin tone",
        "\uD83E\uDD39\uD83C\uDFFD\u200D\u2640",
        "1F939 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🤹🏾‍♀️ E4.0 woman juggling: medium-dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F939 1F3FE 200D 2640                      ; minimally-qualified # 🤹🏾‍♀ E4.0 woman juggling: medium-dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFE\u200D\u2640",
        "1F939 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🤹🏿‍♀️ E4.0 woman juggling: dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F939 1F3FF 200D 2640                      ; minimally-qualified # 🤹🏿‍♀ E4.0 woman juggling: dark skin tone",
        "\uD83E\uDD39\uD83C\uDFFF\u200D\u2640",
        "1F9D8                                      ; fully-qualified     # 🧘 E5.0 person in lotus position",
        "\uD83E\uDDD8",
        "1F9D8 1F3FB                                ; fully-qualified     # 🧘🏻 E5.0 person in lotus position: light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFB",
        "1F9D8 1F3FC                                ; fully-qualified     # 🧘🏼 E5.0 person in lotus position: medium-light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFC",
        "1F9D8 1F3FD                                ; fully-qualified     # 🧘🏽 E5.0 person in lotus position: medium skin tone",
        "\uD83E\uDDD8\uD83C\uDFFD",
        "1F9D8 1F3FE                                ; fully-qualified     # 🧘🏾 E5.0 person in lotus position: medium-dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFE",
        "1F9D8 1F3FF                                ; fully-qualified     # 🧘🏿 E5.0 person in lotus position: dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFF",
        "1F9D8 200D 2642 FE0F                       ; fully-qualified     # 🧘‍♂️ E5.0 man in lotus position",
        "\uD83E\uDDD8\u200D\u2642\uFE0F",
        "1F9D8 200D 2642                            ; minimally-qualified # 🧘‍♂ E5.0 man in lotus position",
        "\uD83E\uDDD8\u200D\u2642",
        "1F9D8 1F3FB 200D 2642 FE0F                 ; fully-qualified     # 🧘🏻‍♂️ E5.0 man in lotus position: light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642\uFE0F",
        "1F9D8 1F3FB 200D 2642                      ; minimally-qualified # 🧘🏻‍♂ E5.0 man in lotus position: light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2642",
        "1F9D8 1F3FC 200D 2642 FE0F                 ; fully-qualified     # 🧘🏼‍♂️ E5.0 man in lotus position: medium-light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642\uFE0F",
        "1F9D8 1F3FC 200D 2642                      ; minimally-qualified # 🧘🏼‍♂ E5.0 man in lotus position: medium-light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2642",
        "1F9D8 1F3FD 200D 2642 FE0F                 ; fully-qualified     # 🧘🏽‍♂️ E5.0 man in lotus position: medium skin tone",
        "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642\uFE0F",
        "1F9D8 1F3FD 200D 2642                      ; minimally-qualified # 🧘🏽‍♂ E5.0 man in lotus position: medium skin tone",
        "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2642",
        "1F9D8 1F3FE 200D 2642 FE0F                 ; fully-qualified     # 🧘🏾‍♂️ E5.0 man in lotus position: medium-dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642\uFE0F",
        "1F9D8 1F3FE 200D 2642                      ; minimally-qualified # 🧘🏾‍♂ E5.0 man in lotus position: medium-dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2642",
        "1F9D8 1F3FF 200D 2642 FE0F                 ; fully-qualified     # 🧘🏿‍♂️ E5.0 man in lotus position: dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642\uFE0F",
        "1F9D8 1F3FF 200D 2642                      ; minimally-qualified # 🧘🏿‍♂ E5.0 man in lotus position: dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2642",
        "1F9D8 200D 2640 FE0F                       ; fully-qualified     # 🧘‍♀️ E5.0 woman in lotus position",
        "\uD83E\uDDD8\u200D\u2640\uFE0F",
        "1F9D8 200D 2640                            ; minimally-qualified # 🧘‍♀ E5.0 woman in lotus position",
        "\uD83E\uDDD8\u200D\u2640",
        "1F9D8 1F3FB 200D 2640 FE0F                 ; fully-qualified     # 🧘🏻‍♀️ E5.0 woman in lotus position: light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640\uFE0F",
        "1F9D8 1F3FB 200D 2640                      ; minimally-qualified # 🧘🏻‍♀ E5.0 woman in lotus position: light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFB\u200D\u2640",
        "1F9D8 1F3FC 200D 2640 FE0F                 ; fully-qualified     # 🧘🏼‍♀️ E5.0 woman in lotus position: medium-light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640\uFE0F",
        "1F9D8 1F3FC 200D 2640                      ; minimally-qualified # 🧘🏼‍♀ E5.0 woman in lotus position: medium-light skin tone",
        "\uD83E\uDDD8\uD83C\uDFFC\u200D\u2640",
        "1F9D8 1F3FD 200D 2640 FE0F                 ; fully-qualified     # 🧘🏽‍♀️ E5.0 woman in lotus position: medium skin tone",
        "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640\uFE0F",
        "1F9D8 1F3FD 200D 2640                      ; minimally-qualified # 🧘🏽‍♀ E5.0 woman in lotus position: medium skin tone",
        "\uD83E\uDDD8\uD83C\uDFFD\u200D\u2640",
        "1F9D8 1F3FE 200D 2640 FE0F                 ; fully-qualified     # 🧘🏾‍♀️ E5.0 woman in lotus position: medium-dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640\uFE0F",
        "1F9D8 1F3FE 200D 2640                      ; minimally-qualified # 🧘🏾‍♀ E5.0 woman in lotus position: medium-dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFE\u200D\u2640",
        "1F9D8 1F3FF 200D 2640 FE0F                 ; fully-qualified     # 🧘🏿‍♀️ E5.0 woman in lotus position: dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640\uFE0F",
        "1F9D8 1F3FF 200D 2640                      ; minimally-qualified # 🧘🏿‍♀ E5.0 woman in lotus position: dark skin tone",
        "\uD83E\uDDD8\uD83C\uDFFF\u200D\u2640",
        "1F6C0                                      ; fully-qualified     # 🛀 E2.0 person taking bath",
        "\uD83D\uDEC0",
        "1F6C0 1F3FB                                ; fully-qualified     # 🛀🏻 E2.0 person taking bath: light skin tone",
        "\uD83D\uDEC0\uD83C\uDFFB",
        "1F6C0 1F3FC                                ; fully-qualified     # 🛀🏼 E2.0 person taking bath: medium-light skin tone",
        "\uD83D\uDEC0\uD83C\uDFFC",
        "1F6C0 1F3FD                                ; fully-qualified     # 🛀🏽 E2.0 person taking bath: medium skin tone",
        "\uD83D\uDEC0\uD83C\uDFFD",
        "1F6C0 1F3FE                                ; fully-qualified     # 🛀🏾 E2.0 person taking bath: medium-dark skin tone",
        "\uD83D\uDEC0\uD83C\uDFFE",
        "1F6C0 1F3FF                                ; fully-qualified     # 🛀🏿 E2.0 person taking bath: dark skin tone",
        "\uD83D\uDEC0\uD83C\uDFFF",
        "1F6CC                                      ; fully-qualified     # 🛌 E2.0 person in bed",
        "\uD83D\uDECC",
        "1F6CC 1F3FB                                ; fully-qualified     # 🛌🏻 E4.0 person in bed: light skin tone",
        "\uD83D\uDECC\uD83C\uDFFB",
        "1F6CC 1F3FC                                ; fully-qualified     # 🛌🏼 E4.0 person in bed: medium-light skin tone",
        "\uD83D\uDECC\uD83C\uDFFC",
        "1F6CC 1F3FD                                ; fully-qualified     # 🛌🏽 E4.0 person in bed: medium skin tone",
        "\uD83D\uDECC\uD83C\uDFFD",
        "1F6CC 1F3FE                                ; fully-qualified     # 🛌🏾 E4.0 person in bed: medium-dark skin tone",
        "\uD83D\uDECC\uD83C\uDFFE",
        "1F6CC 1F3FF                                ; fully-qualified     # 🛌🏿 E4.0 person in bed: dark skin tone",
        "\uD83D\uDECC\uD83C\uDFFF",
        "1F9D1 200D 1F91D 200D 1F9D1                ; fully-qualified     # 🧑‍🤝‍🧑 E12.1 people holding hands",
        "\uD83E\uDDD1\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1",
        "1F9D1 1F3FB 200D 1F91D 200D 1F9D1 1F3FB    ; fully-qualified     # 🧑🏻‍🤝‍🧑🏻 E12.1 people holding hands: light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FB 200D 1F91D 200D 1F9D1 1F3FC    ; fully-qualified     # 🧑🏻‍🤝‍🧑🏼 E12.1 people holding hands: light skin tone, medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FB 200D 1F91D 200D 1F9D1 1F3FD    ; fully-qualified     # 🧑🏻‍🤝‍🧑🏽 E12.1 people holding hands: light skin tone, medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FB 200D 1F91D 200D 1F9D1 1F3FE    ; fully-qualified     # 🧑🏻‍🤝‍🧑🏾 E12.1 people holding hands: light skin tone, medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FB 200D 1F91D 200D 1F9D1 1F3FF    ; fully-qualified     # 🧑🏻‍🤝‍🧑🏿 E12.1 people holding hands: light skin tone, dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
        "1F9D1 1F3FC 200D 1F91D 200D 1F9D1 1F3FB    ; fully-qualified     # 🧑🏼‍🤝‍🧑🏻 E12.1 people holding hands: medium-light skin tone, light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FC 200D 1F91D 200D 1F9D1 1F3FC    ; fully-qualified     # 🧑🏼‍🤝‍🧑🏼 E12.1 people holding hands: medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FC 200D 1F91D 200D 1F9D1 1F3FD    ; fully-qualified     # 🧑🏼‍🤝‍🧑🏽 E12.1 people holding hands: medium-light skin tone, medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FC 200D 1F91D 200D 1F9D1 1F3FE    ; fully-qualified     # 🧑🏼‍🤝‍🧑🏾 E12.1 people holding hands: medium-light skin tone, medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FC 200D 1F91D 200D 1F9D1 1F3FF    ; fully-qualified     # 🧑🏼‍🤝‍🧑🏿 E12.1 people holding hands: medium-light skin tone, dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
        "1F9D1 1F3FD 200D 1F91D 200D 1F9D1 1F3FB    ; fully-qualified     # 🧑🏽‍🤝‍🧑🏻 E12.1 people holding hands: medium skin tone, light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FD 200D 1F91D 200D 1F9D1 1F3FC    ; fully-qualified     # 🧑🏽‍🤝‍🧑🏼 E12.1 people holding hands: medium skin tone, medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FD 200D 1F91D 200D 1F9D1 1F3FD    ; fully-qualified     # 🧑🏽‍🤝‍🧑🏽 E12.1 people holding hands: medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FD 200D 1F91D 200D 1F9D1 1F3FE    ; fully-qualified     # 🧑🏽‍🤝‍🧑🏾 E12.1 people holding hands: medium skin tone, medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FD 200D 1F91D 200D 1F9D1 1F3FF    ; fully-qualified     # 🧑🏽‍🤝‍🧑🏿 E12.1 people holding hands: medium skin tone, dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
        "1F9D1 1F3FE 200D 1F91D 200D 1F9D1 1F3FB    ; fully-qualified     # 🧑🏾‍🤝‍🧑🏻 E12.1 people holding hands: medium-dark skin tone, light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FE 200D 1F91D 200D 1F9D1 1F3FC    ; fully-qualified     # 🧑🏾‍🤝‍🧑🏼 E12.1 people holding hands: medium-dark skin tone, medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FE 200D 1F91D 200D 1F9D1 1F3FD    ; fully-qualified     # 🧑🏾‍🤝‍🧑🏽 E12.1 people holding hands: medium-dark skin tone, medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FE 200D 1F91D 200D 1F9D1 1F3FE    ; fully-qualified     # 🧑🏾‍🤝‍🧑🏾 E12.1 people holding hands: medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FE 200D 1F91D 200D 1F9D1 1F3FF    ; fully-qualified     # 🧑🏾‍🤝‍🧑🏿 E12.1 people holding hands: medium-dark skin tone, dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
        "1F9D1 1F3FF 200D 1F91D 200D 1F9D1 1F3FB    ; fully-qualified     # 🧑🏿‍🤝‍🧑🏻 E12.1 people holding hands: dark skin tone, light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFB",
        "1F9D1 1F3FF 200D 1F91D 200D 1F9D1 1F3FC    ; fully-qualified     # 🧑🏿‍🤝‍🧑🏼 E12.1 people holding hands: dark skin tone, medium-light skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFC",
        "1F9D1 1F3FF 200D 1F91D 200D 1F9D1 1F3FD    ; fully-qualified     # 🧑🏿‍🤝‍🧑🏽 E12.1 people holding hands: dark skin tone, medium skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFD",
        "1F9D1 1F3FF 200D 1F91D 200D 1F9D1 1F3FE    ; fully-qualified     # 🧑🏿‍🤝‍🧑🏾 E12.1 people holding hands: dark skin tone, medium-dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFE",
        "1F9D1 1F3FF 200D 1F91D 200D 1F9D1 1F3FF    ; fully-qualified     # 🧑🏿‍🤝‍🧑🏿 E12.1 people holding hands: dark skin tone",
        "\uD83E\uDDD1\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1\uD83C\uDFFF",
        "1F46D                                      ; fully-qualified     # 👭 E2.0 women holding hands",
        "\uD83D\uDC6D",
        "1F46D 1F3FB                                ; fully-qualified     # 👭🏻 E12.1 women holding hands: light skin tone",
        "\uD83D\uDC6D\uD83C\uDFFB",
        "1F469 1F3FB 200D 1F91D 200D 1F469 1F3FC    ; fully-qualified     # 👩🏻‍🤝‍👩🏼 E12.1 women holding hands: light skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
        "1F469 1F3FB 200D 1F91D 200D 1F469 1F3FD    ; fully-qualified     # 👩🏻‍🤝‍👩🏽 E12.1 women holding hands: light skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
        "1F469 1F3FB 200D 1F91D 200D 1F469 1F3FE    ; fully-qualified     # 👩🏻‍🤝‍👩🏾 E12.1 women holding hands: light skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
        "1F469 1F3FB 200D 1F91D 200D 1F469 1F3FF    ; fully-qualified     # 👩🏻‍🤝‍👩🏿 E12.1 women holding hands: light skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
        "1F469 1F3FC 200D 1F91D 200D 1F469 1F3FB    ; fully-qualified     # 👩🏼‍🤝‍👩🏻 E12.1 women holding hands: medium-light skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
        "1F46D 1F3FC                                ; fully-qualified     # 👭🏼 E12.1 women holding hands: medium-light skin tone",
        "\uD83D\uDC6D\uD83C\uDFFC",
        "1F469 1F3FC 200D 1F91D 200D 1F469 1F3FD    ; fully-qualified     # 👩🏼‍🤝‍👩🏽 E12.1 women holding hands: medium-light skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
        "1F469 1F3FC 200D 1F91D 200D 1F469 1F3FE    ; fully-qualified     # 👩🏼‍🤝‍👩🏾 E12.1 women holding hands: medium-light skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
        "1F469 1F3FC 200D 1F91D 200D 1F469 1F3FF    ; fully-qualified     # 👩🏼‍🤝‍👩🏿 E12.1 women holding hands: medium-light skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
        "1F469 1F3FD 200D 1F91D 200D 1F469 1F3FB    ; fully-qualified     # 👩🏽‍🤝‍👩🏻 E12.1 women holding hands: medium skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
        "1F469 1F3FD 200D 1F91D 200D 1F469 1F3FC    ; fully-qualified     # 👩🏽‍🤝‍👩🏼 E12.1 women holding hands: medium skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
        "1F46D 1F3FD                                ; fully-qualified     # 👭🏽 E12.1 women holding hands: medium skin tone",
        "\uD83D\uDC6D\uD83C\uDFFD",
        "1F469 1F3FD 200D 1F91D 200D 1F469 1F3FE    ; fully-qualified     # 👩🏽‍🤝‍👩🏾 E12.1 women holding hands: medium skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
        "1F469 1F3FD 200D 1F91D 200D 1F469 1F3FF    ; fully-qualified     # 👩🏽‍🤝‍👩🏿 E12.1 women holding hands: medium skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
        "1F469 1F3FE 200D 1F91D 200D 1F469 1F3FB    ; fully-qualified     # 👩🏾‍🤝‍👩🏻 E12.1 women holding hands: medium-dark skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
        "1F469 1F3FE 200D 1F91D 200D 1F469 1F3FC    ; fully-qualified     # 👩🏾‍🤝‍👩🏼 E12.1 women holding hands: medium-dark skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
        "1F469 1F3FE 200D 1F91D 200D 1F469 1F3FD    ; fully-qualified     # 👩🏾‍🤝‍👩🏽 E12.1 women holding hands: medium-dark skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
        "1F46D 1F3FE                                ; fully-qualified     # 👭🏾 E12.1 women holding hands: medium-dark skin tone",
        "\uD83D\uDC6D\uD83C\uDFFE",
        "1F469 1F3FE 200D 1F91D 200D 1F469 1F3FF    ; fully-qualified     # 👩🏾‍🤝‍👩🏿 E12.1 women holding hands: medium-dark skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFF",
        "1F469 1F3FF 200D 1F91D 200D 1F469 1F3FB    ; fully-qualified     # 👩🏿‍🤝‍👩🏻 E12.1 women holding hands: dark skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFB",
        "1F469 1F3FF 200D 1F91D 200D 1F469 1F3FC    ; fully-qualified     # 👩🏿‍🤝‍👩🏼 E12.1 women holding hands: dark skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFC",
        "1F469 1F3FF 200D 1F91D 200D 1F469 1F3FD    ; fully-qualified     # 👩🏿‍🤝‍👩🏽 E12.1 women holding hands: dark skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFD",
        "1F469 1F3FF 200D 1F91D 200D 1F469 1F3FE    ; fully-qualified     # 👩🏿‍🤝‍👩🏾 E12.1 women holding hands: dark skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC69\uD83C\uDFFE",
        "1F46D 1F3FF                                ; fully-qualified     # 👭🏿 E12.1 women holding hands: dark skin tone",
        "\uD83D\uDC6D\uD83C\uDFFF",
        "1F46B                                      ; fully-qualified     # 👫 E2.0 woman and man holding hands",
        "\uD83D\uDC6B",
        "1F46B 1F3FB                                ; fully-qualified     # 👫🏻 E12.1 woman and man holding hands: light skin tone",
        "\uD83D\uDC6B\uD83C\uDFFB",
        "1F469 1F3FB 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👩🏻‍🤝‍👨🏼 E12.1 woman and man holding hands: light skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F469 1F3FB 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👩🏻‍🤝‍👨🏽 E12.1 woman and man holding hands: light skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F469 1F3FB 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👩🏻‍🤝‍👨🏾 E12.1 woman and man holding hands: light skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F469 1F3FB 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👩🏻‍🤝‍👨🏿 E12.1 woman and man holding hands: light skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F469 1F3FC 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👩🏼‍🤝‍👨🏻 E12.1 woman and man holding hands: medium-light skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F46B 1F3FC                                ; fully-qualified     # 👫🏼 E12.1 woman and man holding hands: medium-light skin tone",
        "\uD83D\uDC6B\uD83C\uDFFC",
        "1F469 1F3FC 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👩🏼‍🤝‍👨🏽 E12.1 woman and man holding hands: medium-light skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F469 1F3FC 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👩🏼‍🤝‍👨🏾 E12.1 woman and man holding hands: medium-light skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F469 1F3FC 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👩🏼‍🤝‍👨🏿 E12.1 woman and man holding hands: medium-light skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F469 1F3FD 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👩🏽‍🤝‍👨🏻 E12.1 woman and man holding hands: medium skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F469 1F3FD 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👩🏽‍🤝‍👨🏼 E12.1 woman and man holding hands: medium skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F46B 1F3FD                                ; fully-qualified     # 👫🏽 E12.1 woman and man holding hands: medium skin tone",
        "\uD83D\uDC6B\uD83C\uDFFD",
        "1F469 1F3FD 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👩🏽‍🤝‍👨🏾 E12.1 woman and man holding hands: medium skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F469 1F3FD 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👩🏽‍🤝‍👨🏿 E12.1 woman and man holding hands: medium skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F469 1F3FE 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👩🏾‍🤝‍👨🏻 E12.1 woman and man holding hands: medium-dark skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F469 1F3FE 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👩🏾‍🤝‍👨🏼 E12.1 woman and man holding hands: medium-dark skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F469 1F3FE 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👩🏾‍🤝‍👨🏽 E12.1 woman and man holding hands: medium-dark skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F46B 1F3FE                                ; fully-qualified     # 👫🏾 E12.1 woman and man holding hands: medium-dark skin tone",
        "\uD83D\uDC6B\uD83C\uDFFE",
        "1F469 1F3FE 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👩🏾‍🤝‍👨🏿 E12.1 woman and man holding hands: medium-dark skin tone, dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F469 1F3FF 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👩🏿‍🤝‍👨🏻 E12.1 woman and man holding hands: dark skin tone, light skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F469 1F3FF 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👩🏿‍🤝‍👨🏼 E12.1 woman and man holding hands: dark skin tone, medium-light skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F469 1F3FF 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👩🏿‍🤝‍👨🏽 E12.1 woman and man holding hands: dark skin tone, medium skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F469 1F3FF 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👩🏿‍🤝‍👨🏾 E12.1 woman and man holding hands: dark skin tone, medium-dark skin tone",
        "\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F46B 1F3FF                                ; fully-qualified     # 👫🏿 E12.1 woman and man holding hands: dark skin tone",
        "\uD83D\uDC6B\uD83C\uDFFF",
        "1F46C                                      ; fully-qualified     # 👬 E2.0 men holding hands",
        "\uD83D\uDC6C",
        "1F46C 1F3FB                                ; fully-qualified     # 👬🏻 E12.1 men holding hands: light skin tone",
        "\uD83D\uDC6C\uD83C\uDFFB",
        "1F468 1F3FB 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👨🏻‍🤝‍👨🏼 E12.1 men holding hands: light skin tone, medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F468 1F3FB 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👨🏻‍🤝‍👨🏽 E12.1 men holding hands: light skin tone, medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F468 1F3FB 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👨🏻‍🤝‍👨🏾 E12.1 men holding hands: light skin tone, medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F468 1F3FB 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👨🏻‍🤝‍👨🏿 E12.1 men holding hands: light skin tone, dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F468 1F3FC 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👨🏼‍🤝‍👨🏻 E12.1 men holding hands: medium-light skin tone, light skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F46C 1F3FC                                ; fully-qualified     # 👬🏼 E12.1 men holding hands: medium-light skin tone",
        "\uD83D\uDC6C\uD83C\uDFFC",
        "1F468 1F3FC 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👨🏼‍🤝‍👨🏽 E12.1 men holding hands: medium-light skin tone, medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F468 1F3FC 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👨🏼‍🤝‍👨🏾 E12.1 men holding hands: medium-light skin tone, medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F468 1F3FC 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👨🏼‍🤝‍👨🏿 E12.1 men holding hands: medium-light skin tone, dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F468 1F3FD 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👨🏽‍🤝‍👨🏻 E12.1 men holding hands: medium skin tone, light skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F468 1F3FD 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👨🏽‍🤝‍👨🏼 E12.1 men holding hands: medium skin tone, medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F46C 1F3FD                                ; fully-qualified     # 👬🏽 E12.1 men holding hands: medium skin tone",
        "\uD83D\uDC6C\uD83C\uDFFD",
        "1F468 1F3FD 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👨🏽‍🤝‍👨🏾 E12.1 men holding hands: medium skin tone, medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F468 1F3FD 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👨🏽‍🤝‍👨🏿 E12.1 men holding hands: medium skin tone, dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F468 1F3FE 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👨🏾‍🤝‍👨🏻 E12.1 men holding hands: medium-dark skin tone, light skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F468 1F3FE 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👨🏾‍🤝‍👨🏼 E12.1 men holding hands: medium-dark skin tone, medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F468 1F3FE 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👨🏾‍🤝‍👨🏽 E12.1 men holding hands: medium-dark skin tone, medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F46C 1F3FE                                ; fully-qualified     # 👬🏾 E12.1 men holding hands: medium-dark skin tone",
        "\uD83D\uDC6C\uD83C\uDFFE",
        "1F468 1F3FE 200D 1F91D 200D 1F468 1F3FF    ; fully-qualified     # 👨🏾‍🤝‍👨🏿 E12.1 men holding hands: medium-dark skin tone, dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFF",
        "1F468 1F3FF 200D 1F91D 200D 1F468 1F3FB    ; fully-qualified     # 👨🏿‍🤝‍👨🏻 E12.1 men holding hands: dark skin tone, light skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB",
        "1F468 1F3FF 200D 1F91D 200D 1F468 1F3FC    ; fully-qualified     # 👨🏿‍🤝‍👨🏼 E12.1 men holding hands: dark skin tone, medium-light skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFC",
        "1F468 1F3FF 200D 1F91D 200D 1F468 1F3FD    ; fully-qualified     # 👨🏿‍🤝‍👨🏽 E12.1 men holding hands: dark skin tone, medium skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFD",
        "1F468 1F3FF 200D 1F91D 200D 1F468 1F3FE    ; fully-qualified     # 👨🏿‍🤝‍👨🏾 E12.1 men holding hands: dark skin tone, medium-dark skin tone",
        "\uD83D\uDC68\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFE",
        "1F46C 1F3FF                                ; fully-qualified     # 👬🏿 E12.1 men holding hands: dark skin tone",
        "\uD83D\uDC6C\uD83C\uDFFF",
        "1F48F                                      ; fully-qualified     # 💏 E2.0 kiss",
        "\uD83D\uDC8F",
        "1F469 200D 2764 FE0F 200D 1F48B 200D 1F468 ; fully-qualified     # 👩‍❤️‍💋‍👨 E2.0 kiss: woman, man",
        "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
        "1F469 200D 2764 200D 1F48B 200D 1F468      ; minimally-qualified # 👩‍❤‍💋‍👨 E2.0 kiss: woman, man",
        "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
        "1F468 200D 2764 FE0F 200D 1F48B 200D 1F468 ; fully-qualified     # 👨‍❤️‍💋‍👨 E2.0 kiss: man, man",
        "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
        "1F468 200D 2764 200D 1F48B 200D 1F468      ; minimally-qualified # 👨‍❤‍💋‍👨 E2.0 kiss: man, man",
        "\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC68",
        "1F469 200D 2764 FE0F 200D 1F48B 200D 1F469 ; fully-qualified     # 👩‍❤️‍💋‍👩 E2.0 kiss: woman, woman",
        "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC8B\u200D\uD83D\uDC69",
        "1F469 200D 2764 200D 1F48B 200D 1F469      ; minimally-qualified # 👩‍❤‍💋‍👩 E2.0 kiss: woman, woman",
        "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC8B\u200D\uD83D\uDC69",
        "1F491                                      ; fully-qualified     # 💑 E2.0 couple with heart",
        "\uD83D\uDC91",
        "1F469 200D 2764 FE0F 200D 1F468            ; fully-qualified     # 👩‍❤️‍👨 E2.0 couple with heart: woman, man",
        "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC68",
        "1F469 200D 2764 200D 1F468                 ; minimally-qualified # 👩‍❤‍👨 E2.0 couple with heart: woman, man",
        "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC68",
        "1F468 200D 2764 FE0F 200D 1F468            ; fully-qualified     # 👨‍❤️‍👨 E2.0 couple with heart: man, man",
        "\uD83D\uDC68\u200D\u2764\uFE0F\u200D\uD83D\uDC68",
        "1F468 200D 2764 200D 1F468                 ; minimally-qualified # 👨‍❤‍👨 E2.0 couple with heart: man, man",
        "\uD83D\uDC68\u200D\u2764\u200D\uD83D\uDC68",
        "1F469 200D 2764 FE0F 200D 1F469            ; fully-qualified     # 👩‍❤️‍👩 E2.0 couple with heart: woman, woman",
        "\uD83D\uDC69\u200D\u2764\uFE0F\u200D\uD83D\uDC69",
        "1F469 200D 2764 200D 1F469                 ; minimally-qualified # 👩‍❤‍👩 E2.0 couple with heart: woman, woman",
        "\uD83D\uDC69\u200D\u2764\u200D\uD83D\uDC69",
        "1F46A                                      ; fully-qualified     # 👪 E2.0 family",
        "\uD83D\uDC6A",
        "1F468 200D 1F469 200D 1F466                ; fully-qualified     # 👨‍👩‍👦 E2.0 family: man, woman, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66",
        "1F468 200D 1F469 200D 1F467                ; fully-qualified     # 👨‍👩‍👧 E2.0 family: man, woman, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67",
        "1F468 200D 1F469 200D 1F467 200D 1F466     ; fully-qualified     # 👨‍👩‍👧‍👦 E2.0 family: man, woman, girl, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
        "1F468 200D 1F469 200D 1F466 200D 1F466     ; fully-qualified     # 👨‍👩‍👦‍👦 E2.0 family: man, woman, boy, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
        "1F468 200D 1F469 200D 1F467 200D 1F467     ; fully-qualified     # 👨‍👩‍👧‍👧 E2.0 family: man, woman, girl, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
        "1F468 200D 1F468 200D 1F466                ; fully-qualified     # 👨‍👨‍👦 E2.0 family: man, man, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66",
        "1F468 200D 1F468 200D 1F467                ; fully-qualified     # 👨‍👨‍👧 E2.0 family: man, man, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67",
        "1F468 200D 1F468 200D 1F467 200D 1F466     ; fully-qualified     # 👨‍👨‍👧‍👦 E2.0 family: man, man, girl, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
        "1F468 200D 1F468 200D 1F466 200D 1F466     ; fully-qualified     # 👨‍👨‍👦‍👦 E2.0 family: man, man, boy, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
        "1F468 200D 1F468 200D 1F467 200D 1F467     ; fully-qualified     # 👨‍👨‍👧‍👧 E2.0 family: man, man, girl, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
        "1F469 200D 1F469 200D 1F466                ; fully-qualified     # 👩‍👩‍👦 E2.0 family: woman, woman, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66",
        "1F469 200D 1F469 200D 1F467                ; fully-qualified     # 👩‍👩‍👧 E2.0 family: woman, woman, girl",
        "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67",
        "1F469 200D 1F469 200D 1F467 200D 1F466     ; fully-qualified     # 👩‍👩‍👧‍👦 E2.0 family: woman, woman, girl, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
        "1F469 200D 1F469 200D 1F466 200D 1F466     ; fully-qualified     # 👩‍👩‍👦‍👦 E2.0 family: woman, woman, boy, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
        "1F469 200D 1F469 200D 1F467 200D 1F467     ; fully-qualified     # 👩‍👩‍👧‍👧 E2.0 family: woman, woman, girl, girl",
        "\uD83D\uDC69\u200D\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
        "1F468 200D 1F466                           ; fully-qualified     # 👨‍👦 E4.0 family: man, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC66",
        "1F468 200D 1F466 200D 1F466                ; fully-qualified     # 👨‍👦‍👦 E4.0 family: man, boy, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
        "1F468 200D 1F467                           ; fully-qualified     # 👨‍👧 E4.0 family: man, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC67",
        "1F468 200D 1F467 200D 1F466                ; fully-qualified     # 👨‍👧‍👦 E4.0 family: man, girl, boy",
        "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
        "1F468 200D 1F467 200D 1F467                ; fully-qualified     # 👨‍👧‍👧 E4.0 family: man, girl, girl",
        "\uD83D\uDC68\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
        "1F469 200D 1F466                           ; fully-qualified     # 👩‍👦 E4.0 family: woman, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC66",
        "1F469 200D 1F466 200D 1F466                ; fully-qualified     # 👩‍👦‍👦 E4.0 family: woman, boy, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66",
        "1F469 200D 1F467                           ; fully-qualified     # 👩‍👧 E4.0 family: woman, girl",
        "\uD83D\uDC69\u200D\uD83D\uDC67",
        "1F469 200D 1F467 200D 1F466                ; fully-qualified     # 👩‍👧‍👦 E4.0 family: woman, girl, boy",
        "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC66",
        "1F469 200D 1F467 200D 1F467                ; fully-qualified     # 👩‍👧‍👧 E4.0 family: woman, girl, girl",
        "\uD83D\uDC69\u200D\uD83D\uDC67\u200D\uD83D\uDC67",
        "1F5E3 FE0F                                 ; fully-qualified     # 🗣️ E2.0 speaking head",
        "\uD83D\uDDE3\uFE0F",
        "1F5E3                                      ; unqualified         # 🗣 E2.0 speaking head",
        "\uD83D\uDDE3",
        "1F464                                      ; fully-qualified     # 👤 E2.0 bust in silhouette",
        "\uD83D\uDC64",
        "1F465                                      ; fully-qualified     # 👥 E2.0 busts in silhouette",
        "\uD83D\uDC65",
        "1F463                                      ; fully-qualified     # 👣 E2.0 footprints",
        "\uD83D\uDC63",
        "1F3FB                                      ; component           # 🏻 E2.0 light skin tone",
        "\uD83C\uDFFB",
        "1F3FC                                      ; component           # 🏼 E2.0 medium-light skin tone",
        "\uD83C\uDFFC",
        "1F3FD                                      ; component           # 🏽 E2.0 medium skin tone",
        "\uD83C\uDFFD",
        "1F3FE                                      ; component           # 🏾 E2.0 medium-dark skin tone",
        "\uD83C\uDFFE",
        "1F3FF                                      ; component           # 🏿 E2.0 dark skin tone",
        "\uD83C\uDFFF",
        "1F9B0                                      ; component           # 🦰 E11.0 red hair",
        "\uD83E\uDDB0",
        "1F9B1                                      ; component           # 🦱 E11.0 curly hair",
        "\uD83E\uDDB1",
        "1F9B3                                      ; component           # 🦳 E11.0 white hair",
        "\uD83E\uDDB3",
        "1F9B2                                      ; component           # 🦲 E11.0 bald",
        "\uD83E\uDDB2",
        "1F435                                      ; fully-qualified     # 🐵 E2.0 monkey face",
        "\uD83D\uDC35",
        "1F412                                      ; fully-qualified     # 🐒 E2.0 monkey",
        "\uD83D\uDC12",
        "1F98D                                      ; fully-qualified     # 🦍 E4.0 gorilla",
        "\uD83E\uDD8D",
        "1F9A7                                      ; fully-qualified     # 🦧 E12.1 orangutan",
        "\uD83E\uDDA7",
        "1F436                                      ; fully-qualified     # 🐶 E2.0 dog face",
        "\uD83D\uDC36",
        "1F415                                      ; fully-qualified     # 🐕 E2.0 dog",
        "\uD83D\uDC15",
        "1F9AE                                      ; fully-qualified     # 🦮 E12.1 guide dog",
        "\uD83E\uDDAE",
        "1F415 200D 1F9BA                           ; fully-qualified     # 🐕‍🦺 E12.1 service dog",
        "\uD83D\uDC15\u200D\uD83E\uDDBA",
        "1F429                                      ; fully-qualified     # 🐩 E2.0 poodle",
        "\uD83D\uDC29",
        "1F43A                                      ; fully-qualified     # 🐺 E2.0 wolf",
        "\uD83D\uDC3A",
        "1F98A                                      ; fully-qualified     # 🦊 E4.0 fox",
        "\uD83E\uDD8A",
        "1F99D                                      ; fully-qualified     # 🦝 E11.0 raccoon",
        "\uD83E\uDD9D",
        "1F431                                      ; fully-qualified     # 🐱 E2.0 cat face",
        "\uD83D\uDC31",
        "1F408                                      ; fully-qualified     # 🐈 E2.0 cat",
        "\uD83D\uDC08",
        "1F981                                      ; fully-qualified     # 🦁 E2.0 lion",
        "\uD83E\uDD81",
        "1F42F                                      ; fully-qualified     # 🐯 E2.0 tiger face",
        "\uD83D\uDC2F",
        "1F405                                      ; fully-qualified     # 🐅 E2.0 tiger",
        "\uD83D\uDC05",
        "1F406                                      ; fully-qualified     # 🐆 E2.0 leopard",
        "\uD83D\uDC06",
        "1F434                                      ; fully-qualified     # 🐴 E2.0 horse face",
        "\uD83D\uDC34",
        "1F40E                                      ; fully-qualified     # 🐎 E2.0 horse",
        "\uD83D\uDC0E",
        "1F984                                      ; fully-qualified     # 🦄 E2.0 unicorn",
        "\uD83E\uDD84",
        "1F993                                      ; fully-qualified     # 🦓 E5.0 zebra",
        "\uD83E\uDD93",
        "1F98C                                      ; fully-qualified     # 🦌 E4.0 deer",
        "\uD83E\uDD8C",
        "1F42E                                      ; fully-qualified     # 🐮 E2.0 cow face",
        "\uD83D\uDC2E",
        "1F402                                      ; fully-qualified     # 🐂 E2.0 ox",
        "\uD83D\uDC02",
        "1F403                                      ; fully-qualified     # 🐃 E2.0 water buffalo",
        "\uD83D\uDC03",
        "1F404                                      ; fully-qualified     # 🐄 E2.0 cow",
        "\uD83D\uDC04",
        "1F437                                      ; fully-qualified     # 🐷 E2.0 pig face",
        "\uD83D\uDC37",
        "1F416                                      ; fully-qualified     # 🐖 E2.0 pig",
        "\uD83D\uDC16",
        "1F417                                      ; fully-qualified     # 🐗 E2.0 boar",
        "\uD83D\uDC17",
        "1F43D                                      ; fully-qualified     # 🐽 E2.0 pig nose",
        "\uD83D\uDC3D",
        "1F40F                                      ; fully-qualified     # 🐏 E2.0 ram",
        "\uD83D\uDC0F",
        "1F411                                      ; fully-qualified     # 🐑 E2.0 ewe",
        "\uD83D\uDC11",
        "1F410                                      ; fully-qualified     # 🐐 E2.0 goat",
        "\uD83D\uDC10",
        "1F42A                                      ; fully-qualified     # 🐪 E2.0 camel",
        "\uD83D\uDC2A",
        "1F42B                                      ; fully-qualified     # 🐫 E2.0 two-hump camel",
        "\uD83D\uDC2B",
        "1F999                                      ; fully-qualified     # 🦙 E11.0 llama",
        "\uD83E\uDD99",
        "1F992                                      ; fully-qualified     # 🦒 E5.0 giraffe",
        "\uD83E\uDD92",
        "1F418                                      ; fully-qualified     # 🐘 E2.0 elephant",
        "\uD83D\uDC18",
        "1F98F                                      ; fully-qualified     # 🦏 E4.0 rhinoceros",
        "\uD83E\uDD8F",
        "1F99B                                      ; fully-qualified     # 🦛 E11.0 hippopotamus",
        "\uD83E\uDD9B",
        "1F42D                                      ; fully-qualified     # 🐭 E2.0 mouse face",
        "\uD83D\uDC2D",
        "1F401                                      ; fully-qualified     # 🐁 E2.0 mouse",
        "\uD83D\uDC01",
        "1F400                                      ; fully-qualified     # 🐀 E2.0 rat",
        "\uD83D\uDC00",
        "1F439                                      ; fully-qualified     # 🐹 E2.0 hamster",
        "\uD83D\uDC39",
        "1F430                                      ; fully-qualified     # 🐰 E2.0 rabbit face",
        "\uD83D\uDC30",
        "1F407                                      ; fully-qualified     # 🐇 E2.0 rabbit",
        "\uD83D\uDC07",
        "1F43F FE0F                                 ; fully-qualified     # 🐿️ E2.0 chipmunk",
        "\uD83D\uDC3F\uFE0F",
        "1F43F                                      ; unqualified         # 🐿 E2.0 chipmunk",
        "\uD83D\uDC3F",
        "1F994                                      ; fully-qualified     # 🦔 E5.0 hedgehog",
        "\uD83E\uDD94",
        "1F987                                      ; fully-qualified     # 🦇 E4.0 bat",
        "\uD83E\uDD87",
        "1F43B                                      ; fully-qualified     # 🐻 E2.0 bear",
        "\uD83D\uDC3B",
        "1F428                                      ; fully-qualified     # 🐨 E2.0 koala",
        "\uD83D\uDC28",
        "1F43C                                      ; fully-qualified     # 🐼 E2.0 panda",
        "\uD83D\uDC3C",
        "1F9A5                                      ; fully-qualified     # 🦥 E12.1 sloth",
        "\uD83E\uDDA5",
        "1F9A6                                      ; fully-qualified     # 🦦 E12.1 otter",
        "\uD83E\uDDA6",
        "1F9A8                                      ; fully-qualified     # 🦨 E12.1 skunk",
        "\uD83E\uDDA8",
        "1F998                                      ; fully-qualified     # 🦘 E11.0 kangaroo",
        "\uD83E\uDD98",
        "1F9A1                                      ; fully-qualified     # 🦡 E11.0 badger",
        "\uD83E\uDDA1",
        "1F43E                                      ; fully-qualified     # 🐾 E2.0 paw prints",
        "\uD83D\uDC3E",
        "1F983                                      ; fully-qualified     # 🦃 E2.0 turkey",
        "\uD83E\uDD83",
        "1F414                                      ; fully-qualified     # 🐔 E2.0 chicken",
        "\uD83D\uDC14",
        "1F413                                      ; fully-qualified     # 🐓 E2.0 rooster",
        "\uD83D\uDC13",
        "1F423                                      ; fully-qualified     # 🐣 E2.0 hatching chick",
        "\uD83D\uDC23",
        "1F424                                      ; fully-qualified     # 🐤 E2.0 baby chick",
        "\uD83D\uDC24",
        "1F425                                      ; fully-qualified     # 🐥 E2.0 front-facing baby chick",
        "\uD83D\uDC25",
        "1F426                                      ; fully-qualified     # 🐦 E2.0 bird",
        "\uD83D\uDC26",
        "1F427                                      ; fully-qualified     # 🐧 E2.0 penguin",
        "\uD83D\uDC27",
        "1F54A FE0F                                 ; fully-qualified     # 🕊️ E2.0 dove",
        "\uD83D\uDD4A\uFE0F",
        "1F54A                                      ; unqualified         # 🕊 E2.0 dove",
        "\uD83D\uDD4A",
        "1F985                                      ; fully-qualified     # 🦅 E4.0 eagle",
        "\uD83E\uDD85",
        "1F986                                      ; fully-qualified     # 🦆 E4.0 duck",
        "\uD83E\uDD86",
        "1F9A2                                      ; fully-qualified     # 🦢 E11.0 swan",
        "\uD83E\uDDA2",
        "1F989                                      ; fully-qualified     # 🦉 E4.0 owl",
        "\uD83E\uDD89",
        "1F9A9                                      ; fully-qualified     # 🦩 E12.1 flamingo",
        "\uD83E\uDDA9",
        "1F99A                                      ; fully-qualified     # 🦚 E11.0 peacock",
        "\uD83E\uDD9A",
        "1F99C                                      ; fully-qualified     # 🦜 E11.0 parrot",
        "\uD83E\uDD9C",
        "1F438                                      ; fully-qualified     # 🐸 E2.0 frog",
        "\uD83D\uDC38",
        "1F40A                                      ; fully-qualified     # 🐊 E2.0 crocodile",
        "\uD83D\uDC0A",
        "1F422                                      ; fully-qualified     # 🐢 E2.0 turtle",
        "\uD83D\uDC22",
        "1F98E                                      ; fully-qualified     # 🦎 E4.0 lizard",
        "\uD83E\uDD8E",
        "1F40D                                      ; fully-qualified     # 🐍 E2.0 snake",
        "\uD83D\uDC0D",
        "1F432                                      ; fully-qualified     # 🐲 E2.0 dragon face",
        "\uD83D\uDC32",
        "1F409                                      ; fully-qualified     # 🐉 E2.0 dragon",
        "\uD83D\uDC09",
        "1F995                                      ; fully-qualified     # 🦕 E5.0 sauropod",
        "\uD83E\uDD95",
        "1F996                                      ; fully-qualified     # 🦖 E5.0 T-Rex",
        "\uD83E\uDD96",
        "1F433                                      ; fully-qualified     # 🐳 E2.0 spouting whale",
        "\uD83D\uDC33",
        "1F40B                                      ; fully-qualified     # 🐋 E2.0 whale",
        "\uD83D\uDC0B",
        "1F42C                                      ; fully-qualified     # 🐬 E2.0 dolphin",
        "\uD83D\uDC2C",
        "1F41F                                      ; fully-qualified     # 🐟 E2.0 fish",
        "\uD83D\uDC1F",
        "1F420                                      ; fully-qualified     # 🐠 E2.0 tropical fish",
        "\uD83D\uDC20",
        "1F421                                      ; fully-qualified     # 🐡 E2.0 blowfish",
        "\uD83D\uDC21",
        "1F988                                      ; fully-qualified     # 🦈 E4.0 shark",
        "\uD83E\uDD88",
        "1F419                                      ; fully-qualified     # 🐙 E2.0 octopus",
        "\uD83D\uDC19",
        "1F41A                                      ; fully-qualified     # 🐚 E2.0 spiral shell",
        "\uD83D\uDC1A",
        "1F40C                                      ; fully-qualified     # 🐌 E2.0 snail",
        "\uD83D\uDC0C",
        "1F98B                                      ; fully-qualified     # 🦋 E4.0 butterfly",
        "\uD83E\uDD8B",
        "1F41B                                      ; fully-qualified     # 🐛 E2.0 bug",
        "\uD83D\uDC1B",
        "1F41C                                      ; fully-qualified     # 🐜 E2.0 ant",
        "\uD83D\uDC1C",
        "1F41D                                      ; fully-qualified     # 🐝 E2.0 honeybee",
        "\uD83D\uDC1D",
        "1F41E                                      ; fully-qualified     # 🐞 E2.0 lady beetle",
        "\uD83D\uDC1E",
        "1F997                                      ; fully-qualified     # 🦗 E5.0 cricket",
        "\uD83E\uDD97",
        "1F577 FE0F                                 ; fully-qualified     # 🕷️ E2.0 spider",
        "\uD83D\uDD77\uFE0F",
        "1F577                                      ; unqualified         # 🕷 E2.0 spider",
        "\uD83D\uDD77",
        "1F578 FE0F                                 ; fully-qualified     # 🕸️ E2.0 spider web",
        "\uD83D\uDD78\uFE0F",
        "1F578                                      ; unqualified         # 🕸 E2.0 spider web",
        "\uD83D\uDD78",
        "1F982                                      ; fully-qualified     # 🦂 E2.0 scorpion",
        "\uD83E\uDD82",
        "1F99F                                      ; fully-qualified     # 🦟 E11.0 mosquito",
        "\uD83E\uDD9F",
        "1F9A0                                      ; fully-qualified     # 🦠 E11.0 microbe",
        "\uD83E\uDDA0",
        "1F490                                      ; fully-qualified     # 💐 E2.0 bouquet",
        "\uD83D\uDC90",
        "1F338                                      ; fully-qualified     # 🌸 E2.0 cherry blossom",
        "\uD83C\uDF38",
        "1F4AE                                      ; fully-qualified     # 💮 E2.0 white flower",
        "\uD83D\uDCAE",
        "1F3F5 FE0F                                 ; fully-qualified     # 🏵️ E2.0 rosette",
        "\uD83C\uDFF5\uFE0F",
        "1F3F5                                      ; unqualified         # 🏵 E2.0 rosette",
        "\uD83C\uDFF5",
        "1F339                                      ; fully-qualified     # 🌹 E2.0 rose",
        "\uD83C\uDF39",
        "1F940                                      ; fully-qualified     # 🥀 E4.0 wilted flower",
        "\uD83E\uDD40",
        "1F33A                                      ; fully-qualified     # 🌺 E2.0 hibiscus",
        "\uD83C\uDF3A",
        "1F33B                                      ; fully-qualified     # 🌻 E2.0 sunflower",
        "\uD83C\uDF3B",
        "1F33C                                      ; fully-qualified     # 🌼 E2.0 blossom",
        "\uD83C\uDF3C",
        "1F337                                      ; fully-qualified     # 🌷 E2.0 tulip",
        "\uD83C\uDF37",
        "1F331                                      ; fully-qualified     # 🌱 E2.0 seedling",
        "\uD83C\uDF31",
        "1F332                                      ; fully-qualified     # 🌲 E2.0 evergreen tree",
        "\uD83C\uDF32",
        "1F333                                      ; fully-qualified     # 🌳 E2.0 deciduous tree",
        "\uD83C\uDF33",
        "1F334                                      ; fully-qualified     # 🌴 E2.0 palm tree",
        "\uD83C\uDF34",
        "1F335                                      ; fully-qualified     # 🌵 E2.0 cactus",
        "\uD83C\uDF35",
        "1F33E                                      ; fully-qualified     # 🌾 E2.0 sheaf of rice",
        "\uD83C\uDF3E",
        "1F33F                                      ; fully-qualified     # 🌿 E2.0 herb",
        "\uD83C\uDF3F",
        "2618 FE0F                                  ; fully-qualified     # ☘️ E2.0 shamrock",
        "\u2618\uFE0F",
        "2618                                       ; unqualified         # ☘ E2.0 shamrock",
        "\u2618",
        "1F340                                      ; fully-qualified     # 🍀 E2.0 four leaf clover",
        "\uD83C\uDF40",
        "1F341                                      ; fully-qualified     # 🍁 E2.0 maple leaf",
        "\uD83C\uDF41",
        "1F342                                      ; fully-qualified     # 🍂 E2.0 fallen leaf",
        "\uD83C\uDF42",
        "1F343                                      ; fully-qualified     # 🍃 E2.0 leaf fluttering in wind",
        "\uD83C\uDF43",
        "1F347                                      ; fully-qualified     # 🍇 E2.0 grapes",
        "\uD83C\uDF47",
        "1F348                                      ; fully-qualified     # 🍈 E2.0 melon",
        "\uD83C\uDF48",
        "1F349                                      ; fully-qualified     # 🍉 E2.0 watermelon",
        "\uD83C\uDF49",
        "1F34A                                      ; fully-qualified     # 🍊 E2.0 tangerine",
        "\uD83C\uDF4A",
        "1F34B                                      ; fully-qualified     # 🍋 E2.0 lemon",
        "\uD83C\uDF4B",
        "1F34C                                      ; fully-qualified     # 🍌 E2.0 banana",
        "\uD83C\uDF4C",
        "1F34D                                      ; fully-qualified     # 🍍 E2.0 pineapple",
        "\uD83C\uDF4D",
        "1F96D                                      ; fully-qualified     # 🥭 E11.0 mango",
        "\uD83E\uDD6D",
        "1F34E                                      ; fully-qualified     # 🍎 E2.0 red apple",
        "\uD83C\uDF4E",
        "1F34F                                      ; fully-qualified     # 🍏 E2.0 green apple",
        "\uD83C\uDF4F",
        "1F350                                      ; fully-qualified     # 🍐 E2.0 pear",
        "\uD83C\uDF50",
        "1F351                                      ; fully-qualified     # 🍑 E2.0 peach",
        "\uD83C\uDF51",
        "1F352                                      ; fully-qualified     # 🍒 E2.0 cherries",
        "\uD83C\uDF52",
        "1F353                                      ; fully-qualified     # 🍓 E2.0 strawberry",
        "\uD83C\uDF53",
        "1F95D                                      ; fully-qualified     # 🥝 E4.0 kiwi fruit",
        "\uD83E\uDD5D",
        "1F345                                      ; fully-qualified     # 🍅 E2.0 tomato",
        "\uD83C\uDF45",
        "1F965                                      ; fully-qualified     # 🥥 E5.0 coconut",
        "\uD83E\uDD65",
        "1F951                                      ; fully-qualified     # 🥑 E4.0 avocado",
        "\uD83E\uDD51",
        "1F346                                      ; fully-qualified     # 🍆 E2.0 eggplant",
        "\uD83C\uDF46",
        "1F954                                      ; fully-qualified     # 🥔 E4.0 potato",
        "\uD83E\uDD54",
        "1F955                                      ; fully-qualified     # 🥕 E4.0 carrot",
        "\uD83E\uDD55",
        "1F33D                                      ; fully-qualified     # 🌽 E2.0 ear of corn",
        "\uD83C\uDF3D",
        "1F336 FE0F                                 ; fully-qualified     # 🌶️ E2.0 hot pepper",
        "\uD83C\uDF36\uFE0F",
        "1F336                                      ; unqualified         # 🌶 E2.0 hot pepper",
        "\uD83C\uDF36",
        "1F952                                      ; fully-qualified     # 🥒 E4.0 cucumber",
        "\uD83E\uDD52",
        "1F96C                                      ; fully-qualified     # 🥬 E11.0 leafy green",
        "\uD83E\uDD6C",
        "1F966                                      ; fully-qualified     # 🥦 E5.0 broccoli",
        "\uD83E\uDD66",
        "1F9C4                                      ; fully-qualified     # 🧄 E12.1 garlic",
        "\uD83E\uDDC4",
        "1F9C5                                      ; fully-qualified     # 🧅 E12.1 onion",
        "\uD83E\uDDC5",
        "1F344                                      ; fully-qualified     # 🍄 E2.0 mushroom",
        "\uD83C\uDF44",
        "1F95C                                      ; fully-qualified     # 🥜 E4.0 peanuts",
        "\uD83E\uDD5C",
        "1F330                                      ; fully-qualified     # 🌰 E2.0 chestnut",
        "\uD83C\uDF30",
        "1F35E                                      ; fully-qualified     # 🍞 E2.0 bread",
        "\uD83C\uDF5E",
        "1F950                                      ; fully-qualified     # 🥐 E4.0 croissant",
        "\uD83E\uDD50",
        "1F956                                      ; fully-qualified     # 🥖 E4.0 baguette bread",
        "\uD83E\uDD56",
        "1F968                                      ; fully-qualified     # 🥨 E5.0 pretzel",
        "\uD83E\uDD68",
        "1F96F                                      ; fully-qualified     # 🥯 E11.0 bagel",
        "\uD83E\uDD6F",
        "1F95E                                      ; fully-qualified     # 🥞 E4.0 pancakes",
        "\uD83E\uDD5E",
        "1F9C7                                      ; fully-qualified     # 🧇 E12.1 waffle",
        "\uD83E\uDDC7",
        "1F9C0                                      ; fully-qualified     # 🧀 E2.0 cheese wedge",
        "\uD83E\uDDC0",
        "1F356                                      ; fully-qualified     # 🍖 E2.0 meat on bone",
        "\uD83C\uDF56",
        "1F357                                      ; fully-qualified     # 🍗 E2.0 poultry leg",
        "\uD83C\uDF57",
        "1F969                                      ; fully-qualified     # 🥩 E5.0 cut of meat",
        "\uD83E\uDD69",
        "1F953                                      ; fully-qualified     # 🥓 E4.0 bacon",
        "\uD83E\uDD53",
        "1F354                                      ; fully-qualified     # 🍔 E2.0 hamburger",
        "\uD83C\uDF54",
        "1F35F                                      ; fully-qualified     # 🍟 E2.0 french fries",
        "\uD83C\uDF5F",
        "1F355                                      ; fully-qualified     # 🍕 E2.0 pizza",
        "\uD83C\uDF55",
        "1F32D                                      ; fully-qualified     # 🌭 E2.0 hot dog",
        "\uD83C\uDF2D",
        "1F96A                                      ; fully-qualified     # 🥪 E5.0 sandwich",
        "\uD83E\uDD6A",
        "1F32E                                      ; fully-qualified     # 🌮 E2.0 taco",
        "\uD83C\uDF2E",
        "1F32F                                      ; fully-qualified     # 🌯 E2.0 burrito",
        "\uD83C\uDF2F",
        "1F959                                      ; fully-qualified     # 🥙 E4.0 stuffed flatbread",
        "\uD83E\uDD59",
        "1F9C6                                      ; fully-qualified     # 🧆 E12.1 falafel",
        "\uD83E\uDDC6",
        "1F95A                                      ; fully-qualified     # 🥚 E4.0 egg",
        "\uD83E\uDD5A",
        "1F373                                      ; fully-qualified     # 🍳 E2.0 cooking",
        "\uD83C\uDF73",
        "1F958                                      ; fully-qualified     # 🥘 E4.0 shallow pan of food",
        "\uD83E\uDD58",
        "1F372                                      ; fully-qualified     # 🍲 E2.0 pot of food",
        "\uD83C\uDF72",
        "1F963                                      ; fully-qualified     # 🥣 E5.0 bowl with spoon",
        "\uD83E\uDD63",
        "1F957                                      ; fully-qualified     # 🥗 E4.0 green salad",
        "\uD83E\uDD57",
        "1F37F                                      ; fully-qualified     # 🍿 E2.0 popcorn",
        "\uD83C\uDF7F",
        "1F9C8                                      ; fully-qualified     # 🧈 E12.1 butter",
        "\uD83E\uDDC8",
        "1F9C2                                      ; fully-qualified     # 🧂 E11.0 salt",
        "\uD83E\uDDC2",
        "1F96B                                      ; fully-qualified     # 🥫 E5.0 canned food",
        "\uD83E\uDD6B",
        "1F371                                      ; fully-qualified     # 🍱 E2.0 bento box",
        "\uD83C\uDF71",
        "1F358                                      ; fully-qualified     # 🍘 E2.0 rice cracker",
        "\uD83C\uDF58",
        "1F359                                      ; fully-qualified     # 🍙 E2.0 rice ball",
        "\uD83C\uDF59",
        "1F35A                                      ; fully-qualified     # 🍚 E2.0 cooked rice",
        "\uD83C\uDF5A",
        "1F35B                                      ; fully-qualified     # 🍛 E2.0 curry rice",
        "\uD83C\uDF5B",
        "1F35C                                      ; fully-qualified     # 🍜 E2.0 steaming bowl",
        "\uD83C\uDF5C",
        "1F35D                                      ; fully-qualified     # 🍝 E2.0 spaghetti",
        "\uD83C\uDF5D",
        "1F360                                      ; fully-qualified     # 🍠 E2.0 roasted sweet potato",
        "\uD83C\uDF60",
        "1F362                                      ; fully-qualified     # 🍢 E2.0 oden",
        "\uD83C\uDF62",
        "1F363                                      ; fully-qualified     # 🍣 E2.0 sushi",
        "\uD83C\uDF63",
        "1F364                                      ; fully-qualified     # 🍤 E2.0 fried shrimp",
        "\uD83C\uDF64",
        "1F365                                      ; fully-qualified     # 🍥 E2.0 fish cake with swirl",
        "\uD83C\uDF65",
        "1F96E                                      ; fully-qualified     # 🥮 E11.0 moon cake",
        "\uD83E\uDD6E",
        "1F361                                      ; fully-qualified     # 🍡 E2.0 dango",
        "\uD83C\uDF61",
        "1F95F                                      ; fully-qualified     # 🥟 E5.0 dumpling",
        "\uD83E\uDD5F",
        "1F960                                      ; fully-qualified     # 🥠 E5.0 fortune cookie",
        "\uD83E\uDD60",
        "1F961                                      ; fully-qualified     # 🥡 E5.0 takeout box",
        "\uD83E\uDD61",
        "1F980                                      ; fully-qualified     # 🦀 E2.0 crab",
        "\uD83E\uDD80",
        "1F99E                                      ; fully-qualified     # 🦞 E11.0 lobster",
        "\uD83E\uDD9E",
        "1F990                                      ; fully-qualified     # 🦐 E4.0 shrimp",
        "\uD83E\uDD90",
        "1F991                                      ; fully-qualified     # 🦑 E4.0 squid",
        "\uD83E\uDD91",
        "1F9AA                                      ; fully-qualified     # 🦪 E12.1 oyster",
        "\uD83E\uDDAA",
        "1F366                                      ; fully-qualified     # 🍦 E2.0 soft ice cream",
        "\uD83C\uDF66",
        "1F367                                      ; fully-qualified     # 🍧 E2.0 shaved ice",
        "\uD83C\uDF67",
        "1F368                                      ; fully-qualified     # 🍨 E2.0 ice cream",
        "\uD83C\uDF68",
        "1F369                                      ; fully-qualified     # 🍩 E2.0 doughnut",
        "\uD83C\uDF69",
        "1F36A                                      ; fully-qualified     # 🍪 E2.0 cookie",
        "\uD83C\uDF6A",
        "1F382                                      ; fully-qualified     # 🎂 E2.0 birthday cake",
        "\uD83C\uDF82",
        "1F370                                      ; fully-qualified     # 🍰 E2.0 shortcake",
        "\uD83C\uDF70",
        "1F9C1                                      ; fully-qualified     # 🧁 E11.0 cupcake",
        "\uD83E\uDDC1",
        "1F967                                      ; fully-qualified     # 🥧 E5.0 pie",
        "\uD83E\uDD67",
        "1F36B                                      ; fully-qualified     # 🍫 E2.0 chocolate bar",
        "\uD83C\uDF6B",
        "1F36C                                      ; fully-qualified     # 🍬 E2.0 candy",
        "\uD83C\uDF6C",
        "1F36D                                      ; fully-qualified     # 🍭 E2.0 lollipop",
        "\uD83C\uDF6D",
        "1F36E                                      ; fully-qualified     # 🍮 E2.0 custard",
        "\uD83C\uDF6E",
        "1F36F                                      ; fully-qualified     # 🍯 E2.0 honey pot",
        "\uD83C\uDF6F",
        "1F37C                                      ; fully-qualified     # 🍼 E2.0 baby bottle",
        "\uD83C\uDF7C",
        "1F95B                                      ; fully-qualified     # 🥛 E4.0 glass of milk",
        "\uD83E\uDD5B",
        "2615                                       ; fully-qualified     # ☕ E2.0 hot beverage",
        "\u2615",
        "1F375                                      ; fully-qualified     # 🍵 E2.0 teacup without handle",
        "\uD83C\uDF75",
        "1F376                                      ; fully-qualified     # 🍶 E2.0 sake",
        "\uD83C\uDF76",
        "1F37E                                      ; fully-qualified     # 🍾 E2.0 bottle with popping cork",
        "\uD83C\uDF7E",
        "1F377                                      ; fully-qualified     # 🍷 E2.0 wine glass",
        "\uD83C\uDF77",
        "1F378                                      ; fully-qualified     # 🍸 E2.0 cocktail glass",
        "\uD83C\uDF78",
        "1F379                                      ; fully-qualified     # 🍹 E2.0 tropical drink",
        "\uD83C\uDF79",
        "1F37A                                      ; fully-qualified     # 🍺 E2.0 beer mug",
        "\uD83C\uDF7A",
        "1F37B                                      ; fully-qualified     # 🍻 E2.0 clinking beer mugs",
        "\uD83C\uDF7B",
        "1F942                                      ; fully-qualified     # 🥂 E4.0 clinking glasses",
        "\uD83E\uDD42",
        "1F943                                      ; fully-qualified     # 🥃 E4.0 tumbler glass",
        "\uD83E\uDD43",
        "1F964                                      ; fully-qualified     # 🥤 E5.0 cup with straw",
        "\uD83E\uDD64",
        "1F9C3                                      ; fully-qualified     # 🧃 E12.1 beverage box",
        "\uD83E\uDDC3",
        "1F9C9                                      ; fully-qualified     # 🧉 E12.1 mate",
        "\uD83E\uDDC9",
        "1F9CA                                      ; fully-qualified     # 🧊 E12.1 ice",
        "\uD83E\uDDCA",
        "1F962                                      ; fully-qualified     # 🥢 E5.0 chopsticks",
        "\uD83E\uDD62",
        "1F37D FE0F                                 ; fully-qualified     # 🍽️ E2.0 fork and knife with plate",
        "\uD83C\uDF7D\uFE0F",
        "1F37D                                      ; unqualified         # 🍽 E2.0 fork and knife with plate",
        "\uD83C\uDF7D",
        "1F374                                      ; fully-qualified     # 🍴 E2.0 fork and knife",
        "\uD83C\uDF74",
        "1F944                                      ; fully-qualified     # 🥄 E4.0 spoon",
        "\uD83E\uDD44",
        "1F52A                                      ; fully-qualified     # 🔪 E2.0 kitchen knife",
        "\uD83D\uDD2A",
        "1F3FA                                      ; fully-qualified     # 🏺 E2.0 amphora",
        "\uD83C\uDFFA",
        "1F30D                                      ; fully-qualified     # 🌍 E2.0 globe showing Europe-Africa",
        "\uD83C\uDF0D",
        "1F30E                                      ; fully-qualified     # 🌎 E2.0 globe showing Americas",
        "\uD83C\uDF0E",
        "1F30F                                      ; fully-qualified     # 🌏 E2.0 globe showing Asia-Australia",
        "\uD83C\uDF0F",
        "1F310                                      ; fully-qualified     # 🌐 E2.0 globe with meridians",
        "\uD83C\uDF10",
        "1F5FA FE0F                                 ; fully-qualified     # 🗺️ E2.0 world map",
        "\uD83D\uDDFA\uFE0F",
        "1F5FA                                      ; unqualified         # 🗺 E2.0 world map",
        "\uD83D\uDDFA",
        "1F5FE                                      ; fully-qualified     # 🗾 E2.0 map of Japan",
        "\uD83D\uDDFE",
        "1F9ED                                      ; fully-qualified     # 🧭 E11.0 compass",
        "\uD83E\uDDED",
        "1F3D4 FE0F                                 ; fully-qualified     # 🏔️ E2.0 snow-capped mountain",
        "\uD83C\uDFD4\uFE0F",
        "1F3D4                                      ; unqualified         # 🏔 E2.0 snow-capped mountain",
        "\uD83C\uDFD4",
        "26F0 FE0F                                  ; fully-qualified     # ⛰️ E2.0 mountain",
        "\u26F0\uFE0F",
        "26F0                                       ; unqualified         # ⛰ E2.0 mountain",
        "\u26F0",
        "1F30B                                      ; fully-qualified     # 🌋 E2.0 volcano",
        "\uD83C\uDF0B",
        "1F5FB                                      ; fully-qualified     # 🗻 E2.0 mount fuji",
        "\uD83D\uDDFB",
        "1F3D5 FE0F                                 ; fully-qualified     # 🏕️ E2.0 camping",
        "\uD83C\uDFD5\uFE0F",
        "1F3D5                                      ; unqualified         # 🏕 E2.0 camping",
        "\uD83C\uDFD5",
        "1F3D6 FE0F                                 ; fully-qualified     # 🏖️ E2.0 beach with umbrella",
        "\uD83C\uDFD6\uFE0F",
        "1F3D6                                      ; unqualified         # 🏖 E2.0 beach with umbrella",
        "\uD83C\uDFD6",
        "1F3DC FE0F                                 ; fully-qualified     # 🏜️ E2.0 desert",
        "\uD83C\uDFDC\uFE0F",
        "1F3DC                                      ; unqualified         # 🏜 E2.0 desert",
        "\uD83C\uDFDC",
        "1F3DD FE0F                                 ; fully-qualified     # 🏝️ E2.0 desert island",
        "\uD83C\uDFDD\uFE0F",
        "1F3DD                                      ; unqualified         # 🏝 E2.0 desert island",
        "\uD83C\uDFDD",
        "1F3DE FE0F                                 ; fully-qualified     # 🏞️ E2.0 national park",
        "\uD83C\uDFDE\uFE0F",
        "1F3DE                                      ; unqualified         # 🏞 E2.0 national park",
        "\uD83C\uDFDE",
        "1F3DF FE0F                                 ; fully-qualified     # 🏟️ E2.0 stadium",
        "\uD83C\uDFDF\uFE0F",
        "1F3DF                                      ; unqualified         # 🏟 E2.0 stadium",
        "\uD83C\uDFDF",
        "1F3DB FE0F                                 ; fully-qualified     # 🏛️ E2.0 classical building",
        "\uD83C\uDFDB\uFE0F",
        "1F3DB                                      ; unqualified         # 🏛 E2.0 classical building",
        "\uD83C\uDFDB",
        "1F3D7 FE0F                                 ; fully-qualified     # 🏗️ E2.0 building construction",
        "\uD83C\uDFD7\uFE0F",
        "1F3D7                                      ; unqualified         # 🏗 E2.0 building construction",
        "\uD83C\uDFD7",
        "1F9F1                                      ; fully-qualified     # 🧱 E11.0 brick",
        "\uD83E\uDDF1",
        "1F3D8 FE0F                                 ; fully-qualified     # 🏘️ E2.0 houses",
        "\uD83C\uDFD8\uFE0F",
        "1F3D8                                      ; unqualified         # 🏘 E2.0 houses",
        "\uD83C\uDFD8",
        "1F3DA FE0F                                 ; fully-qualified     # 🏚️ E2.0 derelict house",
        "\uD83C\uDFDA\uFE0F",
        "1F3DA                                      ; unqualified         # 🏚 E2.0 derelict house",
        "\uD83C\uDFDA",
        "1F3E0                                      ; fully-qualified     # 🏠 E2.0 house",
        "\uD83C\uDFE0",
        "1F3E1                                      ; fully-qualified     # 🏡 E2.0 house with garden",
        "\uD83C\uDFE1",
        "1F3E2                                      ; fully-qualified     # 🏢 E2.0 office building",
        "\uD83C\uDFE2",
        "1F3E3                                      ; fully-qualified     # 🏣 E2.0 Japanese post office",
        "\uD83C\uDFE3",
        "1F3E4                                      ; fully-qualified     # 🏤 E2.0 post office",
        "\uD83C\uDFE4",
        "1F3E5                                      ; fully-qualified     # 🏥 E2.0 hospital",
        "\uD83C\uDFE5",
        "1F3E6                                      ; fully-qualified     # 🏦 E2.0 bank",
        "\uD83C\uDFE6",
        "1F3E8                                      ; fully-qualified     # 🏨 E2.0 hotel",
        "\uD83C\uDFE8",
        "1F3E9                                      ; fully-qualified     # 🏩 E2.0 love hotel",
        "\uD83C\uDFE9",
        "1F3EA                                      ; fully-qualified     # 🏪 E2.0 convenience store",
        "\uD83C\uDFEA",
        "1F3EB                                      ; fully-qualified     # 🏫 E2.0 school",
        "\uD83C\uDFEB",
        "1F3EC                                      ; fully-qualified     # 🏬 E2.0 department store",
        "\uD83C\uDFEC",
        "1F3ED                                      ; fully-qualified     # 🏭 E2.0 factory",
        "\uD83C\uDFED",
        "1F3EF                                      ; fully-qualified     # 🏯 E2.0 Japanese castle",
        "\uD83C\uDFEF",
        "1F3F0                                      ; fully-qualified     # 🏰 E2.0 castle",
        "\uD83C\uDFF0",
        "1F492                                      ; fully-qualified     # 💒 E2.0 wedding",
        "\uD83D\uDC92",
        "1F5FC                                      ; fully-qualified     # 🗼 E2.0 Tokyo tower",
        "\uD83D\uDDFC",
        "1F5FD                                      ; fully-qualified     # 🗽 E2.0 Statue of Liberty",
        "\uD83D\uDDFD",
        "26EA                                       ; fully-qualified     # ⛪ E2.0 church",
        "\u26EA",
        "1F54C                                      ; fully-qualified     # 🕌 E2.0 mosque",
        "\uD83D\uDD4C",
        "1F6D5                                      ; fully-qualified     # 🛕 E12.1 hindu temple",
        "\uD83D\uDED5",
        "1F54D                                      ; fully-qualified     # 🕍 E2.0 synagogue",
        "\uD83D\uDD4D",
        "26E9 FE0F                                  ; fully-qualified     # ⛩️ E2.0 shinto shrine",
        "\u26E9\uFE0F",
        "26E9                                       ; unqualified         # ⛩ E2.0 shinto shrine",
        "\u26E9",
        "1F54B                                      ; fully-qualified     # 🕋 E2.0 kaaba",
        "\uD83D\uDD4B",
        "26F2                                       ; fully-qualified     # ⛲ E2.0 fountain",
        "\u26F2",
        "26FA                                       ; fully-qualified     # ⛺ E2.0 tent",
        "\u26FA",
        "1F301                                      ; fully-qualified     # 🌁 E2.0 foggy",
        "\uD83C\uDF01",
        "1F303                                      ; fully-qualified     # 🌃 E2.0 night with stars",
        "\uD83C\uDF03",
        "1F3D9 FE0F                                 ; fully-qualified     # 🏙️ E2.0 cityscape",
        "\uD83C\uDFD9\uFE0F",
        "1F3D9                                      ; unqualified         # 🏙 E2.0 cityscape",
        "\uD83C\uDFD9",
        "1F304                                      ; fully-qualified     # 🌄 E2.0 sunrise over mountains",
        "\uD83C\uDF04",
        "1F305                                      ; fully-qualified     # 🌅 E2.0 sunrise",
        "\uD83C\uDF05",
        "1F306                                      ; fully-qualified     # 🌆 E2.0 cityscape at dusk",
        "\uD83C\uDF06",
        "1F307                                      ; fully-qualified     # 🌇 E2.0 sunset",
        "\uD83C\uDF07",
        "1F309                                      ; fully-qualified     # 🌉 E2.0 bridge at night",
        "\uD83C\uDF09",
        "2668 FE0F                                  ; fully-qualified     # ♨️ E2.0 hot springs",
        "\u2668\uFE0F",
        "2668                                       ; unqualified         # ♨ E2.0 hot springs",
        "\u2668",
        "1F3A0                                      ; fully-qualified     # 🎠 E2.0 carousel horse",
        "\uD83C\uDFA0",
        "1F3A1                                      ; fully-qualified     # 🎡 E2.0 ferris wheel",
        "\uD83C\uDFA1",
        "1F3A2                                      ; fully-qualified     # 🎢 E2.0 roller coaster",
        "\uD83C\uDFA2",
        "1F488                                      ; fully-qualified     # 💈 E2.0 barber pole",
        "\uD83D\uDC88",
        "1F3AA                                      ; fully-qualified     # 🎪 E2.0 circus tent",
        "\uD83C\uDFAA",
        "1F682                                      ; fully-qualified     # 🚂 E2.0 locomotive",
        "\uD83D\uDE82",
        "1F683                                      ; fully-qualified     # 🚃 E2.0 railway car",
        "\uD83D\uDE83",
        "1F684                                      ; fully-qualified     # 🚄 E2.0 high-speed train",
        "\uD83D\uDE84",
        "1F685                                      ; fully-qualified     # 🚅 E2.0 bullet train",
        "\uD83D\uDE85",
        "1F686                                      ; fully-qualified     # 🚆 E2.0 train",
        "\uD83D\uDE86",
        "1F687                                      ; fully-qualified     # 🚇 E2.0 metro",
        "\uD83D\uDE87",
        "1F688                                      ; fully-qualified     # 🚈 E2.0 light rail",
        "\uD83D\uDE88",
        "1F689                                      ; fully-qualified     # 🚉 E2.0 station",
        "\uD83D\uDE89",
        "1F68A                                      ; fully-qualified     # 🚊 E2.0 tram",
        "\uD83D\uDE8A",
        "1F69D                                      ; fully-qualified     # 🚝 E2.0 monorail",
        "\uD83D\uDE9D",
        "1F69E                                      ; fully-qualified     # 🚞 E2.0 mountain railway",
        "\uD83D\uDE9E",
        "1F68B                                      ; fully-qualified     # 🚋 E2.0 tram car",
        "\uD83D\uDE8B",
        "1F68C                                      ; fully-qualified     # 🚌 E2.0 bus",
        "\uD83D\uDE8C",
        "1F68D                                      ; fully-qualified     # 🚍 E2.0 oncoming bus",
        "\uD83D\uDE8D",
        "1F68E                                      ; fully-qualified     # 🚎 E2.0 trolleybus",
        "\uD83D\uDE8E",
        "1F690                                      ; fully-qualified     # 🚐 E2.0 minibus",
        "\uD83D\uDE90",
        "1F691                                      ; fully-qualified     # 🚑 E2.0 ambulance",
        "\uD83D\uDE91",
        "1F692                                      ; fully-qualified     # 🚒 E2.0 fire engine",
        "\uD83D\uDE92",
        "1F693                                      ; fully-qualified     # 🚓 E2.0 police car",
        "\uD83D\uDE93",
        "1F694                                      ; fully-qualified     # 🚔 E2.0 oncoming police car",
        "\uD83D\uDE94",
        "1F695                                      ; fully-qualified     # 🚕 E2.0 taxi",
        "\uD83D\uDE95",
        "1F696                                      ; fully-qualified     # 🚖 E2.0 oncoming taxi",
        "\uD83D\uDE96",
        "1F697                                      ; fully-qualified     # 🚗 E2.0 automobile",
        "\uD83D\uDE97",
        "1F698                                      ; fully-qualified     # 🚘 E2.0 oncoming automobile",
        "\uD83D\uDE98",
        "1F699                                      ; fully-qualified     # 🚙 E2.0 sport utility vehicle",
        "\uD83D\uDE99",
        "1F69A                                      ; fully-qualified     # 🚚 E2.0 delivery truck",
        "\uD83D\uDE9A",
        "1F69B                                      ; fully-qualified     # 🚛 E2.0 articulated lorry",
        "\uD83D\uDE9B",
        "1F69C                                      ; fully-qualified     # 🚜 E2.0 tractor",
        "\uD83D\uDE9C",
        "1F3CE FE0F                                 ; fully-qualified     # 🏎️ E2.0 racing car",
        "\uD83C\uDFCE\uFE0F",
        "1F3CE                                      ; unqualified         # 🏎 E2.0 racing car",
        "\uD83C\uDFCE",
        "1F3CD FE0F                                 ; fully-qualified     # 🏍️ E2.0 motorcycle",
        "\uD83C\uDFCD\uFE0F",
        "1F3CD                                      ; unqualified         # 🏍 E2.0 motorcycle",
        "\uD83C\uDFCD",
        "1F6F5                                      ; fully-qualified     # 🛵 E4.0 motor scooter",
        "\uD83D\uDEF5",
        "1F9BD                                      ; fully-qualified     # 🦽 E12.1 manual wheelchair",
        "\uD83E\uDDBD",
        "1F9BC                                      ; fully-qualified     # 🦼 E12.1 motorized wheelchair",
        "\uD83E\uDDBC",
        "1F6FA                                      ; fully-qualified     # 🛺 E12.1 auto rickshaw",
        "\uD83D\uDEFA",
        "1F6B2                                      ; fully-qualified     # 🚲 E2.0 bicycle",
        "\uD83D\uDEB2",
        "1F6F4                                      ; fully-qualified     # 🛴 E4.0 kick scooter",
        "\uD83D\uDEF4",
        "1F6F9                                      ; fully-qualified     # 🛹 E11.0 skateboard",
        "\uD83D\uDEF9",
        "1F68F                                      ; fully-qualified     # 🚏 E2.0 bus stop",
        "\uD83D\uDE8F",
        "1F6E3 FE0F                                 ; fully-qualified     # 🛣️ E2.0 motorway",
        "\uD83D\uDEE3\uFE0F",
        "1F6E3                                      ; unqualified         # 🛣 E2.0 motorway",
        "\uD83D\uDEE3",
        "1F6E4 FE0F                                 ; fully-qualified     # 🛤️ E2.0 railway track",
        "\uD83D\uDEE4\uFE0F",
        "1F6E4                                      ; unqualified         # 🛤 E2.0 railway track",
        "\uD83D\uDEE4",
        "1F6E2 FE0F                                 ; fully-qualified     # 🛢️ E2.0 oil drum",
        "\uD83D\uDEE2\uFE0F",
        "1F6E2                                      ; unqualified         # 🛢 E2.0 oil drum",
        "\uD83D\uDEE2",
        "26FD                                       ; fully-qualified     # ⛽ E2.0 fuel pump",
        "\u26FD",
        "1F6A8                                      ; fully-qualified     # 🚨 E2.0 police car light",
        "\uD83D\uDEA8",
        "1F6A5                                      ; fully-qualified     # 🚥 E2.0 horizontal traffic light",
        "\uD83D\uDEA5",
        "1F6A6                                      ; fully-qualified     # 🚦 E2.0 vertical traffic light",
        "\uD83D\uDEA6",
        "1F6D1                                      ; fully-qualified     # 🛑 E4.0 stop sign",
        "\uD83D\uDED1",
        "1F6A7                                      ; fully-qualified     # 🚧 E2.0 construction",
        "\uD83D\uDEA7",
        "2693                                       ; fully-qualified     # ⚓ E2.0 anchor",
        "\u2693",
        "26F5                                       ; fully-qualified     # ⛵ E2.0 sailboat",
        "\u26F5",
        "1F6F6                                      ; fully-qualified     # 🛶 E4.0 canoe",
        "\uD83D\uDEF6",
        "1F6A4                                      ; fully-qualified     # 🚤 E2.0 speedboat",
        "\uD83D\uDEA4",
        "1F6F3 FE0F                                 ; fully-qualified     # 🛳️ E2.0 passenger ship",
        "\uD83D\uDEF3\uFE0F",
        "1F6F3                                      ; unqualified         # 🛳 E2.0 passenger ship",
        "\uD83D\uDEF3",
        "26F4 FE0F                                  ; fully-qualified     # ⛴️ E2.0 ferry",
        "\u26F4\uFE0F",
        "26F4                                       ; unqualified         # ⛴ E2.0 ferry",
        "\u26F4",
        "1F6E5 FE0F                                 ; fully-qualified     # 🛥️ E2.0 motor boat",
        "\uD83D\uDEE5\uFE0F",
        "1F6E5                                      ; unqualified         # 🛥 E2.0 motor boat",
        "\uD83D\uDEE5",
        "1F6A2                                      ; fully-qualified     # 🚢 E2.0 ship",
        "\uD83D\uDEA2",
        "2708 FE0F                                  ; fully-qualified     # ✈️ E2.0 airplane",
        "\u2708\uFE0F",
        "2708                                       ; unqualified         # ✈ E2.0 airplane",
        "\u2708",
        "1F6E9 FE0F                                 ; fully-qualified     # 🛩️ E2.0 small airplane",
        "\uD83D\uDEE9\uFE0F",
        "1F6E9                                      ; unqualified         # 🛩 E2.0 small airplane",
        "\uD83D\uDEE9",
        "1F6EB                                      ; fully-qualified     # 🛫 E2.0 airplane departure",
        "\uD83D\uDEEB",
        "1F6EC                                      ; fully-qualified     # 🛬 E2.0 airplane arrival",
        "\uD83D\uDEEC",
        "1FA82                                      ; fully-qualified     # 🪂 E12.1 parachute",
        "\uD83E\uDE82",
        "1F4BA                                      ; fully-qualified     # 💺 E2.0 seat",
        "\uD83D\uDCBA",
        "1F681                                      ; fully-qualified     # 🚁 E2.0 helicopter",
        "\uD83D\uDE81",
        "1F69F                                      ; fully-qualified     # 🚟 E2.0 suspension railway",
        "\uD83D\uDE9F",
        "1F6A0                                      ; fully-qualified     # 🚠 E2.0 mountain cableway",
        "\uD83D\uDEA0",
        "1F6A1                                      ; fully-qualified     # 🚡 E2.0 aerial tramway",
        "\uD83D\uDEA1",
        "1F6F0 FE0F                                 ; fully-qualified     # 🛰️ E2.0 satellite",
        "\uD83D\uDEF0\uFE0F",
        "1F6F0                                      ; unqualified         # 🛰 E2.0 satellite",
        "\uD83D\uDEF0",
        "1F680                                      ; fully-qualified     # 🚀 E2.0 rocket",
        "\uD83D\uDE80",
        "1F6F8                                      ; fully-qualified     # 🛸 E5.0 flying saucer",
        "\uD83D\uDEF8",
        "1F6CE FE0F                                 ; fully-qualified     # 🛎️ E2.0 bellhop bell",
        "\uD83D\uDECE\uFE0F",
        "1F6CE                                      ; unqualified         # 🛎 E2.0 bellhop bell",
        "\uD83D\uDECE",
        "1F9F3                                      ; fully-qualified     # 🧳 E11.0 luggage",
        "\uD83E\uDDF3",
        "231B                                       ; fully-qualified     # ⌛ E2.0 hourglass done",
        "\u231B",
        "23F3                                       ; fully-qualified     # ⏳ E2.0 hourglass not done",
        "\u23F3",
        "231A                                       ; fully-qualified     # ⌚ E2.0 watch",
        "\u231A",
        "23F0                                       ; fully-qualified     # ⏰ E2.0 alarm clock",
        "\u23F0",
        "23F1 FE0F                                  ; fully-qualified     # ⏱️ E2.0 stopwatch",
        "\u23F1\uFE0F",
        "23F1                                       ; unqualified         # ⏱ E2.0 stopwatch",
        "\u23F1",
        "23F2 FE0F                                  ; fully-qualified     # ⏲️ E2.0 timer clock",
        "\u23F2\uFE0F",
        "23F2                                       ; unqualified         # ⏲ E2.0 timer clock",
        "\u23F2",
        "1F570 FE0F                                 ; fully-qualified     # 🕰️ E2.0 mantelpiece clock",
        "\uD83D\uDD70\uFE0F",
        "1F570                                      ; unqualified         # 🕰 E2.0 mantelpiece clock",
        "\uD83D\uDD70",
        "1F55B                                      ; fully-qualified     # 🕛 E2.0 twelve o’clock",
        "\uD83D\uDD5B",
        "1F567                                      ; fully-qualified     # 🕧 E2.0 twelve-thirty",
        "\uD83D\uDD67",
        "1F550                                      ; fully-qualified     # 🕐 E2.0 one o’clock",
        "\uD83D\uDD50",
        "1F55C                                      ; fully-qualified     # 🕜 E2.0 one-thirty",
        "\uD83D\uDD5C",
        "1F551                                      ; fully-qualified     # 🕑 E2.0 two o’clock",
        "\uD83D\uDD51",
        "1F55D                                      ; fully-qualified     # 🕝 E2.0 two-thirty",
        "\uD83D\uDD5D",
        "1F552                                      ; fully-qualified     # 🕒 E2.0 three o’clock",
        "\uD83D\uDD52",
        "1F55E                                      ; fully-qualified     # 🕞 E2.0 three-thirty",
        "\uD83D\uDD5E",
        "1F553                                      ; fully-qualified     # 🕓 E2.0 four o’clock",
        "\uD83D\uDD53",
        "1F55F                                      ; fully-qualified     # 🕟 E2.0 four-thirty",
        "\uD83D\uDD5F",
        "1F554                                      ; fully-qualified     # 🕔 E2.0 five o’clock",
        "\uD83D\uDD54",
        "1F560                                      ; fully-qualified     # 🕠 E2.0 five-thirty",
        "\uD83D\uDD60",
        "1F555                                      ; fully-qualified     # 🕕 E2.0 six o’clock",
        "\uD83D\uDD55",
        "1F561                                      ; fully-qualified     # 🕡 E2.0 six-thirty",
        "\uD83D\uDD61",
        "1F556                                      ; fully-qualified     # 🕖 E2.0 seven o’clock",
        "\uD83D\uDD56",
        "1F562                                      ; fully-qualified     # 🕢 E2.0 seven-thirty",
        "\uD83D\uDD62",
        "1F557                                      ; fully-qualified     # 🕗 E2.0 eight o’clock",
        "\uD83D\uDD57",
        "1F563                                      ; fully-qualified     # 🕣 E2.0 eight-thirty",
        "\uD83D\uDD63",
        "1F558                                      ; fully-qualified     # 🕘 E2.0 nine o’clock",
        "\uD83D\uDD58",
        "1F564                                      ; fully-qualified     # 🕤 E2.0 nine-thirty",
        "\uD83D\uDD64",
        "1F559                                      ; fully-qualified     # 🕙 E2.0 ten o’clock",
        "\uD83D\uDD59",
        "1F565                                      ; fully-qualified     # 🕥 E2.0 ten-thirty",
        "\uD83D\uDD65",
        "1F55A                                      ; fully-qualified     # 🕚 E2.0 eleven o’clock",
        "\uD83D\uDD5A",
        "1F566                                      ; fully-qualified     # 🕦 E2.0 eleven-thirty",
        "\uD83D\uDD66",
        "1F311                                      ; fully-qualified     # 🌑 E2.0 new moon",
        "\uD83C\uDF11",
        "1F312                                      ; fully-qualified     # 🌒 E2.0 waxing crescent moon",
        "\uD83C\uDF12",
        "1F313                                      ; fully-qualified     # 🌓 E2.0 first quarter moon",
        "\uD83C\uDF13",
        "1F314                                      ; fully-qualified     # 🌔 E2.0 waxing gibbous moon",
        "\uD83C\uDF14",
        "1F315                                      ; fully-qualified     # 🌕 E2.0 full moon",
        "\uD83C\uDF15",
        "1F316                                      ; fully-qualified     # 🌖 E2.0 waning gibbous moon",
        "\uD83C\uDF16",
        "1F317                                      ; fully-qualified     # 🌗 E2.0 last quarter moon",
        "\uD83C\uDF17",
        "1F318                                      ; fully-qualified     # 🌘 E2.0 waning crescent moon",
        "\uD83C\uDF18",
        "1F319                                      ; fully-qualified     # 🌙 E2.0 crescent moon",
        "\uD83C\uDF19",
        "1F31A                                      ; fully-qualified     # 🌚 E2.0 new moon face",
        "\uD83C\uDF1A",
        "1F31B                                      ; fully-qualified     # 🌛 E2.0 first quarter moon face",
        "\uD83C\uDF1B",
        "1F31C                                      ; fully-qualified     # 🌜 E2.0 last quarter moon face",
        "\uD83C\uDF1C",
        "1F321 FE0F                                 ; fully-qualified     # 🌡️ E2.0 thermometer",
        "\uD83C\uDF21\uFE0F",
        "1F321                                      ; unqualified         # 🌡 E2.0 thermometer",
        "\uD83C\uDF21",
        "2600 FE0F                                  ; fully-qualified     # ☀️ E2.0 sun",
        "\u2600\uFE0F",
        "2600                                       ; unqualified         # ☀ E2.0 sun",
        "\u2600",
        "1F31D                                      ; fully-qualified     # 🌝 E2.0 full moon face",
        "\uD83C\uDF1D",
        "1F31E                                      ; fully-qualified     # 🌞 E2.0 sun with face",
        "\uD83C\uDF1E",
        "1FA90                                      ; fully-qualified     # 🪐 E12.1 ringed planet",
        "\uD83E\uDE90",
        "2B50                                       ; fully-qualified     # ⭐ E2.0 star",
        "\u2B50",
        "1F31F                                      ; fully-qualified     # 🌟 E2.0 glowing star",
        "\uD83C\uDF1F",
        "1F320                                      ; fully-qualified     # 🌠 E2.0 shooting star",
        "\uD83C\uDF20",
        "1F30C                                      ; fully-qualified     # 🌌 E2.0 milky way",
        "\uD83C\uDF0C",
        "2601 FE0F                                  ; fully-qualified     # ☁️ E2.0 cloud",
        "\u2601\uFE0F",
        "2601                                       ; unqualified         # ☁ E2.0 cloud",
        "\u2601",
        "26C5                                       ; fully-qualified     # ⛅ E2.0 sun behind cloud",
        "\u26C5",
        "26C8 FE0F                                  ; fully-qualified     # ⛈️ E2.0 cloud with lightning and rain",
        "\u26C8\uFE0F",
        "26C8                                       ; unqualified         # ⛈ E2.0 cloud with lightning and rain",
        "\u26C8",
        "1F324 FE0F                                 ; fully-qualified     # 🌤️ E2.0 sun behind small cloud",
        "\uD83C\uDF24\uFE0F",
        "1F324                                      ; unqualified         # 🌤 E2.0 sun behind small cloud",
        "\uD83C\uDF24",
        "1F325 FE0F                                 ; fully-qualified     # 🌥️ E2.0 sun behind large cloud",
        "\uD83C\uDF25\uFE0F",
        "1F325                                      ; unqualified         # 🌥 E2.0 sun behind large cloud",
        "\uD83C\uDF25",
        "1F326 FE0F                                 ; fully-qualified     # 🌦️ E2.0 sun behind rain cloud",
        "\uD83C\uDF26\uFE0F",
        "1F326                                      ; unqualified         # 🌦 E2.0 sun behind rain cloud",
        "\uD83C\uDF26",
        "1F327 FE0F                                 ; fully-qualified     # 🌧️ E2.0 cloud with rain",
        "\uD83C\uDF27\uFE0F",
        "1F327                                      ; unqualified         # 🌧 E2.0 cloud with rain",
        "\uD83C\uDF27",
        "1F328 FE0F                                 ; fully-qualified     # 🌨️ E2.0 cloud with snow",
        "\uD83C\uDF28\uFE0F",
        "1F328                                      ; unqualified         # 🌨 E2.0 cloud with snow",
        "\uD83C\uDF28",
        "1F329 FE0F                                 ; fully-qualified     # 🌩️ E2.0 cloud with lightning",
        "\uD83C\uDF29\uFE0F",
        "1F329                                      ; unqualified         # 🌩 E2.0 cloud with lightning",
        "\uD83C\uDF29",
        "1F32A FE0F                                 ; fully-qualified     # 🌪️ E2.0 tornado",
        "\uD83C\uDF2A\uFE0F",
        "1F32A                                      ; unqualified         # 🌪 E2.0 tornado",
        "\uD83C\uDF2A",
        "1F32B FE0F                                 ; fully-qualified     # 🌫️ E2.0 fog",
        "\uD83C\uDF2B\uFE0F",
        "1F32B                                      ; unqualified         # 🌫 E2.0 fog",
        "\uD83C\uDF2B",
        "1F32C FE0F                                 ; fully-qualified     # 🌬️ E2.0 wind face",
        "\uD83C\uDF2C\uFE0F",
        "1F32C                                      ; unqualified         # 🌬 E2.0 wind face",
        "\uD83C\uDF2C",
        "1F300                                      ; fully-qualified     # 🌀 E2.0 cyclone",
        "\uD83C\uDF00",
        "1F308                                      ; fully-qualified     # 🌈 E2.0 rainbow",
        "\uD83C\uDF08",
        "1F302                                      ; fully-qualified     # 🌂 E2.0 closed umbrella",
        "\uD83C\uDF02",
        "2602 FE0F                                  ; fully-qualified     # ☂️ E2.0 umbrella",
        "\u2602\uFE0F",
        "2602                                       ; unqualified         # ☂ E2.0 umbrella",
        "\u2602",
        "2614                                       ; fully-qualified     # ☔ E2.0 umbrella with rain drops",
        "\u2614",
        "26F1 FE0F                                  ; fully-qualified     # ⛱️ E2.0 umbrella on ground",
        "\u26F1\uFE0F",
        "26F1                                       ; unqualified         # ⛱ E2.0 umbrella on ground",
        "\u26F1",
        "26A1                                       ; fully-qualified     # ⚡ E2.0 high voltage",
        "\u26A1",
        "2744 FE0F                                  ; fully-qualified     # ❄️ E2.0 snowflake",
        "\u2744\uFE0F",
        "2744                                       ; unqualified         # ❄ E2.0 snowflake",
        "\u2744",
        "2603 FE0F                                  ; fully-qualified     # ☃️ E2.0 snowman",
        "\u2603\uFE0F",
        "2603                                       ; unqualified         # ☃ E2.0 snowman",
        "\u2603",
        "26C4                                       ; fully-qualified     # ⛄ E2.0 snowman without snow",
        "\u26C4",
        "2604 FE0F                                  ; fully-qualified     # ☄️ E2.0 comet",
        "\u2604\uFE0F",
        "2604                                       ; unqualified         # ☄ E2.0 comet",
        "\u2604",
        "1F525                                      ; fully-qualified     # 🔥 E2.0 fire",
        "\uD83D\uDD25",
        "1F4A7                                      ; fully-qualified     # 💧 E2.0 droplet",
        "\uD83D\uDCA7",
        "1F30A                                      ; fully-qualified     # 🌊 E2.0 water wave",
        "\uD83C\uDF0A",
        "1F383                                      ; fully-qualified     # 🎃 E2.0 jack-o-lantern",
        "\uD83C\uDF83",
        "1F384                                      ; fully-qualified     # 🎄 E2.0 Christmas tree",
        "\uD83C\uDF84",
        "1F386                                      ; fully-qualified     # 🎆 E2.0 fireworks",
        "\uD83C\uDF86",
        "1F387                                      ; fully-qualified     # 🎇 E2.0 sparkler",
        "\uD83C\uDF87",
        "1F9E8                                      ; fully-qualified     # 🧨 E11.0 firecracker",
        "\uD83E\uDDE8",
        "2728                                       ; fully-qualified     # ✨ E2.0 sparkles",
        "\u2728",
        "1F388                                      ; fully-qualified     # 🎈 E2.0 balloon",
        "\uD83C\uDF88",
        "1F389                                      ; fully-qualified     # 🎉 E2.0 party popper",
        "\uD83C\uDF89",
        "1F38A                                      ; fully-qualified     # 🎊 E2.0 confetti ball",
        "\uD83C\uDF8A",
        "1F38B                                      ; fully-qualified     # 🎋 E2.0 tanabata tree",
        "\uD83C\uDF8B",
        "1F38D                                      ; fully-qualified     # 🎍 E2.0 pine decoration",
        "\uD83C\uDF8D",
        "1F38E                                      ; fully-qualified     # 🎎 E2.0 Japanese dolls",
        "\uD83C\uDF8E",
        "1F38F                                      ; fully-qualified     # 🎏 E2.0 carp streamer",
        "\uD83C\uDF8F",
        "1F390                                      ; fully-qualified     # 🎐 E2.0 wind chime",
        "\uD83C\uDF90",
        "1F391                                      ; fully-qualified     # 🎑 E2.0 moon viewing ceremony",
        "\uD83C\uDF91",
        "1F9E7                                      ; fully-qualified     # 🧧 E11.0 red envelope",
        "\uD83E\uDDE7",
        "1F380                                      ; fully-qualified     # 🎀 E2.0 ribbon",
        "\uD83C\uDF80",
        "1F381                                      ; fully-qualified     # 🎁 E2.0 wrapped gift",
        "\uD83C\uDF81",
        "1F397 FE0F                                 ; fully-qualified     # 🎗️ E2.0 reminder ribbon",
        "\uD83C\uDF97\uFE0F",
        "1F397                                      ; unqualified         # 🎗 E2.0 reminder ribbon",
        "\uD83C\uDF97",
        "1F39F FE0F                                 ; fully-qualified     # 🎟️ E2.0 admission tickets",
        "\uD83C\uDF9F\uFE0F",
        "1F39F                                      ; unqualified         # 🎟 E2.0 admission tickets",
        "\uD83C\uDF9F",
        "1F3AB                                      ; fully-qualified     # 🎫 E2.0 ticket",
        "\uD83C\uDFAB",
        "1F396 FE0F                                 ; fully-qualified     # 🎖️ E2.0 military medal",
        "\uD83C\uDF96\uFE0F",
        "1F396                                      ; unqualified         # 🎖 E2.0 military medal",
        "\uD83C\uDF96",
        "1F3C6                                      ; fully-qualified     # 🏆 E2.0 trophy",
        "\uD83C\uDFC6",
        "1F3C5                                      ; fully-qualified     # 🏅 E2.0 sports medal",
        "\uD83C\uDFC5",
        "1F947                                      ; fully-qualified     # 🥇 E4.0 1st place medal",
        "\uD83E\uDD47",
        "1F948                                      ; fully-qualified     # 🥈 E4.0 2nd place medal",
        "\uD83E\uDD48",
        "1F949                                      ; fully-qualified     # 🥉 E4.0 3rd place medal",
        "\uD83E\uDD49",
        "26BD                                       ; fully-qualified     # ⚽ E2.0 soccer ball",
        "\u26BD",
        "26BE                                       ; fully-qualified     # ⚾ E2.0 baseball",
        "\u26BE",
        "1F94E                                      ; fully-qualified     # 🥎 E11.0 softball",
        "\uD83E\uDD4E",
        "1F3C0                                      ; fully-qualified     # 🏀 E2.0 basketball",
        "\uD83C\uDFC0",
        "1F3D0                                      ; fully-qualified     # 🏐 E2.0 volleyball",
        "\uD83C\uDFD0",
        "1F3C8                                      ; fully-qualified     # 🏈 E2.0 american football",
        "\uD83C\uDFC8",
        "1F3C9                                      ; fully-qualified     # 🏉 E2.0 rugby football",
        "\uD83C\uDFC9",
        "1F3BE                                      ; fully-qualified     # 🎾 E2.0 tennis",
        "\uD83C\uDFBE",
        "1F94F                                      ; fully-qualified     # 🥏 E11.0 flying disc",
        "\uD83E\uDD4F",
        "1F3B3                                      ; fully-qualified     # 🎳 E2.0 bowling",
        "\uD83C\uDFB3",
        "1F3CF                                      ; fully-qualified     # 🏏 E2.0 cricket game",
        "\uD83C\uDFCF",
        "1F3D1                                      ; fully-qualified     # 🏑 E2.0 field hockey",
        "\uD83C\uDFD1",
        "1F3D2                                      ; fully-qualified     # 🏒 E2.0 ice hockey",
        "\uD83C\uDFD2",
        "1F94D                                      ; fully-qualified     # 🥍 E11.0 lacrosse",
        "\uD83E\uDD4D",
        "1F3D3                                      ; fully-qualified     # 🏓 E2.0 ping pong",
        "\uD83C\uDFD3",
        "1F3F8                                      ; fully-qualified     # 🏸 E2.0 badminton",
        "\uD83C\uDFF8",
        "1F94A                                      ; fully-qualified     # 🥊 E4.0 boxing glove",
        "\uD83E\uDD4A",
        "1F94B                                      ; fully-qualified     # 🥋 E4.0 martial arts uniform",
        "\uD83E\uDD4B",
        "1F945                                      ; fully-qualified     # 🥅 E4.0 goal net",
        "\uD83E\uDD45",
        "26F3                                       ; fully-qualified     # ⛳ E2.0 flag in hole",
        "\u26F3",
        "26F8 FE0F                                  ; fully-qualified     # ⛸️ E2.0 ice skate",
        "\u26F8\uFE0F",
        "26F8                                       ; unqualified         # ⛸ E2.0 ice skate",
        "\u26F8",
        "1F3A3                                      ; fully-qualified     # 🎣 E2.0 fishing pole",
        "\uD83C\uDFA3",
        "1F93F                                      ; fully-qualified     # 🤿 E12.1 diving mask",
        "\uD83E\uDD3F",
        "1F3BD                                      ; fully-qualified     # 🎽 E2.0 running shirt",
        "\uD83C\uDFBD",
        "1F3BF                                      ; fully-qualified     # 🎿 E2.0 skis",
        "\uD83C\uDFBF",
        "1F6F7                                      ; fully-qualified     # 🛷 E5.0 sled",
        "\uD83D\uDEF7",
        "1F94C                                      ; fully-qualified     # 🥌 E5.0 curling stone",
        "\uD83E\uDD4C",
        "1F3AF                                      ; fully-qualified     # 🎯 E2.0 direct hit",
        "\uD83C\uDFAF",
        "1FA80                                      ; fully-qualified     # 🪀 E12.1 yo-yo",
        "\uD83E\uDE80",
        "1FA81                                      ; fully-qualified     # 🪁 E12.1 kite",
        "\uD83E\uDE81",
        "1F3B1                                      ; fully-qualified     # 🎱 E2.0 pool 8 ball",
        "\uD83C\uDFB1",
        "1F52E                                      ; fully-qualified     # 🔮 E2.0 crystal ball",
        "\uD83D\uDD2E",
        "1F9FF                                      ; fully-qualified     # 🧿 E11.0 nazar amulet",
        "\uD83E\uDDFF",
        "1F3AE                                      ; fully-qualified     # 🎮 E2.0 video game",
        "\uD83C\uDFAE",
        "1F579 FE0F                                 ; fully-qualified     # 🕹️ E2.0 joystick",
        "\uD83D\uDD79\uFE0F",
        "1F579                                      ; unqualified         # 🕹 E2.0 joystick",
        "\uD83D\uDD79",
        "1F3B0                                      ; fully-qualified     # 🎰 E2.0 slot machine",
        "\uD83C\uDFB0",
        "1F3B2                                      ; fully-qualified     # 🎲 E2.0 game die",
        "\uD83C\uDFB2",
        "1F9E9                                      ; fully-qualified     # 🧩 E11.0 puzzle piece",
        "\uD83E\uDDE9",
        "1F9F8                                      ; fully-qualified     # 🧸 E11.0 teddy bear",
        "\uD83E\uDDF8",
        "2660 FE0F                                  ; fully-qualified     # ♠️ E2.0 spade suit",
        "\u2660\uFE0F",
        "2660                                       ; unqualified         # ♠ E2.0 spade suit",
        "\u2660",
        "2665 FE0F                                  ; fully-qualified     # ♥️ E2.0 heart suit",
        "\u2665\uFE0F",
        "2665                                       ; unqualified         # ♥ E2.0 heart suit",
        "\u2665",
        "2666 FE0F                                  ; fully-qualified     # ♦️ E2.0 diamond suit",
        "\u2666\uFE0F",
        "2666                                       ; unqualified         # ♦ E2.0 diamond suit",
        "\u2666",
        "2663 FE0F                                  ; fully-qualified     # ♣️ E2.0 club suit",
        "\u2663\uFE0F",
        "2663                                       ; unqualified         # ♣ E2.0 club suit",
        "\u2663",
        "265F FE0F                                  ; fully-qualified     # ♟️ E11.0 chess pawn",
        "\u265F\uFE0F",
        "265F                                       ; unqualified         # ♟ E11.0 chess pawn",
        "\u265F",
        "1F0CF                                      ; fully-qualified     # 🃏 E2.0 joker",
        "\uD83C\uDCCF",
        "1F004                                      ; fully-qualified     # 🀄 E2.0 mahjong red dragon",
        "\uD83C\uDC04",
        "1F3B4                                      ; fully-qualified     # 🎴 E2.0 flower playing cards",
        "\uD83C\uDFB4",
        "1F3AD                                      ; fully-qualified     # 🎭 E2.0 performing arts",
        "\uD83C\uDFAD",
        "1F5BC FE0F                                 ; fully-qualified     # 🖼️ E2.0 framed picture",
        "\uD83D\uDDBC\uFE0F",
        "1F5BC                                      ; unqualified         # 🖼 E2.0 framed picture",
        "\uD83D\uDDBC",
        "1F3A8                                      ; fully-qualified     # 🎨 E2.0 artist palette",
        "\uD83C\uDFA8",
        "1F9F5                                      ; fully-qualified     # 🧵 E11.0 thread",
        "\uD83E\uDDF5",
        "1F9F6                                      ; fully-qualified     # 🧶 E11.0 yarn",
        "\uD83E\uDDF6",
        "1F453                                      ; fully-qualified     # 👓 E2.0 glasses",
        "\uD83D\uDC53",
        "1F576 FE0F                                 ; fully-qualified     # 🕶️ E2.0 sunglasses",
        "\uD83D\uDD76\uFE0F",
        "1F576                                      ; unqualified         # 🕶 E2.0 sunglasses",
        "\uD83D\uDD76",
        "1F97D                                      ; fully-qualified     # 🥽 E11.0 goggles",
        "\uD83E\uDD7D",
        "1F97C                                      ; fully-qualified     # 🥼 E11.0 lab coat",
        "\uD83E\uDD7C",
        "1F9BA                                      ; fully-qualified     # 🦺 E12.1 safety vest",
        "\uD83E\uDDBA",
        "1F454                                      ; fully-qualified     # 👔 E2.0 necktie",
        "\uD83D\uDC54",
        "1F455                                      ; fully-qualified     # 👕 E2.0 t-shirt",
        "\uD83D\uDC55",
        "1F456                                      ; fully-qualified     # 👖 E2.0 jeans",
        "\uD83D\uDC56",
        "1F9E3                                      ; fully-qualified     # 🧣 E5.0 scarf",
        "\uD83E\uDDE3",
        "1F9E4                                      ; fully-qualified     # 🧤 E5.0 gloves",
        "\uD83E\uDDE4",
        "1F9E5                                      ; fully-qualified     # 🧥 E5.0 coat",
        "\uD83E\uDDE5",
        "1F9E6                                      ; fully-qualified     # 🧦 E5.0 socks",
        "\uD83E\uDDE6",
        "1F457                                      ; fully-qualified     # 👗 E2.0 dress",
        "\uD83D\uDC57",
        "1F458                                      ; fully-qualified     # 👘 E2.0 kimono",
        "\uD83D\uDC58",
        "1F97B                                      ; fully-qualified     # 🥻 E12.1 sari",
        "\uD83E\uDD7B",
        "1FA71                                      ; fully-qualified     # 🩱 E12.1 one-piece swimsuit",
        "\uD83E\uDE71",
        "1FA72                                      ; fully-qualified     # 🩲 E12.1 briefs",
        "\uD83E\uDE72",
        "1FA73                                      ; fully-qualified     # 🩳 E12.1 shorts",
        "\uD83E\uDE73",
        "1F459                                      ; fully-qualified     # 👙 E2.0 bikini",
        "\uD83D\uDC59",
        "1F45A                                      ; fully-qualified     # 👚 E2.0 woman’s clothes",
        "\uD83D\uDC5A",
        "1F45B                                      ; fully-qualified     # 👛 E2.0 purse",
        "\uD83D\uDC5B",
        "1F45C                                      ; fully-qualified     # 👜 E2.0 handbag",
        "\uD83D\uDC5C",
        "1F45D                                      ; fully-qualified     # 👝 E2.0 clutch bag",
        "\uD83D\uDC5D",
        "1F6CD FE0F                                 ; fully-qualified     # 🛍️ E2.0 shopping bags",
        "\uD83D\uDECD\uFE0F",
        "1F6CD                                      ; unqualified         # 🛍 E2.0 shopping bags",
        "\uD83D\uDECD",
        "1F392                                      ; fully-qualified     # 🎒 E2.0 backpack",
        "\uD83C\uDF92",
        "1F45E                                      ; fully-qualified     # 👞 E2.0 man’s shoe",
        "\uD83D\uDC5E",
        "1F45F                                      ; fully-qualified     # 👟 E2.0 running shoe",
        "\uD83D\uDC5F",
        "1F97E                                      ; fully-qualified     # 🥾 E11.0 hiking boot",
        "\uD83E\uDD7E",
        "1F97F                                      ; fully-qualified     # 🥿 E11.0 flat shoe",
        "\uD83E\uDD7F",
        "1F460                                      ; fully-qualified     # 👠 E2.0 high-heeled shoe",
        "\uD83D\uDC60",
        "1F461                                      ; fully-qualified     # 👡 E2.0 woman’s sandal",
        "\uD83D\uDC61",
        "1FA70                                      ; fully-qualified     # 🩰 E12.1 ballet shoes",
        "\uD83E\uDE70",
        "1F462                                      ; fully-qualified     # 👢 E2.0 woman’s boot",
        "\uD83D\uDC62",
        "1F451                                      ; fully-qualified     # 👑 E2.0 crown",
        "\uD83D\uDC51",
        "1F452                                      ; fully-qualified     # 👒 E2.0 woman’s hat",
        "\uD83D\uDC52",
        "1F3A9                                      ; fully-qualified     # 🎩 E2.0 top hat",
        "\uD83C\uDFA9",
        "1F393                                      ; fully-qualified     # 🎓 E2.0 graduation cap",
        "\uD83C\uDF93",
        "1F9E2                                      ; fully-qualified     # 🧢 E5.0 billed cap",
        "\uD83E\uDDE2",
        "26D1 FE0F                                  ; fully-qualified     # ⛑️ E2.0 rescue worker’s helmet",
        "\u26D1\uFE0F",
        "26D1                                       ; unqualified         # ⛑ E2.0 rescue worker’s helmet",
        "\u26D1",
        "1F4FF                                      ; fully-qualified     # 📿 E2.0 prayer beads",
        "\uD83D\uDCFF",
        "1F484                                      ; fully-qualified     # 💄 E2.0 lipstick",
        "\uD83D\uDC84",
        "1F48D                                      ; fully-qualified     # 💍 E2.0 ring",
        "\uD83D\uDC8D",
        "1F48E                                      ; fully-qualified     # 💎 E2.0 gem stone",
        "\uD83D\uDC8E",
        "1F507                                      ; fully-qualified     # 🔇 E2.0 muted speaker",
        "\uD83D\uDD07",
        "1F508                                      ; fully-qualified     # 🔈 E2.0 speaker low volume",
        "\uD83D\uDD08",
        "1F509                                      ; fully-qualified     # 🔉 E2.0 speaker medium volume",
        "\uD83D\uDD09",
        "1F50A                                      ; fully-qualified     # 🔊 E2.0 speaker high volume",
        "\uD83D\uDD0A",
        "1F4E2                                      ; fully-qualified     # 📢 E2.0 loudspeaker",
        "\uD83D\uDCE2",
        "1F4E3                                      ; fully-qualified     # 📣 E2.0 megaphone",
        "\uD83D\uDCE3",
        "1F4EF                                      ; fully-qualified     # 📯 E2.0 postal horn",
        "\uD83D\uDCEF",
        "1F514                                      ; fully-qualified     # 🔔 E2.0 bell",
        "\uD83D\uDD14",
        "1F515                                      ; fully-qualified     # 🔕 E2.0 bell with slash",
        "\uD83D\uDD15",
        "1F3BC                                      ; fully-qualified     # 🎼 E2.0 musical score",
        "\uD83C\uDFBC",
        "1F3B5                                      ; fully-qualified     # 🎵 E2.0 musical note",
        "\uD83C\uDFB5",
        "1F3B6                                      ; fully-qualified     # 🎶 E2.0 musical notes",
        "\uD83C\uDFB6",
        "1F399 FE0F                                 ; fully-qualified     # 🎙️ E2.0 studio microphone",
        "\uD83C\uDF99\uFE0F",
        "1F399                                      ; unqualified         # 🎙 E2.0 studio microphone",
        "\uD83C\uDF99",
        "1F39A FE0F                                 ; fully-qualified     # 🎚️ E2.0 level slider",
        "\uD83C\uDF9A\uFE0F",
        "1F39A                                      ; unqualified         # 🎚 E2.0 level slider",
        "\uD83C\uDF9A",
        "1F39B FE0F                                 ; fully-qualified     # 🎛️ E2.0 control knobs",
        "\uD83C\uDF9B\uFE0F",
        "1F39B                                      ; unqualified         # 🎛 E2.0 control knobs",
        "\uD83C\uDF9B",
        "1F3A4                                      ; fully-qualified     # 🎤 E2.0 microphone",
        "\uD83C\uDFA4",
        "1F3A7                                      ; fully-qualified     # 🎧 E2.0 headphone",
        "\uD83C\uDFA7",
        "1F4FB                                      ; fully-qualified     # 📻 E2.0 radio",
        "\uD83D\uDCFB",
        "1F3B7                                      ; fully-qualified     # 🎷 E2.0 saxophone",
        "\uD83C\uDFB7",
        "1F3B8                                      ; fully-qualified     # 🎸 E2.0 guitar",
        "\uD83C\uDFB8",
        "1F3B9                                      ; fully-qualified     # 🎹 E2.0 musical keyboard",
        "\uD83C\uDFB9",
        "1F3BA                                      ; fully-qualified     # 🎺 E2.0 trumpet",
        "\uD83C\uDFBA",
        "1F3BB                                      ; fully-qualified     # 🎻 E2.0 violin",
        "\uD83C\uDFBB",
        "1FA95                                      ; fully-qualified     # 🪕 E12.1 banjo",
        "\uD83E\uDE95",
        "1F941                                      ; fully-qualified     # 🥁 E4.0 drum",
        "\uD83E\uDD41",
        "1F4F1                                      ; fully-qualified     # 📱 E2.0 mobile phone",
        "\uD83D\uDCF1",
        "1F4F2                                      ; fully-qualified     # 📲 E2.0 mobile phone with arrow",
        "\uD83D\uDCF2",
        "260E FE0F                                  ; fully-qualified     # ☎️ E2.0 telephone",
        "\u260E\uFE0F",
        "260E                                       ; unqualified         # ☎ E2.0 telephone",
        "\u260E",
        "1F4DE                                      ; fully-qualified     # 📞 E2.0 telephone receiver",
        "\uD83D\uDCDE",
        "1F4DF                                      ; fully-qualified     # 📟 E2.0 pager",
        "\uD83D\uDCDF",
        "1F4E0                                      ; fully-qualified     # 📠 E2.0 fax machine",
        "\uD83D\uDCE0",
        "1F50B                                      ; fully-qualified     # 🔋 E2.0 battery",
        "\uD83D\uDD0B",
        "1F50C                                      ; fully-qualified     # 🔌 E2.0 electric plug",
        "\uD83D\uDD0C",
        "1F4BB                                      ; fully-qualified     # 💻 E2.0 laptop",
        "\uD83D\uDCBB",
        "1F5A5 FE0F                                 ; fully-qualified     # 🖥️ E2.0 desktop computer",
        "\uD83D\uDDA5\uFE0F",
        "1F5A5                                      ; unqualified         # 🖥 E2.0 desktop computer",
        "\uD83D\uDDA5",
        "1F5A8 FE0F                                 ; fully-qualified     # 🖨️ E2.0 printer",
        "\uD83D\uDDA8\uFE0F",
        "1F5A8                                      ; unqualified         # 🖨 E2.0 printer",
        "\uD83D\uDDA8",
        "2328 FE0F                                  ; fully-qualified     # ⌨️ E2.0 keyboard",
        "\u2328\uFE0F",
        "2328                                       ; unqualified         # ⌨ E2.0 keyboard",
        "\u2328",
        "1F5B1 FE0F                                 ; fully-qualified     # 🖱️ E2.0 computer mouse",
        "\uD83D\uDDB1\uFE0F",
        "1F5B1                                      ; unqualified         # 🖱 E2.0 computer mouse",
        "\uD83D\uDDB1",
        "1F5B2 FE0F                                 ; fully-qualified     # 🖲️ E2.0 trackball",
        "\uD83D\uDDB2\uFE0F",
        "1F5B2                                      ; unqualified         # 🖲 E2.0 trackball",
        "\uD83D\uDDB2",
        "1F4BD                                      ; fully-qualified     # 💽 E2.0 computer disk",
        "\uD83D\uDCBD",
        "1F4BE                                      ; fully-qualified     # 💾 E2.0 floppy disk",
        "\uD83D\uDCBE",
        "1F4BF                                      ; fully-qualified     # 💿 E2.0 optical disk",
        "\uD83D\uDCBF",
        "1F4C0                                      ; fully-qualified     # 📀 E2.0 dvd",
        "\uD83D\uDCC0",
        "1F9EE                                      ; fully-qualified     # 🧮 E11.0 abacus",
        "\uD83E\uDDEE",
        "1F3A5                                      ; fully-qualified     # 🎥 E2.0 movie camera",
        "\uD83C\uDFA5",
        "1F39E FE0F                                 ; fully-qualified     # 🎞️ E2.0 film frames",
        "\uD83C\uDF9E\uFE0F",
        "1F39E                                      ; unqualified         # 🎞 E2.0 film frames",
        "\uD83C\uDF9E",
        "1F4FD FE0F                                 ; fully-qualified     # 📽️ E2.0 film projector",
        "\uD83D\uDCFD\uFE0F",
        "1F4FD                                      ; unqualified         # 📽 E2.0 film projector",
        "\uD83D\uDCFD",
        "1F3AC                                      ; fully-qualified     # 🎬 E2.0 clapper board",
        "\uD83C\uDFAC",
        "1F4FA                                      ; fully-qualified     # 📺 E2.0 television",
        "\uD83D\uDCFA",
        "1F4F7                                      ; fully-qualified     # 📷 E2.0 camera",
        "\uD83D\uDCF7",
        "1F4F8                                      ; fully-qualified     # 📸 E2.0 camera with flash",
        "\uD83D\uDCF8",
        "1F4F9                                      ; fully-qualified     # 📹 E2.0 video camera",
        "\uD83D\uDCF9",
        "1F4FC                                      ; fully-qualified     # 📼 E2.0 videocassette",
        "\uD83D\uDCFC",
        "1F50D                                      ; fully-qualified     # 🔍 E2.0 magnifying glass tilted left",
        "\uD83D\uDD0D",
        "1F50E                                      ; fully-qualified     # 🔎 E2.0 magnifying glass tilted right",
        "\uD83D\uDD0E",
        "1F56F FE0F                                 ; fully-qualified     # 🕯️ E2.0 candle",
        "\uD83D\uDD6F\uFE0F",
        "1F56F                                      ; unqualified         # 🕯 E2.0 candle",
        "\uD83D\uDD6F",
        "1F4A1                                      ; fully-qualified     # 💡 E2.0 light bulb",
        "\uD83D\uDCA1",
        "1F526                                      ; fully-qualified     # 🔦 E2.0 flashlight",
        "\uD83D\uDD26",
        "1F3EE                                      ; fully-qualified     # 🏮 E2.0 red paper lantern",
        "\uD83C\uDFEE",
        "1FA94                                      ; fully-qualified     # 🪔 E12.1 diya lamp",
        "\uD83E\uDE94",
        "1F4D4                                      ; fully-qualified     # 📔 E2.0 notebook with decorative cover",
        "\uD83D\uDCD4",
        "1F4D5                                      ; fully-qualified     # 📕 E2.0 closed book",
        "\uD83D\uDCD5",
        "1F4D6                                      ; fully-qualified     # 📖 E2.0 open book",
        "\uD83D\uDCD6",
        "1F4D7                                      ; fully-qualified     # 📗 E2.0 green book",
        "\uD83D\uDCD7",
        "1F4D8                                      ; fully-qualified     # 📘 E2.0 blue book",
        "\uD83D\uDCD8",
        "1F4D9                                      ; fully-qualified     # 📙 E2.0 orange book",
        "\uD83D\uDCD9",
        "1F4DA                                      ; fully-qualified     # 📚 E2.0 books",
        "\uD83D\uDCDA",
        "1F4D3                                      ; fully-qualified     # 📓 E2.0 notebook",
        "\uD83D\uDCD3",
        "1F4D2                                      ; fully-qualified     # 📒 E2.0 ledger",
        "\uD83D\uDCD2",
        "1F4C3                                      ; fully-qualified     # 📃 E2.0 page with curl",
        "\uD83D\uDCC3",
        "1F4DC                                      ; fully-qualified     # 📜 E2.0 scroll",
        "\uD83D\uDCDC",
        "1F4C4                                      ; fully-qualified     # 📄 E2.0 page facing up",
        "\uD83D\uDCC4",
        "1F4F0                                      ; fully-qualified     # 📰 E2.0 newspaper",
        "\uD83D\uDCF0",
        "1F5DE FE0F                                 ; fully-qualified     # 🗞️ E2.0 rolled-up newspaper",
        "\uD83D\uDDDE\uFE0F",
        "1F5DE                                      ; unqualified         # 🗞 E2.0 rolled-up newspaper",
        "\uD83D\uDDDE",
        "1F4D1                                      ; fully-qualified     # 📑 E2.0 bookmark tabs",
        "\uD83D\uDCD1",
        "1F516                                      ; fully-qualified     # 🔖 E2.0 bookmark",
        "\uD83D\uDD16",
        "1F3F7 FE0F                                 ; fully-qualified     # 🏷️ E2.0 label",
        "\uD83C\uDFF7\uFE0F",
        "1F3F7                                      ; unqualified         # 🏷 E2.0 label",
        "\uD83C\uDFF7",
        "1F4B0                                      ; fully-qualified     # 💰 E2.0 money bag",
        "\uD83D\uDCB0",
        "1F4B4                                      ; fully-qualified     # 💴 E2.0 yen banknote",
        "\uD83D\uDCB4",
        "1F4B5                                      ; fully-qualified     # 💵 E2.0 dollar banknote",
        "\uD83D\uDCB5",
        "1F4B6                                      ; fully-qualified     # 💶 E2.0 euro banknote",
        "\uD83D\uDCB6",
        "1F4B7                                      ; fully-qualified     # 💷 E2.0 pound banknote",
        "\uD83D\uDCB7",
        "1F4B8                                      ; fully-qualified     # 💸 E2.0 money with wings",
        "\uD83D\uDCB8",
        "1F4B3                                      ; fully-qualified     # 💳 E2.0 credit card",
        "\uD83D\uDCB3",
        "1F9FE                                      ; fully-qualified     # 🧾 E11.0 receipt",
        "\uD83E\uDDFE",
        "1F4B9                                      ; fully-qualified     # 💹 E2.0 chart increasing with yen",
        "\uD83D\uDCB9",
        "1F4B1                                      ; fully-qualified     # 💱 E2.0 currency exchange",
        "\uD83D\uDCB1",
        "1F4B2                                      ; fully-qualified     # 💲 E2.0 heavy dollar sign",
        "\uD83D\uDCB2",
        "2709 FE0F                                  ; fully-qualified     # ✉️ E2.0 envelope",
        "\u2709\uFE0F",
        "2709                                       ; unqualified         # ✉ E2.0 envelope",
        "\u2709",
        "1F4E7                                      ; fully-qualified     # 📧 E2.0 e-mail",
        "\uD83D\uDCE7",
        "1F4E8                                      ; fully-qualified     # 📨 E2.0 incoming envelope",
        "\uD83D\uDCE8",
        "1F4E9                                      ; fully-qualified     # 📩 E2.0 envelope with arrow",
        "\uD83D\uDCE9",
        "1F4E4                                      ; fully-qualified     # 📤 E2.0 outbox tray",
        "\uD83D\uDCE4",
        "1F4E5                                      ; fully-qualified     # 📥 E2.0 inbox tray",
        "\uD83D\uDCE5",
        "1F4E6                                      ; fully-qualified     # 📦 E2.0 package",
        "\uD83D\uDCE6",
        "1F4EB                                      ; fully-qualified     # 📫 E2.0 closed mailbox with raised flag",
        "\uD83D\uDCEB",
        "1F4EA                                      ; fully-qualified     # 📪 E2.0 closed mailbox with lowered flag",
        "\uD83D\uDCEA",
        "1F4EC                                      ; fully-qualified     # 📬 E2.0 open mailbox with raised flag",
        "\uD83D\uDCEC",
        "1F4ED                                      ; fully-qualified     # 📭 E2.0 open mailbox with lowered flag",
        "\uD83D\uDCED",
        "1F4EE                                      ; fully-qualified     # 📮 E2.0 postbox",
        "\uD83D\uDCEE",
        "1F5F3 FE0F                                 ; fully-qualified     # 🗳️ E2.0 ballot box with ballot",
        "\uD83D\uDDF3\uFE0F",
        "1F5F3                                      ; unqualified         # 🗳 E2.0 ballot box with ballot",
        "\uD83D\uDDF3",
        "270F FE0F                                  ; fully-qualified     # ✏️ E2.0 pencil",
        "\u270F\uFE0F",
        "270F                                       ; unqualified         # ✏ E2.0 pencil",
        "\u270F",
        "2712 FE0F                                  ; fully-qualified     # ✒️ E2.0 black nib",
        "\u2712\uFE0F",
        "2712                                       ; unqualified         # ✒ E2.0 black nib",
        "\u2712",
        "1F58B FE0F                                 ; fully-qualified     # 🖋️ E2.0 fountain pen",
        "\uD83D\uDD8B\uFE0F",
        "1F58B                                      ; unqualified         # 🖋 E2.0 fountain pen",
        "\uD83D\uDD8B",
        "1F58A FE0F                                 ; fully-qualified     # 🖊️ E2.0 pen",
        "\uD83D\uDD8A\uFE0F",
        "1F58A                                      ; unqualified         # 🖊 E2.0 pen",
        "\uD83D\uDD8A",
        "1F58C FE0F                                 ; fully-qualified     # 🖌️ E2.0 paintbrush",
        "\uD83D\uDD8C\uFE0F",
        "1F58C                                      ; unqualified         # 🖌 E2.0 paintbrush",
        "\uD83D\uDD8C",
        "1F58D FE0F                                 ; fully-qualified     # 🖍️ E2.0 crayon",
        "\uD83D\uDD8D\uFE0F",
        "1F58D                                      ; unqualified         # 🖍 E2.0 crayon",
        "\uD83D\uDD8D",
        "1F4DD                                      ; fully-qualified     # 📝 E2.0 memo",
        "\uD83D\uDCDD",
        "1F4BC                                      ; fully-qualified     # 💼 E2.0 briefcase",
        "\uD83D\uDCBC",
        "1F4C1                                      ; fully-qualified     # 📁 E2.0 file folder",
        "\uD83D\uDCC1",
        "1F4C2                                      ; fully-qualified     # 📂 E2.0 open file folder",
        "\uD83D\uDCC2",
        "1F5C2 FE0F                                 ; fully-qualified     # 🗂️ E2.0 card index dividers",
        "\uD83D\uDDC2\uFE0F",
        "1F5C2                                      ; unqualified         # 🗂 E2.0 card index dividers",
        "\uD83D\uDDC2",
        "1F4C5                                      ; fully-qualified     # 📅 E2.0 calendar",
        "\uD83D\uDCC5",
        "1F4C6                                      ; fully-qualified     # 📆 E2.0 tear-off calendar",
        "\uD83D\uDCC6",
        "1F5D2 FE0F                                 ; fully-qualified     # 🗒️ E2.0 spiral notepad",
        "\uD83D\uDDD2\uFE0F",
        "1F5D2                                      ; unqualified         # 🗒 E2.0 spiral notepad",
        "\uD83D\uDDD2",
        "1F5D3 FE0F                                 ; fully-qualified     # 🗓️ E2.0 spiral calendar",
        "\uD83D\uDDD3\uFE0F",
        "1F5D3                                      ; unqualified         # 🗓 E2.0 spiral calendar",
        "\uD83D\uDDD3",
        "1F4C7                                      ; fully-qualified     # 📇 E2.0 card index",
        "\uD83D\uDCC7",
        "1F4C8                                      ; fully-qualified     # 📈 E2.0 chart increasing",
        "\uD83D\uDCC8",
        "1F4C9                                      ; fully-qualified     # 📉 E2.0 chart decreasing",
        "\uD83D\uDCC9",
        "1F4CA                                      ; fully-qualified     # 📊 E2.0 bar chart",
        "\uD83D\uDCCA",
        "1F4CB                                      ; fully-qualified     # 📋 E2.0 clipboard",
        "\uD83D\uDCCB",
        "1F4CC                                      ; fully-qualified     # 📌 E2.0 pushpin",
        "\uD83D\uDCCC",
        "1F4CD                                      ; fully-qualified     # 📍 E2.0 round pushpin",
        "\uD83D\uDCCD",
        "1F4CE                                      ; fully-qualified     # 📎 E2.0 paperclip",
        "\uD83D\uDCCE",
        "1F587 FE0F                                 ; fully-qualified     # 🖇️ E2.0 linked paperclips",
        "\uD83D\uDD87\uFE0F",
        "1F587                                      ; unqualified         # 🖇 E2.0 linked paperclips",
        "\uD83D\uDD87",
        "1F4CF                                      ; fully-qualified     # 📏 E2.0 straight ruler",
        "\uD83D\uDCCF",
        "1F4D0                                      ; fully-qualified     # 📐 E2.0 triangular ruler",
        "\uD83D\uDCD0",
        "2702 FE0F                                  ; fully-qualified     # ✂️ E2.0 scissors",
        "\u2702\uFE0F",
        "2702                                       ; unqualified         # ✂ E2.0 scissors",
        "\u2702",
        "1F5C3 FE0F                                 ; fully-qualified     # 🗃️ E2.0 card file box",
        "\uD83D\uDDC3\uFE0F",
        "1F5C3                                      ; unqualified         # 🗃 E2.0 card file box",
        "\uD83D\uDDC3",
        "1F5C4 FE0F                                 ; fully-qualified     # 🗄️ E2.0 file cabinet",
        "\uD83D\uDDC4\uFE0F",
        "1F5C4                                      ; unqualified         # 🗄 E2.0 file cabinet",
        "\uD83D\uDDC4",
        "1F5D1 FE0F                                 ; fully-qualified     # 🗑️ E2.0 wastebasket",
        "\uD83D\uDDD1\uFE0F",
        "1F5D1                                      ; unqualified         # 🗑 E2.0 wastebasket",
        "\uD83D\uDDD1",
        "1F512                                      ; fully-qualified     # 🔒 E2.0 locked",
        "\uD83D\uDD12",
        "1F513                                      ; fully-qualified     # 🔓 E2.0 unlocked",
        "\uD83D\uDD13",
        "1F50F                                      ; fully-qualified     # 🔏 E2.0 locked with pen",
        "\uD83D\uDD0F",
        "1F510                                      ; fully-qualified     # 🔐 E2.0 locked with key",
        "\uD83D\uDD10",
        "1F511                                      ; fully-qualified     # 🔑 E2.0 key",
        "\uD83D\uDD11",
        "1F5DD FE0F                                 ; fully-qualified     # 🗝️ E2.0 old key",
        "\uD83D\uDDDD\uFE0F",
        "1F5DD                                      ; unqualified         # 🗝 E2.0 old key",
        "\uD83D\uDDDD",
        "1F528                                      ; fully-qualified     # 🔨 E2.0 hammer",
        "\uD83D\uDD28",
        "1FA93                                      ; fully-qualified     # 🪓 E12.1 axe",
        "\uD83E\uDE93",
        "26CF FE0F                                  ; fully-qualified     # ⛏️ E2.0 pick",
        "\u26CF\uFE0F",
        "26CF                                       ; unqualified         # ⛏ E2.0 pick",
        "\u26CF",
        "2692 FE0F                                  ; fully-qualified     # ⚒️ E2.0 hammer and pick",
        "\u2692\uFE0F",
        "2692                                       ; unqualified         # ⚒ E2.0 hammer and pick",
        "\u2692",
        "1F6E0 FE0F                                 ; fully-qualified     # 🛠️ E2.0 hammer and wrench",
        "\uD83D\uDEE0\uFE0F",
        "1F6E0                                      ; unqualified         # 🛠 E2.0 hammer and wrench",
        "\uD83D\uDEE0",
        "1F5E1 FE0F                                 ; fully-qualified     # 🗡️ E2.0 dagger",
        "\uD83D\uDDE1\uFE0F",
        "1F5E1                                      ; unqualified         # 🗡 E2.0 dagger",
        "\uD83D\uDDE1",
        "2694 FE0F                                  ; fully-qualified     # ⚔️ E2.0 crossed swords",
        "\u2694\uFE0F",
        "2694                                       ; unqualified         # ⚔ E2.0 crossed swords",
        "\u2694",
        "1F52B                                      ; fully-qualified     # 🔫 E2.0 pistol",
        "\uD83D\uDD2B",
        "1F3F9                                      ; fully-qualified     # 🏹 E2.0 bow and arrow",
        "\uD83C\uDFF9",
        "1F6E1 FE0F                                 ; fully-qualified     # 🛡️ E2.0 shield",
        "\uD83D\uDEE1\uFE0F",
        "1F6E1                                      ; unqualified         # 🛡 E2.0 shield",
        "\uD83D\uDEE1",
        "1F527                                      ; fully-qualified     # 🔧 E2.0 wrench",
        "\uD83D\uDD27",
        "1F529                                      ; fully-qualified     # 🔩 E2.0 nut and bolt",
        "\uD83D\uDD29",
        "2699 FE0F                                  ; fully-qualified     # ⚙️ E2.0 gear",
        "\u2699\uFE0F",
        "2699                                       ; unqualified         # ⚙ E2.0 gear",
        "\u2699",
        "1F5DC FE0F                                 ; fully-qualified     # 🗜️ E2.0 clamp",
        "\uD83D\uDDDC\uFE0F",
        "1F5DC                                      ; unqualified         # 🗜 E2.0 clamp",
        "\uD83D\uDDDC",
        "2696 FE0F                                  ; fully-qualified     # ⚖️ E2.0 balance scale",
        "\u2696\uFE0F",
        "2696                                       ; unqualified         # ⚖ E2.0 balance scale",
        "\u2696",
        "1F9AF                                      ; fully-qualified     # 🦯 E12.1 probing cane",
        "\uD83E\uDDAF",
        "1F517                                      ; fully-qualified     # 🔗 E2.0 link",
        "\uD83D\uDD17",
        "26D3 FE0F                                  ; fully-qualified     # ⛓️ E2.0 chains",
        "\u26D3\uFE0F",
        "26D3                                       ; unqualified         # ⛓ E2.0 chains",
        "\u26D3",
        "1F9F0                                      ; fully-qualified     # 🧰 E11.0 toolbox",
        "\uD83E\uDDF0",
        "1F9F2                                      ; fully-qualified     # 🧲 E11.0 magnet",
        "\uD83E\uDDF2",
        "2697 FE0F                                  ; fully-qualified     # ⚗️ E2.0 alembic",
        "\u2697\uFE0F",
        "2697                                       ; unqualified         # ⚗ E2.0 alembic",
        "\u2697",
        "1F9EA                                      ; fully-qualified     # 🧪 E11.0 test tube",
        "\uD83E\uDDEA",
        "1F9EB                                      ; fully-qualified     # 🧫 E11.0 petri dish",
        "\uD83E\uDDEB",
        "1F9EC                                      ; fully-qualified     # 🧬 E11.0 dna",
        "\uD83E\uDDEC",
        "1F52C                                      ; fully-qualified     # 🔬 E2.0 microscope",
        "\uD83D\uDD2C",
        "1F52D                                      ; fully-qualified     # 🔭 E2.0 telescope",
        "\uD83D\uDD2D",
        "1F4E1                                      ; fully-qualified     # 📡 E2.0 satellite antenna",
        "\uD83D\uDCE1",
        "1F489                                      ; fully-qualified     # 💉 E2.0 syringe",
        "\uD83D\uDC89",
        "1FA78                                      ; fully-qualified     # 🩸 E12.1 drop of blood",
        "\uD83E\uDE78",
        "1F48A                                      ; fully-qualified     # 💊 E2.0 pill",
        "\uD83D\uDC8A",
        "1FA79                                      ; fully-qualified     # 🩹 E12.1 adhesive bandage",
        "\uD83E\uDE79",
        "1FA7A                                      ; fully-qualified     # 🩺 E12.1 stethoscope",
        "\uD83E\uDE7A",
        "1F6AA                                      ; fully-qualified     # 🚪 E2.0 door",
        "\uD83D\uDEAA",
        "1F6CF FE0F                                 ; fully-qualified     # 🛏️ E2.0 bed",
        "\uD83D\uDECF\uFE0F",
        "1F6CF                                      ; unqualified         # 🛏 E2.0 bed",
        "\uD83D\uDECF",
        "1F6CB FE0F                                 ; fully-qualified     # 🛋️ E2.0 couch and lamp",
        "\uD83D\uDECB\uFE0F",
        "1F6CB                                      ; unqualified         # 🛋 E2.0 couch and lamp",
        "\uD83D\uDECB",
        "1FA91                                      ; fully-qualified     # 🪑 E12.1 chair",
        "\uD83E\uDE91",
        "1F6BD                                      ; fully-qualified     # 🚽 E2.0 toilet",
        "\uD83D\uDEBD",
        "1F6BF                                      ; fully-qualified     # 🚿 E2.0 shower",
        "\uD83D\uDEBF",
        "1F6C1                                      ; fully-qualified     # 🛁 E2.0 bathtub",
        "\uD83D\uDEC1",
        "1FA92                                      ; fully-qualified     # 🪒 E12.1 razor",
        "\uD83E\uDE92",
        "1F9F4                                      ; fully-qualified     # 🧴 E11.0 lotion bottle",
        "\uD83E\uDDF4",
        "1F9F7                                      ; fully-qualified     # 🧷 E11.0 safety pin",
        "\uD83E\uDDF7",
        "1F9F9                                      ; fully-qualified     # 🧹 E11.0 broom",
        "\uD83E\uDDF9",
        "1F9FA                                      ; fully-qualified     # 🧺 E11.0 basket",
        "\uD83E\uDDFA",
        "1F9FB                                      ; fully-qualified     # 🧻 E11.0 roll of paper",
        "\uD83E\uDDFB",
        "1F9FC                                      ; fully-qualified     # 🧼 E11.0 soap",
        "\uD83E\uDDFC",
        "1F9FD                                      ; fully-qualified     # 🧽 E11.0 sponge",
        "\uD83E\uDDFD",
        "1F9EF                                      ; fully-qualified     # 🧯 E11.0 fire extinguisher",
        "\uD83E\uDDEF",
        "1F6D2                                      ; fully-qualified     # 🛒 E4.0 shopping cart",
        "\uD83D\uDED2",
        "1F6AC                                      ; fully-qualified     # 🚬 E2.0 cigarette",
        "\uD83D\uDEAC",
        "26B0 FE0F                                  ; fully-qualified     # ⚰️ E2.0 coffin",
        "\u26B0\uFE0F",
        "26B0                                       ; unqualified         # ⚰ E2.0 coffin",
        "\u26B0",
        "26B1 FE0F                                  ; fully-qualified     # ⚱️ E2.0 funeral urn",
        "\u26B1\uFE0F",
        "26B1                                       ; unqualified         # ⚱ E2.0 funeral urn",
        "\u26B1",
        "1F5FF                                      ; fully-qualified     # 🗿 E2.0 moai",
        "\uD83D\uDDFF",
        "1F3E7                                      ; fully-qualified     # 🏧 E2.0 ATM sign",
        "\uD83C\uDFE7",
        "1F6AE                                      ; fully-qualified     # 🚮 E2.0 litter in bin sign",
        "\uD83D\uDEAE",
        "1F6B0                                      ; fully-qualified     # 🚰 E2.0 potable water",
        "\uD83D\uDEB0",
        "267F                                       ; fully-qualified     # ♿ E2.0 wheelchair symbol",
        "\u267F",
        "1F6B9                                      ; fully-qualified     # 🚹 E2.0 men’s room",
        "\uD83D\uDEB9",
        "1F6BA                                      ; fully-qualified     # 🚺 E2.0 women’s room",
        "\uD83D\uDEBA",
        "1F6BB                                      ; fully-qualified     # 🚻 E2.0 restroom",
        "\uD83D\uDEBB",
        "1F6BC                                      ; fully-qualified     # 🚼 E2.0 baby symbol",
        "\uD83D\uDEBC",
        "1F6BE                                      ; fully-qualified     # 🚾 E2.0 water closet",
        "\uD83D\uDEBE",
        "1F6C2                                      ; fully-qualified     # 🛂 E2.0 passport control",
        "\uD83D\uDEC2",
        "1F6C3                                      ; fully-qualified     # 🛃 E2.0 customs",
        "\uD83D\uDEC3",
        "1F6C4                                      ; fully-qualified     # 🛄 E2.0 baggage claim",
        "\uD83D\uDEC4",
        "1F6C5                                      ; fully-qualified     # 🛅 E2.0 left luggage",
        "\uD83D\uDEC5",
        "26A0 FE0F                                  ; fully-qualified     # ⚠️ E2.0 warning",
        "\u26A0\uFE0F",
        "26A0                                       ; unqualified         # ⚠ E2.0 warning",
        "\u26A0",
        "1F6B8                                      ; fully-qualified     # 🚸 E2.0 children crossing",
        "\uD83D\uDEB8",
        "26D4                                       ; fully-qualified     # ⛔ E2.0 no entry",
        "\u26D4",
        "1F6AB                                      ; fully-qualified     # 🚫 E2.0 prohibited",
        "\uD83D\uDEAB",
        "1F6B3                                      ; fully-qualified     # 🚳 E2.0 no bicycles",
        "\uD83D\uDEB3",
        "1F6AD                                      ; fully-qualified     # 🚭 E2.0 no smoking",
        "\uD83D\uDEAD",
        "1F6AF                                      ; fully-qualified     # 🚯 E2.0 no littering",
        "\uD83D\uDEAF",
        "1F6B1                                      ; fully-qualified     # 🚱 E2.0 non-potable water",
        "\uD83D\uDEB1",
        "1F6B7                                      ; fully-qualified     # 🚷 E2.0 no pedestrians",
        "\uD83D\uDEB7",
        "1F4F5                                      ; fully-qualified     # 📵 E2.0 no mobile phones",
        "\uD83D\uDCF5",
        "1F51E                                      ; fully-qualified     # 🔞 E2.0 no one under eighteen",
        "\uD83D\uDD1E",
        "2622 FE0F                                  ; fully-qualified     # ☢️ E2.0 radioactive",
        "\u2622\uFE0F",
        "2622                                       ; unqualified         # ☢ E2.0 radioactive",
        "\u2622",
        "2623 FE0F                                  ; fully-qualified     # ☣️ E2.0 biohazard",
        "\u2623\uFE0F",
        "2623                                       ; unqualified         # ☣ E2.0 biohazard",
        "\u2623",
        "2B06 FE0F                                  ; fully-qualified     # ⬆️ E2.0 up arrow",
        "\u2B06\uFE0F",
        "2B06                                       ; unqualified         # ⬆ E2.0 up arrow",
        "\u2B06",
        "2197 FE0F                                  ; fully-qualified     # ↗️ E2.0 up-right arrow",
        "\u2197\uFE0F",
        "2197                                       ; unqualified         # ↗ E2.0 up-right arrow",
        "\u2197",
        "27A1 FE0F                                  ; fully-qualified     # ➡️ E2.0 right arrow",
        "\u27A1\uFE0F",
        "27A1                                       ; unqualified         # ➡ E2.0 right arrow",
        "\u27A1",
        "2198 FE0F                                  ; fully-qualified     # ↘️ E2.0 down-right arrow",
        "\u2198\uFE0F",
        "2198                                       ; unqualified         # ↘ E2.0 down-right arrow",
        "\u2198",
        "2B07 FE0F                                  ; fully-qualified     # ⬇️ E2.0 down arrow",
        "\u2B07\uFE0F",
        "2B07                                       ; unqualified         # ⬇ E2.0 down arrow",
        "\u2B07",
        "2199 FE0F                                  ; fully-qualified     # ↙️ E2.0 down-left arrow",
        "\u2199\uFE0F",
        "2199                                       ; unqualified         # ↙ E2.0 down-left arrow",
        "\u2199",
        "2B05 FE0F                                  ; fully-qualified     # ⬅️ E2.0 left arrow",
        "\u2B05\uFE0F",
        "2B05                                       ; unqualified         # ⬅ E2.0 left arrow",
        "\u2B05",
        "2196 FE0F                                  ; fully-qualified     # ↖️ E2.0 up-left arrow",
        "\u2196\uFE0F",
        "2196                                       ; unqualified         # ↖ E2.0 up-left arrow",
        "\u2196",
        "2195 FE0F                                  ; fully-qualified     # ↕️ E2.0 up-down arrow",
        "\u2195\uFE0F",
        "2195                                       ; unqualified         # ↕ E2.0 up-down arrow",
        "\u2195",
        "2194 FE0F                                  ; fully-qualified     # ↔️ E2.0 left-right arrow",
        "\u2194\uFE0F",
        "2194                                       ; unqualified         # ↔ E2.0 left-right arrow",
        "\u2194",
        "21A9 FE0F                                  ; fully-qualified     # ↩️ E2.0 right arrow curving left",
        "\u21A9\uFE0F",
        "21A9                                       ; unqualified         # ↩ E2.0 right arrow curving left",
        "\u21A9",
        "21AA FE0F                                  ; fully-qualified     # ↪️ E2.0 left arrow curving right",
        "\u21AA\uFE0F",
        "21AA                                       ; unqualified         # ↪ E2.0 left arrow curving right",
        "\u21AA",
        "2934 FE0F                                  ; fully-qualified     # ⤴️ E2.0 right arrow curving up",
        "\u2934\uFE0F",
        "2934                                       ; unqualified         # ⤴ E2.0 right arrow curving up",
        "\u2934",
        "2935 FE0F                                  ; fully-qualified     # ⤵️ E2.0 right arrow curving down",
        "\u2935\uFE0F",
        "2935                                       ; unqualified         # ⤵ E2.0 right arrow curving down",
        "\u2935",
        "1F503                                      ; fully-qualified     # 🔃 E2.0 clockwise vertical arrows",
        "\uD83D\uDD03",
        "1F504                                      ; fully-qualified     # 🔄 E2.0 counterclockwise arrows button",
        "\uD83D\uDD04",
        "1F519                                      ; fully-qualified     # 🔙 E2.0 BACK arrow",
        "\uD83D\uDD19",
        "1F51A                                      ; fully-qualified     # 🔚 E2.0 END arrow",
        "\uD83D\uDD1A",
        "1F51B                                      ; fully-qualified     # 🔛 E2.0 ON! arrow",
        "\uD83D\uDD1B",
        "1F51C                                      ; fully-qualified     # 🔜 E2.0 SOON arrow",
        "\uD83D\uDD1C",
        "1F51D                                      ; fully-qualified     # 🔝 E2.0 TOP arrow",
        "\uD83D\uDD1D",
        "1F6D0                                      ; fully-qualified     # 🛐 E2.0 place of worship",
        "\uD83D\uDED0",
        "269B FE0F                                  ; fully-qualified     # ⚛️ E2.0 atom symbol",
        "\u269B\uFE0F",
        "269B                                       ; unqualified         # ⚛ E2.0 atom symbol",
        "\u269B",
        "1F549 FE0F                                 ; fully-qualified     # 🕉️ E2.0 om",
        "\uD83D\uDD49\uFE0F",
        "1F549                                      ; unqualified         # 🕉 E2.0 om",
        "\uD83D\uDD49",
        "2721 FE0F                                  ; fully-qualified     # ✡️ E2.0 star of David",
        "\u2721\uFE0F",
        "2721                                       ; unqualified         # ✡ E2.0 star of David",
        "\u2721",
        "2638 FE0F                                  ; fully-qualified     # ☸️ E2.0 wheel of dharma",
        "\u2638\uFE0F",
        "2638                                       ; unqualified         # ☸ E2.0 wheel of dharma",
        "\u2638",
        "262F FE0F                                  ; fully-qualified     # ☯️ E2.0 yin yang",
        "\u262F\uFE0F",
        "262F                                       ; unqualified         # ☯ E2.0 yin yang",
        "\u262F",
        "271D FE0F                                  ; fully-qualified     # ✝️ E2.0 latin cross",
        "\u271D\uFE0F",
        "271D                                       ; unqualified         # ✝ E2.0 latin cross",
        "\u271D",
        "2626 FE0F                                  ; fully-qualified     # ☦️ E2.0 orthodox cross",
        "\u2626\uFE0F",
        "2626                                       ; unqualified         # ☦ E2.0 orthodox cross",
        "\u2626",
        "262A FE0F                                  ; fully-qualified     # ☪️ E2.0 star and crescent",
        "\u262A\uFE0F",
        "262A                                       ; unqualified         # ☪ E2.0 star and crescent",
        "\u262A",
        "262E FE0F                                  ; fully-qualified     # ☮️ E2.0 peace symbol",
        "\u262E\uFE0F",
        "262E                                       ; unqualified         # ☮ E2.0 peace symbol",
        "\u262E",
        "1F54E                                      ; fully-qualified     # 🕎 E2.0 menorah",
        "\uD83D\uDD4E",
        "1F52F                                      ; fully-qualified     # 🔯 E2.0 dotted six-pointed star",
        "\uD83D\uDD2F",
        "2648                                       ; fully-qualified     # ♈ E2.0 Aries",
        "\u2648",
        "2649                                       ; fully-qualified     # ♉ E2.0 Taurus",
        "\u2649",
        "264A                                       ; fully-qualified     # ♊ E2.0 Gemini",
        "\u264A",
        "264B                                       ; fully-qualified     # ♋ E2.0 Cancer",
        "\u264B",
        "264C                                       ; fully-qualified     # ♌ E2.0 Leo",
        "\u264C",
        "264D                                       ; fully-qualified     # ♍ E2.0 Virgo",
        "\u264D",
        "264E                                       ; fully-qualified     # ♎ E2.0 Libra",
        "\u264E",
        "264F                                       ; fully-qualified     # ♏ E2.0 Scorpio",
        "\u264F",
        "2650                                       ; fully-qualified     # ♐ E2.0 Sagittarius",
        "\u2650",
        "2651                                       ; fully-qualified     # ♑ E2.0 Capricorn",
        "\u2651",
        "2652                                       ; fully-qualified     # ♒ E2.0 Aquarius",
        "\u2652",
        "2653                                       ; fully-qualified     # ♓ E2.0 Pisces",
        "\u2653",
        "26CE                                       ; fully-qualified     # ⛎ E2.0 Ophiuchus",
        "\u26CE",
        "1F500                                      ; fully-qualified     # 🔀 E2.0 shuffle tracks button",
        "\uD83D\uDD00",
        "1F501                                      ; fully-qualified     # 🔁 E2.0 repeat button",
        "\uD83D\uDD01",
        "1F502                                      ; fully-qualified     # 🔂 E2.0 repeat single button",
        "\uD83D\uDD02",
        "25B6 FE0F                                  ; fully-qualified     # ▶️ E2.0 play button",
        "\u25B6\uFE0F",
        "25B6                                       ; unqualified         # ▶ E2.0 play button",
        "\u25B6",
        "23E9                                       ; fully-qualified     # ⏩ E2.0 fast-forward button",
        "\u23E9",
        "23ED FE0F                                  ; fully-qualified     # ⏭️ E2.0 next track button",
        "\u23ED\uFE0F",
        "23ED                                       ; unqualified         # ⏭ E2.0 next track button",
        "\u23ED",
        "23EF FE0F                                  ; fully-qualified     # ⏯️ E2.0 play or pause button",
        "\u23EF\uFE0F",
        "23EF                                       ; unqualified         # ⏯ E2.0 play or pause button",
        "\u23EF",
        "25C0 FE0F                                  ; fully-qualified     # ◀️ E2.0 reverse button",
        "\u25C0\uFE0F",
        "25C0                                       ; unqualified         # ◀ E2.0 reverse button",
        "\u25C0",
        "23EA                                       ; fully-qualified     # ⏪ E2.0 fast reverse button",
        "\u23EA",
        "23EE FE0F                                  ; fully-qualified     # ⏮️ E2.0 last track button",
        "\u23EE\uFE0F",
        "23EE                                       ; unqualified         # ⏮ E2.0 last track button",
        "\u23EE",
        "1F53C                                      ; fully-qualified     # 🔼 E2.0 upwards button",
        "\uD83D\uDD3C",
        "23EB                                       ; fully-qualified     # ⏫ E2.0 fast up button",
        "\u23EB",
        "1F53D                                      ; fully-qualified     # 🔽 E2.0 downwards button",
        "\uD83D\uDD3D",
        "23EC                                       ; fully-qualified     # ⏬ E2.0 fast down button",
        "\u23EC",
        "23F8 FE0F                                  ; fully-qualified     # ⏸️ E2.0 pause button",
        "\u23F8\uFE0F",
        "23F8                                       ; unqualified         # ⏸ E2.0 pause button",
        "\u23F8",
        "23F9 FE0F                                  ; fully-qualified     # ⏹️ E2.0 stop button",
        "\u23F9\uFE0F",
        "23F9                                       ; unqualified         # ⏹ E2.0 stop button",
        "\u23F9",
        "23FA FE0F                                  ; fully-qualified     # ⏺️ E2.0 record button",
        "\u23FA\uFE0F",
        "23FA                                       ; unqualified         # ⏺ E2.0 record button",
        "\u23FA",
        "23CF FE0F                                  ; fully-qualified     # ⏏️ E2.0 eject button",
        "\u23CF\uFE0F",
        "23CF                                       ; unqualified         # ⏏ E2.0 eject button",
        "\u23CF",
        "1F3A6                                      ; fully-qualified     # 🎦 E2.0 cinema",
        "\uD83C\uDFA6",
        "1F505                                      ; fully-qualified     # 🔅 E2.0 dim button",
        "\uD83D\uDD05",
        "1F506                                      ; fully-qualified     # 🔆 E2.0 bright button",
        "\uD83D\uDD06",
        "1F4F6                                      ; fully-qualified     # 📶 E2.0 antenna bars",
        "\uD83D\uDCF6",
        "1F4F3                                      ; fully-qualified     # 📳 E2.0 vibration mode",
        "\uD83D\uDCF3",
        "1F4F4                                      ; fully-qualified     # 📴 E2.0 mobile phone off",
        "\uD83D\uDCF4",
        "2640 FE0F                                  ; fully-qualified     # ♀️ E4.0 female sign",
        "\u2640\uFE0F",
        "2640                                       ; unqualified         # ♀ E4.0 female sign",
        "\u2640",
        "2642 FE0F                                  ; fully-qualified     # ♂️ E4.0 male sign",
        "\u2642\uFE0F",
        "2642                                       ; unqualified         # ♂ E4.0 male sign",
        "\u2642",
        "2695 FE0F                                  ; fully-qualified     # ⚕️ E4.0 medical symbol",
        "\u2695\uFE0F",
        "2695                                       ; unqualified         # ⚕ E4.0 medical symbol",
        "\u2695",
        "267E FE0F                                  ; fully-qualified     # ♾️ E11.0 infinity",
        "\u267E\uFE0F",
        "267E                                       ; unqualified         # ♾ E11.0 infinity",
        "\u267E",
        "267B FE0F                                  ; fully-qualified     # ♻️ E2.0 recycling symbol",
        "\u267B\uFE0F",
        "267B                                       ; unqualified         # ♻ E2.0 recycling symbol",
        "\u267B",
        "269C FE0F                                  ; fully-qualified     # ⚜️ E2.0 fleur-de-lis",
        "\u269C\uFE0F",
        "269C                                       ; unqualified         # ⚜ E2.0 fleur-de-lis",
        "\u269C",
        "1F531                                      ; fully-qualified     # 🔱 E2.0 trident emblem",
        "\uD83D\uDD31",
        "1F4DB                                      ; fully-qualified     # 📛 E2.0 name badge",
        "\uD83D\uDCDB",
        "1F530                                      ; fully-qualified     # 🔰 E2.0 Japanese symbol for beginner",
        "\uD83D\uDD30",
        "2B55                                       ; fully-qualified     # ⭕ E2.0 hollow red circle",
        "\u2B55",
        "2705                                       ; fully-qualified     # ✅ E2.0 check mark button",
        "\u2705",
        "2611 FE0F                                  ; fully-qualified     # ☑️ E2.0 check box with check",
        "\u2611\uFE0F",
        "2611                                       ; unqualified         # ☑ E2.0 check box with check",
        "\u2611",
        "2714 FE0F                                  ; fully-qualified     # ✔️ E2.0 check mark",
        "\u2714\uFE0F",
        "2714                                       ; unqualified         # ✔ E2.0 check mark",
        "\u2714",
        "2716 FE0F                                  ; fully-qualified     # ✖️ E2.0 multiplication sign",
        "\u2716\uFE0F",
        "2716                                       ; unqualified         # ✖ E2.0 multiplication sign",
        "\u2716",
        "274C                                       ; fully-qualified     # ❌ E2.0 cross mark",
        "\u274C",
        "274E                                       ; fully-qualified     # ❎ E2.0 cross mark button",
        "\u274E",
        "2795                                       ; fully-qualified     # ➕ E2.0 plus sign",
        "\u2795",
        "2796                                       ; fully-qualified     # ➖ E2.0 minus sign",
        "\u2796",
        "2797                                       ; fully-qualified     # ➗ E2.0 division sign",
        "\u2797",
        "27B0                                       ; fully-qualified     # ➰ E2.0 curly loop",
        "\u27B0",
        "27BF                                       ; fully-qualified     # ➿ E2.0 double curly loop",
        "\u27BF",
        "303D FE0F                                  ; fully-qualified     # 〽️ E2.0 part alternation mark",
        "\u303D\uFE0F",
        "303D                                       ; unqualified         # 〽 E2.0 part alternation mark",
        "\u303D",
        "2733 FE0F                                  ; fully-qualified     # ✳️ E2.0 eight-spoked asterisk",
        "\u2733\uFE0F",
        "2733                                       ; unqualified         # ✳ E2.0 eight-spoked asterisk",
        "\u2733",
        "2734 FE0F                                  ; fully-qualified     # ✴️ E2.0 eight-pointed star",
        "\u2734\uFE0F",
        "2734                                       ; unqualified         # ✴ E2.0 eight-pointed star",
        "\u2734",
        "2747 FE0F                                  ; fully-qualified     # ❇️ E2.0 sparkle",
        "\u2747\uFE0F",
        "2747                                       ; unqualified         # ❇ E2.0 sparkle",
        "\u2747",
        "203C FE0F                                  ; fully-qualified     # ‼️ E2.0 double exclamation mark",
        "\u203C\uFE0F",
        "203C                                       ; unqualified         # ‼ E2.0 double exclamation mark",
        "\u203C",
        "2049 FE0F                                  ; fully-qualified     # ⁉️ E2.0 exclamation question mark",
        "\u2049\uFE0F",
        "2049                                       ; unqualified         # ⁉ E2.0 exclamation question mark",
        "\u2049",
        "2753                                       ; fully-qualified     # ❓ E2.0 question mark",
        "\u2753",
        "2754                                       ; fully-qualified     # ❔ E2.0 white question mark",
        "\u2754",
        "2755                                       ; fully-qualified     # ❕ E2.0 white exclamation mark",
        "\u2755",
        "2757                                       ; fully-qualified     # ❗ E2.0 exclamation mark",
        "\u2757",
        "3030 FE0F                                  ; fully-qualified     # 〰️ E2.0 wavy dash",
        "\u3030\uFE0F",
        "3030                                       ; unqualified         # 〰 E2.0 wavy dash",
        "\u3030",
        "00A9 FE0F                                  ; fully-qualified     # ©️ E2.0 copyright",
        "\u00A9\uFE0F",
        "00A9                                       ; unqualified         # © E2.0 copyright",
        "\u00A9",
        "00AE FE0F                                  ; fully-qualified     # ®️ E2.0 registered",
        "\u00AE\uFE0F",
        "00AE                                       ; unqualified         # ® E2.0 registered",
        "\u00AE",
        "2122 FE0F                                  ; fully-qualified     # ™️ E2.0 trade mark",
        "\u2122\uFE0F",
        "2122                                       ; unqualified         # ™ E2.0 trade mark",
        "\u2122",
        "0023 FE0F 20E3                             ; fully-qualified     # #️⃣ E0.0 keycap: #",
        "\u0023\uFE0F\u20E3",
        "0023 20E3                                  ; unqualified         # #⃣ E0.0 keycap: #",
        "\u0023\u20E3",
        "002A FE0F 20E3                             ; fully-qualified     # *️⃣ E0.0 keycap: *",
        "\u002A\uFE0F\u20E3",
        "002A 20E3                                  ; unqualified         # *⃣ E0.0 keycap: *",
        "\u002A\u20E3",
        "0030 FE0F 20E3                             ; fully-qualified     # 0️⃣ E0.0 keycap: 0",
        "\u0030\uFE0F\u20E3",
        "0030 20E3                                  ; unqualified         # 0⃣ E0.0 keycap: 0",
        "\u0030\u20E3",
        "0031 FE0F 20E3                             ; fully-qualified     # 1️⃣ E0.0 keycap: 1",
        "\u0031\uFE0F\u20E3",
        "0031 20E3                                  ; unqualified         # 1⃣ E0.0 keycap: 1",
        "\u0031\u20E3",
        "0032 FE0F 20E3                             ; fully-qualified     # 2️⃣ E0.0 keycap: 2",
        "\u0032\uFE0F\u20E3",
        "0032 20E3                                  ; unqualified         # 2⃣ E0.0 keycap: 2",
        "\u0032\u20E3",
        "0033 FE0F 20E3                             ; fully-qualified     # 3️⃣ E0.0 keycap: 3",
        "\u0033\uFE0F\u20E3",
        "0033 20E3                                  ; unqualified         # 3⃣ E0.0 keycap: 3",
        "\u0033\u20E3",
        "0034 FE0F 20E3                             ; fully-qualified     # 4️⃣ E0.0 keycap: 4",
        "\u0034\uFE0F\u20E3",
        "0034 20E3                                  ; unqualified         # 4⃣ E0.0 keycap: 4",
        "\u0034\u20E3",
        "0035 FE0F 20E3                             ; fully-qualified     # 5️⃣ E0.0 keycap: 5",
        "\u0035\uFE0F\u20E3",
        "0035 20E3                                  ; unqualified         # 5⃣ E0.0 keycap: 5",
        "\u0035\u20E3",
        "0036 FE0F 20E3                             ; fully-qualified     # 6️⃣ E0.0 keycap: 6",
        "\u0036\uFE0F\u20E3",
        "0036 20E3                                  ; unqualified         # 6⃣ E0.0 keycap: 6",
        "\u0036\u20E3",
        "0037 FE0F 20E3                             ; fully-qualified     # 7️⃣ E0.0 keycap: 7",
        "\u0037\uFE0F\u20E3",
        "0037 20E3                                  ; unqualified         # 7⃣ E0.0 keycap: 7",
        "\u0037\u20E3",
        "0038 FE0F 20E3                             ; fully-qualified     # 8️⃣ E0.0 keycap: 8",
        "\u0038\uFE0F\u20E3",
        "0038 20E3                                  ; unqualified         # 8⃣ E0.0 keycap: 8",
        "\u0038\u20E3",
        "0039 FE0F 20E3                             ; fully-qualified     # 9️⃣ E0.0 keycap: 9",
        "\u0039\uFE0F\u20E3",
        "0039 20E3                                  ; unqualified         # 9⃣ E0.0 keycap: 9",
        "\u0039\u20E3",
        "1F51F                                      ; fully-qualified     # 🔟 E2.0 keycap: 10",
        "\uD83D\uDD1F",
        "1F520                                      ; fully-qualified     # 🔠 E2.0 input latin uppercase",
        "\uD83D\uDD20",
        "1F521                                      ; fully-qualified     # 🔡 E2.0 input latin lowercase",
        "\uD83D\uDD21",
        "1F522                                      ; fully-qualified     # 🔢 E2.0 input numbers",
        "\uD83D\uDD22",
        "1F523                                      ; fully-qualified     # 🔣 E2.0 input symbols",
        "\uD83D\uDD23",
        "1F524                                      ; fully-qualified     # 🔤 E2.0 input latin letters",
        "\uD83D\uDD24",
        "1F170 FE0F                                 ; fully-qualified     # 🅰️ E2.0 A button (blood type)",
        "\uD83C\uDD70\uFE0F",
        "1F170                                      ; unqualified         # 🅰 E2.0 A button (blood type)",
        "\uD83C\uDD70",
        "1F18E                                      ; fully-qualified     # 🆎 E2.0 AB button (blood type)",
        "\uD83C\uDD8E",
        "1F171 FE0F                                 ; fully-qualified     # 🅱️ E2.0 B button (blood type)",
        "\uD83C\uDD71\uFE0F",
        "1F171                                      ; unqualified         # 🅱 E2.0 B button (blood type)",
        "\uD83C\uDD71",
        "1F191                                      ; fully-qualified     # 🆑 E2.0 CL button",
        "\uD83C\uDD91",
        "1F192                                      ; fully-qualified     # 🆒 E2.0 COOL button",
        "\uD83C\uDD92",
        "1F193                                      ; fully-qualified     # 🆓 E2.0 FREE button",
        "\uD83C\uDD93",
        "2139 FE0F                                  ; fully-qualified     # ℹ️ E2.0 information",
        "\u2139\uFE0F",
        "2139                                       ; unqualified         # ℹ E2.0 information",
        "\u2139",
        "1F194                                      ; fully-qualified     # 🆔 E2.0 ID button",
        "\uD83C\uDD94",
        "24C2 FE0F                                  ; fully-qualified     # Ⓜ️ E2.0 circled M",
        "\u24C2\uFE0F",
        "24C2                                       ; unqualified         # Ⓜ E2.0 circled M",
        "\u24C2",
        "1F195                                      ; fully-qualified     # 🆕 E2.0 NEW button",
        "\uD83C\uDD95",
        "1F196                                      ; fully-qualified     # 🆖 E2.0 NG button",
        "\uD83C\uDD96",
        "1F17E FE0F                                 ; fully-qualified     # 🅾️ E2.0 O button (blood type)",
        "\uD83C\uDD7E\uFE0F",
        "1F17E                                      ; unqualified         # 🅾 E2.0 O button (blood type)",
        "\uD83C\uDD7E",
        "1F197                                      ; fully-qualified     # 🆗 E2.0 OK button",
        "\uD83C\uDD97",
        "1F17F FE0F                                 ; fully-qualified     # 🅿️ E2.0 P button",
        "\uD83C\uDD7F\uFE0F",
        "1F17F                                      ; unqualified         # 🅿 E2.0 P button",
        "\uD83C\uDD7F",
        "1F198                                      ; fully-qualified     # 🆘 E2.0 SOS button",
        "\uD83C\uDD98",
        "1F199                                      ; fully-qualified     # 🆙 E2.0 UP! button",
        "\uD83C\uDD99",
        "1F19A                                      ; fully-qualified     # 🆚 E2.0 VS button",
        "\uD83C\uDD9A",
        "1F201                                      ; fully-qualified     # 🈁 E2.0 Japanese “here” button",
        "\uD83C\uDE01",
        "1F202 FE0F                                 ; fully-qualified     # 🈂️ E2.0 Japanese “service charge” button",
        "\uD83C\uDE02\uFE0F",
        "1F202                                      ; unqualified         # 🈂 E2.0 Japanese “service charge” button",
        "\uD83C\uDE02",
        "1F237 FE0F                                 ; fully-qualified     # 🈷️ E2.0 Japanese “monthly amount” button",
        "\uD83C\uDE37\uFE0F",
        "1F237                                      ; unqualified         # 🈷 E2.0 Japanese “monthly amount” button",
        "\uD83C\uDE37",
        "1F236                                      ; fully-qualified     # 🈶 E2.0 Japanese “not free of charge” button",
        "\uD83C\uDE36",
        "1F22F                                      ; fully-qualified     # 🈯 E2.0 Japanese “reserved” button",
        "\uD83C\uDE2F",
        "1F250                                      ; fully-qualified     # 🉐 E2.0 Japanese “bargain” button",
        "\uD83C\uDE50",
        "1F239                                      ; fully-qualified     # 🈹 E2.0 Japanese “discount” button",
        "\uD83C\uDE39",
        "1F21A                                      ; fully-qualified     # 🈚 E2.0 Japanese “free of charge” button",
        "\uD83C\uDE1A",
        "1F232                                      ; fully-qualified     # 🈲 E2.0 Japanese “prohibited” button",
        "\uD83C\uDE32",
        "1F251                                      ; fully-qualified     # 🉑 E2.0 Japanese “acceptable” button",
        "\uD83C\uDE51",
        "1F238                                      ; fully-qualified     # 🈸 E2.0 Japanese “application” button",
        "\uD83C\uDE38",
        "1F234                                      ; fully-qualified     # 🈴 E2.0 Japanese “passing grade” button",
        "\uD83C\uDE34",
        "1F233                                      ; fully-qualified     # 🈳 E2.0 Japanese “vacancy” button",
        "\uD83C\uDE33",
        "3297 FE0F                                  ; fully-qualified     # ㊗️ E2.0 Japanese “congratulations” button",
        "\u3297\uFE0F",
        "3297                                       ; unqualified         # ㊗ E2.0 Japanese “congratulations” button",
        "\u3297",
        "3299 FE0F                                  ; fully-qualified     # ㊙️ E2.0 Japanese “secret” button",
        "\u3299\uFE0F",
        "3299                                       ; unqualified         # ㊙ E2.0 Japanese “secret” button",
        "\u3299",
        "1F23A                                      ; fully-qualified     # 🈺 E2.0 Japanese “open for business” button",
        "\uD83C\uDE3A",
        "1F235                                      ; fully-qualified     # 🈵 E2.0 Japanese “no vacancy” button",
        "\uD83C\uDE35",
        "1F534                                      ; fully-qualified     # 🔴 E2.0 red circle",
        "\uD83D\uDD34",
        "1F7E0                                      ; fully-qualified     # 🟠 E12.1 orange circle",
        "\uD83D\uDFE0",
        "1F7E1                                      ; fully-qualified     # 🟡 E12.1 yellow circle",
        "\uD83D\uDFE1",
        "1F7E2                                      ; fully-qualified     # 🟢 E12.1 green circle",
        "\uD83D\uDFE2",
        "1F535                                      ; fully-qualified     # 🔵 E2.0 blue circle",
        "\uD83D\uDD35",
        "1F7E3                                      ; fully-qualified     # 🟣 E12.1 purple circle",
        "\uD83D\uDFE3",
        "1F7E4                                      ; fully-qualified     # 🟤 E12.1 brown circle",
        "\uD83D\uDFE4",
        "26AB                                       ; fully-qualified     # ⚫ E2.0 black circle",
        "\u26AB",
        "26AA                                       ; fully-qualified     # ⚪ E2.0 white circle",
        "\u26AA",
        "1F7E5                                      ; fully-qualified     # 🟥 E12.1 red square",
        "\uD83D\uDFE5",
        "1F7E7                                      ; fully-qualified     # 🟧 E12.1 orange square",
        "\uD83D\uDFE7",
        "1F7E8                                      ; fully-qualified     # 🟨 E12.1 yellow square",
        "\uD83D\uDFE8",
        "1F7E9                                      ; fully-qualified     # 🟩 E12.1 green square",
        "\uD83D\uDFE9",
        "1F7E6                                      ; fully-qualified     # 🟦 E12.1 blue square",
        "\uD83D\uDFE6",
        "1F7EA                                      ; fully-qualified     # 🟪 E12.1 purple square",
        "\uD83D\uDFEA",
        "1F7EB                                      ; fully-qualified     # 🟫 E12.1 brown square",
        "\uD83D\uDFEB",
        "2B1B                                       ; fully-qualified     # ⬛ E2.0 black large square",
        "\u2B1B",
        "2B1C                                       ; fully-qualified     # ⬜ E2.0 white large square",
        "\u2B1C",
        "25FC FE0F                                  ; fully-qualified     # ◼️ E2.0 black medium square",
        "\u25FC\uFE0F",
        "25FC                                       ; unqualified         # ◼ E2.0 black medium square",
        "\u25FC",
        "25FB FE0F                                  ; fully-qualified     # ◻️ E2.0 white medium square",
        "\u25FB\uFE0F",
        "25FB                                       ; unqualified         # ◻ E2.0 white medium square",
        "\u25FB",
        "25FE                                       ; fully-qualified     # ◾ E2.0 black medium-small square",
        "\u25FE",
        "25FD                                       ; fully-qualified     # ◽ E2.0 white medium-small square",
        "\u25FD",
        "25AA FE0F                                  ; fully-qualified     # ▪️ E2.0 black small square",
        "\u25AA\uFE0F",
        "25AA                                       ; unqualified         # ▪ E2.0 black small square",
        "\u25AA",
        "25AB FE0F                                  ; fully-qualified     # ▫️ E2.0 white small square",
        "\u25AB\uFE0F",
        "25AB                                       ; unqualified         # ▫ E2.0 white small square",
        "\u25AB",
        "1F536                                      ; fully-qualified     # 🔶 E2.0 large orange diamond",
        "\uD83D\uDD36",
        "1F537                                      ; fully-qualified     # 🔷 E2.0 large blue diamond",
        "\uD83D\uDD37",
        "1F538                                      ; fully-qualified     # 🔸 E2.0 small orange diamond",
        "\uD83D\uDD38",
        "1F539                                      ; fully-qualified     # 🔹 E2.0 small blue diamond",
        "\uD83D\uDD39",
        "1F53A                                      ; fully-qualified     # 🔺 E2.0 red triangle pointed up",
        "\uD83D\uDD3A",
        "1F53B                                      ; fully-qualified     # 🔻 E2.0 red triangle pointed down",
        "\uD83D\uDD3B",
        "1F4A0                                      ; fully-qualified     # 💠 E2.0 diamond with a dot",
        "\uD83D\uDCA0",
        "1F518                                      ; fully-qualified     # 🔘 E2.0 radio button",
        "\uD83D\uDD18",
        "1F533                                      ; fully-qualified     # 🔳 E2.0 white square button",
        "\uD83D\uDD33",
        "1F532                                      ; fully-qualified     # 🔲 E2.0 black square button",
        "\uD83D\uDD32",
        "1F3C1                                      ; fully-qualified     # 🏁 E2.0 chequered flag",
        "\uD83C\uDFC1",
        "1F6A9                                      ; fully-qualified     # 🚩 E2.0 triangular flag",
        "\uD83D\uDEA9",
        "1F38C                                      ; fully-qualified     # 🎌 E2.0 crossed flags",
        "\uD83C\uDF8C",
        "1F3F4                                      ; fully-qualified     # 🏴 E2.0 black flag",
        "\uD83C\uDFF4",
        "1F3F3 FE0F                                 ; fully-qualified     # 🏳️ E2.0 white flag",
        "\uD83C\uDFF3\uFE0F",
        "1F3F3                                      ; unqualified         # 🏳 E2.0 white flag",
        "\uD83C\uDFF3",
        "1F3F3 FE0F 200D 1F308                      ; fully-qualified     # 🏳️‍🌈 E4.0 rainbow flag",
        "\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08",
        "1F3F3 200D 1F308                           ; unqualified         # 🏳‍🌈 E4.0 rainbow flag",
        "\uD83C\uDFF3\u200D\uD83C\uDF08",
        "1F3F4 200D 2620 FE0F                       ; fully-qualified     # 🏴‍☠️ E11.0 pirate flag",
        "\uD83C\uDFF4\u200D\u2620\uFE0F",
        "1F3F4 200D 2620                            ; minimally-qualified # 🏴‍☠ E11.0 pirate flag",
        "\uD83C\uDFF4\u200D\u2620",
        "1F1E6 1F1E8                                ; fully-qualified     # 🇦🇨 E2.0 flag: Ascension Island",
        "\uD83C\uDDE6\uD83C\uDDE8",
        "1F1E6 1F1E9                                ; fully-qualified     # 🇦🇩 E2.0 flag: Andorra",
        "\uD83C\uDDE6\uD83C\uDDE9",
        "1F1E6 1F1EA                                ; fully-qualified     # 🇦🇪 E2.0 flag: United Arab Emirates",
        "\uD83C\uDDE6\uD83C\uDDEA",
        "1F1E6 1F1EB                                ; fully-qualified     # 🇦🇫 E2.0 flag: Afghanistan",
        "\uD83C\uDDE6\uD83C\uDDEB",
        "1F1E6 1F1EC                                ; fully-qualified     # 🇦🇬 E2.0 flag: Antigua & Barbuda",
        "\uD83C\uDDE6\uD83C\uDDEC",
        "1F1E6 1F1EE                                ; fully-qualified     # 🇦🇮 E2.0 flag: Anguilla",
        "\uD83C\uDDE6\uD83C\uDDEE",
        "1F1E6 1F1F1                                ; fully-qualified     # 🇦🇱 E2.0 flag: Albania",
        "\uD83C\uDDE6\uD83C\uDDF1",
        "1F1E6 1F1F2                                ; fully-qualified     # 🇦🇲 E2.0 flag: Armenia",
        "\uD83C\uDDE6\uD83C\uDDF2",
        "1F1E6 1F1F4                                ; fully-qualified     # 🇦🇴 E2.0 flag: Angola",
        "\uD83C\uDDE6\uD83C\uDDF4",
        "1F1E6 1F1F6                                ; fully-qualified     # 🇦🇶 E2.0 flag: Antarctica",
        "\uD83C\uDDE6\uD83C\uDDF6",
        "1F1E6 1F1F7                                ; fully-qualified     # 🇦🇷 E2.0 flag: Argentina",
        "\uD83C\uDDE6\uD83C\uDDF7",
        "1F1E6 1F1F8                                ; fully-qualified     # 🇦🇸 E2.0 flag: American Samoa",
        "\uD83C\uDDE6\uD83C\uDDF8",
        "1F1E6 1F1F9                                ; fully-qualified     # 🇦🇹 E2.0 flag: Austria",
        "\uD83C\uDDE6\uD83C\uDDF9",
        "1F1E6 1F1FA                                ; fully-qualified     # 🇦🇺 E2.0 flag: Australia",
        "\uD83C\uDDE6\uD83C\uDDFA",
        "1F1E6 1F1FC                                ; fully-qualified     # 🇦🇼 E2.0 flag: Aruba",
        "\uD83C\uDDE6\uD83C\uDDFC",
        "1F1E6 1F1FD                                ; fully-qualified     # 🇦🇽 E2.0 flag: Åland Islands",
        "\uD83C\uDDE6\uD83C\uDDFD",
        "1F1E6 1F1FF                                ; fully-qualified     # 🇦🇿 E2.0 flag: Azerbaijan",
        "\uD83C\uDDE6\uD83C\uDDFF",
        "1F1E7 1F1E6                                ; fully-qualified     # 🇧🇦 E2.0 flag: Bosnia & Herzegovina",
        "\uD83C\uDDE7\uD83C\uDDE6",
        "1F1E7 1F1E7                                ; fully-qualified     # 🇧🇧 E2.0 flag: Barbados",
        "\uD83C\uDDE7\uD83C\uDDE7",
        "1F1E7 1F1E9                                ; fully-qualified     # 🇧🇩 E2.0 flag: Bangladesh",
        "\uD83C\uDDE7\uD83C\uDDE9",
        "1F1E7 1F1EA                                ; fully-qualified     # 🇧🇪 E2.0 flag: Belgium",
        "\uD83C\uDDE7\uD83C\uDDEA",
        "1F1E7 1F1EB                                ; fully-qualified     # 🇧🇫 E2.0 flag: Burkina Faso",
        "\uD83C\uDDE7\uD83C\uDDEB",
        "1F1E7 1F1EC                                ; fully-qualified     # 🇧🇬 E2.0 flag: Bulgaria",
        "\uD83C\uDDE7\uD83C\uDDEC",
        "1F1E7 1F1ED                                ; fully-qualified     # 🇧🇭 E2.0 flag: Bahrain",
        "\uD83C\uDDE7\uD83C\uDDED",
        "1F1E7 1F1EE                                ; fully-qualified     # 🇧🇮 E2.0 flag: Burundi",
        "\uD83C\uDDE7\uD83C\uDDEE",
        "1F1E7 1F1EF                                ; fully-qualified     # 🇧🇯 E2.0 flag: Benin",
        "\uD83C\uDDE7\uD83C\uDDEF",
        "1F1E7 1F1F1                                ; fully-qualified     # 🇧🇱 E2.0 flag: St. Barthélemy",
        "\uD83C\uDDE7\uD83C\uDDF1",
        "1F1E7 1F1F2                                ; fully-qualified     # 🇧🇲 E2.0 flag: Bermuda",
        "\uD83C\uDDE7\uD83C\uDDF2",
        "1F1E7 1F1F3                                ; fully-qualified     # 🇧🇳 E2.0 flag: Brunei",
        "\uD83C\uDDE7\uD83C\uDDF3",
        "1F1E7 1F1F4                                ; fully-qualified     # 🇧🇴 E2.0 flag: Bolivia",
        "\uD83C\uDDE7\uD83C\uDDF4",
        "1F1E7 1F1F6                                ; fully-qualified     # 🇧🇶 E2.0 flag: Caribbean Netherlands",
        "\uD83C\uDDE7\uD83C\uDDF6",
        "1F1E7 1F1F7                                ; fully-qualified     # 🇧🇷 E2.0 flag: Brazil",
        "\uD83C\uDDE7\uD83C\uDDF7",
        "1F1E7 1F1F8                                ; fully-qualified     # 🇧🇸 E2.0 flag: Bahamas",
        "\uD83C\uDDE7\uD83C\uDDF8",
        "1F1E7 1F1F9                                ; fully-qualified     # 🇧🇹 E2.0 flag: Bhutan",
        "\uD83C\uDDE7\uD83C\uDDF9",
        "1F1E7 1F1FB                                ; fully-qualified     # 🇧🇻 E2.0 flag: Bouvet Island",
        "\uD83C\uDDE7\uD83C\uDDFB",
        "1F1E7 1F1FC                                ; fully-qualified     # 🇧🇼 E2.0 flag: Botswana",
        "\uD83C\uDDE7\uD83C\uDDFC",
        "1F1E7 1F1FE                                ; fully-qualified     # 🇧🇾 E2.0 flag: Belarus",
        "\uD83C\uDDE7\uD83C\uDDFE",
        "1F1E7 1F1FF                                ; fully-qualified     # 🇧🇿 E2.0 flag: Belize",
        "\uD83C\uDDE7\uD83C\uDDFF",
        "1F1E8 1F1E6                                ; fully-qualified     # 🇨🇦 E2.0 flag: Canada",
        "\uD83C\uDDE8\uD83C\uDDE6",
        "1F1E8 1F1E8                                ; fully-qualified     # 🇨🇨 E2.0 flag: Cocos (Keeling) Islands",
        "\uD83C\uDDE8\uD83C\uDDE8",
        "1F1E8 1F1E9                                ; fully-qualified     # 🇨🇩 E2.0 flag: Congo - Kinshasa",
        "\uD83C\uDDE8\uD83C\uDDE9",
        "1F1E8 1F1EB                                ; fully-qualified     # 🇨🇫 E2.0 flag: Central African Republic",
        "\uD83C\uDDE8\uD83C\uDDEB",
        "1F1E8 1F1EC                                ; fully-qualified     # 🇨🇬 E2.0 flag: Congo - Brazzaville",
        "\uD83C\uDDE8\uD83C\uDDEC",
        "1F1E8 1F1ED                                ; fully-qualified     # 🇨🇭 E2.0 flag: Switzerland",
        "\uD83C\uDDE8\uD83C\uDDED",
        "1F1E8 1F1EE                                ; fully-qualified     # 🇨🇮 E2.0 flag: Côte d’Ivoire",
        "\uD83C\uDDE8\uD83C\uDDEE",
        "1F1E8 1F1F0                                ; fully-qualified     # 🇨🇰 E2.0 flag: Cook Islands",
        "\uD83C\uDDE8\uD83C\uDDF0",
        "1F1E8 1F1F1                                ; fully-qualified     # 🇨🇱 E2.0 flag: Chile",
        "\uD83C\uDDE8\uD83C\uDDF1",
        "1F1E8 1F1F2                                ; fully-qualified     # 🇨🇲 E2.0 flag: Cameroon",
        "\uD83C\uDDE8\uD83C\uDDF2",
        "1F1E8 1F1F3                                ; fully-qualified     # 🇨🇳 E2.0 flag: China",
        "\uD83C\uDDE8\uD83C\uDDF3",
        "1F1E8 1F1F4                                ; fully-qualified     # 🇨🇴 E2.0 flag: Colombia",
        "\uD83C\uDDE8\uD83C\uDDF4",
        "1F1E8 1F1F5                                ; fully-qualified     # 🇨🇵 E2.0 flag: Clipperton Island",
        "\uD83C\uDDE8\uD83C\uDDF5",
        "1F1E8 1F1F7                                ; fully-qualified     # 🇨🇷 E2.0 flag: Costa Rica",
        "\uD83C\uDDE8\uD83C\uDDF7",
        "1F1E8 1F1FA                                ; fully-qualified     # 🇨🇺 E2.0 flag: Cuba",
        "\uD83C\uDDE8\uD83C\uDDFA",
        "1F1E8 1F1FB                                ; fully-qualified     # 🇨🇻 E2.0 flag: Cape Verde",
        "\uD83C\uDDE8\uD83C\uDDFB",
        "1F1E8 1F1FC                                ; fully-qualified     # 🇨🇼 E2.0 flag: Curaçao",
        "\uD83C\uDDE8\uD83C\uDDFC",
        "1F1E8 1F1FD                                ; fully-qualified     # 🇨🇽 E2.0 flag: Christmas Island",
        "\uD83C\uDDE8\uD83C\uDDFD",
        "1F1E8 1F1FE                                ; fully-qualified     # 🇨🇾 E2.0 flag: Cyprus",
        "\uD83C\uDDE8\uD83C\uDDFE",
        "1F1E8 1F1FF                                ; fully-qualified     # 🇨🇿 E2.0 flag: Czechia",
        "\uD83C\uDDE8\uD83C\uDDFF",
        "1F1E9 1F1EA                                ; fully-qualified     # 🇩🇪 E2.0 flag: Germany",
        "\uD83C\uDDE9\uD83C\uDDEA",
        "1F1E9 1F1EC                                ; fully-qualified     # 🇩🇬 E2.0 flag: Diego Garcia",
        "\uD83C\uDDE9\uD83C\uDDEC",
        "1F1E9 1F1EF                                ; fully-qualified     # 🇩🇯 E2.0 flag: Djibouti",
        "\uD83C\uDDE9\uD83C\uDDEF",
        "1F1E9 1F1F0                                ; fully-qualified     # 🇩🇰 E2.0 flag: Denmark",
        "\uD83C\uDDE9\uD83C\uDDF0",
        "1F1E9 1F1F2                                ; fully-qualified     # 🇩🇲 E2.0 flag: Dominica",
        "\uD83C\uDDE9\uD83C\uDDF2",
        "1F1E9 1F1F4                                ; fully-qualified     # 🇩🇴 E2.0 flag: Dominican Republic",
        "\uD83C\uDDE9\uD83C\uDDF4",
        "1F1E9 1F1FF                                ; fully-qualified     # 🇩🇿 E2.0 flag: Algeria",
        "\uD83C\uDDE9\uD83C\uDDFF",
        "1F1EA 1F1E6                                ; fully-qualified     # 🇪🇦 E2.0 flag: Ceuta & Melilla",
        "\uD83C\uDDEA\uD83C\uDDE6",
        "1F1EA 1F1E8                                ; fully-qualified     # 🇪🇨 E2.0 flag: Ecuador",
        "\uD83C\uDDEA\uD83C\uDDE8",
        "1F1EA 1F1EA                                ; fully-qualified     # 🇪🇪 E2.0 flag: Estonia",
        "\uD83C\uDDEA\uD83C\uDDEA",
        "1F1EA 1F1EC                                ; fully-qualified     # 🇪🇬 E2.0 flag: Egypt",
        "\uD83C\uDDEA\uD83C\uDDEC",
        "1F1EA 1F1ED                                ; fully-qualified     # 🇪🇭 E2.0 flag: Western Sahara",
        "\uD83C\uDDEA\uD83C\uDDED",
        "1F1EA 1F1F7                                ; fully-qualified     # 🇪🇷 E2.0 flag: Eritrea",
        "\uD83C\uDDEA\uD83C\uDDF7",
        "1F1EA 1F1F8                                ; fully-qualified     # 🇪🇸 E2.0 flag: Spain",
        "\uD83C\uDDEA\uD83C\uDDF8",
        "1F1EA 1F1F9                                ; fully-qualified     # 🇪🇹 E2.0 flag: Ethiopia",
        "\uD83C\uDDEA\uD83C\uDDF9",
        "1F1EA 1F1FA                                ; fully-qualified     # 🇪🇺 E2.0 flag: European Union",
        "\uD83C\uDDEA\uD83C\uDDFA",
        "1F1EB 1F1EE                                ; fully-qualified     # 🇫🇮 E2.0 flag: Finland",
        "\uD83C\uDDEB\uD83C\uDDEE",
        "1F1EB 1F1EF                                ; fully-qualified     # 🇫🇯 E2.0 flag: Fiji",
        "\uD83C\uDDEB\uD83C\uDDEF",
        "1F1EB 1F1F0                                ; fully-qualified     # 🇫🇰 E2.0 flag: Falkland Islands",
        "\uD83C\uDDEB\uD83C\uDDF0",
        "1F1EB 1F1F2                                ; fully-qualified     # 🇫🇲 E2.0 flag: Micronesia",
        "\uD83C\uDDEB\uD83C\uDDF2",
        "1F1EB 1F1F4                                ; fully-qualified     # 🇫🇴 E2.0 flag: Faroe Islands",
        "\uD83C\uDDEB\uD83C\uDDF4",
        "1F1EB 1F1F7                                ; fully-qualified     # 🇫🇷 E2.0 flag: France",
        "\uD83C\uDDEB\uD83C\uDDF7",
        "1F1EC 1F1E6                                ; fully-qualified     # 🇬🇦 E2.0 flag: Gabon",
        "\uD83C\uDDEC\uD83C\uDDE6",
        "1F1EC 1F1E7                                ; fully-qualified     # 🇬🇧 E2.0 flag: United Kingdom",
        "\uD83C\uDDEC\uD83C\uDDE7",
        "1F1EC 1F1E9                                ; fully-qualified     # 🇬🇩 E2.0 flag: Grenada",
        "\uD83C\uDDEC\uD83C\uDDE9",
        "1F1EC 1F1EA                                ; fully-qualified     # 🇬🇪 E2.0 flag: Georgia",
        "\uD83C\uDDEC\uD83C\uDDEA",
        "1F1EC 1F1EB                                ; fully-qualified     # 🇬🇫 E2.0 flag: French Guiana",
        "\uD83C\uDDEC\uD83C\uDDEB",
        "1F1EC 1F1EC                                ; fully-qualified     # 🇬🇬 E2.0 flag: Guernsey",
        "\uD83C\uDDEC\uD83C\uDDEC",
        "1F1EC 1F1ED                                ; fully-qualified     # 🇬🇭 E2.0 flag: Ghana",
        "\uD83C\uDDEC\uD83C\uDDED",
        "1F1EC 1F1EE                                ; fully-qualified     # 🇬🇮 E2.0 flag: Gibraltar",
        "\uD83C\uDDEC\uD83C\uDDEE",
        "1F1EC 1F1F1                                ; fully-qualified     # 🇬🇱 E2.0 flag: Greenland",
        "\uD83C\uDDEC\uD83C\uDDF1",
        "1F1EC 1F1F2                                ; fully-qualified     # 🇬🇲 E2.0 flag: Gambia",
        "\uD83C\uDDEC\uD83C\uDDF2",
        "1F1EC 1F1F3                                ; fully-qualified     # 🇬🇳 E2.0 flag: Guinea",
        "\uD83C\uDDEC\uD83C\uDDF3",
        "1F1EC 1F1F5                                ; fully-qualified     # 🇬🇵 E2.0 flag: Guadeloupe",
        "\uD83C\uDDEC\uD83C\uDDF5",
        "1F1EC 1F1F6                                ; fully-qualified     # 🇬🇶 E2.0 flag: Equatorial Guinea",
        "\uD83C\uDDEC\uD83C\uDDF6",
        "1F1EC 1F1F7                                ; fully-qualified     # 🇬🇷 E2.0 flag: Greece",
        "\uD83C\uDDEC\uD83C\uDDF7",
        "1F1EC 1F1F8                                ; fully-qualified     # 🇬🇸 E2.0 flag: South Georgia & South Sandwich Islands",
        "\uD83C\uDDEC\uD83C\uDDF8",
        "1F1EC 1F1F9                                ; fully-qualified     # 🇬🇹 E2.0 flag: Guatemala",
        "\uD83C\uDDEC\uD83C\uDDF9",
        "1F1EC 1F1FA                                ; fully-qualified     # 🇬🇺 E2.0 flag: Guam",
        "\uD83C\uDDEC\uD83C\uDDFA",
        "1F1EC 1F1FC                                ; fully-qualified     # 🇬🇼 E2.0 flag: Guinea-Bissau",
        "\uD83C\uDDEC\uD83C\uDDFC",
        "1F1EC 1F1FE                                ; fully-qualified     # 🇬🇾 E2.0 flag: Guyana",
        "\uD83C\uDDEC\uD83C\uDDFE",
        "1F1ED 1F1F0                                ; fully-qualified     # 🇭🇰 E2.0 flag: Hong Kong SAR China",
        "\uD83C\uDDED\uD83C\uDDF0",
        "1F1ED 1F1F2                                ; fully-qualified     # 🇭🇲 E2.0 flag: Heard & McDonald Islands",
        "\uD83C\uDDED\uD83C\uDDF2",
        "1F1ED 1F1F3                                ; fully-qualified     # 🇭🇳 E2.0 flag: Honduras",
        "\uD83C\uDDED\uD83C\uDDF3",
        "1F1ED 1F1F7                                ; fully-qualified     # 🇭🇷 E2.0 flag: Croatia",
        "\uD83C\uDDED\uD83C\uDDF7",
        "1F1ED 1F1F9                                ; fully-qualified     # 🇭🇹 E2.0 flag: Haiti",
        "\uD83C\uDDED\uD83C\uDDF9",
        "1F1ED 1F1FA                                ; fully-qualified     # 🇭🇺 E2.0 flag: Hungary",
        "\uD83C\uDDED\uD83C\uDDFA",
        "1F1EE 1F1E8                                ; fully-qualified     # 🇮🇨 E2.0 flag: Canary Islands",
        "\uD83C\uDDEE\uD83C\uDDE8",
        "1F1EE 1F1E9                                ; fully-qualified     # 🇮🇩 E2.0 flag: Indonesia",
        "\uD83C\uDDEE\uD83C\uDDE9",
        "1F1EE 1F1EA                                ; fully-qualified     # 🇮🇪 E2.0 flag: Ireland",
        "\uD83C\uDDEE\uD83C\uDDEA",
        "1F1EE 1F1F1                                ; fully-qualified     # 🇮🇱 E2.0 flag: Israel",
        "\uD83C\uDDEE\uD83C\uDDF1",
        "1F1EE 1F1F2                                ; fully-qualified     # 🇮🇲 E2.0 flag: Isle of Man",
        "\uD83C\uDDEE\uD83C\uDDF2",
        "1F1EE 1F1F3                                ; fully-qualified     # 🇮🇳 E2.0 flag: India",
        "\uD83C\uDDEE\uD83C\uDDF3",
        "1F1EE 1F1F4                                ; fully-qualified     # 🇮🇴 E2.0 flag: British Indian Ocean Territory",
        "\uD83C\uDDEE\uD83C\uDDF4",
        "1F1EE 1F1F6                                ; fully-qualified     # 🇮🇶 E2.0 flag: Iraq",
        "\uD83C\uDDEE\uD83C\uDDF6",
        "1F1EE 1F1F7                                ; fully-qualified     # 🇮🇷 E2.0 flag: Iran",
        "\uD83C\uDDEE\uD83C\uDDF7",
        "1F1EE 1F1F8                                ; fully-qualified     # 🇮🇸 E2.0 flag: Iceland",
        "\uD83C\uDDEE\uD83C\uDDF8",
        "1F1EE 1F1F9                                ; fully-qualified     # 🇮🇹 E2.0 flag: Italy",
        "\uD83C\uDDEE\uD83C\uDDF9",
        "1F1EF 1F1EA                                ; fully-qualified     # 🇯🇪 E2.0 flag: Jersey",
        "\uD83C\uDDEF\uD83C\uDDEA",
        "1F1EF 1F1F2                                ; fully-qualified     # 🇯🇲 E2.0 flag: Jamaica",
        "\uD83C\uDDEF\uD83C\uDDF2",
        "1F1EF 1F1F4                                ; fully-qualified     # 🇯🇴 E2.0 flag: Jordan",
        "\uD83C\uDDEF\uD83C\uDDF4",
        "1F1EF 1F1F5                                ; fully-qualified     # 🇯🇵 E2.0 flag: Japan",
        "\uD83C\uDDEF\uD83C\uDDF5",
        "1F1F0 1F1EA                                ; fully-qualified     # 🇰🇪 E2.0 flag: Kenya",
        "\uD83C\uDDF0\uD83C\uDDEA",
        "1F1F0 1F1EC                                ; fully-qualified     # 🇰🇬 E2.0 flag: Kyrgyzstan",
        "\uD83C\uDDF0\uD83C\uDDEC",
        "1F1F0 1F1ED                                ; fully-qualified     # 🇰🇭 E2.0 flag: Cambodia",
        "\uD83C\uDDF0\uD83C\uDDED",
        "1F1F0 1F1EE                                ; fully-qualified     # 🇰🇮 E2.0 flag: Kiribati",
        "\uD83C\uDDF0\uD83C\uDDEE",
        "1F1F0 1F1F2                                ; fully-qualified     # 🇰🇲 E2.0 flag: Comoros",
        "\uD83C\uDDF0\uD83C\uDDF2",
        "1F1F0 1F1F3                                ; fully-qualified     # 🇰🇳 E2.0 flag: St. Kitts & Nevis",
        "\uD83C\uDDF0\uD83C\uDDF3",
        "1F1F0 1F1F5                                ; fully-qualified     # 🇰🇵 E2.0 flag: North Korea",
        "\uD83C\uDDF0\uD83C\uDDF5",
        "1F1F0 1F1F7                                ; fully-qualified     # 🇰🇷 E2.0 flag: South Korea",
        "\uD83C\uDDF0\uD83C\uDDF7",
        "1F1F0 1F1FC                                ; fully-qualified     # 🇰🇼 E2.0 flag: Kuwait",
        "\uD83C\uDDF0\uD83C\uDDFC",
        "1F1F0 1F1FE                                ; fully-qualified     # 🇰🇾 E2.0 flag: Cayman Islands",
        "\uD83C\uDDF0\uD83C\uDDFE",
        "1F1F0 1F1FF                                ; fully-qualified     # 🇰🇿 E2.0 flag: Kazakhstan",
        "\uD83C\uDDF0\uD83C\uDDFF",
        "1F1F1 1F1E6                                ; fully-qualified     # 🇱🇦 E2.0 flag: Laos",
        "\uD83C\uDDF1\uD83C\uDDE6",
        "1F1F1 1F1E7                                ; fully-qualified     # 🇱🇧 E2.0 flag: Lebanon",
        "\uD83C\uDDF1\uD83C\uDDE7",
        "1F1F1 1F1E8                                ; fully-qualified     # 🇱🇨 E2.0 flag: St. Lucia",
        "\uD83C\uDDF1\uD83C\uDDE8",
        "1F1F1 1F1EE                                ; fully-qualified     # 🇱🇮 E2.0 flag: Liechtenstein",
        "\uD83C\uDDF1\uD83C\uDDEE",
        "1F1F1 1F1F0                                ; fully-qualified     # 🇱🇰 E2.0 flag: Sri Lanka",
        "\uD83C\uDDF1\uD83C\uDDF0",
        "1F1F1 1F1F7                                ; fully-qualified     # 🇱🇷 E2.0 flag: Liberia",
        "\uD83C\uDDF1\uD83C\uDDF7",
        "1F1F1 1F1F8                                ; fully-qualified     # 🇱🇸 E2.0 flag: Lesotho",
        "\uD83C\uDDF1\uD83C\uDDF8",
        "1F1F1 1F1F9                                ; fully-qualified     # 🇱🇹 E2.0 flag: Lithuania",
        "\uD83C\uDDF1\uD83C\uDDF9",
        "1F1F1 1F1FA                                ; fully-qualified     # 🇱🇺 E2.0 flag: Luxembourg",
        "\uD83C\uDDF1\uD83C\uDDFA",
        "1F1F1 1F1FB                                ; fully-qualified     # 🇱🇻 E2.0 flag: Latvia",
        "\uD83C\uDDF1\uD83C\uDDFB",
        "1F1F1 1F1FE                                ; fully-qualified     # 🇱🇾 E2.0 flag: Libya",
        "\uD83C\uDDF1\uD83C\uDDFE",
        "1F1F2 1F1E6                                ; fully-qualified     # 🇲🇦 E2.0 flag: Morocco",
        "\uD83C\uDDF2\uD83C\uDDE6",
        "1F1F2 1F1E8                                ; fully-qualified     # 🇲🇨 E2.0 flag: Monaco",
        "\uD83C\uDDF2\uD83C\uDDE8",
        "1F1F2 1F1E9                                ; fully-qualified     # 🇲🇩 E2.0 flag: Moldova",
        "\uD83C\uDDF2\uD83C\uDDE9",
        "1F1F2 1F1EA                                ; fully-qualified     # 🇲🇪 E2.0 flag: Montenegro",
        "\uD83C\uDDF2\uD83C\uDDEA",
        "1F1F2 1F1EB                                ; fully-qualified     # 🇲🇫 E2.0 flag: St. Martin",
        "\uD83C\uDDF2\uD83C\uDDEB",
        "1F1F2 1F1EC                                ; fully-qualified     # 🇲🇬 E2.0 flag: Madagascar",
        "\uD83C\uDDF2\uD83C\uDDEC",
        "1F1F2 1F1ED                                ; fully-qualified     # 🇲🇭 E2.0 flag: Marshall Islands",
        "\uD83C\uDDF2\uD83C\uDDED",
        "1F1F2 1F1F0                                ; fully-qualified     # 🇲🇰 E2.0 flag: North Macedonia",
        "\uD83C\uDDF2\uD83C\uDDF0",
        "1F1F2 1F1F1                                ; fully-qualified     # 🇲🇱 E2.0 flag: Mali",
        "\uD83C\uDDF2\uD83C\uDDF1",
        "1F1F2 1F1F2                                ; fully-qualified     # 🇲🇲 E2.0 flag: Myanmar (Burma)",
        "\uD83C\uDDF2\uD83C\uDDF2",
        "1F1F2 1F1F3                                ; fully-qualified     # 🇲🇳 E2.0 flag: Mongolia",
        "\uD83C\uDDF2\uD83C\uDDF3",
        "1F1F2 1F1F4                                ; fully-qualified     # 🇲🇴 E2.0 flag: Macao SAR China",
        "\uD83C\uDDF2\uD83C\uDDF4",
        "1F1F2 1F1F5                                ; fully-qualified     # 🇲🇵 E2.0 flag: Northern Mariana Islands",
        "\uD83C\uDDF2\uD83C\uDDF5",
        "1F1F2 1F1F6                                ; fully-qualified     # 🇲🇶 E2.0 flag: Martinique",
        "\uD83C\uDDF2\uD83C\uDDF6",
        "1F1F2 1F1F7                                ; fully-qualified     # 🇲🇷 E2.0 flag: Mauritania",
        "\uD83C\uDDF2\uD83C\uDDF7",
        "1F1F2 1F1F8                                ; fully-qualified     # 🇲🇸 E2.0 flag: Montserrat",
        "\uD83C\uDDF2\uD83C\uDDF8",
        "1F1F2 1F1F9                                ; fully-qualified     # 🇲🇹 E2.0 flag: Malta",
        "\uD83C\uDDF2\uD83C\uDDF9",
        "1F1F2 1F1FA                                ; fully-qualified     # 🇲🇺 E2.0 flag: Mauritius",
        "\uD83C\uDDF2\uD83C\uDDFA",
        "1F1F2 1F1FB                                ; fully-qualified     # 🇲🇻 E2.0 flag: Maldives",
        "\uD83C\uDDF2\uD83C\uDDFB",
        "1F1F2 1F1FC                                ; fully-qualified     # 🇲🇼 E2.0 flag: Malawi",
        "\uD83C\uDDF2\uD83C\uDDFC",
        "1F1F2 1F1FD                                ; fully-qualified     # 🇲🇽 E2.0 flag: Mexico",
        "\uD83C\uDDF2\uD83C\uDDFD",
        "1F1F2 1F1FE                                ; fully-qualified     # 🇲🇾 E2.0 flag: Malaysia",
        "\uD83C\uDDF2\uD83C\uDDFE",
        "1F1F2 1F1FF                                ; fully-qualified     # 🇲🇿 E2.0 flag: Mozambique",
        "\uD83C\uDDF2\uD83C\uDDFF",
        "1F1F3 1F1E6                                ; fully-qualified     # 🇳🇦 E2.0 flag: Namibia",
        "\uD83C\uDDF3\uD83C\uDDE6",
        "1F1F3 1F1E8                                ; fully-qualified     # 🇳🇨 E2.0 flag: New Caledonia",
        "\uD83C\uDDF3\uD83C\uDDE8",
        "1F1F3 1F1EA                                ; fully-qualified     # 🇳🇪 E2.0 flag: Niger",
        "\uD83C\uDDF3\uD83C\uDDEA",
        "1F1F3 1F1EB                                ; fully-qualified     # 🇳🇫 E2.0 flag: Norfolk Island",
        "\uD83C\uDDF3\uD83C\uDDEB",
        "1F1F3 1F1EC                                ; fully-qualified     # 🇳🇬 E2.0 flag: Nigeria",
        "\uD83C\uDDF3\uD83C\uDDEC",
        "1F1F3 1F1EE                                ; fully-qualified     # 🇳🇮 E2.0 flag: Nicaragua",
        "\uD83C\uDDF3\uD83C\uDDEE",
        "1F1F3 1F1F1                                ; fully-qualified     # 🇳🇱 E2.0 flag: Netherlands",
        "\uD83C\uDDF3\uD83C\uDDF1",
        "1F1F3 1F1F4                                ; fully-qualified     # 🇳🇴 E2.0 flag: Norway",
        "\uD83C\uDDF3\uD83C\uDDF4",
        "1F1F3 1F1F5                                ; fully-qualified     # 🇳🇵 E2.0 flag: Nepal",
        "\uD83C\uDDF3\uD83C\uDDF5",
        "1F1F3 1F1F7                                ; fully-qualified     # 🇳🇷 E2.0 flag: Nauru",
        "\uD83C\uDDF3\uD83C\uDDF7",
        "1F1F3 1F1FA                                ; fully-qualified     # 🇳🇺 E2.0 flag: Niue",
        "\uD83C\uDDF3\uD83C\uDDFA",
        "1F1F3 1F1FF                                ; fully-qualified     # 🇳🇿 E2.0 flag: New Zealand",
        "\uD83C\uDDF3\uD83C\uDDFF",
        "1F1F4 1F1F2                                ; fully-qualified     # 🇴🇲 E2.0 flag: Oman",
        "\uD83C\uDDF4\uD83C\uDDF2",
        "1F1F5 1F1E6                                ; fully-qualified     # 🇵🇦 E2.0 flag: Panama",
        "\uD83C\uDDF5\uD83C\uDDE6",
        "1F1F5 1F1EA                                ; fully-qualified     # 🇵🇪 E2.0 flag: Peru",
        "\uD83C\uDDF5\uD83C\uDDEA",
        "1F1F5 1F1EB                                ; fully-qualified     # 🇵🇫 E2.0 flag: French Polynesia",
        "\uD83C\uDDF5\uD83C\uDDEB",
        "1F1F5 1F1EC                                ; fully-qualified     # 🇵🇬 E2.0 flag: Papua New Guinea",
        "\uD83C\uDDF5\uD83C\uDDEC",
        "1F1F5 1F1ED                                ; fully-qualified     # 🇵🇭 E2.0 flag: Philippines",
        "\uD83C\uDDF5\uD83C\uDDED",
        "1F1F5 1F1F0                                ; fully-qualified     # 🇵🇰 E2.0 flag: Pakistan",
        "\uD83C\uDDF5\uD83C\uDDF0",
        "1F1F5 1F1F1                                ; fully-qualified     # 🇵🇱 E2.0 flag: Poland",
        "\uD83C\uDDF5\uD83C\uDDF1",
        "1F1F5 1F1F2                                ; fully-qualified     # 🇵🇲 E2.0 flag: St. Pierre & Miquelon",
        "\uD83C\uDDF5\uD83C\uDDF2",
        "1F1F5 1F1F3                                ; fully-qualified     # 🇵🇳 E2.0 flag: Pitcairn Islands",
        "\uD83C\uDDF5\uD83C\uDDF3",
        "1F1F5 1F1F7                                ; fully-qualified     # 🇵🇷 E2.0 flag: Puerto Rico",
        "\uD83C\uDDF5\uD83C\uDDF7",
        "1F1F5 1F1F8                                ; fully-qualified     # 🇵🇸 E2.0 flag: Palestinian Territories",
        "\uD83C\uDDF5\uD83C\uDDF8",
        "1F1F5 1F1F9                                ; fully-qualified     # 🇵🇹 E2.0 flag: Portugal",
        "\uD83C\uDDF5\uD83C\uDDF9",
        "1F1F5 1F1FC                                ; fully-qualified     # 🇵🇼 E2.0 flag: Palau",
        "\uD83C\uDDF5\uD83C\uDDFC",
        "1F1F5 1F1FE                                ; fully-qualified     # 🇵🇾 E2.0 flag: Paraguay",
        "\uD83C\uDDF5\uD83C\uDDFE",
        "1F1F6 1F1E6                                ; fully-qualified     # 🇶🇦 E2.0 flag: Qatar",
        "\uD83C\uDDF6\uD83C\uDDE6",
        "1F1F7 1F1EA                                ; fully-qualified     # 🇷🇪 E2.0 flag: Réunion",
        "\uD83C\uDDF7\uD83C\uDDEA",
        "1F1F7 1F1F4                                ; fully-qualified     # 🇷🇴 E2.0 flag: Romania",
        "\uD83C\uDDF7\uD83C\uDDF4",
        "1F1F7 1F1F8                                ; fully-qualified     # 🇷🇸 E2.0 flag: Serbia",
        "\uD83C\uDDF7\uD83C\uDDF8",
        "1F1F7 1F1FA                                ; fully-qualified     # 🇷🇺 E2.0 flag: Russia",
        "\uD83C\uDDF7\uD83C\uDDFA",
        "1F1F7 1F1FC                                ; fully-qualified     # 🇷🇼 E2.0 flag: Rwanda",
        "\uD83C\uDDF7\uD83C\uDDFC",
        "1F1F8 1F1E6                                ; fully-qualified     # 🇸🇦 E2.0 flag: Saudi Arabia",
        "\uD83C\uDDF8\uD83C\uDDE6",
        "1F1F8 1F1E7                                ; fully-qualified     # 🇸🇧 E2.0 flag: Solomon Islands",
        "\uD83C\uDDF8\uD83C\uDDE7",
        "1F1F8 1F1E8                                ; fully-qualified     # 🇸🇨 E2.0 flag: Seychelles",
        "\uD83C\uDDF8\uD83C\uDDE8",
        "1F1F8 1F1E9                                ; fully-qualified     # 🇸🇩 E2.0 flag: Sudan",
        "\uD83C\uDDF8\uD83C\uDDE9",
        "1F1F8 1F1EA                                ; fully-qualified     # 🇸🇪 E2.0 flag: Sweden",
        "\uD83C\uDDF8\uD83C\uDDEA",
        "1F1F8 1F1EC                                ; fully-qualified     # 🇸🇬 E2.0 flag: Singapore",
        "\uD83C\uDDF8\uD83C\uDDEC",
        "1F1F8 1F1ED                                ; fully-qualified     # 🇸🇭 E2.0 flag: St. Helena",
        "\uD83C\uDDF8\uD83C\uDDED",
        "1F1F8 1F1EE                                ; fully-qualified     # 🇸🇮 E2.0 flag: Slovenia",
        "\uD83C\uDDF8\uD83C\uDDEE",
        "1F1F8 1F1EF                                ; fully-qualified     # 🇸🇯 E2.0 flag: Svalbard & Jan Mayen",
        "\uD83C\uDDF8\uD83C\uDDEF",
        "1F1F8 1F1F0                                ; fully-qualified     # 🇸🇰 E2.0 flag: Slovakia",
        "\uD83C\uDDF8\uD83C\uDDF0",
        "1F1F8 1F1F1                                ; fully-qualified     # 🇸🇱 E2.0 flag: Sierra Leone",
        "\uD83C\uDDF8\uD83C\uDDF1",
        "1F1F8 1F1F2                                ; fully-qualified     # 🇸🇲 E2.0 flag: San Marino",
        "\uD83C\uDDF8\uD83C\uDDF2",
        "1F1F8 1F1F3                                ; fully-qualified     # 🇸🇳 E2.0 flag: Senegal",
        "\uD83C\uDDF8\uD83C\uDDF3",
        "1F1F8 1F1F4                                ; fully-qualified     # 🇸🇴 E2.0 flag: Somalia",
        "\uD83C\uDDF8\uD83C\uDDF4",
        "1F1F8 1F1F7                                ; fully-qualified     # 🇸🇷 E2.0 flag: Suriname",
        "\uD83C\uDDF8\uD83C\uDDF7",
        "1F1F8 1F1F8                                ; fully-qualified     # 🇸🇸 E2.0 flag: South Sudan",
        "\uD83C\uDDF8\uD83C\uDDF8",
        "1F1F8 1F1F9                                ; fully-qualified     # 🇸🇹 E2.0 flag: São Tomé & Príncipe",
        "\uD83C\uDDF8\uD83C\uDDF9",
        "1F1F8 1F1FB                                ; fully-qualified     # 🇸🇻 E2.0 flag: El Salvador",
        "\uD83C\uDDF8\uD83C\uDDFB",
        "1F1F8 1F1FD                                ; fully-qualified     # 🇸🇽 E2.0 flag: Sint Maarten",
        "\uD83C\uDDF8\uD83C\uDDFD",
        "1F1F8 1F1FE                                ; fully-qualified     # 🇸🇾 E2.0 flag: Syria",
        "\uD83C\uDDF8\uD83C\uDDFE",
        "1F1F8 1F1FF                                ; fully-qualified     # 🇸🇿 E2.0 flag: Eswatini",
        "\uD83C\uDDF8\uD83C\uDDFF",
        "1F1F9 1F1E6                                ; fully-qualified     # 🇹🇦 E2.0 flag: Tristan da Cunha",
        "\uD83C\uDDF9\uD83C\uDDE6",
        "1F1F9 1F1E8                                ; fully-qualified     # 🇹🇨 E2.0 flag: Turks & Caicos Islands",
        "\uD83C\uDDF9\uD83C\uDDE8",
        "1F1F9 1F1E9                                ; fully-qualified     # 🇹🇩 E2.0 flag: Chad",
        "\uD83C\uDDF9\uD83C\uDDE9",
        "1F1F9 1F1EB                                ; fully-qualified     # 🇹🇫 E2.0 flag: French Southern Territories",
        "\uD83C\uDDF9\uD83C\uDDEB",
        "1F1F9 1F1EC                                ; fully-qualified     # 🇹🇬 E2.0 flag: Togo",
        "\uD83C\uDDF9\uD83C\uDDEC",
        "1F1F9 1F1ED                                ; fully-qualified     # 🇹🇭 E2.0 flag: Thailand",
        "\uD83C\uDDF9\uD83C\uDDED",
        "1F1F9 1F1EF                                ; fully-qualified     # 🇹🇯 E2.0 flag: Tajikistan",
        "\uD83C\uDDF9\uD83C\uDDEF",
        "1F1F9 1F1F0                                ; fully-qualified     # 🇹🇰 E2.0 flag: Tokelau",
        "\uD83C\uDDF9\uD83C\uDDF0",
        "1F1F9 1F1F1                                ; fully-qualified     # 🇹🇱 E2.0 flag: Timor-Leste",
        "\uD83C\uDDF9\uD83C\uDDF1",
        "1F1F9 1F1F2                                ; fully-qualified     # 🇹🇲 E2.0 flag: Turkmenistan",
        "\uD83C\uDDF9\uD83C\uDDF2",
        "1F1F9 1F1F3                                ; fully-qualified     # 🇹🇳 E2.0 flag: Tunisia",
        "\uD83C\uDDF9\uD83C\uDDF3",
        "1F1F9 1F1F4                                ; fully-qualified     # 🇹🇴 E2.0 flag: Tonga",
        "\uD83C\uDDF9\uD83C\uDDF4",
        "1F1F9 1F1F7                                ; fully-qualified     # 🇹🇷 E2.0 flag: Turkey",
        "\uD83C\uDDF9\uD83C\uDDF7",
        "1F1F9 1F1F9                                ; fully-qualified     # 🇹🇹 E2.0 flag: Trinidad & Tobago",
        "\uD83C\uDDF9\uD83C\uDDF9",
        "1F1F9 1F1FB                                ; fully-qualified     # 🇹🇻 E2.0 flag: Tuvalu",
        "\uD83C\uDDF9\uD83C\uDDFB",
        "1F1F9 1F1FC                                ; fully-qualified     # 🇹🇼 E2.0 flag: Taiwan",
        "\uD83C\uDDF9\uD83C\uDDFC",
        "1F1F9 1F1FF                                ; fully-qualified     # 🇹🇿 E2.0 flag: Tanzania",
        "\uD83C\uDDF9\uD83C\uDDFF",
        "1F1FA 1F1E6                                ; fully-qualified     # 🇺🇦 E2.0 flag: Ukraine",
        "\uD83C\uDDFA\uD83C\uDDE6",
        "1F1FA 1F1EC                                ; fully-qualified     # 🇺🇬 E2.0 flag: Uganda",
        "\uD83C\uDDFA\uD83C\uDDEC",
        "1F1FA 1F1F2                                ; fully-qualified     # 🇺🇲 E2.0 flag: U.S. Outlying Islands",
        "\uD83C\uDDFA\uD83C\uDDF2",
        "1F1FA 1F1F3                                ; fully-qualified     # 🇺🇳 E4.0 flag: United Nations",
        "\uD83C\uDDFA\uD83C\uDDF3",
        "1F1FA 1F1F8                                ; fully-qualified     # 🇺🇸 E2.0 flag: United States",
        "\uD83C\uDDFA\uD83C\uDDF8",
        "1F1FA 1F1FE                                ; fully-qualified     # 🇺🇾 E2.0 flag: Uruguay",
        "\uD83C\uDDFA\uD83C\uDDFE",
        "1F1FA 1F1FF                                ; fully-qualified     # 🇺🇿 E2.0 flag: Uzbekistan",
        "\uD83C\uDDFA\uD83C\uDDFF",
        "1F1FB 1F1E6                                ; fully-qualified     # 🇻🇦 E2.0 flag: Vatican City",
        "\uD83C\uDDFB\uD83C\uDDE6",
        "1F1FB 1F1E8                                ; fully-qualified     # 🇻🇨 E2.0 flag: St. Vincent & Grenadines",
        "\uD83C\uDDFB\uD83C\uDDE8",
        "1F1FB 1F1EA                                ; fully-qualified     # 🇻🇪 E2.0 flag: Venezuela",
        "\uD83C\uDDFB\uD83C\uDDEA",
        "1F1FB 1F1EC                                ; fully-qualified     # 🇻🇬 E2.0 flag: British Virgin Islands",
        "\uD83C\uDDFB\uD83C\uDDEC",
        "1F1FB 1F1EE                                ; fully-qualified     # 🇻🇮 E2.0 flag: U.S. Virgin Islands",
        "\uD83C\uDDFB\uD83C\uDDEE",
        "1F1FB 1F1F3                                ; fully-qualified     # 🇻🇳 E2.0 flag: Vietnam",
        "\uD83C\uDDFB\uD83C\uDDF3",
        "1F1FB 1F1FA                                ; fully-qualified     # 🇻🇺 E2.0 flag: Vanuatu",
        "\uD83C\uDDFB\uD83C\uDDFA",
        "1F1FC 1F1EB                                ; fully-qualified     # 🇼🇫 E2.0 flag: Wallis & Futuna",
        "\uD83C\uDDFC\uD83C\uDDEB",
        "1F1FC 1F1F8                                ; fully-qualified     # 🇼🇸 E2.0 flag: Samoa",
        "\uD83C\uDDFC\uD83C\uDDF8",
        "1F1FD 1F1F0                                ; fully-qualified     # 🇽🇰 E2.0 flag: Kosovo",
        "\uD83C\uDDFD\uD83C\uDDF0",
        "1F1FE 1F1EA                                ; fully-qualified     # 🇾🇪 E2.0 flag: Yemen",
        "\uD83C\uDDFE\uD83C\uDDEA",
        "1F1FE 1F1F9                                ; fully-qualified     # 🇾🇹 E2.0 flag: Mayotte",
        "\uD83C\uDDFE\uD83C\uDDF9",
        "1F1FF 1F1E6                                ; fully-qualified     # 🇿🇦 E2.0 flag: South Africa",
        "\uD83C\uDDFF\uD83C\uDDE6",
        "1F1FF 1F1F2                                ; fully-qualified     # 🇿🇲 E2.0 flag: Zambia",
        "\uD83C\uDDFF\uD83C\uDDF2",
        "1F1FF 1F1FC                                ; fully-qualified     # 🇿🇼 E2.0 flag: Zimbabwe",
        "\uD83C\uDDFF\uD83C\uDDFC",
        "1F3F4 E0067 E0062 E0065 E006E E0067 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁥󠁮󠁧󠁿 E5.0 flag: England",
        "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67\uDB40\uDC7F",
        "1F3F4 E0067 E0062 E0073 E0063 E0074 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁳󠁣󠁴󠁿 E5.0 flag: Scotland",
        "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74\uDB40\uDC7F",
        "1F3F4 E0067 E0062 E0077 E006C E0073 E007F  ; fully-qualified     # 🏴󠁧󠁢󠁷󠁬󠁳󠁿 E5.0 flag: Wales",
        "\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73\uDB40\uDC7F"
      };
}
