/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;

/**
 * Parser for trec docs which selects the parser to apply according to the source files path,
 * defaulting to {@link TrecGov2Parser}.
 */
public class TrecParserByPath extends TrecDocParser {

  @Override
  public DocData parse(
      DocData docData,
      String name,
      TrecContentSource trecSrc,
      StringBuilder docBuf,
      ParsePathType pathType)
      throws IOException {
    return pathType2Parser.get(pathType).parse(docData, name, trecSrc, docBuf, pathType);
  }
}
