/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;

public class QueryDecomposer {
    public Set<Query> decompose(Query q) {
        if (q instanceof BooleanQuery) {
            return this.decomposeBoolean((BooleanQuery)q);
        }
        if (q instanceof DisjunctionMaxQuery) {
            LinkedHashSet<Query> subqueries = new LinkedHashSet<Query>();
            for (Query subq : ((DisjunctionMaxQuery)q).getDisjuncts()) {
                subqueries.addAll(this.decompose(subq));
            }
            return subqueries;
        }
        if (q instanceof BoostQuery) {
            return this.decomposeBoostQuery((BoostQuery)q);
        }
        return Collections.singleton(q);
    }

    public Set<Query> decomposeBoostQuery(BoostQuery q) {
        if ((double)q.getBoost() == 1.0) {
            return this.decompose(q.getQuery());
        }
        LinkedHashSet<Query> boostedDecomposedQueries = new LinkedHashSet<Query>();
        for (Query subq : this.decompose(q.getQuery())) {
            boostedDecomposedQueries.add((Query)new BoostQuery(subq, q.getBoost()));
        }
        return boostedDecomposedQueries;
    }

    public Set<Query> decomposeBoolean(BooleanQuery q) {
        if (q.getMinimumNumberShouldMatch() > 1) {
            return Collections.singleton(q);
        }
        LinkedHashSet<Query> subqueries = new LinkedHashSet<Query>();
        HashSet<Query> exclusions = new HashSet<Query>();
        HashSet<Query> mandatory = new HashSet<Query>();
        for (BooleanClause clause : q) {
            if (clause.occur() == BooleanClause.Occur.MUST || clause.occur() == BooleanClause.Occur.FILTER) {
                mandatory.add(clause.query());
                continue;
            }
            if (clause.occur() == BooleanClause.Occur.MUST_NOT) {
                exclusions.add(clause.query());
                continue;
            }
            subqueries.addAll(this.decompose(clause.query()));
        }
        if (mandatory.size() > 1 || mandatory.size() == 1 && subqueries.size() > 0) {
            return Collections.singleton(q);
        }
        if (mandatory.size() == 1) {
            subqueries.addAll(this.decompose((Query)mandatory.iterator().next()));
        }
        if (exclusions.size() == 0) {
            return subqueries;
        }
        LinkedHashSet<Query> rewrittenSubqueries = new LinkedHashSet<Query>();
        for (Query subquery : subqueries) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add(subquery, BooleanClause.Occur.MUST);
            for (Query ex : exclusions) {
                bq.add(ex, BooleanClause.Occur.MUST_NOT);
            }
            rewrittenSubqueries.add((Query)bq.build());
        }
        return rewrittenSubqueries;
    }
}

